/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.service.ShoppingItemLocalServiceUtil;
import com.liferay.portlet.shopping.service.permission.ShoppingCategoryPermission;

public class ShoppingItemPermission {
    public static void check(PermissionChecker permissionChecker, long itemId, String actionId) throws PortalException, SystemException {
        if (!ShoppingItemPermission.contains(permissionChecker, itemId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, ShoppingItem item, String actionId) throws PortalException, SystemException {
        if (!ShoppingItemPermission.contains(permissionChecker, item, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long itemId, String actionId) throws PortalException, SystemException {
        ShoppingItem item = ShoppingItemLocalServiceUtil.getItem((long)itemId);
        return ShoppingItemPermission.contains(permissionChecker, item, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, ShoppingItem item, String actionId) throws PortalException, SystemException {
        ShoppingCategory category;
        if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && item.getCategoryId() != 0L && !ShoppingCategoryPermission.contains(permissionChecker, category = item.getCategory(), "VIEW")) {
            return false;
        }
        if (permissionChecker.hasOwnerPermission(item.getCompanyId(), ShoppingItem.class.getName(), item.getItemId(), item.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(item.getGroupId(), ShoppingItem.class.getName(), item.getItemId(), actionId);
    }
}

