/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rss.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class RSSPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "rss";
    private static Log _log = LogFactoryUtil.getLog(RSSPortletDataHandler.class);

    public RSSPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setDataPortletPreferences(new String[]{"footerArticleValues", "headerArticleValues"});
        this.setExportControls(new PortletDataHandlerControl[0]);
        this.setPublishToLiveByDefault(PropsValues.RSS_PUBLISH_TO_LIVE_BY_DEFAULT);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("expandedItemsPerChannel", "");
        portletPreferences.setValue("feedImageAlignment", "");
        portletPreferences.setValues("footerArticleValues", new String[]{"0", ""});
        portletPreferences.setValues("headerArticleValues", new String[]{"0", ""});
        portletPreferences.setValue("itemsPerChannel", "");
        portletPreferences.setValue("showFeedDescription", "");
        portletPreferences.setValue("showFeedImage", "");
        portletPreferences.setValue("showFeedItemAuthor", "");
        portletPreferences.setValue("showFeedPublishedDate", "");
        portletPreferences.setValue("showFeedTitle", "");
        portletPreferences.setValue("titles", "");
        portletPreferences.setValue("urls", "");
        return portletPreferences;
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        ArrayList<JournalArticle> articles;
        block11: {
            long headerArticleGroupId;
            String headerArticleId;
            block10: {
                String[] footerArticleValues = portletPreferences.getValues("footerArticleValues", new String[]{"0", ""});
                String[] headerArticleValues = portletPreferences.getValues("headerArticleValues", new String[]{"0", ""});
                String footerArticleId = footerArticleValues[1];
                headerArticleId = headerArticleValues[1];
                if (Validator.isNull((String)footerArticleId) && Validator.isNull((String)headerArticleId)) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No article ids found in preferences of portlet " + portletId));
                    }
                    return portletPreferences;
                }
                long footerArticleGroupId = GetterUtil.getLong((String)footerArticleValues[0]);
                headerArticleGroupId = GetterUtil.getLong((String)headerArticleValues[0]);
                if (footerArticleGroupId <= 0L && headerArticleGroupId <= 0L) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No group ids found in preferences of portlet " + portletId));
                    }
                    return portletPreferences;
                }
                articles = new ArrayList<JournalArticle>(2);
                JournalArticle footerArticle = null;
                try {
                    footerArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)footerArticleGroupId, (String)footerArticleId, (int)0);
                    articles.add(footerArticle);
                }
                catch (NoSuchArticleException noSuchArticleException) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn((Object)("No approved article found with group id " + footerArticleGroupId + " and article id " + footerArticleId));
                }
            }
            JournalArticle headerArticle = null;
            try {
                headerArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)headerArticleGroupId, (String)headerArticleId, (int)0);
                articles.add(headerArticle);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                if (!_log.isWarnEnabled()) break block11;
                _log.warn((Object)("No approved article found with group id " + headerArticleGroupId + " and article id " + headerArticleId));
            }
        }
        if (articles.isEmpty()) {
            return portletPreferences;
        }
        for (JournalArticle article : articles) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)article);
        }
        return portletPreferences;
    }

    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        this.importReferenceArticle(portletDataContext);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getPlid());
        Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
        String[] footerArticleValues = portletPreferences.getValues("footerArticleValues", new String[]{"0", ""});
        String footerArticleId = footerArticleValues[1];
        footerArticleId = MapUtil.getString((Map)articleIds, (String)footerArticleId, (String)footerArticleId);
        if (Validator.isNotNull((String)footerArticleId)) {
            footerArticleId = MapUtil.getString((Map)articleIds, (String)footerArticleId, (String)footerArticleId);
            portletPreferences.setValues("footerArticleValues", new String[]{String.valueOf(portletDataContext.getScopeGroupId()), footerArticleId});
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)footerArticleId, (boolean)true);
        }
        String[] headerArticleValues = portletPreferences.getValues("headerArticleValues", new String[]{"0", ""});
        String headerArticleId = headerArticleValues[1];
        if (Validator.isNotNull((String)(headerArticleId = MapUtil.getString((Map)articleIds, (String)headerArticleId, (String)headerArticleId)))) {
            portletPreferences.setValues("headerArticleValues", new String[]{String.valueOf(portletDataContext.getScopeGroupId()), headerArticleId});
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)headerArticleId, (boolean)true);
        }
        return portletPreferences;
    }

    protected void importReferenceArticle(PortletDataContext portletDataContext) throws PortletDataException {
        Element articlesElement = portletDataContext.getImportDataGroupElement(JournalArticle.class);
        if (articlesElement == null) {
            return;
        }
        List articleElements = articlesElement.elements();
        for (Element articleElement : articleElements) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (Element)articleElement);
        }
    }
}

