/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletdisplaytemplate.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.GenericServletWrapper;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.template.TemplateVariableGroup;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.templateparser.Transformer;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletURLUtil;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.portletdisplaytemplate.util.PortletDisplayTemplate;
import com.liferay.taglib.util.VelocityTaglib;
import com.liferay.taglib.util.VelocityTaglibImpl;
import com.liferay.util.freemarker.FreeMarkerTaglibFactoryUtil;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateHashModel;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

@DoPrivileged
public class PortletDisplayTemplateImpl
implements PortletDisplayTemplate {
    private static Log _log = LogFactoryUtil.getLog(PortletDisplayTemplateImpl.class);
    private Transformer _transformer = new Transformer("dynamic.data.lists.error.template", false);

    public DDMTemplate fetchDDMTemplate(long groupId, String displayStyle) {
        block8: {
            String uuid;
            Group companyGroup;
            block7: {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)group.getCompanyId());
                uuid = this.getDDMTemplateUuid(displayStyle);
                if (!Validator.isNull((String)uuid)) break block7;
                return null;
            }
            try {
                try {
                    return DDMTemplateLocalServiceUtil.getDDMTemplateByUuidAndGroupId((String)uuid, (long)groupId);
                }
                catch (NoSuchTemplateException noSuchTemplateException) {
                    try {
                        return DDMTemplateLocalServiceUtil.getDDMTemplateByUuidAndGroupId((String)uuid, (long)companyGroup.getGroupId());
                    }
                    catch (NoSuchTemplateException noSuchTemplateException2) {
                    }
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return null;
    }

    public long getDDMTemplateGroupId(long groupId) {
        try {
            Group liveGroup;
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                group = group.getParentGroup();
            }
            if (group.isStagingGroup() && !(liveGroup = group.getLiveGroup()).isStagedPortlet("183")) {
                return liveGroup.getGroupId();
            }
            return group.getGroupId();
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return groupId;
        }
    }

    public String getDDMTemplateUuid(String displayStyle) {
        if (!displayStyle.startsWith("ddmTemplate_")) {
            return null;
        }
        return displayStyle.substring("ddmTemplate_".length());
    }

    public long getPortletDisplayTemplateDDMTemplateId(long groupId, String displayStyle) {
        DDMTemplate portletDisplayDDMTemplate;
        long portletDisplayDDMTemplateId = 0L;
        long portletDisplayDDMTemplateGroupId = this.getDDMTemplateGroupId(groupId);
        if (displayStyle.startsWith("ddmTemplate_") && (portletDisplayDDMTemplate = this.fetchDDMTemplate(portletDisplayDDMTemplateGroupId, displayStyle)) != null) {
            portletDisplayDDMTemplateId = portletDisplayDDMTemplate.getTemplateId();
        }
        return portletDisplayDDMTemplateId;
    }

    public Map<String, TemplateVariableGroup> getTemplateVariableGroups(String language) {
        LinkedHashMap<String, TemplateVariableGroup> templateVariableGroups = new LinkedHashMap<String, TemplateVariableGroup>();
        TemplateVariableGroup fieldsTemplateVariableGroup = new TemplateVariableGroup("fields");
        fieldsTemplateVariableGroup.addCollectionVariable("entries", List.class, "entries", "entries-item", null, "curEntry", null);
        fieldsTemplateVariableGroup.addVariable("entry", null, "entry");
        templateVariableGroups.put("fields", fieldsTemplateVariableGroup);
        TemplateVariableGroup generalVariablesTemplateVariableGroup = new TemplateVariableGroup("general-variables");
        generalVariablesTemplateVariableGroup.addVariable("current-url", String.class, "currentURL");
        generalVariablesTemplateVariableGroup.addVariable("locale", Locale.class, "locale");
        generalVariablesTemplateVariableGroup.addVariable("portlet-preferences", Map.class, "portletPreferences");
        generalVariablesTemplateVariableGroup.addVariable("template-id", null, "template_id");
        generalVariablesTemplateVariableGroup.addVariable("theme-display", ThemeDisplay.class, "themeDisplay");
        templateVariableGroups.put("general-variables", generalVariablesTemplateVariableGroup);
        TemplateVariableGroup utilTemplateVariableGroup = new TemplateVariableGroup("util");
        utilTemplateVariableGroup.addVariable("http-request", HttpServletRequest.class, "request");
        if (language.equals("vm")) {
            utilTemplateVariableGroup.addVariable("liferay-taglib", VelocityTaglib.class, "taglibLiferay");
        }
        utilTemplateVariableGroup.addVariable("render-request", RenderRequest.class, "renderRequest");
        utilTemplateVariableGroup.addVariable("render-response", RenderResponse.class, "renderResponse");
        templateVariableGroups.put("util", utilTemplateVariableGroup);
        return templateVariableGroups;
    }

    public String renderDDMTemplate(PageContext pageContext, long ddmTemplateId, List<?> entries) throws Exception {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        return this.renderDDMTemplate(pageContext, ddmTemplateId, entries, contextObjects);
    }

    public String renderDDMTemplate(PageContext pageContext, long ddmTemplateId, List<?> entries, Map<String, Object> contextObjects) throws Exception {
        contextObjects.put("template_id", ddmTemplateId);
        contextObjects.put("entries", entries);
        if (!entries.isEmpty()) {
            contextObjects.put("entry", entries.get(0));
        }
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        contextObjects.put("locale", request.getLocale());
        contextObjects.put("request", request);
        RenderRequest renderRequest = (RenderRequest)request.getAttribute("javax.portlet.request");
        contextObjects.put("renderRequest", renderRequest);
        RenderResponse renderResponse = (RenderResponse)request.getAttribute("javax.portlet.response");
        contextObjects.put("renderResponse", renderResponse);
        PortletURL currentURL = PortletURLUtil.getCurrent((PortletRequest)renderRequest, (MimeResponse)renderResponse);
        contextObjects.put("currentURL", currentURL.toString());
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        contextObjects.put("themeDisplay", themeDisplay);
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)ddmTemplateId);
        String language = ddmTemplate.getLanguage();
        if (language.equals("ftl")) {
            this._addTaglibSupportFTL(contextObjects, pageContext);
        } else if (language.equals("vm")) {
            this._addTaglibSupportVM(contextObjects, pageContext);
        }
        contextObjects.putAll(this._getPortletPreferences(renderRequest));
        return this._transformer.transform(themeDisplay, contextObjects, ddmTemplate.getScript(), language);
    }

    private void _addTaglibSupportFTL(Map<String, Object> contextObjects, PageContext pageContext) throws Exception {
        Servlet servlet = (Servlet)pageContext.getPage();
        GenericServlet genericServlet = null;
        if (servlet instanceof GenericServlet) {
            genericServlet = (GenericServlet)servlet;
        } else {
            genericServlet = new GenericServletWrapper(servlet);
            genericServlet.init(pageContext.getServletConfig());
        }
        ServletContextHashModel servletContextHashModel = new ServletContextHashModel(genericServlet, ObjectWrapper.DEFAULT_WRAPPER);
        contextObjects.put("__FreeMarkerServlet.Application__", servletContextHashModel);
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        HttpRequestHashModel requestHashModel = new HttpRequestHashModel(request, response, ObjectWrapper.DEFAULT_WRAPPER);
        contextObjects.put("__FreeMarkerServlet.Request__", requestHashModel);
        TemplateHashModel taglibLiferayHash = FreeMarkerTaglibFactoryUtil.createTaglibFactory((ServletContext)pageContext.getServletContext());
        contextObjects.put("taglibLiferayHash", taglibLiferayHash);
    }

    private void _addTaglibSupportVM(Map<String, Object> contextObjects, PageContext pageContext) {
        contextObjects.put("taglibLiferay", this._getVelocityTaglib(pageContext));
    }

    private Map<String, Object> _getPortletPreferences(RenderRequest renderRequest) {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        Map map = portletPreferences.getMap();
        contextObjects.put("portletPreferences", map);
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            Object[] values = (String[])entry.getValue();
            if (ArrayUtil.isEmpty((Object[])values) || (value = values[0]) == null) continue;
            contextObjects.put((String)entry.getKey(), value);
        }
        return contextObjects;
    }

    private VelocityTaglib _getVelocityTaglib(PageContext pageContext) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        VelocityTaglibImpl velocityTaglib = new VelocityTaglibImpl(servletContext, request, (HttpServletResponse)new PipingServletResponse(response, (Writer)pageContext.getOut()), pageContext, null);
        return velocityTaglib;
    }
}

