/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.ActionUtil;
import com.liferay.portlet.portletconfiguration.util.PortletConfigurationUtil;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditScopeAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        PortletPreferences portletPreferences = ActionUtil.getLayoutPortletSetup((PortletRequest)actionRequest, portlet);
        actionRequest = ActionUtil.getWrappedActionRequest(actionRequest, portletPreferences);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("save")) {
            this.updateScope(actionRequest, portlet);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".refreshPortlet"), (Object)portletResource);
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".updatedConfiguration"));
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return actionMapping.findForward("portlet.portlet_configuration.error");
        }
        PortletPreferences portletPreferences = ActionUtil.getLayoutPortletSetup((PortletRequest)renderRequest, portlet);
        renderRequest = ActionUtil.getWrappedRenderRequest(renderRequest, portletPreferences);
        renderResponse.setTitle(ActionUtil.getTitle(portlet, renderRequest));
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_scope"));
    }

    protected Tuple getNewScope(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        String scopeType = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeType");
        long scopeGroupId = 0L;
        String scopeName = null;
        if (Validator.isNull((String)scopeType)) {
            scopeGroupId = layout.getGroupId();
        } else if (scopeType.equals("company")) {
            scopeGroupId = themeDisplay.getCompanyGroupId();
            scopeName = themeDisplay.translate("global");
        } else if (scopeType.equals("layout")) {
            String scopeLayoutUuid = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeLayoutUuid");
            Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout());
            if (!scopeLayout.hasScopeGroup()) {
                String name = String.valueOf(scopeLayout.getPlid());
                GroupLocalServiceUtil.addGroup((long)themeDisplay.getUserId(), (long)0L, (String)Layout.class.getName(), (long)scopeLayout.getPlid(), (long)0L, (String)name, null, (int)0, (boolean)true, (int)0, null, (boolean)false, (boolean)true, null);
            }
            scopeGroupId = scopeLayout.getGroupId();
            scopeName = scopeLayout.getName(themeDisplay.getLocale());
        } else {
            throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
        }
        return new Tuple(new Object[]{scopeGroupId, scopeName});
    }

    protected String getOldScopeName(ActionRequest actionRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletPreferences portletPreferences = actionRequest.getPreferences();
        String scopeType = GetterUtil.getString((String)portletPreferences.getValue("lfrScopeType", null));
        if (Validator.isNull((String)scopeType)) {
            return null;
        }
        String scopeName = null;
        if (scopeType.equals("company")) {
            scopeName = themeDisplay.translate("global");
        } else if (scopeType.equals("layout")) {
            String scopeLayoutUuid = GetterUtil.getString((String)portletPreferences.getValue("lfrScopeLayoutUuid", null));
            try {
                Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout());
                scopeName = scopeLayout.getName(themeDisplay.getLocale());
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        } else {
            throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
        }
        return scopeName;
    }

    protected String getPortletTitle(PortletRequest portletRequest, Portlet portlet, PortletPreferences portletPreferences) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletTitle = PortletConfigurationUtil.getPortletTitle((PortletPreferences)portletPreferences, (String)themeDisplay.getLanguageId());
        if (Validator.isNull((String)portletTitle)) {
            ServletContext servletContext = (ServletContext)portletRequest.getAttribute("CTX");
            PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
            ResourceBundle resourceBundle = portletConfig.getResourceBundle(themeDisplay.getLocale());
            portletTitle = resourceBundle.getString("javax.portlet.title");
        }
        return portletTitle;
    }

    protected void updateScope(ActionRequest actionRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String oldScopeName = this.getOldScopeName(actionRequest, portlet);
        PortletPreferences portletPreferences = actionRequest.getPreferences();
        String scopeType = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeType");
        portletPreferences.setValue("lfrScopeType", scopeType);
        String scopeLayoutUuid = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeLayoutUuid");
        if (!scopeType.equals("layout")) {
            scopeLayoutUuid = "";
        }
        portletPreferences.setValue("lfrScopeLayoutUuid", scopeLayoutUuid);
        String portletTitle = this.getPortletTitle((PortletRequest)actionRequest, portlet, portletPreferences);
        Tuple newScopeTuple = this.getNewScope(actionRequest);
        long newScopeGroupId = (Long)newScopeTuple.getObject(0);
        portletPreferences.setValue("groupId", String.valueOf(newScopeGroupId));
        String newScopeName = (String)newScopeTuple.getObject(1);
        String newPortletTitle = PortalUtil.getNewPortletTitle((String)portletTitle, (String)oldScopeName, (String)newScopeName);
        if (!newPortletTitle.equals(portletTitle)) {
            portletPreferences.setValue("portletSetupTitle_" + themeDisplay.getLanguageId(), newPortletTitle);
            portletPreferences.setValue("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        }
        portletPreferences.store();
    }
}

