/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portalsettings.action;

import com.liferay.portal.AccountNameException;
import com.liferay.portal.AddressCityException;
import com.liferay.portal.AddressStreetException;
import com.liferay.portal.AddressZipException;
import com.liferay.portal.CompanyMxException;
import com.liferay.portal.CompanyVirtualHostException;
import com.liferay.portal.CompanyWebIdException;
import com.liferay.portal.EmailAddressException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchCountryException;
import com.liferay.portal.NoSuchListTypeException;
import com.liferay.portal.NoSuchRegionException;
import com.liferay.portal.PhoneNumberException;
import com.liferay.portal.WebsiteURLException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditCompanyAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.validateCAS(actionRequest);
                this.validateLDAP(actionRequest);
                if (!SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                    this.setForward((PortletRequest)actionRequest, "portlet.portal_settings.edit_company");
                } else {
                    this.updateCompany(actionRequest);
                    this.updateDisplay(actionRequest);
                    this.sendRedirect(actionRequest, actionResponse);
                }
            }
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.portal_settings.error");
            }
            if (e2 instanceof AddressCityException || e2 instanceof AccountNameException || e2 instanceof AddressStreetException || e2 instanceof AddressZipException || e2 instanceof CompanyMxException || e2 instanceof CompanyVirtualHostException || e2 instanceof CompanyWebIdException || e2 instanceof EmailAddressException || e2 instanceof LocaleException || e2 instanceof NoSuchCountryException || e2 instanceof NoSuchListTypeException || e2 instanceof NoSuchRegionException || e2 instanceof PhoneNumberException || e2 instanceof WebsiteURLException) {
                if (e2 instanceof NoSuchListTypeException) {
                    NoSuchListTypeException nslte = (NoSuchListTypeException)((Object)e2);
                    SessionErrors.add((PortletRequest)actionRequest, (String)(String.valueOf(e2.getClass().getName()) + nslte.getType()));
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
                }
                this.setForward((PortletRequest)actionRequest, "portlet.portal_settings.edit_company");
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portal_settings.edit_company"));
    }

    protected void updateCompany(ActionRequest actionRequest) throws Exception {
        long companyId = PortalUtil.getCompanyId((PortletRequest)actionRequest);
        String virtualHostname = ParamUtil.getString((PortletRequest)actionRequest, (String)"virtualHostname");
        String mx = ParamUtil.getString((PortletRequest)actionRequest, (String)"mx");
        String homeURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"homeURL");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String legalName = ParamUtil.getString((PortletRequest)actionRequest, (String)"legalName");
        String legalId = ParamUtil.getString((PortletRequest)actionRequest, (String)"legalId");
        String legalType = ParamUtil.getString((PortletRequest)actionRequest, (String)"legalType");
        String sicCode = ParamUtil.getString((PortletRequest)actionRequest, (String)"sicCode");
        String tickerSymbol = ParamUtil.getString((PortletRequest)actionRequest, (String)"tickerSymbol");
        String industry = ParamUtil.getString((PortletRequest)actionRequest, (String)"industry");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        String size = ParamUtil.getString((PortletRequest)actionRequest, (String)"size");
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        String timeZoneId = ParamUtil.getString((PortletRequest)actionRequest, (String)"timeZoneId");
        List addresses = UsersAdminUtil.getAddresses((ActionRequest)actionRequest);
        List emailAddresses = UsersAdminUtil.getEmailAddresses((ActionRequest)actionRequest);
        List phones = UsersAdminUtil.getPhones((ActionRequest)actionRequest);
        List websites = UsersAdminUtil.getWebsites((ActionRequest)actionRequest);
        UnicodeProperties properties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"settings--");
        CompanyServiceUtil.updateCompany((long)companyId, (String)virtualHostname, (String)mx, (String)homeURL, (String)name, (String)legalName, (String)legalId, (String)legalType, (String)sicCode, (String)tickerSymbol, (String)industry, (String)type, (String)size, (String)languageId, (String)timeZoneId, (List)addresses, (List)emailAddresses, (List)phones, (List)websites, (UnicodeProperties)properties);
        PortalUtil.resetCDNHosts();
    }

    protected void updateDisplay(ActionRequest actionRequest) throws Exception {
        Company company = PortalUtil.getCompany((PortletRequest)actionRequest);
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        String timeZoneId = ParamUtil.getString((PortletRequest)actionRequest, (String)"timeZoneId");
        CompanyServiceUtil.updateDisplay((long)company.getCompanyId(), (String)languageId, (String)timeZoneId);
        boolean siteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--company.security.site.logo--");
        CompanyServiceUtil.updateSecurity((long)company.getCompanyId(), (String)company.getAuthType(), (boolean)company.isAutoLogin(), (boolean)company.isSendPassword(), (boolean)company.isStrangers(), (boolean)company.isStrangersWithMx(), (boolean)company.isStrangersVerify(), (boolean)siteLogo);
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        if (deleteLogo) {
            CompanyServiceUtil.deleteLogo((long)company.getCompanyId());
        }
    }

    protected void validateCAS(ActionRequest actionRequest) throws Exception {
        boolean casEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--cas.auth.enabled--");
        if (!casEnabled) {
            return;
        }
        String casLoginURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.login.url--");
        String casLogoutURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.logout.url--");
        String casServerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.server.name--");
        String casServerURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.server.url--");
        String casServiceURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.service.url--");
        String casNoSuchUserRedirectURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.no.such.user.redirect.url--");
        if (!Validator.isUrl((String)casLoginURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casLoginURLInvalid");
        }
        if (!Validator.isUrl((String)casLogoutURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casLogoutURLInvalid");
        }
        if (Validator.isNull((String)casServerName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casServerNameInvalid");
        }
        if (Validator.isNotNull((String)casServerURL) && Validator.isNotNull((String)casServiceURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casServerURLAndServiceURLConflict");
        } else if (Validator.isNull((String)casServerURL) && Validator.isNull((String)casServiceURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casServerURLAndServiceURLNotSet");
        } else {
            if (Validator.isNotNull((String)casServerURL) && !Validator.isUrl((String)casServerURL)) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"casServerURLInvalid");
            }
            if (Validator.isNotNull((String)casServiceURL) && !Validator.isUrl((String)casServiceURL)) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"casServiceURLInvalid");
            }
        }
        if (Validator.isNotNull((String)casNoSuchUserRedirectURL) && !Validator.isUrl((String)casNoSuchUserRedirectURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casNoSuchUserURLInvalid");
        }
    }

    protected void validateLDAP(ActionRequest actionRequest) throws Exception {
        if (!PropsValues.LDAP_IMPORT_USER_PASSWORD_AUTOGENERATED) {
            return;
        }
        boolean ldapExportEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--ldap.export.enabled--");
        boolean ldapImportEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--ldap.import.enabled--");
        if (ldapExportEnabled && ldapImportEnabled) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"ldapExportAndImportOnPasswordAutogeneration");
        }
    }
}

