/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.service.PollsQuestionLocalServiceUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class PollsQuestionStagedModelDataHandler
extends BaseStagedModelDataHandler<PollsQuestion> {
    public static final String[] CLASS_NAMES = new String[]{PollsQuestion.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        PollsQuestion question = PollsQuestionLocalServiceUtil.fetchPollsQuestionByUuidAndGroupId((String)uuid, (long)groupId);
        if (question != null) {
            PollsQuestionLocalServiceUtil.deleteQuestion((PollsQuestion)question);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(PollsQuestion question) {
        return question.getTitle();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, PollsQuestion question) throws Exception {
        Element questionElement = portletDataContext.getExportDataElement((ClassedModel)question);
        portletDataContext.addClassedModel(questionElement, ExportImportPathUtil.getModelPath((StagedModel)question), (ClassedModel)question);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, PollsQuestion question) throws Exception {
        long userId = portletDataContext.getUserId(question.getUserUuid());
        int expirationMonth = 0;
        int expirationDay = 0;
        int expirationYear = 0;
        int expirationHour = 0;
        int expirationMinute = 0;
        boolean neverExpire = true;
        Date expirationDate = question.getExpirationDate();
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar();
            expirationCal.setTime(expirationDate);
            expirationMonth = expirationCal.get(2);
            expirationDay = expirationCal.get(5);
            expirationYear = expirationCal.get(1);
            expirationHour = expirationCal.get(10);
            expirationMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationHour += 12;
            }
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)question);
        PollsQuestion importedQuestion = null;
        if (portletDataContext.isDataStrategyMirror()) {
            PollsQuestion existingQuestion = PollsQuestionLocalServiceUtil.fetchPollsQuestionByUuidAndGroupId((String)question.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingQuestion == null) {
                serviceContext.setUuid(question.getUuid());
                importedQuestion = PollsQuestionLocalServiceUtil.addQuestion((long)userId, (Map)question.getTitleMap(), (Map)question.getDescriptionMap(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
            } else {
                importedQuestion = PollsQuestionLocalServiceUtil.updateQuestion((long)userId, (long)existingQuestion.getQuestionId(), (Map)question.getTitleMap(), (Map)question.getDescriptionMap(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
            }
        } else {
            importedQuestion = PollsQuestionLocalServiceUtil.addQuestion((long)userId, (Map)question.getTitleMap(), (Map)question.getDescriptionMap(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)question, (ClassedModel)importedQuestion);
    }
}

