/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.mobiledevicerules.DuplicateRuleGroupInstanceException;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.base.MDRRuleGroupInstanceLocalServiceBaseImpl;
import com.liferay.portlet.mobiledevicerules.util.RuleGroupInstancePriorityComparator;
import java.util.Date;
import java.util.List;

public class MDRRuleGroupInstanceLocalServiceImpl
extends MDRRuleGroupInstanceLocalServiceBaseImpl {
    public MDRRuleGroupInstance addRuleGroupInstance(long groupId, String className, long classPK, long ruleGroupId, int priority, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(serviceContext.getUserId());
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        this.validate(classNameId, classPK, ruleGroupId);
        long ruleGroupInstanceId = this.counterLocalService.increment();
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstanceLocalService.createMDRRuleGroupInstance(ruleGroupInstanceId);
        ruleGroupInstance.setUuid(serviceContext.getUuid());
        ruleGroupInstance.setGroupId(groupId);
        ruleGroupInstance.setCompanyId(serviceContext.getCompanyId());
        ruleGroupInstance.setCreateDate(serviceContext.getCreateDate(now));
        ruleGroupInstance.setModifiedDate(serviceContext.getModifiedDate(now));
        ruleGroupInstance.setUserId(serviceContext.getUserId());
        ruleGroupInstance.setUserName(user.getFullName());
        ruleGroupInstance.setClassNameId(classNameId);
        ruleGroupInstance.setClassPK(classPK);
        ruleGroupInstance.setRuleGroupId(ruleGroupId);
        ruleGroupInstance.setPriority(priority);
        return this.updateMDRRuleGroupInstance(ruleGroupInstance);
    }

    public MDRRuleGroupInstance addRuleGroupInstance(long groupId, String className, long classPK, long ruleGroupId, ServiceContext serviceContext) throws PortalException, SystemException {
        List<MDRRuleGroupInstance> ruleGroupInstances = this.getRuleGroupInstances(className, classPK, -1, -1, (OrderByComparator)new RuleGroupInstancePriorityComparator());
        int priority = 0;
        if (!ruleGroupInstances.isEmpty()) {
            MDRRuleGroupInstance highestPriorityRuleGroupInstance = ruleGroupInstances.get(ruleGroupInstances.size() - 1);
            priority = highestPriorityRuleGroupInstance.getPriority() + 1;
        }
        return this.addRuleGroupInstance(groupId, className, classPK, ruleGroupId, priority, serviceContext);
    }

    public void deleteGroupRuleGroupInstances(long groupId) throws SystemException {
        List ruleGroupInstances = this.mdrRuleGroupInstancePersistence.findByGroupId(groupId);
        for (MDRRuleGroupInstance ruleGroupInstance : ruleGroupInstances) {
            this.mdrRuleGroupInstanceLocalService.deleteRuleGroupInstance(ruleGroupInstance);
        }
    }

    public void deleteRuleGroupInstance(long ruleGroupInstanceId) throws SystemException {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.fetchByPrimaryKey(ruleGroupInstanceId);
        this.mdrRuleGroupInstanceLocalService.deleteRuleGroupInstance(ruleGroupInstance);
    }

    @SystemEvent(action=1, type=1)
    public void deleteRuleGroupInstance(MDRRuleGroupInstance ruleGroupInstance) throws SystemException {
        this.mdrRuleGroupInstancePersistence.remove((BaseModel)ruleGroupInstance);
        this.mdrActionLocalService.deleteActions(ruleGroupInstance.getRuleGroupInstanceId());
    }

    public void deleteRuleGroupInstances(long ruleGroupId) throws SystemException {
        List ruleGroupInstances = this.mdrRuleGroupInstancePersistence.findByRuleGroupId(ruleGroupId);
        for (MDRRuleGroupInstance ruleGroupInstance : ruleGroupInstances) {
            this.mdrRuleGroupInstanceLocalService.deleteRuleGroupInstance(ruleGroupInstance);
        }
    }

    public MDRRuleGroupInstance fetchRuleGroupInstance(long ruleGroupInstanceId) throws SystemException {
        return this.mdrRuleGroupInstancePersistence.fetchByPrimaryKey(ruleGroupInstanceId);
    }

    public MDRRuleGroupInstance fetchRuleGroupInstance(String className, long classPK, long ruleGroupId) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mdrRuleGroupInstancePersistence.fetchByC_C_R(classNameId, classPK, ruleGroupId);
    }

    public MDRRuleGroupInstance getRuleGroupInstance(long ruleGroupInstanceId) throws PortalException, SystemException {
        return this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
    }

    public MDRRuleGroupInstance getRuleGroupInstance(String className, long classPK, long ruleGroupId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mdrRuleGroupInstancePersistence.findByC_C_R(classNameId, classPK, ruleGroupId);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(long ruleGroupId) throws SystemException {
        return this.mdrRuleGroupInstancePersistence.findByRuleGroupId(ruleGroupId);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(long ruleGroupId, int start, int end) throws SystemException {
        return this.mdrRuleGroupInstancePersistence.findByRuleGroupId(ruleGroupId, start, end);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mdrRuleGroupInstancePersistence.findByC_C(classNameId, classPK);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(String className, long classPK, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mdrRuleGroupInstancePersistence.findByC_C(classNameId, classPK, start, end, orderByComparator);
    }

    public int getRuleGroupInstancesCount(long ruleGroupId) throws SystemException {
        return this.mdrRuleGroupInstancePersistence.countByRuleGroupId(ruleGroupId);
    }

    public int getRuleGroupInstancesCount(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mdrRuleGroupInstancePersistence.countByC_C(classNameId, classPK);
    }

    public MDRRuleGroupInstance updateRuleGroupInstance(long ruleGroupInstanceId, int priority) throws PortalException, SystemException {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
        ruleGroupInstance.setPriority(priority);
        this.mdrRuleGroupInstancePersistence.update((BaseModel)ruleGroupInstance);
        return ruleGroupInstance;
    }

    protected void validate(long classNameId, long classPK, long ruleGroupId) throws PortalException, SystemException {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.fetchByC_C_R(classNameId, classPK, ruleGroupId);
        if (ruleGroupInstance != null) {
            throw new DuplicateRuleGroupInstanceException();
        }
        this.mdrRuleGroupLocalService.getMDRRuleGroup(ruleGroupId);
    }
}

