/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.lar;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleLocalServiceUtil;
import java.util.Map;

public class MDRRuleStagedModelDataHandler
extends BaseStagedModelDataHandler<MDRRule> {
    public static final String[] CLASS_NAMES = new String[]{MDRRule.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws SystemException {
        MDRRule rule = MDRRuleLocalServiceUtil.fetchMDRRuleByUuidAndGroupId((String)uuid, (long)groupId);
        if (rule != null) {
            MDRRuleLocalServiceUtil.deleteRule((MDRRule)rule);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MDRRule rule) {
        return rule.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MDRRule rule) throws Exception {
        MDRRuleGroup ruleGroup = MDRRuleGroupLocalServiceUtil.getRuleGroup((long)rule.getRuleGroupId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)rule, (StagedModel)ruleGroup, (String)"parent");
        Element ruleElement = portletDataContext.getExportDataElement((ClassedModel)rule);
        portletDataContext.addClassedModel(ruleElement, ExportImportPathUtil.getModelPath((StagedModel)rule), (ClassedModel)rule);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MDRRule rule) throws Exception {
        String ruleGroupPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)MDRRuleGroup.class.getName(), (long)rule.getRuleGroupId());
        MDRRuleGroup ruleGroup = (MDRRuleGroup)portletDataContext.getZipEntryAsObject(ruleGroupPath);
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)ruleGroup);
        Map ruleGroupIds = portletDataContext.getNewPrimaryKeysMap(MDRRuleGroup.class);
        long ruleGroupId = MapUtil.getLong((Map)ruleGroupIds, (long)rule.getRuleGroupId(), (long)rule.getRuleGroupId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)rule);
        serviceContext.setUserId(portletDataContext.getUserId(rule.getUserUuid()));
        MDRRule importedRule = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRRule existingRule = MDRRuleLocalServiceUtil.fetchMDRRuleByUuidAndGroupId((String)rule.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingRule == null) {
                serviceContext.setUuid(rule.getUuid());
                importedRule = MDRRuleLocalServiceUtil.addRule((long)ruleGroupId, (Map)rule.getNameMap(), (Map)rule.getDescriptionMap(), (String)rule.getType(), (UnicodeProperties)rule.getTypeSettingsProperties(), (ServiceContext)serviceContext);
            } else {
                importedRule = MDRRuleLocalServiceUtil.updateRule((long)existingRule.getRuleId(), (Map)rule.getNameMap(), (Map)rule.getDescriptionMap(), (String)rule.getType(), (UnicodeProperties)rule.getTypeSettingsProperties(), (ServiceContext)serviceContext);
            }
        } else {
            importedRule = MDRRuleLocalServiceUtil.addRule((long)ruleGroupId, (Map)rule.getNameMap(), (Map)rule.getDescriptionMap(), (String)rule.getType(), (UnicodeProperties)rule.getTypeSettingsProperties(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)rule, (ClassedModel)importedRule);
    }
}

