/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.trash.MBCategoryTrashRenderer;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class MBCategoryTrashHandler
extends BaseTrashHandler {
    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        MBCategoryLocalServiceUtil.deleteCategory((MBCategory)category, (boolean)false);
    }

    public String getClassName() {
        return MBCategory.class.getName();
    }

    public ContainerModel getContainerModel(long containerModelId) throws PortalException, SystemException {
        return MBCategoryLocalServiceUtil.getCategory((long)containerModelId);
    }

    public String getContainerModelClassName() {
        return MBCategory.class.getName();
    }

    public String getContainerModelName() {
        return "category";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        List categories = MBCategoryLocalServiceUtil.getCategories((long)category.getGroupId(), (long)parentContainerModelId, (int)0, (int)start, (int)end);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        for (MBCategory curCategory : categories) {
            containerModels.add((ContainerModel)curCategory);
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        return MBCategoryLocalServiceUtil.getCategoriesCount((long)category.getGroupId(), (long)parentContainerModelId, (int)0);
    }

    public String getDeleteMessage() {
        return "found-in-deleted-category-x";
    }

    public List<ContainerModel> getParentContainerModels(long containerModelId) throws PortalException, SystemException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getContainerModel(containerModelId);
        while (containerModel.getParentContainerModelId() > 0L) {
            if ((containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) == null) break;
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK);
        portletURL.setParameter("mbCategoryId", String.valueOf(category.getCategoryId()));
        return portletURL.toString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK);
        portletURL.setParameter("mbCategoryId", String.valueOf(category.getParentCategoryId()));
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        return MBUtil.getAbsolutePath(portletRequest, category.getParentCategoryId());
    }

    public String getRootContainerModelName() {
        return "home";
    }

    public String getTrashContainedModelName() {
        return "threads";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        return MBThreadLocalServiceUtil.getThreadsCount((long)category.getGroupId(), (long)classPK, (int)8);
    }

    public List<TrashRenderer> getTrashContainedModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        List threads = MBThreadLocalServiceUtil.getThreads((long)category.getGroupId(), (long)classPK, (int)8, (int)start, (int)end);
        for (MBThread thread : threads) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)MBThread.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(thread.getPrimaryKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public String getTrashContainerModelName() {
        return "categories";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        return MBCategoryLocalServiceUtil.getCategoriesCount((long)category.getGroupId(), (long)classPK, (int)8);
    }

    public List<TrashRenderer> getTrashContainerModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        List categories = MBCategoryLocalServiceUtil.getCategories((long)category.getGroupId(), (long)classPK, (int)8, (int)start, (int)end);
        for (MBCategory curCategory : categories) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)MBCategory.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(curCategory.getPrimaryKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        return category.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        return new MBCategoryTrashRenderer(category);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        if (trashActionId.equals("MOVE")) {
            return MBCategoryPermission.contains(permissionChecker, groupId, classPK, "ADD_CATEGORY");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        return category.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        return category.isInTrashContainer();
    }

    public boolean isMovable() {
        return true;
    }

    public boolean isRestorable(long classPK) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        if (category.getParentCategoryId() > 0L && MBCategoryLocalServiceUtil.fetchMBCategory((long)category.getParentCategoryId()) == null) {
            return false;
        }
        return !category.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        MBCategoryLocalServiceUtil.moveCategory((long)classPK, (long)containerModelId, (boolean)false);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        MBCategoryLocalServiceUtil.moveCategoryFromTrash((long)userId, (long)classPK, (long)containerModelId);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        MBCategoryLocalServiceUtil.restoreCategoryFromTrash((long)userId, (long)classPK);
    }

    public void updateTitle(long classPK, String name) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        category.setName(name);
        MBCategoryLocalServiceUtil.updateMBCategory((MBCategory)category);
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        String portletId = "19";
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        long plid = PortalUtil.getPlidFromPortletId((long)category.getGroupId(), (String)"19");
        if (plid == 0L) {
            portletId = "162";
            plid = PortalUtil.getControlPanelPlid((PortletRequest)portletRequest);
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        if (portletId.equals("19")) {
            portletURL.setParameter("struts_action", "/message_boards/view");
        } else {
            portletURL.setParameter("struts_action", "/message_boards_admin/view");
        }
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)classPK);
        return MBCategoryPermission.contains(permissionChecker, category, actionId);
    }
}

