/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import java.util.List;

public class MBDiscussionPermission {
    public static void check(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long messageId, long ownerId, String actionId) throws PortalException, SystemException {
        if (!MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, messageId, ownerId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long ownerId, String actionId) throws PortalException, SystemException {
        if (!MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, ownerId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long messageId, long ownerId, String actionId) throws PortalException, SystemException {
        Boolean hasPermission;
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
        if (PropsValues.DISCUSSION_COMMENTS_ALWAYS_EDITABLE_BY_OWNER && permissionChecker.getUserId() == message.getUserId()) {
            return true;
        }
        if (message.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)message.getGroupId(), (String)message.getWorkflowClassName(), (long)message.getMessageId(), (String)actionId)) != null) {
            return hasPermission;
        }
        return MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, ownerId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long ownerId, String actionId) throws SystemException {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)groupId, (String)className, (long)classPK, (String)"19", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        List resourceActions = ResourceActionsUtil.getResourceActions((String)className);
        if (!resourceActions.contains(actionId)) {
            return true;
        }
        if (MBBanLocalServiceUtil.hasBan((long)groupId, (long)permissionChecker.getUserId())) {
            return false;
        }
        if (ownerId > 0L && permissionChecker.hasOwnerPermission(companyId, className, classPK, ownerId, actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(groupId, className, classPK, actionId);
    }
}

