/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.NoSuchCategoryException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBPermission;

public class MBCategoryPermission {
    public static void check(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException, SystemException {
        if (!MBCategoryPermission.contains(permissionChecker, groupId, categoryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException, SystemException {
        if (!MBCategoryPermission.contains(permissionChecker, categoryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, MBCategory category, String actionId) throws PortalException, SystemException {
        if (!MBCategoryPermission.contains(permissionChecker, category, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException, SystemException {
        if (categoryId == 0L || categoryId == -1L) {
            return MBPermission.contains(permissionChecker, groupId, actionId);
        }
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        return MBCategoryPermission.contains(permissionChecker, category, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        return MBCategoryPermission.contains(permissionChecker, category, actionId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contains(PermissionChecker permissionChecker, MBCategory category, String actionId) throws PortalException, SystemException {
        Boolean hasPermission;
        if (actionId.equals("ADD_CATEGORY")) {
            actionId = "ADD_SUBCATEGORY";
        }
        if ((hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)category.getGroupId(), (String)MBCategory.class.getName(), (long)category.getCategoryId(), (String)"19", (String)actionId)) != null) {
            return hasPermission;
        }
        if (MBBanLocalServiceUtil.hasBan((long)category.getGroupId(), (long)permissionChecker.getUserId())) {
            return false;
        }
        if (!actionId.equals("VIEW")) return MBCategoryPermission._hasPermission(permissionChecker, category, actionId);
        if (!PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) return MBCategoryPermission._hasPermission(permissionChecker, category, actionId);
        try {
            long categoryId = category.getCategoryId();
            while (true) {
                if (categoryId == 0L) {
                    return true;
                }
                category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
                if (!MBCategoryPermission._hasPermission(permissionChecker, category, actionId)) {
                    return false;
                }
                categoryId = category.getParentCategoryId();
            }
        }
        catch (NoSuchCategoryException nsce) {
            if (category.isInTrash()) return true;
            throw nsce;
        }
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, MBCategory category, String actionId) {
        return permissionChecker.hasOwnerPermission(category.getCompanyId(), MBCategory.class.getName(), category.getCategoryId(), category.getUserId(), actionId) || permissionChecker.hasPermission(category.getGroupId(), MBCategory.class.getName(), category.getCategoryId(), actionId);
    }
}

