/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.CategoryNameException;
import com.liferay.portlet.messageboards.NoSuchMailingListException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.service.base.MBCategoryLocalServiceBaseImpl;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MBCategoryLocalServiceImpl
extends MBCategoryLocalServiceBaseImpl {
    public MBCategory addCategory(long userId, long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addCategory(userId, parentCategoryId, name, description, MBCategoryConstants.DEFAULT_DISPLAY_STYLE, null, null, null, 0, false, null, null, 0, null, false, null, 0, false, null, null, false, false, serviceContext);
    }

    public MBCategory addCategory(long userId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean mailingListActive, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentCategoryId = this.getParentCategoryId(groupId, parentCategoryId);
        Date now = new Date();
        this.validate(name);
        long categoryId = this.counterLocalService.increment();
        MBCategory category = this.mbCategoryPersistence.create(categoryId);
        category.setUuid(serviceContext.getUuid());
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setCreateDate(serviceContext.getCreateDate(now));
        category.setModifiedDate(serviceContext.getModifiedDate(now));
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        category.setDisplayStyle(displayStyle);
        category.setExpandoBridgeAttributes(serviceContext);
        this.mbCategoryPersistence.update((BaseModel)category);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.mbMailingListLocalService.addMailingList(userId, groupId, category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        return category;
    }

    public void addCategoryResources(long categoryId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(long categoryId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, groupPermissions, guestPermissions);
    }

    public void addCategoryResources(MBCategory category, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(MBCategory category, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), groupPermissions, guestPermissions);
    }

    public void deleteCategories(long groupId) throws PortalException, SystemException {
        List categories = this.mbCategoryPersistence.findByGroupId(groupId);
        for (MBCategory category : categories) {
            this.mbCategoryLocalService.deleteCategory(category);
        }
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.mbCategoryLocalService.deleteCategory(category);
    }

    @SystemEvent(action=1, type=1)
    public void deleteCategory(MBCategory category) throws PortalException, SystemException {
        this.deleteCategory(category, true);
    }

    @SystemEvent(action=1, type=1)
    public void deleteCategory(MBCategory category, boolean includeTrashedEntries) throws PortalException, SystemException {
        List categories = this.mbCategoryPersistence.findByG_P(category.getGroupId(), category.getCategoryId());
        for (MBCategory curCategory : categories) {
            if (!includeTrashedEntries && curCategory.isInTrash()) continue;
            this.deleteCategory(curCategory, includeTrashedEntries);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        indexer.delete((Object)category);
        this.mbThreadLocalService.deleteThreads(category.getGroupId(), category.getCategoryId(), includeTrashedEntries);
        try {
            this.mbMailingListLocalService.deleteCategoryMailingList(category.getGroupId(), category.getCategoryId());
        }
        catch (NoSuchMailingListException noSuchMailingListException) {}
        this.subscriptionLocalService.deleteSubscriptions(category.getCompanyId(), MBCategory.class.getName(), category.getCategoryId());
        this.expandoRowLocalService.deleteRows(category.getCategoryId());
        this.resourceLocalService.deleteResource(category.getCompanyId(), MBCategory.class.getName(), 4, category.getCategoryId());
        this.trashEntryLocalService.deleteEntry(MBCategory.class.getName(), category.getCategoryId());
        this.mbCategoryPersistence.remove((BaseModel)category);
    }

    public List<MBCategory> getCategories(long groupId) throws SystemException {
        return this.mbCategoryPersistence.findByGroupId(groupId);
    }

    public List<MBCategory> getCategories(long groupId, int status) throws SystemException {
        return this.mbCategoryPersistence.findByG_S(groupId, status);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int start, int end) throws SystemException {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
        }
        return this.mbCategoryPersistence.findByG_P_S(groupId, parentCategoryId, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int start, int end) throws SystemException {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryIds, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryIds, start, end);
        }
        return this.mbCategoryPersistence.findByG_P_S(groupId, parentCategoryIds, status, start, end);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId) throws SystemException {
        ArrayList<Object> categoriesAndThreads = new ArrayList<Object>();
        List<MBCategory> categories = this.getCategories(groupId, categoryId, -1, -1);
        categoriesAndThreads.addAll(categories);
        List threads = this.mbThreadLocalService.getThreads(groupId, categoryId, -1, -1, -1);
        categoriesAndThreads.addAll(threads);
        return categoriesAndThreads;
    }

    public int getCategoriesCount(long groupId) throws SystemException {
        return this.mbCategoryPersistence.countByGroupId(groupId);
    }

    public int getCategoriesCount(long groupId, int status) throws SystemException {
        return this.mbCategoryPersistence.countByG_S(groupId, status);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) throws SystemException {
        return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryId);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryId);
        }
        return this.mbCategoryPersistence.countByG_P_S(groupId, parentCategoryId, status);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds) throws SystemException {
        return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryIds);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds, int status) throws SystemException {
        if (status == -1) {
            return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryIds);
        }
        return this.mbCategoryPersistence.countByG_P_S(groupId, parentCategoryIds, status);
    }

    public MBCategory getCategory(long categoryId) throws PortalException, SystemException {
        MBCategoryImpl category = null;
        if (categoryId != 0L && categoryId != -1L) {
            category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        } else {
            category = new MBCategoryImpl();
            category.setCategoryId(categoryId);
            category.setParentCategoryId(categoryId);
        }
        return category;
    }

    public List<MBCategory> getCompanyCategories(long companyId, int start, int end) throws SystemException {
        return this.mbCategoryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyCategoriesCount(long companyId) throws SystemException {
        return this.mbCategoryPersistence.countByCompanyId(companyId);
    }

    public List<Long> getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) throws SystemException {
        List categories = this.mbCategoryPersistence.findByG_P(groupId, categoryId);
        for (MBCategory category : categories) {
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
        return categoryIds;
    }

    public List<MBCategory> getSubscribedCategories(long groupId, long userId, int start, int end) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(-1, start, end, null);
        return this.mbCategoryFinder.findByS_G_U_P(groupId, userId, null, queryDefinition);
    }

    public int getSubscribedCategoriesCount(long groupId, long userId) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.countByS_G_U_P(groupId, userId, null, queryDefinition);
    }

    public void moveCategoriesToTrash(long groupId, long userId) throws PortalException, SystemException {
        List categories = this.mbCategoryPersistence.findByGroupId(groupId);
        for (MBCategory category : categories) {
            this.moveCategoryToTrash(userId, category.getCategoryId());
        }
    }

    public MBCategory moveCategory(long categoryId, long parentCategoryId, boolean mergeWithParentCategory) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this.getParentCategoryId(category, parentCategoryId);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != 0L && parentCategoryId != -1L) {
            this.mergeCategories(category, parentCategoryId);
            return category;
        }
        category.setParentCategoryId(parentCategoryId);
        return (MBCategory)this.mbCategoryPersistence.update((BaseModel)category);
    }

    public MBCategory moveCategoryFromTrash(long userId, long categoryId, long newCategoryId) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        TrashEntry trashEntry = category.getTrashEntry();
        if (trashEntry.isTrashEntry(MBCategory.class, categoryId)) {
            this.restoreCategoryFromTrash(userId, categoryId);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(trashEntry.getEntryId(), MBCategory.class.getName(), category.getCategoryId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, categoryId, status);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            User user = this.userPersistence.findByPrimaryKey(userId);
            List<Object> categoriesAndThreads = this.getCategoriesAndThreads(category.getGroupId(), categoryId);
            this.restoreDependentsFromTrash(user, categoriesAndThreads, trashEntry.getEntryId());
        }
        return this.moveCategory(categoryId, newCategoryId, false);
    }

    public MBCategory moveCategoryToTrash(long userId, long categoryId) throws PortalException, SystemException {
        MBCategory category = this.updateStatus(userId, categoryId, 8);
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, category.getGroupId(), MBCategory.class.getName(), categoryId, category.getUuid(), null, 0, null, null);
        User user = this.userPersistence.findByPrimaryKey(userId);
        List<Object> categoriesAndThreads = this.getCategoriesAndThreads(category.getGroupId(), categoryId);
        this.moveDependentsToTrash(user, categoriesAndThreads, trashEntry.getEntryId());
        return category;
    }

    public void restoreCategoryFromTrash(long userId, long categoryId) throws PortalException, SystemException {
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(MBCategory.class.getName(), categoryId);
        MBCategory category = this.updateStatus(userId, categoryId, 0);
        User user = this.userPersistence.findByPrimaryKey(userId);
        List<Object> categoriesAndThreads = this.getCategoriesAndThreads(category.getGroupId(), categoryId);
        this.restoreDependentsFromTrash(user, categoriesAndThreads, trashEntry.getEntryId());
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
    }

    public void subscribeCategory(long userId, long groupId, long categoryId) throws PortalException, SystemException {
        if (categoryId == 0L) {
            categoryId = groupId;
        }
        this.subscriptionLocalService.addSubscription(userId, groupId, MBCategory.class.getName(), categoryId);
    }

    public void unsubscribeCategory(long userId, long groupId, long categoryId) throws PortalException, SystemException {
        if (categoryId == 0L) {
            categoryId = groupId;
        }
        this.subscriptionLocalService.deleteSubscription(userId, MBCategory.class.getName(), categoryId);
    }

    public MBCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean mailingListActive, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException, SystemException {
        if (categoryId == 0L || categoryId == -1L) {
            return null;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this.getParentCategoryId(category, parentCategoryId);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != 0L && parentCategoryId != -1L) {
            this.mergeCategories(category, parentCategoryId);
            return category;
        }
        this.validate(name);
        category.setModifiedDate(serviceContext.getModifiedDate(null));
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        if (!displayStyle.equals(category.getDisplayStyle())) {
            category.setDisplayStyle(displayStyle);
            this.updateChildCategoriesDisplayStyle(category, displayStyle);
        }
        category.setExpandoBridgeAttributes(serviceContext);
        this.mbCategoryPersistence.update((BaseModel)category);
        MBMailingList mailingList = this.mbMailingListPersistence.fetchByG_C(category.getGroupId(), category.getCategoryId());
        if (mailingList != null) {
            this.mbMailingListLocalService.updateMailingList(mailingList.getMailingListId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        } else {
            this.mbMailingListLocalService.addMailingList(category.getUserId(), category.getGroupId(), category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        }
        return category;
    }

    public MBCategory updateStatus(long userId, long categoryId, int status) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        category.setStatus(status);
        category.setStatusByUserId(user.getUserId());
        category.setStatusByUserName(user.getFullName());
        category.setStatusDate(new Date());
        this.mbCategoryPersistence.update((BaseModel)category);
        return category;
    }

    protected long getParentCategoryId(long groupId, long parentCategoryId) throws SystemException {
        MBCategory parentCategory;
        if (parentCategoryId != 0L && parentCategoryId != -1L && ((parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId)) == null || groupId != parentCategory.getGroupId())) {
            parentCategoryId = 0L;
        }
        return parentCategoryId;
    }

    protected long getParentCategoryId(MBCategory category, long parentCategoryId) throws SystemException {
        if (parentCategoryId == 0L || parentCategoryId == -1L) {
            return parentCategoryId;
        }
        if (category.getCategoryId() == parentCategoryId) {
            return category.getParentCategoryId();
        }
        MBCategory parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentCategory == null || category.getGroupId() != parentCategory.getGroupId()) {
            return category.getParentCategoryId();
        }
        ArrayList<Long> subcategoryIds = new ArrayList<Long>();
        this.getSubcategoryIds(subcategoryIds, category.getGroupId(), category.getCategoryId());
        if (subcategoryIds.contains(parentCategoryId)) {
            return category.getParentCategoryId();
        }
        return parentCategoryId;
    }

    protected void mergeCategories(MBCategory fromCategory, long toCategoryId) throws PortalException, SystemException {
        if (toCategoryId == 0L || toCategoryId == -1L) {
            return;
        }
        List categories = this.mbCategoryPersistence.findByG_P(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (MBCategory category : categories) {
            this.mergeCategories(category, toCategoryId);
        }
        List threads = this.mbThreadPersistence.findByG_C(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (MBThread thread : threads) {
            thread.setCategoryId(toCategoryId);
            this.mbThreadPersistence.update((BaseModel)thread);
            List messages = this.mbMessagePersistence.findByThreadId(thread.getThreadId());
            for (MBMessage message : messages) {
                message.setCategoryId(toCategoryId);
                this.mbMessagePersistence.update((BaseModel)message);
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                indexer.reindex((Object)message);
            }
        }
        MBCategory toCategory = this.mbCategoryPersistence.findByPrimaryKey(toCategoryId);
        toCategory.setThreadCount(fromCategory.getThreadCount() + toCategory.getThreadCount());
        toCategory.setMessageCount(fromCategory.getMessageCount() + toCategory.getMessageCount());
        this.mbCategoryPersistence.update((BaseModel)toCategory);
        this.deleteCategory(fromCategory);
    }

    protected void moveDependentsToTrash(User user, List<Object> categoriesAndThreads, long trashEntryId) throws PortalException, SystemException {
        for (Object object : categoriesAndThreads) {
            MBCategory category;
            int oldStatus;
            if (object instanceof MBThread) {
                MBThread thread = (MBThread)object;
                oldStatus = thread.getStatus();
                if (oldStatus == 8) continue;
                thread.setStatus(8);
                this.mbThreadPersistence.update((BaseModel)thread);
                if (oldStatus != 0) {
                    this.trashVersionLocalService.addTrashVersion(trashEntryId, MBThread.class.getName(), thread.getThreadId(), oldStatus);
                }
                this.mbThreadLocalService.moveDependentsToTrash(user.getUserId(), thread.getThreadId(), trashEntryId);
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
                indexer.reindex((Object)thread);
                continue;
            }
            if (!(object instanceof MBCategory) || (category = (MBCategory)object).isInTrash()) continue;
            oldStatus = category.getStatus();
            category.setStatus(8);
            this.mbCategoryPersistence.update((BaseModel)category);
            if (oldStatus != 0) {
                this.trashVersionLocalService.addTrashVersion(trashEntryId, MBCategory.class.getName(), category.getCategoryId(), oldStatus);
            }
            this.moveDependentsToTrash(user, this.getCategoriesAndThreads(category.getGroupId(), category.getCategoryId()), trashEntryId);
        }
    }

    protected void restoreDependentsFromTrash(User user, List<Object> categoriesAndThreads, long trashEntryId) throws PortalException, SystemException {
        for (Object object : categoriesAndThreads) {
            int oldStatus;
            TrashVersion trashVersion;
            TrashEntry trashEntry;
            if (object instanceof MBThread) {
                MBThread thread = (MBThread)object;
                trashEntry = this.trashEntryLocalService.fetchEntry(MBThread.class.getName(), thread.getThreadId());
                if (trashEntry != null) continue;
                trashVersion = this.trashVersionLocalService.fetchVersion(trashEntryId, MBThread.class.getName(), thread.getThreadId());
                oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                thread.setStatus(oldStatus);
                this.mbThreadPersistence.update((BaseModel)thread);
                this.mbThreadLocalService.restoreDependentsFromTrash(user.getUserId(), thread.getThreadId(), trashEntryId);
                if (trashVersion != null) {
                    this.trashVersionLocalService.deleteTrashVersion(trashVersion);
                }
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
                indexer.reindex((Object)thread);
                continue;
            }
            if (!(object instanceof MBCategory)) continue;
            MBCategory category = (MBCategory)object;
            trashEntry = this.trashEntryLocalService.fetchEntry(MBCategory.class.getName(), category.getCategoryId());
            if (trashEntry != null) continue;
            trashVersion = this.trashVersionLocalService.fetchVersion(trashEntryId, MBCategory.class.getName(), category.getCategoryId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            category.setStatus(oldStatus);
            this.mbCategoryPersistence.update((BaseModel)category);
            this.restoreDependentsFromTrash(user, this.getCategoriesAndThreads(category.getGroupId(), category.getCategoryId()), trashEntryId);
            if (trashVersion == null) continue;
            this.trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
    }

    protected void updateChildCategoriesDisplayStyle(MBCategory category, String displayStyle) throws PortalException, SystemException {
        List<MBCategory> categories = this.getCategories(category.getGroupId(), category.getCategoryId(), -1, -1);
        for (MBCategory curCategory : categories) {
            this.updateChildCategoriesDisplayStyle(curCategory, displayStyle);
            curCategory.setDisplayStyle(displayStyle);
            this.mbCategoryPersistence.update((BaseModel)curCategory);
        }
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CategoryNameException();
        }
    }
}

