/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.model.MBBan;
import com.liferay.portlet.messageboards.service.base.MBBanServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBPermission;

public class MBBanServiceImpl
extends MBBanServiceBaseImpl {
    public MBBan addBan(long banUserId, ServiceContext serviceContext) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        MBPermission.check(permissionChecker, serviceContext.getScopeGroupId(), "BAN_USER");
        User banUser = this.userPersistence.findByPrimaryKey(banUserId);
        boolean groupAdmin = false;
        try {
            groupAdmin = PortalUtil.isGroupAdmin((User)banUser, (long)serviceContext.getScopeGroupId());
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        if (groupAdmin) {
            throw new PrincipalException();
        }
        return this.mbBanLocalService.addBan(this.getUserId(), banUserId, serviceContext);
    }

    public void deleteBan(long banUserId, ServiceContext serviceContext) throws PortalException, SystemException {
        MBPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "BAN_USER");
        this.mbBanLocalService.deleteBan(banUserId, serviceContext);
    }
}

