/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.MessageSubjectException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.NoSuchThreadException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.SplitThreadException;
import com.liferay.portlet.messageboards.action.ActionUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadServiceUtil;
import java.util.Collections;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SplitThreadAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.splitThread(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException || e2 instanceof RequiredMessageException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            if (e2 instanceof MessageBodyException || e2 instanceof MessageSubjectException || e2 instanceof NoSuchThreadException || e2 instanceof SplitThreadException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getMessage((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchMessageException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.message_boards.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.message_boards.split_thread"));
    }

    protected void splitThread(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        PortletPreferences portletPreferences = actionRequest.getPreferences();
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        String splitThreadSubject = ParamUtil.getString((PortletRequest)actionRequest, (String)"splitThreadSubject");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBThread.class.getName(), (PortletRequest)actionRequest);
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
        long oldParentMessageId = message.getParentMessageId();
        MBThread newThread = MBThreadServiceUtil.splitThread((long)messageId, (String)splitThreadSubject, (ServiceContext)serviceContext);
        boolean addExplanationPost = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"addExplanationPost");
        if (addExplanationPost) {
            String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
            String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
            String format = GetterUtil.getString((String)portletPreferences.getValue("messageFormat", null), (String)MBMessageConstants.DEFAULT_FORMAT);
            String layoutFullURL = PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay);
            String newThreadURL = String.valueOf(layoutFullURL) + "/-/message_boards/view_message/" + message.getMessageId();
            body = StringUtil.replace((String)body, (String)"${newThreadURL}", (String)newThreadURL);
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            MBMessageServiceUtil.addMessage((long)oldParentMessageId, (String)subject, (String)body, (String)format, Collections.emptyList(), (boolean)false, (double)-1.0, (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
        }
        PortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(newThread.getRootMessageId()));
        actionResponse.sendRedirect(portletURL.toString());
    }
}

