/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.util;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserTracker;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthenticatedUserUUIDStoreUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.util.Encryptor;
import java.security.Key;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginUtil {
    private static Log _log = LogFactoryUtil.getLog(LoginUtil.class);

    public static long getAuthenticatedUserId(HttpServletRequest request, String login, String password, String authType) throws PortalException, SystemException {
        String contextPath;
        long userId = GetterUtil.getLong((String)login);
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        String requestURI = request.getRequestURI();
        if (requestURI.startsWith((contextPath = PortalUtil.getPathContext()).concat("/api/liferay"))) {
            throw new AuthException();
        }
        HashMap<String, String[]> headerMap = new HashMap<String, String[]>();
        Enumeration enu1 = request.getHeaderNames();
        while (enu1.hasMoreElements()) {
            String name = (String)enu1.nextElement();
            Enumeration enu2 = request.getHeaders(name);
            ArrayList<String> headers = new ArrayList<String>();
            while (enu2.hasMoreElements()) {
                String value = (String)enu2.nextElement();
                headers.add(value);
            }
            headerMap.put(name, headers.toArray(new String[headers.size()]));
        }
        Map parameterMap = request.getParameterMap();
        HashMap resultsMap = new HashMap();
        if (Validator.isNull((String)authType)) {
            authType = company.getAuthType();
        }
        int authResult = -1;
        if (authType.equals("emailAddress")) {
            authResult = UserLocalServiceUtil.authenticateByEmailAddress((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap, resultsMap);
            userId = MapUtil.getLong(resultsMap, (String)"userId", (long)userId);
        } else if (authType.equals("screenName")) {
            authResult = UserLocalServiceUtil.authenticateByScreenName((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap, resultsMap);
            userId = MapUtil.getLong(resultsMap, (String)"userId", (long)userId);
        } else if (authType.equals("userId")) {
            authResult = UserLocalServiceUtil.authenticateByUserId((long)company.getCompanyId(), (long)userId, (String)password, headerMap, (Map)parameterMap, resultsMap);
        }
        if (authResult != 1) {
            throw new AuthException();
        }
        return userId;
    }

    public static String getEmailFromAddress(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)preferences, (long)companyId, (String)PropsValues.LOGIN_EMAIL_FROM_ADDRESS);
    }

    public static String getEmailFromName(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromName((PortletPreferences)preferences, (long)companyId, (String)PropsValues.LOGIN_EMAIL_FROM_NAME);
    }

    public static String getLogin(HttpServletRequest request, String paramName, Company company) throws SystemException {
        String login = request.getParameter(paramName);
        if (login == null || login.equals("null")) {
            login = GetterUtil.getString((String)CookieKeys.getCookie((HttpServletRequest)request, (String)"LOGIN", (boolean)false));
            if (PropsValues.COMPANY_LOGIN_PREPOPULATE_DOMAIN && Validator.isNull((String)login) && company.getAuthType().equals("emailAddress")) {
                login = "@" + company.getMx();
            }
        }
        return login;
    }

    public static PortletURL getLoginURL(HttpServletRequest request, long plid) throws PortletModeException, WindowStateException {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"58", (long)plid, (String)"RENDER_PHASE");
        portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
        portletURL.setParameter("struts_action", "/login/login");
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setWindowState(WindowState.MAXIMIZED);
        return portletURL;
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, String login, String password, boolean rememberMe, String authType) throws Exception {
        Boolean httpsInitial;
        CookieKeys.validateSupportCookie((HttpServletRequest)request);
        HttpSession session = request.getSession();
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        long userId = LoginUtil.getAuthenticatedUserId(request, login, password, authType);
        if (!PropsValues.AUTH_SIMULTANEOUS_LOGINS) {
            Map<String, UserTracker> sessionUsers = LiveUsers.getSessionUsers(company.getCompanyId());
            ArrayList<UserTracker> userTrackers = new ArrayList<UserTracker>(sessionUsers.values());
            for (UserTracker userTracker : userTrackers) {
                if (userId != userTracker.getUserId()) continue;
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                ClusterNode clusterNode = ClusterExecutorUtil.getLocalClusterNode();
                if (clusterNode != null) {
                    jsonObject.put("clusterNodeId", clusterNode.getClusterNodeId());
                }
                jsonObject.put("command", "signOut");
                long companyId = CompanyLocalServiceUtil.getCompanyIdByUserId((long)userId);
                jsonObject.put("companyId", companyId);
                jsonObject.put("sessionId", userTracker.getSessionId());
                jsonObject.put("userId", userId);
                MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
            }
        }
        if (PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            session = LoginUtil.renewSession(request, session);
        }
        String domain = CookieKeys.getDomain((HttpServletRequest)request);
        User user = UserLocalServiceUtil.getUserById((long)userId);
        String userIdString = String.valueOf(userId);
        session.setAttribute("j_username", (Object)userIdString);
        if (PropsValues.PORTAL_JAAS_PLAIN_PASSWORD) {
            session.setAttribute("j_password", (Object)password);
        } else {
            session.setAttribute("j_password", (Object)user.getPassword());
        }
        session.setAttribute("j_remoteuser", (Object)userIdString);
        if (PropsValues.SESSION_STORE_PASSWORD) {
            session.setAttribute("USER_PASSWORD", (Object)password);
        }
        Cookie companyIdCookie = new Cookie("COMPANY_ID", String.valueOf(company.getCompanyId()));
        if (Validator.isNotNull((String)domain)) {
            companyIdCookie.setDomain(domain);
        }
        companyIdCookie.setPath("/");
        Cookie idCookie = new Cookie("ID", Encryptor.encrypt((Key)company.getKeyObj(), (String)userIdString));
        if (Validator.isNotNull((String)domain)) {
            idCookie.setDomain(domain);
        }
        idCookie.setPath("/");
        Cookie passwordCookie = new Cookie("PASSWORD", Encryptor.encrypt((Key)company.getKeyObj(), (String)password));
        if (Validator.isNotNull((String)domain)) {
            passwordCookie.setDomain(domain);
        }
        passwordCookie.setPath("/");
        Cookie rememberMeCookie = new Cookie("REMEMBER_ME", Boolean.TRUE.toString());
        if (Validator.isNotNull((String)domain)) {
            rememberMeCookie.setDomain(domain);
        }
        rememberMeCookie.setPath("/");
        int loginMaxAge = PropsValues.COMPANY_SECURITY_AUTO_LOGIN_MAX_AGE;
        String userUUID = userIdString.concat(".").concat(String.valueOf(System.nanoTime()));
        Cookie userUUIDCookie = new Cookie("USER_UUID", Encryptor.encrypt((Key)company.getKeyObj(), (String)userUUID));
        userUUIDCookie.setPath("/");
        session.setAttribute("USER_UUID", (Object)userUUID);
        if (PropsValues.SESSION_DISABLED) {
            rememberMe = true;
        }
        if (rememberMe) {
            companyIdCookie.setMaxAge(loginMaxAge);
            idCookie.setMaxAge(loginMaxAge);
            passwordCookie.setMaxAge(loginMaxAge);
            rememberMeCookie.setMaxAge(loginMaxAge);
            userUUIDCookie.setMaxAge(loginMaxAge);
        } else {
            companyIdCookie.setMaxAge(-1);
            idCookie.setMaxAge(-1);
            passwordCookie.setMaxAge(-1);
            rememberMeCookie.setMaxAge(0);
            userUUIDCookie.setMaxAge(-1);
        }
        Cookie loginCookie = new Cookie("LOGIN", login);
        if (Validator.isNotNull((String)domain)) {
            loginCookie.setDomain(domain);
        }
        loginCookie.setMaxAge(loginMaxAge);
        loginCookie.setPath("/");
        Cookie screenNameCookie = new Cookie("SCREEN_NAME", Encryptor.encrypt((Key)company.getKeyObj(), (String)user.getScreenName()));
        if (Validator.isNotNull((String)domain)) {
            screenNameCookie.setDomain(domain);
        }
        screenNameCookie.setMaxAge(loginMaxAge);
        screenNameCookie.setPath("/");
        boolean secure = request.isSecure();
        if (!(!secure || PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS || StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL) || (httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL")) != null && httpsInitial.booleanValue())) {
            secure = false;
        }
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)companyIdCookie, (boolean)secure);
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)idCookie, (boolean)secure);
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)userUUIDCookie, (boolean)secure);
        if (rememberMe) {
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)loginCookie, (boolean)secure);
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)passwordCookie, (boolean)secure);
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)rememberMeCookie, (boolean)secure);
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)screenNameCookie, (boolean)secure);
        }
        AuthenticatedUserUUIDStoreUtil.register((String)userUUID);
    }

    public static HttpSession renewSession(HttpServletRequest request, HttpSession session) throws Exception {
        Object protectedAttributeValue;
        String protectedAttributeName;
        int n;
        int n2;
        String[] stringArray;
        HashMap<String, Object> protectedAttributes;
        String[] protectedAttributeNames;
        block6: {
            protectedAttributeNames = PropsValues.SESSION_PHISHING_PROTECTED_ATTRIBUTES;
            protectedAttributes = new HashMap<String, Object>();
            stringArray = protectedAttributeNames;
            n2 = protectedAttributeNames.length;
            n = 0;
            while (n < n2) {
                protectedAttributeName = stringArray[n];
                protectedAttributeValue = session.getAttribute(protectedAttributeName);
                if (protectedAttributeValue != null) {
                    protectedAttributes.put(protectedAttributeName, protectedAttributeValue);
                }
                ++n;
            }
            try {
                session.invalidate();
            }
            catch (IllegalStateException ise) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)ise.getMessage());
            }
        }
        session = request.getSession(true);
        stringArray = protectedAttributeNames;
        n2 = protectedAttributeNames.length;
        n = 0;
        while (n < n2) {
            protectedAttributeName = stringArray[n];
            protectedAttributeValue = protectedAttributes.get(protectedAttributeName);
            if (protectedAttributeValue != null) {
                session.setAttribute(protectedAttributeName, protectedAttributeValue);
            }
            ++n;
        }
        return session;
    }

    public static void sendPassword(ActionRequest actionRequest) throws Exception {
        String toAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        LoginUtil.sendPassword(actionRequest, null, null, toAddress, null, null);
    }

    public static void sendPassword(ActionRequest actionRequest, String fromName, String fromAddress, String toAddress, String subject, String body) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        if (!company.isSendPassword() && !company.isSendPasswordResetLink()) {
            return;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        UserLocalServiceUtil.sendPassword((long)company.getCompanyId(), (String)toAddress, (String)fromName, (String)fromAddress, (String)subject, (String)body, (ServiceContext)serviceContext);
        SessionMessages.add((PortletRequest)actionRequest, (String)"requestProcessed", (Object)toAddress);
    }
}

