/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.DuplicateUserEmailAddressException;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.OpenIdUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.util.PwdGenerator;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;

public class OpenIdAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static final String _OPEN_ID_AX_ATTR_EMAIL = "email";
    private static final String _OPEN_ID_AX_ATTR_FIRST_NAME = "firstname";
    private static final String _OPEN_ID_AX_ATTR_FULL_NAME = "fullname";
    private static final String _OPEN_ID_AX_ATTR_LAST_NAME = "lastname";
    private static final String _OPEN_ID_AX_TYPE = "open.id.ax.type.";
    private static final String _OPEN_ID_PROVIDER_DEFAULT = "default";
    private static final String _OPEN_ID_SREG_ATTR_EMAIL = "email";
    private static final String _OPEN_ID_SREG_ATTR_FULLNAME = "fullname";
    private static Log _log = LogFactoryUtil.getLog(OpenIdAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!OpenIdUtil.isEnabled(themeDisplay.getCompanyId())) {
            throw new PrincipalException();
        }
        if (actionRequest.getRemoteUser() != null) {
            actionResponse.sendRedirect(themeDisplay.getPathMain());
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("read")) {
                String redirect = this.readOpenIdResponse(themeDisplay, actionRequest, actionResponse);
                if (Validator.isNull((String)redirect)) {
                    redirect = String.valueOf(PortalUtil.getPortalURL((PortletRequest)actionRequest)) + themeDisplay.getURLSignIn();
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                this.sendOpenIdRequest(themeDisplay, actionRequest, actionResponse);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof DuplicateUserEmailAddressException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof OpenIDException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Error communicating with OpenID provider: " + e2.getMessage()));
                }
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            _log.error((Object)"Error processing the OpenID login", (Throwable)e2);
            PortalUtil.sendError((Exception)e2, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!OpenIdUtil.isEnabled(themeDisplay.getCompanyId())) {
            return actionMapping.findForward("portlet.login.login");
        }
        renderResponse.setTitle(themeDisplay.translate("open-id"));
        return actionMapping.findForward("portlet.login.open_id");
    }

    protected String getFirstValue(List<String> values) {
        if (values == null || values.size() < 1) {
            return null;
        }
        return values.get(0);
    }

    protected String getOpenIdProvider(URL endpointURL) {
        String hostName = endpointURL.getHost();
        String[] stringArray = PropsValues.OPEN_ID_PROVIDERS;
        int n = PropsValues.OPEN_ID_PROVIDERS.length;
        int n2 = 0;
        while (n2 < n) {
            String openIdProvider = stringArray[n2];
            String openIdURLString = PropsUtil.get("open.id.url", new Filter(openIdProvider));
            if (hostName.equals(openIdURLString)) {
                return openIdProvider;
            }
            ++n2;
        }
        return _OPEN_ID_PROVIDER_DEFAULT;
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected String readOpenIdResponse(ThemeDisplay themeDisplay, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String password1;
        MessageExtension messageExtension;
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpSession session = request.getSession();
        ConsumerManager consumerManager = OpenIdUtil.getConsumerManager();
        ParameterList parameterList = new ParameterList(actionRequest.getParameterMap());
        DiscoveryInformation discoveryInformation = (DiscoveryInformation)session.getAttribute("openid-disco");
        if (discoveryInformation == null) {
            return null;
        }
        String receivingURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"openid.return_to");
        VerificationResult verificationResult = consumerManager.verify(receivingURL, parameterList, discoveryInformation);
        Identifier identifier = verificationResult.getVerifiedId();
        if (identifier == null) {
            return null;
        }
        AuthSuccess authSuccess = (AuthSuccess)verificationResult.getAuthResponse();
        String firstName = null;
        String lastName = null;
        String emailAddress = null;
        if (authSuccess.hasExtension("http://openid.net/sreg/1.0") && (messageExtension = authSuccess.getExtension("http://openid.net/sreg/1.0")) instanceof SRegResponse) {
            SRegResponse sregResp = (SRegResponse)messageExtension;
            String fullName = GetterUtil.getString((String)sregResp.getAttributeValue("fullname"));
            String[] names = this.splitFullName(fullName);
            if (names != null) {
                firstName = names[0];
                lastName = names[1];
            }
            emailAddress = sregResp.getAttributeValue("email");
        }
        if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0") && (messageExtension = authSuccess.getExtension("http://openid.net/srv/ax/1.0")) instanceof FetchResponse) {
            String[] openIdAXTypes;
            FetchResponse fetchResponse = (FetchResponse)messageExtension;
            String openIdProvider = this.getOpenIdProvider(discoveryInformation.getOPEndpoint());
            String[] stringArray = openIdAXTypes = PropsUtil.getArray("open.id.ax.schema", new Filter(openIdProvider));
            int n = openIdAXTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String openIdAXType = stringArray[n2];
                if (openIdAXType.equals("email")) {
                    if (Validator.isNull((String)emailAddress)) {
                        emailAddress = this.getFirstValue(fetchResponse.getAttributeValues("email"));
                    }
                } else if (openIdAXType.equals(_OPEN_ID_AX_ATTR_FIRST_NAME)) {
                    if (Validator.isNull((String)firstName)) {
                        firstName = this.getFirstValue(fetchResponse.getAttributeValues(_OPEN_ID_AX_ATTR_FIRST_NAME));
                    }
                } else if (openIdAXType.equals("fullname")) {
                    String fullName = fetchResponse.getAttributeValue("fullname");
                    String[] names = this.splitFullName(fullName);
                    if (names != null) {
                        if (Validator.isNull((String)firstName)) {
                            firstName = names[0];
                        }
                        if (Validator.isNull((String)lastName)) {
                            lastName = names[1];
                        }
                    }
                } else if (openIdAXType.equals(_OPEN_ID_AX_ATTR_LAST_NAME) && Validator.isNull((String)lastName)) {
                    lastName = this.getFirstValue(fetchResponse.getAttributeValues(_OPEN_ID_AX_ATTR_LAST_NAME));
                }
                ++n2;
            }
        }
        String openId = OpenIdUtil.normalize(authSuccess.getIdentity());
        User user = UserLocalServiceUtil.fetchUserByOpenId((long)themeDisplay.getCompanyId(), (String)openId);
        if (user != null) {
            session.setAttribute("OPEN_ID_LOGIN", (Object)new Long(user.getUserId()));
            return null;
        }
        if (Validator.isNull(firstName) || Validator.isNull(lastName) || Validator.isNull(emailAddress)) {
            SessionMessages.add((HttpServletRequest)request, (String)"missingOpenIdUserInformation");
            if (_log.isInfoEnabled()) {
                _log.info((Object)"The OpenID provider did not send the required attributes to create an account");
            }
            String createAccountURL = PortalUtil.getCreateAccountURL((HttpServletRequest)request, (ThemeDisplay)themeDisplay);
            createAccountURL = HttpUtil.setParameter((String)createAccountURL, (String)"openId", (String)openId);
            session.setAttribute("OPEN_ID_LOGIN_PENDING", (Object)Boolean.TRUE);
            return createAccountURL;
        }
        long creatorUserId = 0L;
        long companyId = themeDisplay.getCompanyId();
        boolean autoPassword = false;
        String password2 = password1 = PwdGenerator.getPassword();
        boolean autoScreenName = true;
        String screenName = "";
        long facebookId = 0L;
        Locale locale = themeDisplay.getLocale();
        String middleName = "";
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        user = UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, (long[])userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        session.setAttribute("OPEN_ID_LOGIN", (Object)new Long(user.getUserId()));
        return null;
    }

    protected void sendOpenIdRequest(ThemeDisplay themeDisplay, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String[] openIdAXTypes;
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        HttpSession session = request.getSession();
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        String openId = ParamUtil.getString((PortletRequest)actionRequest, (String)"openId");
        PortletURL portletURL = actionResponseImpl.createActionURL();
        portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
        portletURL.setParameter("cmd", "read");
        portletURL.setParameter("struts_action", "/login/open_id");
        ConsumerManager manager = OpenIdUtil.getConsumerManager();
        List discoveries = manager.discover(openId);
        DiscoveryInformation discovered = manager.associate(discoveries);
        session.setAttribute("openid-disco", (Object)discovered);
        AuthRequest authRequest = manager.authenticate(discovered, portletURL.toString(), themeDisplay.getPortalURL());
        if (UserLocalServiceUtil.fetchUserByOpenId((long)themeDisplay.getCompanyId(), (String)openId) != null) {
            response.sendRedirect(authRequest.getDestinationUrl(true));
            return;
        }
        String screenName = OpenIdUtil.getScreenName(openId);
        User user = UserLocalServiceUtil.fetchUserByScreenName((long)themeDisplay.getCompanyId(), (String)screenName);
        if (user != null) {
            UserLocalServiceUtil.updateOpenId((long)user.getUserId(), (String)openId);
            response.sendRedirect(authRequest.getDestinationUrl(true));
            return;
        }
        FetchRequest fetchRequest = FetchRequest.createFetchRequest();
        String openIdProvider = this.getOpenIdProvider(discovered.getOPEndpoint());
        String[] stringArray = openIdAXTypes = PropsUtil.getArray("open.id.ax.schema", new Filter(openIdProvider));
        int n = openIdAXTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String openIdAXType = stringArray[n2];
            fetchRequest.addAttribute(openIdAXType, PropsUtil.get(_OPEN_ID_AX_TYPE.concat(openIdAXType), new Filter(openIdProvider)), true);
            ++n2;
        }
        authRequest.addExtension((MessageExtension)fetchRequest);
        SRegRequest sRegRequest = SRegRequest.createFetchRequest();
        sRegRequest.addAttribute("email", true);
        sRegRequest.addAttribute("fullname", true);
        authRequest.addExtension((MessageExtension)sRegRequest);
        response.sendRedirect(authRequest.getDestinationUrl(true));
    }

    protected String[] splitFullName(String fullName) {
        if (Validator.isNull((String)fullName)) {
            return null;
        }
        int pos = fullName.indexOf(32);
        if (pos != -1 && pos + 1 < fullName.length()) {
            String[] names = new String[]{fullName.substring(0, pos), fullName.substring(pos + 1)};
            return names;
        }
        return null;
    }
}

