/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.CompanyMaxUsersException;
import com.liferay.portal.CookieNotSupportedException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.PasswordExpiredException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserIdException;
import com.liferay.portal.UserLockoutException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.login.util.LoginUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LoginAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(LoginAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            actionResponse.sendRedirect(String.valueOf(themeDisplay.getPathMain()) + PropsValues.AUTH_LOGIN_DISABLED_PATH);
            return;
        }
        try {
            this.login(themeDisplay, actionRequest, actionResponse);
            boolean doActionAfterLogin = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"doActionAfterLogin");
            if (doActionAfterLogin) {
                this.setForward((PortletRequest)actionRequest, "portlet.login.login_redirect");
            }
        }
        catch (Exception e2) {
            if (e2 instanceof AuthException) {
                Throwable cause = e2.getCause();
                if (cause instanceof PasswordExpiredException || cause instanceof UserLockoutException) {
                    SessionErrors.add((PortletRequest)actionRequest, cause.getClass());
                } else {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Authentication failed");
                    }
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                }
            } else if (e2 instanceof CompanyMaxUsersException || e2 instanceof CookieNotSupportedException || e2 instanceof NoSuchUserException || e2 instanceof PasswordExpiredException || e2 instanceof UserEmailAddressException || e2 instanceof UserIdException || e2 instanceof UserLockoutException || e2 instanceof UserPasswordException || e2 instanceof UserScreenNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            } else {
                _log.error((Object)e2, (Throwable)e2);
                PortalUtil.sendError((Exception)e2, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
                return;
            }
            this.postProcessAuthFailure(actionRequest, actionResponse);
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.login.login"));
    }

    protected String getCompleteRedirectURL(HttpServletRequest request, String redirect) {
        HttpSession session = request.getSession();
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        String portalURL = null;
        portalURL = PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !PropsValues.SESSION_ENABLE_PHISHING_PROTECTION && httpsInitial != null && httpsInitial == false ? PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)false) : PortalUtil.getPortalURL((HttpServletRequest)request);
        return portalURL.concat(redirect);
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void login(ThemeDisplay themeDisplay, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String redirect;
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        String login = ParamUtil.getString((PortletRequest)actionRequest, (String)"login");
        String password = actionRequest.getParameter("password");
        boolean rememberMe = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"rememberMe");
        if (!themeDisplay.isSignedIn()) {
            PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest);
            String authType = portletPreferences.getValue("authType", null);
            LoginUtil.login(request, response, login, password, rememberMe, authType);
        }
        if (Validator.isNotNull((String)(redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))) && !(redirect = PortalUtil.escapeRedirect((String)redirect)).startsWith("http")) {
            redirect = this.getCompleteRedirectURL(request, redirect);
        }
        String mainPath = themeDisplay.getPathMain();
        if (PropsValues.PORTAL_JAAS_ENABLE) {
            redirect = Validator.isNotNull((String)redirect) ? mainPath.concat("/portal/protected?redirect=").concat(redirect) : mainPath.concat("/portal/protected");
            actionResponse.sendRedirect(redirect);
        } else if (Validator.isNotNull((String)redirect)) {
            actionResponse.sendRedirect(redirect);
        } else {
            boolean doActionAfterLogin = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"doActionAfterLogin");
            if (doActionAfterLogin) {
                return;
            }
            actionResponse.sendRedirect(mainPath);
        }
    }

    protected void postProcessAuthFailure(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Layout layout = (Layout)actionRequest.getAttribute("LAYOUT");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, "58", layout.getPlid(), "RENDER_PHASE");
        portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
        portletURL.setWindowState(WindowState.MAXIMIZED);
        actionResponse.sendRedirect(portletURL.toString());
    }
}

