/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.kernel.facebook.FacebookConnectUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletURLFactoryUtil;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FacebookConnectAction
extends PortletAction {
    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!FacebookConnectUtil.isEnabled((long)themeDisplay.getCompanyId())) {
            return actionMapping.findForward("portlet.login.login");
        }
        return actionMapping.findForward("portlet.login.facebook_login");
    }

    @Override
    public ActionForward strutsExecute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!FacebookConnectUtil.isEnabled((long)themeDisplay.getCompanyId())) {
            throw new PrincipalException();
        }
        HttpSession session = request.getSession();
        String redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
        String code = ParamUtil.getString((HttpServletRequest)request, (String)"code");
        String token = FacebookConnectUtil.getAccessToken((long)themeDisplay.getCompanyId(), (String)redirect, (String)code);
        if (Validator.isNotNull((String)token)) {
            User user = this.setFacebookCredentials(session, themeDisplay.getCompanyId(), token);
            if (user != null && user.getStatus() == 6) {
                this.redirectUpdateAccount(request, response, user);
                return null;
            }
        } else {
            return actionMapping.findForward("/common/referer_jsp.jsp");
        }
        response.sendRedirect(redirect);
        return null;
    }

    protected User addUser(HttpSession session, long companyId, JSONObject jsonObject) throws Exception {
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = "";
        String password2 = "";
        boolean autoScreenName = true;
        String screenName = "";
        String emailAddress = jsonObject.getString("email");
        long facebookId = jsonObject.getLong("id");
        String openId = "";
        Locale locale = LocaleUtil.getDefault();
        String firstName = jsonObject.getString("first_name");
        String middleName = "";
        String lastName = jsonObject.getString("last_name");
        int prefixId = 0;
        int suffixId = 0;
        boolean male = Validator.equals((Object)jsonObject.getString("gender"), (Object)"male");
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = true;
        ServiceContext serviceContext = new ServiceContext();
        User user = UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, (long[])userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        user = UserLocalServiceUtil.updateLastLogin((long)user.getUserId(), (String)user.getLoginIP());
        user = UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)false);
        user = UserLocalServiceUtil.updateEmailAddressVerified((long)user.getUserId(), (boolean)true);
        session.setAttribute("FACEBOOK_USER_EMAIL_ADDRESS", (Object)emailAddress);
        return user;
    }

    protected void redirectUpdateAccount(HttpServletRequest request, HttpServletResponse response, User user) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"58", (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
        portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
        portletURL.setParameter("struts_action", "/login/update_account");
        LiferayPortletURL redirectURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"164", (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
        redirectURL.setParameter("struts_action", "/login/login_redirect");
        redirectURL.setParameter("emailAddress", user.getEmailAddress());
        redirectURL.setParameter("anonymousUser", Boolean.FALSE.toString());
        redirectURL.setPortletMode(PortletMode.VIEW);
        redirectURL.setWindowState(LiferayWindowState.POP_UP);
        portletURL.setParameter("redirect", redirectURL.toString());
        portletURL.setParameter("userId", String.valueOf(user.getUserId()));
        portletURL.setParameter("emailAddress", user.getEmailAddress());
        portletURL.setParameter("firstName", user.getFirstName());
        portletURL.setParameter("lastName", user.getLastName());
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        response.sendRedirect(portletURL.toString());
    }

    protected User setFacebookCredentials(HttpSession session, long companyId, String token) throws Exception {
        JSONObject jsonObject = FacebookConnectUtil.getGraphResources((long)companyId, (String)"/me", (String)token, (String)"id,email,first_name,last_name,gender");
        if (jsonObject == null || jsonObject.getJSONObject("error") != null) {
            return null;
        }
        if (FacebookConnectUtil.isVerifiedAccountRequired((long)companyId) && !jsonObject.getBoolean("verified")) {
            return null;
        }
        User user = null;
        long facebookId = jsonObject.getLong("id");
        if (facebookId > 0L) {
            session.setAttribute("FACEBOOK_ACCESS_TOKEN", (Object)token);
            user = UserLocalServiceUtil.fetchUserByFacebookId((long)companyId, (long)facebookId);
            if (user != null && user.getStatus() != 6) {
                session.setAttribute("FACEBOOK_USER_ID", (Object)String.valueOf(facebookId));
            }
        }
        String emailAddress = jsonObject.getString("email");
        if (user == null && Validator.isNotNull((String)emailAddress) && (user = UserLocalServiceUtil.fetchUserByEmailAddress((long)companyId, (String)emailAddress)) != null && user.getStatus() != 6) {
            session.setAttribute("FACEBOOK_USER_EMAIL_ADDRESS", (Object)emailAddress);
        }
        if (user != null) {
            if (user.getStatus() == 6) {
                session.setAttribute("FACEBOOK_INCOMPLETE_USER_ID", (Object)facebookId);
                user.setEmailAddress(jsonObject.getString("email"));
                user.setFirstName(jsonObject.getString("first_name"));
                user.setLastName(jsonObject.getString("last_name"));
                return user;
            }
            user = this.updateUser(user, jsonObject);
        } else {
            user = this.addUser(session, companyId, jsonObject);
        }
        return user;
    }

    protected User updateUser(User user, JSONObject jsonObject) throws Exception {
        long facebookId = jsonObject.getLong("id");
        String emailAddress = jsonObject.getString("email");
        String firstName = jsonObject.getString("first_name");
        String lastName = jsonObject.getString("last_name");
        boolean male = Validator.equals((Object)jsonObject.getString("gender"), (Object)"male");
        if (facebookId == user.getFacebookId() && emailAddress.equals(user.getEmailAddress()) && firstName.equals(user.getFirstName()) && lastName.equals(user.getLastName()) && male == user.isMale()) {
            return user;
        }
        Contact contact = user.getContact();
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(contact.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        List userGroupRoles = null;
        long[] userGroupIds = null;
        ServiceContext serviceContext = new ServiceContext();
        if (!StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            UserLocalServiceUtil.updateEmailAddress((long)user.getUserId(), (String)"", (String)emailAddress, (String)emailAddress);
        }
        UserLocalServiceUtil.updateEmailAddressVerified((long)user.getUserId(), (boolean)true);
        return UserLocalServiceUtil.updateUser((long)user.getUserId(), (String)"", (String)"", (String)"", (boolean)false, (String)user.getReminderQueryQuestion(), (String)user.getReminderQueryAnswer(), (String)user.getScreenName(), (String)emailAddress, (long)facebookId, (String)user.getOpenId(), (String)user.getLanguageId(), (String)user.getTimeZoneId(), (String)user.getGreeting(), (String)user.getComments(), (String)firstName, (String)user.getMiddleName(), (String)lastName, (int)contact.getPrefixId(), (int)contact.getSuffixId(), (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)contact.getSmsSn(), (String)contact.getAimSn(), (String)contact.getFacebookSn(), (String)contact.getIcqSn(), (String)contact.getJabberSn(), (String)contact.getMsnSn(), (String)contact.getMySpaceSn(), (String)contact.getSkypeSn(), (String)contact.getTwitterSn(), (String)contact.getYmSn(), (String)contact.getJobTitle(), (long[])groupIds, (long[])organizationIds, (long[])roleIds, userGroupRoles, (long[])userGroupIds, (ServiceContext)serviceContext);
    }
}

