/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SessionClicks;
import com.liferay.portlet.sites.util.SitesUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LayoutsTreeUtil {
    public static String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete) throws Exception {
        return LayoutsTreeUtil.getLayoutsJSON(request, groupId, privateLayout, parentLayoutId, null, incomplete);
    }

    public static String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, long[] expandedLayoutIds, boolean incomplete) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List layoutAncestors = null;
        List layouts = LayoutServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (boolean)incomplete, (int)-1, (int)-1);
        long selPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"selPlid");
        if (selPlid != 0L) {
            Layout selLayout = LayoutLocalServiceUtil.getLayout((long)selPlid);
            layoutAncestors = LayoutServiceUtil.getAncestorLayouts((long)selPlid);
            layoutAncestors.add(selLayout);
        }
        int start = 0;
        int end = layouts.size();
        if (PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN > -1) {
            start = ParamUtil.getInteger((HttpServletRequest)request, (String)"start");
            start = Math.max(0, Math.min(start, layouts.size()));
            end = ParamUtil.getInteger((HttpServletRequest)request, (String)"end", (int)(start + PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN));
            int loadedLayoutsCount = LayoutsTreeUtil._getLoadedLayoutsCount(request, parentLayoutId);
            if (loadedLayoutsCount > end) {
                end = loadedLayoutsCount;
            }
            end = Math.max(start, Math.min(end, layouts.size()));
        }
        boolean hasManageLayoutsPermission = GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        for (Layout layout : layouts.subList(start, end)) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            if (layoutAncestors != null && layoutAncestors.contains(layout) || ArrayUtil.contains((long[])expandedLayoutIds, (long)layout.getLayoutId())) {
                String childrenJSON = "";
                if (layout instanceof VirtualLayout) {
                    VirtualLayout virtualLayout = (VirtualLayout)layout;
                    childrenJSON = LayoutsTreeUtil.getLayoutsJSON(request, virtualLayout.getSourceGroupId(), virtualLayout.isPrivateLayout(), virtualLayout.getLayoutId(), expandedLayoutIds, incomplete);
                } else {
                    childrenJSON = LayoutsTreeUtil.getLayoutsJSON(request, groupId, layout.isPrivateLayout(), layout.getLayoutId(), expandedLayoutIds, incomplete);
                }
                jsonObject.put("children", JSONFactoryUtil.createJSONObject((String)childrenJSON));
            }
            jsonObject.put("contentDisplayPage", layout.isContentDisplayPage());
            jsonObject.put("friendlyURL", layout.getFriendlyURL());
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                jsonObject.put("groupId", virtualLayout.getSourceGroupId());
            } else {
                jsonObject.put("groupId", layout.getGroupId());
            }
            jsonObject.put("hasChildren", layout.hasChildren());
            jsonObject.put("layoutId", layout.getLayoutId());
            jsonObject.put("name", layout.getName(themeDisplay.getLocale()));
            jsonObject.put("parentable", PortalUtil.isLayoutParentable((Layout)layout));
            jsonObject.put("parentLayoutId", layout.getParentLayoutId());
            jsonObject.put("plid", layout.getPlid());
            jsonObject.put("priority", layout.getPriority());
            jsonObject.put("privateLayout", layout.isPrivateLayout());
            jsonObject.put("sortable", hasManageLayoutsPermission && SitesUtil.isLayoutSortable((Layout)layout));
            jsonObject.put("type", layout.getType());
            jsonObject.put("updateable", LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE"));
            jsonObject.put("uuid", layout.getUuid());
            LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
            if (layoutRevision != null) {
                User user = themeDisplay.getUser();
                long recentLayoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId((User)user, (long)layout.getLayoutSet().getLayoutSetId());
                if (StagingUtil.isIncomplete((Layout)layout, (long)recentLayoutSetBranchId)) {
                    jsonObject.put("incomplete", true);
                }
                long layoutSetBranchId = layoutRevision.getLayoutSetBranchId();
                LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)layoutSetBranchId);
                LayoutBranch layoutBranch = layoutRevision.getLayoutBranch();
                if (!layoutBranch.isMaster()) {
                    jsonObject.put("layoutBranchId", layoutBranch.getLayoutBranchId());
                    jsonObject.put("layoutBranchName", layoutBranch.getName());
                }
                if (layoutRevision.isHead()) {
                    jsonObject.put("layoutRevisionHead", true);
                }
                jsonObject.put("layoutRevisionId", layoutRevision.getLayoutRevisionId());
                jsonObject.put("layoutSetBranchId", layoutSetBranchId);
                jsonObject.put("layoutSetBranchName", layoutSetBranch.getName());
            }
            jsonArray.put(jsonObject);
        }
        JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject();
        responseJSONObject.put("layouts", jsonArray);
        responseJSONObject.put("total", layouts.size());
        return responseJSONObject.toString();
    }

    private static int _getLoadedLayoutsCount(HttpServletRequest request, long layoutId) throws Exception {
        HttpSession session = request.getSession();
        String treeId = ParamUtil.getString((HttpServletRequest)request, (String)"treeId");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        StringBundler sb = new StringBundler(7);
        sb.append(treeId);
        sb.append(":");
        sb.append(groupId);
        sb.append(":");
        sb.append(privateLayout);
        sb.append(":");
        sb.append("Pagination");
        String paginationJSON = SessionClicks.get((HttpSession)session, (String)sb.toString(), (String)JSONFactoryUtil.getNullJSON());
        JSONObject paginationJSONObject = JSONFactoryUtil.createJSONObject((String)paginationJSON);
        return paginationJSONObject.getInt(String.valueOf(layoutId), 0);
    }
}

