/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.ImageTypeException;
import com.liferay.portal.LayoutFriendlyURLException;
import com.liferay.portal.LayoutNameException;
import com.liferay.portal.LayoutParentLayoutIdException;
import com.liferay.portal.LayoutSetVirtualHostException;
import com.liferay.portal.LayoutTypeException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.RequiredLayoutException;
import com.liferay.portal.SitemapChangeFrequencyException;
import com.liferay.portal.SitemapIncludeException;
import com.liferay.portal.SitemapPagePriorityException;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.ThemeSetting;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.LayoutSettings;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.MDRActionLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRActionServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceServiceUtil;
import com.liferay.portlet.sites.action.ActionUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditLayoutsAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(EditLayoutsAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        String closeRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"closeRedirect");
        try {
            Layout layout = null;
            String oldFriendlyURL = "";
            if (cmd.equals("add") || cmd.equals("update")) {
                Object[] returnValue = this.updateLayout(actionRequest, actionResponse);
                layout = (Layout)returnValue[0];
                oldFriendlyURL = (String)returnValue[1];
                redirect = this.updateCloseRedirect(themeDisplay, redirect, null, layout, oldFriendlyURL);
                closeRedirect = this.updateCloseRedirect(themeDisplay, closeRedirect, null, layout, oldFriendlyURL);
                SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + "pageAdded"), (Object)layout);
            } else if (cmd.equals("delete")) {
                long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
                if (plid <= 0L) {
                    long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
                    boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
                    long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
                    layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
                    plid = layout.getPlid();
                }
                Object[] returnValue = SitesUtil.deleteLayout((ActionRequest)actionRequest, (ActionResponse)actionResponse);
                Group group = (Group)returnValue[0];
                oldFriendlyURL = (String)returnValue[1];
                long newRefererPlid = (Long)returnValue[2];
                redirect = this.updateCloseRedirect(themeDisplay, redirect, group, null, oldFriendlyURL);
                long refererPlid = themeDisplay.getRefererPlid();
                if (plid == refererPlid) {
                    redirect = HttpUtil.setParameter((String)redirect, (String)"refererPlid", (long)newRefererPlid);
                    redirect = HttpUtil.setParameter((String)redirect, (String)(String.valueOf(actionResponse.getNamespace()) + "selPlid"), (int)0);
                }
                closeRedirect = this.updateCloseRedirect(themeDisplay, closeRedirect, group, null, oldFriendlyURL);
                redirect = HttpUtil.addParameter((String)redirect, (String)(String.valueOf(actionResponse.getNamespace()) + "closeRedirect"), (String)closeRedirect);
            } else if (cmd.equals("display_order")) {
                this.updateDisplayOrder(actionRequest);
            } else if (cmd.equals("delete_layout_revision")) {
                this.deleteLayoutRevision(actionRequest);
            } else if (cmd.equals("enable")) {
                this.enableLayout(actionRequest);
            } else if (cmd.equals("reset_customized_view")) {
                LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
                if (layoutTypePortlet != null && layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView()) {
                    layoutTypePortlet.resetUserPreferences();
                }
            } else if (cmd.equals("reset_merge_fail_count_and_merge")) {
                this.resetMergeFailCountAndMerge(actionRequest);
            } else if (cmd.equals("reset_prototype")) {
                SitesUtil.resetPrototype((Layout)themeDisplay.getLayout());
            } else if (cmd.equals("select_layout_set_branch")) {
                this.selectLayoutSetBranch(actionRequest);
            } else if (cmd.equals("select_layout_branch")) {
                this.selectLayoutBranch(actionRequest);
            } else if (cmd.equals("update_layout_revision")) {
                this.updateLayoutRevision(actionRequest, themeDisplay);
            }
            this.sendRedirect(portletConfig, actionRequest, actionResponse, redirect, closeRedirect);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchLayoutException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.layouts_admin.error");
            }
            if (e2 instanceof ImageTypeException || e2 instanceof LayoutFriendlyURLException || e2 instanceof LayoutNameException || e2 instanceof LayoutParentLayoutIdException || e2 instanceof LayoutSetVirtualHostException || e2 instanceof LayoutTypeException || e2 instanceof RequiredLayoutException || e2 instanceof SitemapChangeFrequencyException || e2 instanceof SitemapIncludeException || e2 instanceof SitemapPagePriorityException || e2 instanceof UploadException) {
                if (e2 instanceof LayoutFriendlyURLException) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)LayoutFriendlyURLException.class.getName(), (Object)e2);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
                }
            }
            if (e2 instanceof SystemException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
                redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
                this.sendRedirect(portletConfig, actionRequest, actionResponse, redirect, closeRedirect);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return actionMapping.findForward("portlet.layouts_admin.error");
        }
        try {
            this.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchGroupException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.layouts_admin.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.edit_layouts"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = null;
        if (cmd.equals("VIEW_TREE")) {
            this.getGroup((PortletRequest)resourceRequest);
            portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/layouts_admin/tree_js.jsp");
        } else {
            this.getGroup((PortletRequest)resourceRequest);
            portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/layouts_admin/view_resources.jsp");
        }
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void checkPermission(PermissionChecker permissionChecker, Group group, Layout layout, long selPlid) throws PortalException, SystemException {
        if (selPlid > 0L) {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW");
        } else {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW");
        }
    }

    protected void checkPermissions(PortletRequest portletRequest) throws Exception {
        Group group = this.getGroup(portletRequest);
        if (group == null) {
            throw new PrincipalException();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Layout layout = themeDisplay.getLayout();
        String cmd = ParamUtil.getString((PortletRequest)portletRequest, (String)"cmd");
        long selPlid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"selPlid");
        if (selPlid > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)selPlid);
        }
        if (cmd.equals("add")) {
            long parentPlid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"parentPlid");
            if (parentPlid == 0L ? !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"ADD_LAYOUT") : !LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)(layout = LayoutLocalServiceUtil.getLayout((long)parentPlid)), (String)"ADD_LAYOUT")) {
                throw new PrincipalException();
            }
        } else if (cmd.equals("delete")) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"DELETE")) {
                throw new PrincipalException();
            }
        } else if (cmd.equals("update")) {
            if (group.isCompany()) {
                if (!permissionChecker.isCompanyAdmin()) {
                    throw new PrincipalException();
                }
            } else if (group.isLayoutPrototype()) {
                LayoutPrototypePermissionUtil.check((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
            } else if (group.isLayoutSetPrototype()) {
                LayoutSetPrototypePermissionUtil.check((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
            } else if (group.isUser()) {
                long groupUserId = group.getClassPK();
                User groupUser = UserLocalServiceUtil.getUserById((long)groupUserId);
                long[] organizationIds = groupUser.getOrganizationIds();
                UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupUserId, (long[])organizationIds, (String)"UPDATE");
            } else {
                this.checkPermission(permissionChecker, group, layout, selPlid);
            }
        } else if (cmd.equals("publish_to_live") || cmd.equals("publish_to_remote")) {
            boolean hasUpdateLayoutPermission = false;
            if (layout != null) {
                hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE");
            }
            if (group.isCompany() || group.isSite()) {
                boolean publishToLive = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"PUBLISH_STAGING");
                if (!hasUpdateLayoutPermission && !publishToLive) {
                    throw new PrincipalException();
                }
            } else {
                this.checkPermission(permissionChecker, group, layout, selPlid);
            }
        } else if (cmd.equals("reset_customized_view")) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CUSTOMIZE")) {
                throw new PrincipalException();
            }
        } else {
            this.checkPermission(permissionChecker, group, layout, selPlid);
        }
    }

    protected void deleteLayoutRevision(ActionRequest actionRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        long layoutRevisionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutRevisionId");
        LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
        LayoutRevisionLocalServiceUtil.deleteLayoutRevision((LayoutRevision)layoutRevision);
        boolean updateRecentLayoutRevisionId = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"updateRecentLayoutRevisionId");
        if (updateRecentLayoutRevisionId) {
            StagingUtil.setRecentLayoutRevisionId((HttpServletRequest)request, (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getPlid(), (long)layoutRevision.getParentLayoutRevisionId());
        }
    }

    protected void deleteThemeSettingsProperties(UnicodeProperties typeSettingsProperties, String device) {
        String keyPrefix = ThemeSettingImpl.namespaceProperty(device);
        Set keys = typeSettingsProperties.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(keyPrefix)) continue;
            itr.remove();
        }
    }

    protected void enableLayout(ActionRequest actionRequest) throws Exception {
        long incompleteLayoutRevisionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"incompleteLayoutRevisionId");
        LayoutRevision incompleteLayoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)incompleteLayoutRevisionId);
        long layoutBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutBranchId", (long)incompleteLayoutRevision.getLayoutBranchId());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        serviceContext.setWorkflowAction(2);
        LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)incompleteLayoutRevision.getLayoutRevisionId(), (long)layoutBranchId, (String)incompleteLayoutRevision.getName(), (String)incompleteLayoutRevision.getTitle(), (String)incompleteLayoutRevision.getDescription(), (String)incompleteLayoutRevision.getKeywords(), (String)incompleteLayoutRevision.getRobots(), (String)incompleteLayoutRevision.getTypeSettings(), (boolean)incompleteLayoutRevision.getIconImage(), (long)incompleteLayoutRevision.getIconImageId(), (String)incompleteLayoutRevision.getThemeId(), (String)incompleteLayoutRevision.getColorSchemeId(), (String)incompleteLayoutRevision.getWapThemeId(), (String)incompleteLayoutRevision.getWapColorSchemeId(), (String)incompleteLayoutRevision.getCss(), (ServiceContext)serviceContext);
    }

    protected String getColorSchemeId(long companyId, String themeId, String colorSchemeId, boolean wapTheme) throws Exception {
        Theme theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)wapTheme);
        if (!theme.hasColorSchemes()) {
            colorSchemeId = "";
        }
        if (Validator.isNull((String)colorSchemeId)) {
            ColorScheme colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)themeId, (String)colorSchemeId, (boolean)wapTheme);
            colorSchemeId = colorScheme.getColorSchemeId();
        }
        return colorSchemeId;
    }

    protected Group getGroup(PortletRequest portletRequest) throws Exception {
        return ActionUtil.getGroup(portletRequest);
    }

    protected byte[] getIconBytes(UploadPortletRequest uploadPortletRequest, String iconFileName) {
        block3: {
            InputStream inputStream = null;
            try {
                inputStream = uploadPortletRequest.getFileAsStream(iconFileName);
                if (inputStream != null) {
                    return FileUtil.getBytes((InputStream)inputStream);
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to retrieve icon", (Throwable)ioe);
            }
        }
        return new byte[0];
    }

    protected void inheritMobileRuleGroups(Layout layout, ServiceContext serviceContext) throws PortalException, SystemException {
        List parentMDRRuleGroupInstances = MDRRuleGroupInstanceLocalServiceUtil.getRuleGroupInstances((String)Layout.class.getName(), (long)layout.getParentPlid());
        for (MDRRuleGroupInstance parentMDRRuleGroupInstance : parentMDRRuleGroupInstances) {
            MDRRuleGroupInstance mdrRuleGroupInstance = MDRRuleGroupInstanceServiceUtil.addRuleGroupInstance((long)layout.getGroupId(), (String)Layout.class.getName(), (long)layout.getPlid(), (long)parentMDRRuleGroupInstance.getRuleGroupId(), (int)parentMDRRuleGroupInstance.getPriority(), (ServiceContext)serviceContext);
            List parentMDRActions = MDRActionLocalServiceUtil.getActions((long)parentMDRRuleGroupInstance.getRuleGroupInstanceId());
            for (MDRAction mdrAction : parentMDRActions) {
                MDRActionServiceUtil.addAction((long)mdrRuleGroupInstance.getRuleGroupInstanceId(), (Map)mdrAction.getNameMap(), (Map)mdrAction.getDescriptionMap(), (String)mdrAction.getType(), (String)mdrAction.getTypeSettings(), (ServiceContext)serviceContext);
            }
        }
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void resetMergeFailCountAndMerge(ActionRequest actionRequest) throws Exception {
        long layoutPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPrototypeId");
        LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)layoutPrototypeId);
        SitesUtil.setMergeFailCount((LayoutPrototype)layoutPrototype, (int)0);
        long selPlid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"selPlid");
        Layout selLayout = LayoutLocalServiceUtil.getLayout((long)selPlid);
        SitesUtil.resetPrototype((Layout)selLayout);
        SitesUtil.mergeLayoutPrototypeLayout((Group)selLayout.getGroup(), (Layout)selLayout);
        layoutPrototype = LayoutPrototypeServiceUtil.getLayoutPrototype((long)layoutPrototypeId);
        int mergeFailCountAfterMerge = SitesUtil.getMergeFailCount((LayoutPrototype)layoutPrototype);
        if (mergeFailCountAfterMerge > 0) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"resetMergeFailCountAndMerge");
        }
    }

    protected void selectLayoutBranch(ActionRequest actionRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long layoutSetBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetBranchId");
        long layoutBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutBranchId");
        StagingUtil.setRecentLayoutBranchId((HttpServletRequest)request, (long)layoutSetBranchId, (long)themeDisplay.getPlid(), (long)layoutBranchId);
    }

    protected void selectLayoutSetBranch(ActionRequest actionRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long layoutSetBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetBranchId");
        LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)layoutSetBranchId);
        StagingUtil.setRecentLayoutSetBranchId((HttpServletRequest)request, (long)layoutSet.getLayoutSetId(), (long)layoutSetBranch.getLayoutSetBranchId());
    }

    protected void setThemeSettingProperties(ActionRequest actionRequest, UnicodeProperties typeSettingsProperties, String themeId, Map<String, ThemeSetting> themeSettings, String device, String deviceThemeId) throws PortalException, SystemException {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        LayoutSet layoutSet = layout.getLayoutSet();
        for (String key : themeSettings.keySet()) {
            ThemeSetting themeSetting = themeSettings.get(key);
            String value = null;
            if (!themeId.equals(deviceThemeId)) {
                value = themeSetting.getValue();
            } else {
                String property = String.valueOf(device) + "ThemeSettingsProperties--" + key + "--";
                value = ParamUtil.getString((PortletRequest)actionRequest, (String)property);
            }
            if (Validator.equals((Object)value, (Object)layoutSet.getThemeSetting(key, device))) continue;
            typeSettingsProperties.setProperty(ThemeSettingImpl.namespaceProperty(device, key), value);
        }
    }

    protected String updateCloseRedirect(ThemeDisplay themeDisplay, String closeRedirect, Group group, Layout layout, String oldLayoutFriendlyURL) {
        if (Validator.isNull((String)closeRedirect) || Validator.isNull((String)oldLayoutFriendlyURL)) {
            return closeRedirect;
        }
        if (layout != null) {
            String oldPath = oldLayoutFriendlyURL;
            String newPath = layout.getFriendlyURL(themeDisplay.getLocale());
            return PortalUtil.updateRedirect((String)closeRedirect, (String)oldPath, (String)newPath);
        }
        if (group != null) {
            String oldPath = String.valueOf(group.getFriendlyURL()) + oldLayoutFriendlyURL;
            String newPath = group.getFriendlyURL();
            return PortalUtil.updateRedirect((String)closeRedirect, (String)oldPath, (String)newPath);
        }
        return closeRedirect;
    }

    protected void updateDisplayOrder(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentLayoutId");
        long[] layoutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"layoutIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        LayoutServiceUtil.setLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (long[])layoutIds, (ServiceContext)serviceContext);
    }

    protected Object[] updateLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"parentLayoutId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        Map keywordsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"keywords");
        Map robotsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"robots");
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        boolean hidden = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"hidden");
        Map friendlyURLMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"friendlyURL");
        boolean iconImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"iconImage");
        byte[] iconBytes = this.getIconBytes(uploadPortletRequest, "iconFileName");
        long layoutPrototypeId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"layoutPrototypeId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        Layout layout = null;
        UnicodeProperties layoutTypeSettingsProperties = null;
        String oldFriendlyURL = "";
        if (cmd.equals("add")) {
            boolean inheritFromParentLayoutId = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"inheritFromParentLayoutId");
            UnicodeProperties typeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
            if (inheritFromParentLayoutId && parentLayoutId > 0L) {
                Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId);
                layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (Map)nameMap, (Map)titleMap, (Map)parentLayout.getDescriptionMap(), (Map)parentLayout.getKeywordsMap(), (Map)parentLayout.getRobotsMap(), (String)parentLayout.getType(), (String)parentLayout.getTypeSettings(), (boolean)hidden, (Map)friendlyURLMap, (ServiceContext)serviceContext);
                this.inheritMobileRuleGroups(layout, serviceContext);
                if (parentLayout.isTypePortlet()) {
                    ActionUtil.copyPreferences((PortletRequest)actionRequest, layout, parentLayout);
                    SitesUtil.copyLookAndFeel((Layout)layout, (Layout)parentLayout);
                }
            } else if (layoutPrototypeId > 0L) {
                LayoutPrototype layoutPrototype = LayoutPrototypeServiceUtil.getLayoutPrototype((long)layoutPrototypeId);
                String layoutPrototypeLinkEnabled = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutPrototypeLinkEnabled");
                if (Validator.isNotNull((String)layoutPrototypeLinkEnabled)) {
                    serviceContext.setAttribute("layoutPrototypeLinkEnabled", (Serializable)((Object)layoutPrototypeLinkEnabled));
                }
                serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
                layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (Map)nameMap, (Map)titleMap, (Map)descriptionMap, (Map)keywordsMap, (Map)robotsMap, (String)"portlet", (String)typeSettingsProperties.toString(), (boolean)hidden, (Map)friendlyURLMap, (ServiceContext)serviceContext);
            } else {
                long copyLayoutId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"copyLayoutId");
                Layout copyLayout = null;
                if (copyLayoutId > 0L) {
                    try {
                        copyLayout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)copyLayoutId);
                        if (copyLayout.isTypePortlet()) {
                            typeSettingsProperties = copyLayout.getTypeSettingsProperties();
                        }
                    }
                    catch (NoSuchLayoutException noSuchLayoutException) {}
                }
                layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (Map)nameMap, (Map)titleMap, (Map)descriptionMap, (Map)keywordsMap, (Map)robotsMap, (String)type, (String)typeSettingsProperties.toString(), (boolean)hidden, (Map)friendlyURLMap, (ServiceContext)serviceContext);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                String layoutTemplateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutTemplateId", (String)PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID);
                layoutTypePortlet.setLayoutTemplateId(themeDisplay.getUserId(), layoutTemplateId);
                LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layout.getLayoutId(), (String)layout.getTypeSettings());
                if (copyLayout != null && copyLayout.isTypePortlet()) {
                    ActionUtil.copyPreferences((PortletRequest)actionRequest, layout, copyLayout);
                    SitesUtil.copyLookAndFeel((Layout)layout, (Layout)copyLayout);
                }
            }
            layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
        } else {
            String[] removeEmbeddedPortletIds;
            layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
            oldFriendlyURL = layout.getFriendlyURL(themeDisplay.getLocale());
            layout = LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (long)layout.getParentLayoutId(), (Map)nameMap, (Map)titleMap, (Map)descriptionMap, (Map)keywordsMap, (Map)robotsMap, (String)type, (boolean)hidden, (Map)friendlyURLMap, (Boolean)iconImage, (byte[])iconBytes, (ServiceContext)serviceContext);
            layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
            if (oldFriendlyURL.equals(layout.getFriendlyURL(themeDisplay.getLocale()))) {
                oldFriendlyURL = "";
            }
            UnicodeProperties formTypeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
            if (type.equals("portlet")) {
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                String layoutTemplateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutTemplateId", (String)PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID);
                layoutTypePortlet.setLayoutTemplateId(themeDisplay.getUserId(), layoutTemplateId);
                long copyLayoutId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"copyLayoutId");
                if (copyLayoutId > 0L && copyLayoutId != layout.getLayoutId()) {
                    try {
                        Layout copyLayout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)copyLayoutId);
                        if (copyLayout.isTypePortlet()) {
                            layoutTypeSettingsProperties = copyLayout.getTypeSettingsProperties();
                            ActionUtil.copyPreferences((PortletRequest)actionRequest, layout, copyLayout);
                            SitesUtil.copyLookAndFeel((Layout)layout, (Layout)copyLayout);
                        }
                    }
                    catch (NoSuchLayoutException noSuchLayoutException) {}
                } else {
                    layoutTypeSettingsProperties.putAll((Map)formTypeSettingsProperties);
                    LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (String)layout.getTypeSettings());
                }
            } else {
                layout.setTypeSettingsProperties(formTypeSettingsProperties);
                layoutTypeSettingsProperties.putAll((Map)layout.getTypeSettingsProperties());
                LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (String)layout.getTypeSettings());
            }
            if ((removeEmbeddedPortletIds = ParamUtil.getParameterValues((PortletRequest)actionRequest, (String)"removeEmbeddedPortletIds")).length > 0) {
                PortletLocalServiceUtil.deletePortlets((long)themeDisplay.getCompanyId(), (String[])removeEmbeddedPortletIds, (long)layout.getPlid());
            }
            LayoutSettings layoutSettings = LayoutSettings.getInstance(layout);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            EventsProcessorUtil.process("layout.configuration.action.update", layoutSettings.getConfigurationActionUpdate(), (HttpServletRequest)uploadPortletRequest, response);
        }
        this.updateLookAndFeel(actionRequest, themeDisplay.getCompanyId(), liveGroupId, stagingGroupId, privateLayout, layout.getLayoutId(), layoutTypeSettingsProperties, layout.getThemeId());
        return new Object[]{layout, oldFriendlyURL};
    }

    protected void updateLayoutRevision(ActionRequest actionRequest, ThemeDisplay themeDisplay) throws Exception {
        long layoutRevisionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutRevisionId");
        LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        LayoutRevision enableLayoutRevision = LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevisionId, (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getWapThemeId(), (String)layoutRevision.getWapColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        if (layoutRevision.getStatus() != 6) {
            return;
        }
        LayoutRevision lastLayoutRevision = LayoutRevisionLocalServiceUtil.fetchLastLayoutRevision((long)enableLayoutRevision.getPlid(), (boolean)true);
        if (lastLayoutRevision != null) {
            LayoutRevision newLayoutRevision = LayoutRevisionLocalServiceUtil.addLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getLayoutBranchId(), (long)enableLayoutRevision.getLayoutRevisionId(), (boolean)false, (long)layoutRevision.getPlid(), (long)lastLayoutRevision.getLayoutRevisionId(), (boolean)lastLayoutRevision.isPrivateLayout(), (String)lastLayoutRevision.getName(), (String)lastLayoutRevision.getTitle(), (String)lastLayoutRevision.getDescription(), (String)lastLayoutRevision.getKeywords(), (String)lastLayoutRevision.getRobots(), (String)lastLayoutRevision.getTypeSettings(), (boolean)lastLayoutRevision.isIconImage(), (long)lastLayoutRevision.getIconImageId(), (String)lastLayoutRevision.getThemeId(), (String)lastLayoutRevision.getColorSchemeId(), (String)lastLayoutRevision.getWapThemeId(), (String)lastLayoutRevision.getWapColorSchemeId(), (String)lastLayoutRevision.getCss(), (ServiceContext)serviceContext);
            StagingUtil.setRecentLayoutRevisionId((User)themeDisplay.getUser(), (long)newLayoutRevision.getLayoutSetBranchId(), (long)newLayoutRevision.getPlid(), (long)newLayoutRevision.getLayoutRevisionId());
        }
    }

    protected void updateLookAndFeel(ActionRequest actionRequest, long companyId, long liveGroupId, long stagingGroupId, boolean privateLayout, long layoutId, UnicodeProperties typeSettingsProperties, String themeId) throws Exception {
        String[] devices;
        String[] stringArray = devices = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"devices"));
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            String device = stringArray[n2];
            String deviceThemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(String.valueOf(device) + "ThemeId"));
            String deviceColorSchemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(String.valueOf(device) + "ColorSchemeId"));
            String deviceCss = ParamUtil.getString((PortletRequest)actionRequest, (String)(String.valueOf(device) + "Css"));
            boolean deviceWapTheme = device.equals("wap");
            boolean deviceInheritLookAndFeel = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)(String.valueOf(device) + "InheritLookAndFeel"));
            if (deviceInheritLookAndFeel) {
                deviceThemeId = ThemeFactoryUtil.getDefaultRegularThemeId((long)companyId);
                deviceColorSchemeId = "";
                this.deleteThemeSettingsProperties(typeSettingsProperties, device);
            } else if (Validator.isNotNull((String)deviceThemeId)) {
                deviceColorSchemeId = this.getColorSchemeId(companyId, deviceThemeId, deviceColorSchemeId, deviceWapTheme);
                this.updateThemeSettingsProperties(actionRequest, companyId, typeSettingsProperties, themeId, device, deviceThemeId, deviceWapTheme);
            }
            long groupId = liveGroupId;
            if (stagingGroupId > 0L) {
                groupId = stagingGroupId;
            }
            LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (String)typeSettingsProperties.toString());
            LayoutServiceUtil.updateLookAndFeel((long)groupId, (boolean)privateLayout, (long)layoutId, (String)deviceThemeId, (String)deviceColorSchemeId, (String)deviceCss, (boolean)deviceWapTheme);
            ++n2;
        }
    }

    protected UnicodeProperties updateThemeSettingsProperties(ActionRequest actionRequest, long companyId, UnicodeProperties typeSettingsProperties, String themeId, String device, String deviceThemeId, boolean wapTheme) throws Exception {
        Theme theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)deviceThemeId, (boolean)wapTheme);
        this.deleteThemeSettingsProperties(typeSettingsProperties, device);
        Map themeSettings = theme.getConfigurableSettings();
        if (themeSettings.isEmpty()) {
            return typeSettingsProperties;
        }
        this.setThemeSettingProperties(actionRequest, typeSettingsProperties, themeId, themeSettings, device, deviceThemeId);
        return typeSettingsProperties;
    }
}

