/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutprototypes.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class LayoutPrototypeStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutPrototype> {
    public static final String[] CLASS_NAMES = new String[]{LayoutPrototype.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.fetchLayoutPrototypeByUuidAndCompanyId((String)uuid, (long)group.getCompanyId());
        if (layoutPrototype != null) {
            LayoutPrototypeLocalServiceUtil.deleteLayoutPrototype((LayoutPrototype)layoutPrototype);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(LayoutPrototype layoutPrototype) {
        return layoutPrototype.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutPrototype layoutPrototype) throws Exception {
        Element layoutPrototypeElement = portletDataContext.getExportDataElement((ClassedModel)layoutPrototype);
        this.exportLayouts(portletDataContext, layoutPrototype, layoutPrototypeElement);
        portletDataContext.addClassedModel(layoutPrototypeElement, ExportImportPathUtil.getModelPath((StagedModel)layoutPrototype), (ClassedModel)layoutPrototype);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutPrototype layoutPrototype) throws Exception {
        long userId = portletDataContext.getUserId(layoutPrototype.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)layoutPrototype);
        serviceContext.setAttribute("addDefaultLayout", (Serializable)Boolean.valueOf(false));
        LayoutPrototype importedLayoutPrototype = null;
        if (portletDataContext.isDataStrategyMirror()) {
            LayoutPrototype existingLayoutPrototype = LayoutPrototypeLocalServiceUtil.fetchLayoutPrototypeByUuidAndCompanyId((String)layoutPrototype.getUuid(), (long)portletDataContext.getCompanyId());
            if (existingLayoutPrototype == null) {
                serviceContext.setUuid(layoutPrototype.getUuid());
                importedLayoutPrototype = LayoutPrototypeLocalServiceUtil.addLayoutPrototype((long)userId, (long)portletDataContext.getCompanyId(), (Map)layoutPrototype.getNameMap(), (String)layoutPrototype.getDescription(), (boolean)layoutPrototype.isActive(), (ServiceContext)serviceContext);
            } else {
                importedLayoutPrototype = LayoutPrototypeLocalServiceUtil.updateLayoutPrototype((long)existingLayoutPrototype.getLayoutPrototypeId(), (Map)layoutPrototype.getNameMap(), (String)layoutPrototype.getDescription(), (boolean)layoutPrototype.isActive(), (ServiceContext)serviceContext);
            }
        } else {
            importedLayoutPrototype = LayoutPrototypeLocalServiceUtil.addLayoutPrototype((long)userId, (long)portletDataContext.getCompanyId(), (Map)layoutPrototype.getNameMap(), (String)layoutPrototype.getDescription(), (boolean)layoutPrototype.isActive(), (ServiceContext)serviceContext);
        }
        this.importLayouts(portletDataContext, layoutPrototype, importedLayoutPrototype.getGroupId());
        portletDataContext.importClassedModel((ClassedModel)layoutPrototype, (ClassedModel)importedLayoutPrototype);
    }

    protected void exportLayouts(PortletDataContext portletDataContext, LayoutPrototype layoutPrototype, Element layoutPrototypeElement) throws Exception {
        List layouts = LayoutLocalServiceUtil.getLayouts((long)layoutPrototype.getGroupId(), (boolean)true, (long)0L);
        for (Layout layout : layouts) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPrototype, (StagedModel)layout, (String)"embedded");
        }
    }

    protected void importLayouts(PortletDataContext portletDataContext, LayoutPrototype layoutPrototype, long importedGroupId) throws PortalException {
        long groupId = portletDataContext.getGroupId();
        boolean privateLayout = portletDataContext.isPrivateLayout();
        long scopeGroupId = portletDataContext.getScopeGroupId();
        try {
            portletDataContext.setGroupId(importedGroupId);
            portletDataContext.setPrivateLayout(true);
            portletDataContext.setScopeGroupId(importedGroupId);
            List layoutElements = portletDataContext.getReferenceDataElements((StagedModel)layoutPrototype, Layout.class);
            for (Element layoutElement : layoutElements) {
                StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (Element)layoutElement);
            }
        }
        finally {
            portletDataContext.setGroupId(groupId);
            portletDataContext.setPrivateLayout(privateLayout);
            portletDataContext.setScopeGroupId(scopeGroupId);
        }
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.fetchLayoutPrototypeByUuidAndCompanyId((String)uuid, (long)companyId);
        return layoutPrototype != null;
    }
}

