/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.templateparser.Transformer;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalStructureAdapter;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.model.JournalTemplateAdapter;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.util.comparator.ArticleCreateDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleDisplayDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleIDComparator;
import com.liferay.portlet.journal.util.comparator.ArticleModifiedDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleReviewDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleTitleComparator;
import com.liferay.portlet.journal.util.comparator.ArticleVersionComparator;
import com.liferay.util.ContentUtil;
import com.liferay.util.FiniteUniqueStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalUtil {
    public static final int MAX_STACK_SIZE = 20;
    private static Log _log = LogFactoryUtil.getLog(JournalUtil.class);
    private static Map<String, String> _customTokens;
    private static Pattern _friendlyURLPattern;
    private static Transformer _transformer;

    static {
        _friendlyURLPattern = Pattern.compile("[^a-z0-9_-]");
        _transformer = new Transformer("journal.transformer.listener", "journal.error.template", true);
    }

    public static void addAllReservedEls(Element rootElement, Map<String, String> tokens, JournalArticle article, String languageId, ThemeDisplay themeDisplay) {
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-id", article.getArticleId());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-version", article.getVersion());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-title", article.getTitle(languageId));
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-url-title", article.getUrlTitle());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-description", article.getDescription(languageId));
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-type", article.getType());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-create-date", article.getCreateDate());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-modified-date", article.getModifiedDate());
        if (article.getDisplayDate() != null) {
            JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-display-date", article.getDisplayDate());
        }
        String smallImageURL = "";
        if (Validator.isNotNull((String)article.getSmallImageURL())) {
            smallImageURL = article.getSmallImageURL();
        } else if (themeDisplay != null && article.isSmallImage()) {
            StringBundler sb = new StringBundler(5);
            sb.append(themeDisplay.getPathImage());
            sb.append("/journal/article?img_id=");
            sb.append(article.getSmallImageId());
            sb.append("&t=");
            sb.append(WebServerServletTokenUtil.getToken((long)article.getSmallImageId()));
            smallImageURL = sb.toString();
        }
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-small-image-url", smallImageURL);
        Object[] assetTagNames = new String[]{};
        try {
            assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
        }
        catch (SystemException systemException) {}
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-asset-tag-names", StringUtil.merge((Object[])assetTagNames));
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-id", String.valueOf(article.getUserId()));
        String userName = "";
        String userEmailAddress = "";
        String userComments = "";
        String userJobTitle = "";
        User user = null;
        try {
            user = UserLocalServiceUtil.getUserById((long)article.getUserId());
            userName = user.getFullName();
            userEmailAddress = user.getEmailAddress();
            userComments = user.getComments();
            userJobTitle = user.getJobTitle();
        }
        catch (PortalException portalException) {
        }
        catch (SystemException systemException) {}
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-name", userName);
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-email-address", userEmailAddress);
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-comments", userComments);
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-job-title", userJobTitle);
    }

    public static void addPortletBreadcrumbEntries(JournalArticle article, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        JournalFolder folder = article.getFolder();
        if (folder.getFolderId() != 0L) {
            JournalUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        JournalArticle unescapedArticle = article.toUnescapedModel();
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/article/view_article");
        portletURL.setParameter("groupId", String.valueOf(article.getGroupId()));
        portletURL.setParameter("articleId", String.valueOf(article.getArticleId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedArticle.getTitle(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(JournalFolder folder, HttpServletRequest request, LiferayPortletResponse liferayPortletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        if (strutsAction.equals("/journal/select_folder")) {
            portletURL.setParameter("struts_action", "/journal/select_folder");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/journal/view");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", 0L);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString(), data);
        }
        if (folder == null) {
            return;
        }
        List ancestorFolders = folder.getAncestors();
        Collections.reverse(ancestorFolders);
        for (JournalFolder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", ancestorFolder.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString(), data);
        }
        portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        if (folder.getFolderId() != 0L) {
            JournalFolder unescapedFolder = folder.toUnescapedModel();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", folder.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFolder.getName(), (String)portletURL.toString(), data);
        }
    }

    public static void addPortletBreadcrumbEntries(JournalFolder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        LiferayPortletResponse liferayPortletResponse = (LiferayPortletResponse)renderResponse;
        JournalUtil.addPortletBreadcrumbEntries(folder, request, liferayPortletResponse);
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (folderId == 0L) {
            return;
        }
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
        JournalUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
    }

    public static void addRecentArticle(PortletRequest portletRequest, JournalArticle article) {
        if (article != null) {
            Stack<JournalArticle> stack = JournalUtil.getRecentArticles(portletRequest);
            stack.push(article);
        }
    }

    public static void addRecentDDMStructure(PortletRequest portletRequest, DDMStructure ddmStructure) {
        if (ddmStructure != null) {
            Stack<DDMStructure> stack = JournalUtil.getRecentDDMStructures(portletRequest);
            stack.push(ddmStructure);
        }
    }

    public static void addRecentDDMTemplate(PortletRequest portletRequest, DDMTemplate ddmTemplate) {
        if (ddmTemplate != null) {
            Stack<DDMTemplate> stack = JournalUtil.getRecentDDMTemplates(portletRequest);
            stack.push(ddmTemplate);
        }
    }

    public static void addReservedEl(Element rootElement, Map<String, String> tokens, String name, Date value) {
        JournalUtil.addReservedEl(rootElement, tokens, name, Time.getRFC822((Date)value));
    }

    public static void addReservedEl(Element rootElement, Map<String, String> tokens, String name, double value) {
        JournalUtil.addReservedEl(rootElement, tokens, name, String.valueOf(value));
    }

    public static void addReservedEl(Element rootElement, Map<String, String> tokens, String name, String value) {
        if (rootElement != null) {
            Element dynamicElementElement = SAXReaderUtil.createElement((String)"dynamic-element");
            Attribute nameAttribute = SAXReaderUtil.createAttribute((Element)dynamicElementElement, (String)"name", (String)name);
            dynamicElementElement.add(nameAttribute);
            Attribute typeAttribute = SAXReaderUtil.createAttribute((Element)dynamicElementElement, (String)"type", (String)"text");
            dynamicElementElement.add(typeAttribute);
            Element dynamicContentElement = SAXReaderUtil.createElement((String)"dynamic-content");
            dynamicContentElement.setText(value);
            dynamicElementElement.add(dynamicContentElement);
            rootElement.add(dynamicElementElement);
        }
        tokens.put(StringUtil.replace((String)name, (char)'-', (char)'_'), value);
    }

    public static String formatVM(String vm) {
        return vm;
    }

    public static String getAbsolutePath(PortletRequest portletRequest, long folderId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L) {
            return themeDisplay.translate("home");
        }
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
        List folders = folder.getAncestors();
        Collections.reverse(folders);
        StringBundler sb = new StringBundler(folders.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (JournalFolder curFolder : folders) {
            sb.append("&raquo;");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append("&raquo;");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    public static OrderByComparator getArticleOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        ArticleCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new ArticleCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("display-date")) {
            orderByComparator = new ArticleDisplayDateComparator(orderByAsc);
        } else if (orderByCol.equals("id")) {
            orderByComparator = new ArticleIDComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new ArticleModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("review-date")) {
            orderByComparator = new ArticleReviewDateComparator(orderByAsc);
        } else if (orderByCol.equals("title")) {
            orderByComparator = new ArticleTitleComparator(orderByAsc);
        } else if (orderByCol.equals("version")) {
            orderByComparator = new ArticleVersionComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static Tuple getArticles(Hits hits) throws PortalException, SystemException {
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        boolean corruptIndex = false;
        List documents = hits.toList();
        for (Document document : documents) {
            long groupId = GetterUtil.getLong((String)document.get("groupId"));
            String articleId = document.get("articleId");
            try {
                JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId);
                articles.add(article);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                corruptIndex = true;
                Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
            }
        }
        return new Tuple(new Object[]{articles, corruptIndex});
    }

    public static String getEmailArticleAddedBody(PortletPreferences preferences) {
        String emailArticleAddedBody = preferences.getValue("emailArticleAddedBody", "");
        if (Validator.isNotNull((String)emailArticleAddedBody)) {
            return emailArticleAddedBody;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.added.body"));
    }

    public static boolean getEmailArticleAddedEnabled(PortletPreferences preferences) {
        String emailArticleAddedEnabled = preferences.getValue("emailArticleAddedEnabled", "");
        if (Validator.isNotNull((String)emailArticleAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleAddedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.added.enabled"));
    }

    public static String getEmailArticleAddedSubject(PortletPreferences preferences) {
        String emailArticleAddedSubject = preferences.getValue("emailArticleAddedSubject", "");
        if (Validator.isNotNull((String)emailArticleAddedSubject)) {
            return emailArticleAddedSubject;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.added.subject"));
    }

    public static String getEmailArticleApprovalDeniedBody(PortletPreferences preferences) {
        String emailArticleApprovalDeniedBody = preferences.getValue("emailArticleApprovalDeniedBody", "");
        if (Validator.isNotNull((String)emailArticleApprovalDeniedBody)) {
            return emailArticleApprovalDeniedBody;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.approval.denied.body"));
    }

    public static boolean getEmailArticleApprovalDeniedEnabled(PortletPreferences preferences) {
        String emailArticleApprovalDeniedEnabled = preferences.getValue("emailArticleApprovalDeniedEnabled", "");
        if (Validator.isNotNull((String)emailArticleApprovalDeniedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleApprovalDeniedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.approval.denied.enabled"));
    }

    public static String getEmailArticleApprovalDeniedSubject(PortletPreferences preferences) {
        String emailArticleApprovalDeniedSubject = preferences.getValue("emailArticleApprovalDeniedSubject", "");
        if (Validator.isNotNull((String)emailArticleApprovalDeniedSubject)) {
            return emailArticleApprovalDeniedSubject;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.approval.denied.subject"));
    }

    public static String getEmailArticleApprovalGrantedBody(PortletPreferences preferences) {
        String emailArticleApprovalGrantedBody = preferences.getValue("emailArticleApprovalGrantedBody", "");
        if (Validator.isNotNull((String)emailArticleApprovalGrantedBody)) {
            return emailArticleApprovalGrantedBody;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.approval.granted.body"));
    }

    public static boolean getEmailArticleApprovalGrantedEnabled(PortletPreferences preferences) {
        String emailArticleApprovalGrantedEnabled = preferences.getValue("emailArticleApprovalGrantedEnabled", "");
        if (Validator.isNotNull((String)emailArticleApprovalGrantedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleApprovalGrantedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.approval.granted.enabled"));
    }

    public static String getEmailArticleApprovalGrantedSubject(PortletPreferences preferences) {
        String emailArticleApprovalGrantedSubject = preferences.getValue("emailArticleApprovalGrantedSubject", "");
        if (Validator.isNotNull((String)emailArticleApprovalGrantedSubject)) {
            return emailArticleApprovalGrantedSubject;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.approval.granted.subject"));
    }

    public static String getEmailArticleApprovalRequestedBody(PortletPreferences preferences) {
        String emailArticleApprovalRequestedBody = preferences.getValue("emailArticleApprovalRequestedBody", "");
        if (Validator.isNotNull((String)emailArticleApprovalRequestedBody)) {
            return emailArticleApprovalRequestedBody;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.approval.requested.body"));
    }

    public static boolean getEmailArticleApprovalRequestedEnabled(PortletPreferences preferences) {
        String emailArticleApprovalRequestedEnabled = preferences.getValue("emailArticleApprovalRequestedEnabled", "");
        if (Validator.isNotNull((String)emailArticleApprovalRequestedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleApprovalRequestedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.approval.requested.enabled"));
    }

    public static String getEmailArticleApprovalRequestedSubject(PortletPreferences preferences) {
        String emailArticleApprovalRequestedSubject = preferences.getValue("emailArticleApprovalRequestedSubject", "");
        if (Validator.isNotNull((String)emailArticleApprovalRequestedSubject)) {
            return emailArticleApprovalRequestedSubject;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.approval.requested.subject"));
    }

    public static String getEmailArticleReviewBody(PortletPreferences preferences) {
        String emailArticleReviewBody = preferences.getValue("emailArticleReviewBody", "");
        if (Validator.isNotNull((String)emailArticleReviewBody)) {
            return emailArticleReviewBody;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.review.body"));
    }

    public static boolean getEmailArticleReviewEnabled(PortletPreferences preferences) {
        String emailArticleReviewEnabled = preferences.getValue("emailArticleReviewEnabled", "");
        if (Validator.isNotNull((String)emailArticleReviewEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleReviewEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.review.enabled"));
    }

    public static String getEmailArticleReviewSubject(PortletPreferences preferences) {
        String emailArticleReviewSubject = preferences.getValue("emailArticleReviewSubject", "");
        if (Validator.isNotNull((String)emailArticleReviewSubject)) {
            return emailArticleReviewSubject;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.review.subject"));
    }

    public static String getEmailArticleUpdatedBody(PortletPreferences preferences) {
        String emailArticleUpdatedBody = preferences.getValue("emailArticleUpdatedBody", "");
        if (Validator.isNotNull((String)emailArticleUpdatedBody)) {
            return emailArticleUpdatedBody;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.updated.body"));
    }

    public static boolean getEmailArticleUpdatedEnabled(PortletPreferences preferences) {
        String emailArticleUpdatedEnabled = preferences.getValue("emailArticleUpdatedEnabled", "");
        if (Validator.isNotNull((String)emailArticleUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleUpdatedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.updated.enabled"));
    }

    public static String getEmailArticleUpdatedSubject(PortletPreferences preferences) {
        String emailArticleUpdatedSubject = preferences.getValue("emailArticleUpdatedSubject", "");
        if (Validator.isNotNull((String)emailArticleUpdatedSubject)) {
            return emailArticleUpdatedSubject;
        }
        return ContentUtil.get((String)PropsUtil.get("journal.email.article.updated.subject"));
    }

    public static String getEmailFromAddress(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)preferences, (long)companyId, (String)PropsValues.JOURNAL_EMAIL_FROM_ADDRESS);
    }

    public static String getEmailFromName(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromName((PortletPreferences)preferences, (long)companyId, (String)PropsValues.JOURNAL_EMAIL_FROM_NAME);
    }

    public static String getJournalControlPanelLink(PortletRequest portletRequest, long folderId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"15", (long)PortalUtil.getControlPanelPlid((long)themeDisplay.getCompanyId()), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/journal/view");
        portletURL.setParameter("folderId", String.valueOf(folderId));
        return portletURL.toString();
    }

    public static long getPreviewPlid(JournalArticle article, ThemeDisplay themeDisplay) throws Exception {
        if (article != null && Validator.isNotNull((String)article.getLayoutUuid())) {
            Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndCompanyId((String)article.getLayoutUuid(), (long)themeDisplay.getCompanyId());
            return layout.getPlid();
        }
        Layout layout = LayoutLocalServiceUtil.fetchFirstLayout((long)themeDisplay.getScopeGroupId(), (boolean)false, (long)0L);
        if (layout == null) {
            layout = LayoutLocalServiceUtil.fetchFirstLayout((long)themeDisplay.getScopeGroupId(), (boolean)true, (long)0L);
        }
        if (layout != null) {
            return layout.getPlid();
        }
        return themeDisplay.getPlid();
    }

    public static Stack<JournalArticle> getRecentArticles(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Stack recentArticles = (Stack)portletSession.getAttribute("JOURNAL_RECENT_ARTICLES");
        if (recentArticles == null) {
            recentArticles = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_ARTICLES", (Object)recentArticles);
        }
        return recentArticles;
    }

    public static Stack<DDMStructure> getRecentDDMStructures(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Stack recentDDMStructures = (Stack)portletSession.getAttribute("JOURNAL_RECENT_DYNAMIC_DATA_MAPPING_STRUCTURES");
        if (recentDDMStructures == null) {
            recentDDMStructures = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_DYNAMIC_DATA_MAPPING_STRUCTURES", (Object)recentDDMStructures);
        }
        return recentDDMStructures;
    }

    public static Stack<DDMTemplate> getRecentDDMTemplates(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Stack recentDDMTemplates = (Stack)portletSession.getAttribute("JOURNAL_RECENT_DYNAMIC_DATA_MAPPING_TEMPLATES");
        if (recentDDMTemplates == null) {
            recentDDMTemplates = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_DYNAMIC_DATA_MAPPING_TEMPLATES", (Object)recentDDMTemplates);
        }
        return recentDDMTemplates;
    }

    public static long[] getStructureClassPKs(long[] groupIds, String structureId) throws SystemException {
        ArrayList<Long> classPKs = new ArrayList<Long>();
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            JournalStructure structure = JournalStructureLocalServiceUtil.fetchStructure((long)groupId, (String)structureId);
            if (structure != null) {
                classPKs.add(structure.getId());
            }
            ++n2;
        }
        return ArrayUtil.toLongArray(classPKs);
    }

    public static String getTemplateScript(DDMTemplate ddmTemplate, Map<String, String> tokens, String languageId, boolean transform) {
        String[] transformerListenerClassNames;
        String script = ddmTemplate.getScript();
        if (!transform) {
            return script;
        }
        String[] stringArray = transformerListenerClassNames = PropsUtil.getArray("journal.transformer.listener");
        int n = transformerListenerClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String transformerListenerClassName = stringArray[n2];
            TransformerListener transformerListener = null;
            try {
                transformerListener = (TransformerListener)InstanceFactory.newInstance((String)transformerListenerClassName);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                script = transformerListener.onScript(script, null, languageId, tokens);
            }
            ++n2;
        }
        return script;
    }

    public static String getTemplateScript(long groupId, String ddmTemplateKey, Map<String, String> tokens, String languageId) throws PortalException, SystemException {
        return JournalUtil.getTemplateScript(groupId, ddmTemplateKey, tokens, languageId, true);
    }

    public static String getTemplateScript(long groupId, String ddmTemplateKey, Map<String, String> tokens, String languageId, boolean transform) throws PortalException, SystemException {
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)groupId, (long)PortalUtil.getClassNameId(DDMStructure.class), (String)ddmTemplateKey);
        return JournalUtil.getTemplateScript(ddmTemplate, tokens, languageId, transform);
    }

    public static Map<String, String> getTokens(long articleGroupId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return JournalUtil.getTokens(articleGroupId, themeDisplay, null);
    }

    public static Map<String, String> getTokens(long articleGroupId, ThemeDisplay themeDisplay, String xmlRequest) throws PortalException, SystemException {
        HashMap<String, String> tokens;
        block5: {
            tokens = new HashMap<String, String>();
            if (themeDisplay != null) {
                JournalUtil._populateTokens(tokens, articleGroupId, themeDisplay);
            } else if (Validator.isNotNull((String)xmlRequest)) {
                try {
                    JournalUtil._populateTokens(tokens, articleGroupId, xmlRequest);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)e2, (Throwable)e2);
                }
            }
        }
        return tokens;
    }

    public static String getUrlTitle(long id, String title) {
        if (title == null) {
            return String.valueOf(id);
        }
        title = Validator.isNull((String)(title = StringUtil.toLowerCase((String)title.trim()))) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalize((String)title, (Pattern)_friendlyURLPattern);
        return ModelHintsUtil.trimString((String)JournalArticle.class.getName(), (String)"urlTitle", (String)title);
    }

    public static String mergeArticleContent(String curContent, String newContent, boolean removeNullElements) {
        try {
            com.liferay.portal.kernel.xml.Document curDocument = SAXReaderUtil.read((String)curContent);
            com.liferay.portal.kernel.xml.Document newDocument = SAXReaderUtil.read((String)newContent);
            Element curRootElement = curDocument.getRootElement();
            Element newRootElement = newDocument.getRootElement();
            curRootElement.addAttribute("default-locale", newRootElement.attributeValue("default-locale"));
            curRootElement.addAttribute("available-locales", newRootElement.attributeValue("available-locales"));
            JournalUtil._mergeArticleContentUpdate(curDocument, newRootElement, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
            if (removeNullElements) {
                JournalUtil._mergeArticleContentDelete(curRootElement, newDocument);
            }
            curContent = DDMXMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)curDocument);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return curContent;
    }

    public static void removeArticleLocale(Element element, String languageId) throws PortalException, SystemException {
        for (Element dynamicElementElement : element.elements("dynamic-element")) {
            for (Element dynamicContentElement : dynamicElementElement.elements("dynamic-content")) {
                String curLanguageId = GetterUtil.getString((String)dynamicContentElement.attributeValue("language-id"));
                if (!curLanguageId.equals(languageId)) continue;
                long id = GetterUtil.getLong((String)dynamicContentElement.attributeValue("id"));
                if (id > 0L) {
                    ImageLocalServiceUtil.deleteImage((long)id);
                }
                dynamicContentElement.detach();
            }
            JournalUtil.removeArticleLocale(dynamicElementElement, languageId);
        }
    }

    public static String removeArticleLocale(String content, String languageId) {
        try {
            com.liferay.portal.kernel.xml.Document document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            String availableLocales = rootElement.attributeValue("available-locales");
            if (availableLocales == null) {
                return content;
            }
            if ((availableLocales = StringUtil.remove((String)availableLocales, (String)languageId)).endsWith(",")) {
                availableLocales = availableLocales.substring(0, availableLocales.length() - 1);
            }
            rootElement.addAttribute("available-locales", availableLocales);
            JournalUtil.removeArticleLocale(rootElement, languageId);
            content = DDMXMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)document);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return content;
    }

    public static String removeOldContent(String content, String xsd) {
        try {
            com.liferay.portal.kernel.xml.Document contentDoc = SAXReaderUtil.read((String)content);
            com.liferay.portal.kernel.xml.Document xsdDoc = SAXReaderUtil.read((String)xsd);
            Element contentRoot = contentDoc.getRootElement();
            Stack<String> path = new Stack<String>();
            path.push(contentRoot.getName());
            JournalUtil._removeOldContent(path, contentRoot, xsdDoc);
            content = DDMXMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)contentDoc);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return content;
    }

    public static void removeRecentArticle(PortletRequest portletRequest, String articleId) {
        JournalUtil.removeRecentArticle(portletRequest, articleId, 0.0);
    }

    public static void removeRecentArticle(PortletRequest portletRequest, String articleId, double version) {
        Stack<JournalArticle> stack = JournalUtil.getRecentArticles(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            JournalArticle journalArticle = (JournalArticle)itr.next();
            if (!journalArticle.getArticleId().equals(articleId) || journalArticle.getVersion() != version && version != 0.0) continue;
            itr.remove();
        }
    }

    public static void removeRecentDDMStructure(PortletRequest portletRequest, String ddmStructureKey) {
        Stack<DDMStructure> stack = JournalUtil.getRecentDDMStructures(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            DDMStructure ddmStructure = (DDMStructure)itr.next();
            if (!ddmStructureKey.equals(ddmStructure.getStructureKey())) continue;
            itr.remove();
            break;
        }
    }

    public static void removeRecentDDMTemplate(PortletRequest portletRequest, String ddmTemplateKey) {
        Stack<DDMTemplate> stack = JournalUtil.getRecentDDMTemplates(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            DDMTemplate ddmTemplate = (DDMTemplate)itr.next();
            if (!ddmTemplateKey.equals(ddmTemplate.getTemplateKey())) continue;
            itr.remove();
            break;
        }
    }

    public static List<JournalStructure> toJournalStructures(List<DDMStructure> ddmStructures) throws SystemException {
        ArrayList<JournalStructureAdapter> structures = new ArrayList<JournalStructureAdapter>();
        for (DDMStructure ddmStructure : ddmStructures) {
            JournalStructureAdapter structure = new JournalStructureAdapter(ddmStructure);
            structures.add(structure);
        }
        return new UnmodifiableList(structures);
    }

    public static List<JournalTemplate> toJournalTemplates(List<DDMTemplate> ddmTemplates) {
        ArrayList<JournalTemplateAdapter> templates = new ArrayList<JournalTemplateAdapter>();
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            JournalTemplateAdapter template = new JournalTemplateAdapter(ddmTemplate);
            templates.add(template);
        }
        return new UnmodifiableList(templates);
    }

    public static String transform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, String xml, String script, String langType) throws Exception {
        return _transformer.transform(themeDisplay, tokens, viewMode, languageId, xml, script, langType);
    }

    private static void _addElementOptions(Element curContentElement, Element newContentElement) {
        List newElementOptions = newContentElement.elements("option");
        for (Element newElementOption : newElementOptions) {
            Element curElementOption = SAXReaderUtil.createElement((String)"option");
            curElementOption.addCDATA(newElementOption.getText());
            curContentElement.add(curElementOption);
        }
    }

    private static Element _getElementByInstanceId(com.liferay.portal.kernel.xml.Document document, String instanceId) {
        XPath xPathSelector = SAXReaderUtil.createXPath((String)("//dynamic-element[@instance-id=" + HtmlUtil.escapeXPathAttribute((String)instanceId) + "]"));
        List nodes = xPathSelector.selectNodes((Object)document);
        if (nodes.size() == 1) {
            return (Element)nodes.get(0);
        }
        return null;
    }

    private static void _mergeArticleContentDelete(Element curParentElement, com.liferay.portal.kernel.xml.Document newDocument) throws Exception {
        List curElements = curParentElement.elements("dynamic-element");
        int i2 = 0;
        while (i2 < curElements.size()) {
            Element curElement = (Element)curElements.get(i2);
            JournalUtil._mergeArticleContentDelete(curElement, newDocument);
            String instanceId = curElement.attributeValue("instance-id");
            Element newElement = JournalUtil._getElementByInstanceId(newDocument, instanceId);
            if (newElement == null) {
                curElement.detach();
            }
            ++i2;
        }
    }

    private static void _mergeArticleContentUpdate(com.liferay.portal.kernel.xml.Document curDocument, Element newParentElement, Element newElement, int pos, String defaultLocale) throws Exception {
        JournalUtil._mergeArticleContentUpdate(curDocument, newElement, defaultLocale);
        String instanceId = newElement.attributeValue("instance-id");
        Element curElement = JournalUtil._getElementByInstanceId(curDocument, instanceId);
        if (curElement != null) {
            JournalUtil._mergeArticleContentUpdate(curElement, newElement, defaultLocale);
        } else {
            String parentInstanceId = newParentElement.attributeValue("instance-id");
            if (Validator.isNull((String)parentInstanceId)) {
                Element curRoot = curDocument.getRootElement();
                List curRootElements = curRoot.elements();
                curRootElements.add(pos, newElement.createCopy());
            } else {
                Element curParentElement = JournalUtil._getElementByInstanceId(curDocument, parentInstanceId);
                if (curParentElement != null) {
                    List curParentElements = curParentElement.elements();
                    curParentElements.add(pos, newElement.createCopy());
                }
            }
        }
    }

    private static void _mergeArticleContentUpdate(com.liferay.portal.kernel.xml.Document curDocument, Element newParentElement, String defaultLocale) throws Exception {
        List newElements = newParentElement.elements("dynamic-element");
        int i2 = 0;
        while (i2 < newElements.size()) {
            Element newElement = (Element)newElements.get(i2);
            JournalUtil._mergeArticleContentUpdate(curDocument, newParentElement, newElement, i2, defaultLocale);
            ++i2;
        }
    }

    private static void _mergeArticleContentUpdate(Element curElement, Element newElement, String defaultLocale) {
        Attribute curTypeAttribute = curElement.attribute("type");
        Attribute newTypeAttribute = newElement.attribute("type");
        curTypeAttribute.setValue(newTypeAttribute.getValue());
        Attribute curIndexTypeAttribute = curElement.attribute("index-type");
        Attribute newIndexTypeAttribute = newElement.attribute("index-type");
        if (newIndexTypeAttribute != null) {
            if (curIndexTypeAttribute == null) {
                curElement.addAttribute("index-type", newIndexTypeAttribute.getValue());
            } else {
                curIndexTypeAttribute.setValue(newIndexTypeAttribute.getValue());
            }
        }
        List elements = newElement.elements("dynamic-content");
        Element newContentElement = (Element)elements.get(0);
        String newLanguageId = newContentElement.attributeValue("language-id");
        String newValue = newContentElement.getText();
        String indexType = newElement.attributeValue("index-type");
        if (Validator.isNotNull((String)indexType)) {
            curElement.addAttribute("index-type", indexType);
        }
        List curContentElements = curElement.elements("dynamic-content");
        if (Validator.isNull((String)newLanguageId)) {
            Element curContentElement2;
            for (Element curContentElement2 : curContentElements) {
                curContentElement2.detach();
            }
            curContentElement2 = SAXReaderUtil.createElement((String)"dynamic-content");
            if (newContentElement.element("option") != null) {
                JournalUtil._addElementOptions(curContentElement2, newContentElement);
            } else {
                curContentElement2.addCDATA(newValue);
            }
            curElement.add(curContentElement2);
        } else {
            boolean alreadyExists = false;
            for (Element curContentElement : curContentElements) {
                String curLanguageId = curContentElement.attributeValue("language-id");
                if (!newLanguageId.equals(curLanguageId)) continue;
                alreadyExists = true;
                curContentElement.clearContent();
                if (newContentElement.element("option") != null) {
                    JournalUtil._addElementOptions(curContentElement, newContentElement);
                    break;
                }
                curContentElement.addCDATA(newValue);
                break;
            }
            if (!alreadyExists) {
                Element curContentElement;
                curContentElement = (Element)curContentElements.get(0);
                String curLanguageId = curContentElement.attributeValue("language-id");
                if (Validator.isNull((String)curLanguageId)) {
                    if (newLanguageId.equals(defaultLocale)) {
                        curContentElement.clearContent();
                        if (newContentElement.element("option") != null) {
                            JournalUtil._addElementOptions(curContentElement, newContentElement);
                        } else {
                            curContentElement.addCDATA(newValue);
                        }
                    } else {
                        curElement.add(newContentElement.createCopy());
                    }
                    curContentElement.addAttribute("language-id", defaultLocale);
                } else {
                    curElement.add(newContentElement.createCopy());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void _populateCustomTokens(Map<String, String> tokens) {
        if (_customTokens == null) {
            Class<JournalUtil> clazz = JournalUtil.class;
            // MONITORENTER : com.liferay.portlet.journal.util.JournalUtil.class
            _customTokens = new HashMap<String, String>();
            String[] stringArray = PropsValues.JOURNAL_ARTICLE_CUSTOM_TOKENS;
            int n = PropsValues.JOURNAL_ARTICLE_CUSTOM_TOKENS.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    // MONITOREXIT : clazz
                    break;
                }
                String customToken = stringArray[n2];
                String value = PropsUtil.get("journal.article.custom.token.value", new Filter(customToken));
                _customTokens.put(customToken, value);
                ++n2;
            }
        }
        if (_customTokens.isEmpty()) return;
        tokens.putAll(_customTokens);
    }

    private static void _populateTokens(Map<String, String> tokens, long articleGroupId, String xmlRequest) throws Exception {
        com.liferay.portal.kernel.xml.Document requestDocument = SAXReaderUtil.read((String)xmlRequest);
        Element rootElement = requestDocument.getRootElement();
        Element themeDisplayElement = rootElement.element("theme-display");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)GetterUtil.getLong((String)themeDisplayElement.elementText("plid")));
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplayElement.elementText("path-friendly-url-public") : (group.isUserGroup() ? themeDisplayElement.elementText("path-friendly-url-private-user") : themeDisplayElement.elementText("path-friendly-url-private-group"));
        String layoutSetFriendlyUrl = themeDisplayElement.elementText("i18n-path");
        String virtualHostname = layoutSet.getVirtualHostname();
        if (Validator.isNull((String)virtualHostname) || !virtualHostname.equals(themeDisplayElement.elementText("server-name"))) {
            layoutSetFriendlyUrl = String.valueOf(friendlyUrlCurrent) + group.getFriendlyURL();
        }
        tokens.put("article_group_id", String.valueOf(articleGroupId));
        tokens.put("cdn_host", themeDisplayElement.elementText("cdn-host"));
        tokens.put("company_id", themeDisplayElement.elementText("company-id"));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplayElement.elementText("path-friendly-url-private-group"));
        tokens.put("friendly_url_private_user", themeDisplayElement.elementText("path-friendly-url-private-user"));
        tokens.put("friendly_url_public", themeDisplayElement.elementText("path-friendly-url-public"));
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("image_path", themeDisplayElement.elementText("path-image"));
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplayElement.elementText("path-main"));
        tokens.put("portal_ctx", themeDisplayElement.elementText("path-context"));
        tokens.put("portal_url", HttpUtil.removeProtocol((String)themeDisplayElement.elementText("url-portal")));
        tokens.put("protocol", HttpUtil.getProtocol((String)themeDisplayElement.elementText("url-portal")));
        tokens.put("root_path", themeDisplayElement.elementText("path-context"));
        tokens.put("scope_group_id", themeDisplayElement.elementText("scope-group-id"));
        tokens.put("site_group_id", themeDisplayElement.elementText("site-group-id"));
        tokens.put("theme_image_path", themeDisplayElement.elementText("path-theme-images"));
        JournalUtil._populateCustomTokens(tokens);
        tokens.put("friendly_url", themeDisplayElement.elementText("path-friendly-url-public"));
        tokens.put("friendly_url_private", themeDisplayElement.elementText("path-friendly-url-private-group"));
        tokens.put("group_id", String.valueOf(articleGroupId));
        tokens.put("page_url", themeDisplayElement.elementText("path-friendly-url-public"));
    }

    private static void _populateTokens(Map<String, String> tokens, long articleGroupId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplay.getPathFriendlyURLPublic() : (group.isUserGroup() ? themeDisplay.getPathFriendlyURLPrivateUser() : themeDisplay.getPathFriendlyURLPrivateGroup());
        String layoutSetFriendlyUrl = themeDisplay.getI18nPath();
        String virtualHostname = layoutSet.getVirtualHostname();
        if (Validator.isNull((String)virtualHostname) || !virtualHostname.equals(themeDisplay.getServerName())) {
            layoutSetFriendlyUrl = String.valueOf(friendlyUrlCurrent) + group.getFriendlyURL();
        }
        tokens.put("article_group_id", String.valueOf(articleGroupId));
        tokens.put("cdn_host", themeDisplay.getCDNHost());
        tokens.put("company_id", String.valueOf(themeDisplay.getCompanyId()));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplay.getPathFriendlyURLPrivateGroup());
        tokens.put("friendly_url_private_user", themeDisplay.getPathFriendlyURLPrivateUser());
        tokens.put("friendly_url_public", themeDisplay.getPathFriendlyURLPublic());
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("image_path", themeDisplay.getPathImage());
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplay.getPathMain());
        tokens.put("portal_ctx", themeDisplay.getPathContext());
        tokens.put("portal_url", HttpUtil.removeProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("protocol", HttpUtil.getProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("root_path", themeDisplay.getPathContext());
        tokens.put("site_group_id", String.valueOf(themeDisplay.getSiteGroupId()));
        tokens.put("scope_group_id", String.valueOf(themeDisplay.getScopeGroupId()));
        tokens.put("theme_image_path", themeDisplay.getPathThemeImages());
        JournalUtil._populateCustomTokens(tokens);
        tokens.put("friendly_url", themeDisplay.getPathFriendlyURLPublic());
        tokens.put("friendly_url_private", themeDisplay.getPathFriendlyURLPrivateGroup());
        tokens.put("group_id", String.valueOf(articleGroupId));
        tokens.put("page_url", themeDisplay.getPathFriendlyURLPublic());
    }

    private static void _removeOldContent(Stack<String> path, Element contentElement, com.liferay.portal.kernel.xml.Document xsdDocument) throws SystemException {
        String elementPath = "";
        int i2 = 0;
        while (i2 < path.size()) {
            elementPath = String.valueOf(elementPath) + "/" + (String)path.elementAt(i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < contentElement.nodeCount()) {
            Node contentNode = contentElement.node(i2);
            if (contentNode instanceof Element) {
                JournalUtil._removeOldContent(path, (Element)contentNode, xsdDocument, elementPath);
            }
            ++i2;
        }
    }

    private static void _removeOldContent(Stack<String> path, Element contentElement, com.liferay.portal.kernel.xml.Document xsdDocument, String elementPath) throws SystemException {
        String name = contentElement.attributeValue("name");
        if (Validator.isNull((String)name)) {
            return;
        }
        String localPath = "dynamic-element[@name=" + HtmlUtil.escapeXPathAttribute((String)name) + "]";
        String fullPath = String.valueOf(elementPath) + "/" + localPath;
        XPath xPathSelector = SAXReaderUtil.createXPath((String)fullPath);
        List curNodes = xPathSelector.selectNodes((Object)xsdDocument);
        if (curNodes.size() == 0) {
            contentElement.detach();
        }
        path.push(localPath);
        JournalUtil._removeOldContent(path, contentElement, xsdDocument);
        path.pop();
    }
}

