/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.util.comparator.ArticleDisplayDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleModifiedDateComparator;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEnclosureImpl;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JournalRSSUtil {
    private static Log _log = LogFactoryUtil.getLog(JournalRSSUtil.class);

    public static List<JournalArticle> getArticles(JournalFeed feed) throws SystemException {
        String templateId;
        String structureId;
        long companyId = feed.getCompanyId();
        long groupId = feed.getGroupId();
        List folderIds = Collections.emptyList();
        String articleId = null;
        Double version = null;
        String title = null;
        String description = null;
        String content = null;
        String type = feed.getType();
        if (Validator.isNull((String)type)) {
            type = null;
        }
        if (Validator.isNull((String)(structureId = feed.getStructureId()))) {
            structureId = null;
        }
        if (Validator.isNull((String)(templateId = feed.getTemplateId()))) {
            templateId = null;
        }
        Date displayDateGT = null;
        Date displayDateLT = new Date();
        int status = 0;
        Date reviewDate = null;
        boolean andOperator = true;
        int start = 0;
        int end = feed.getDelta();
        String orderByCol = feed.getOrderByCol();
        String orderByType = feed.getOrderByType();
        boolean orderByAsc = orderByType.equals("asc");
        ArticleModifiedDateComparator obc = new ArticleModifiedDateComparator(orderByAsc);
        if (orderByCol.equals("display-date")) {
            obc = new ArticleDisplayDateComparator(orderByAsc);
        }
        return JournalArticleLocalServiceUtil.search((long)companyId, (long)groupId, folderIds, (long)0L, articleId, version, title, description, content, (String)type, (String)structureId, (String)templateId, displayDateGT, (Date)displayDateLT, (int)status, reviewDate, (boolean)andOperator, (int)start, (int)end, (OrderByComparator)obc);
    }

    public static List<SyndEnclosure> getDLEnclosures(String portalURL, String url) {
        ArrayList<SyndEnclosure> syndEnclosures = new ArrayList<SyndEnclosure>();
        FileEntry fileEntry = JournalRSSUtil.getFileEntry(url);
        if (fileEntry == null) {
            return syndEnclosures;
        }
        SyndEnclosureImpl syndEnclosure = new SyndEnclosureImpl();
        syndEnclosure.setLength(fileEntry.getSize());
        syndEnclosure.setType(fileEntry.getMimeType());
        syndEnclosure.setUrl(String.valueOf(portalURL) + url);
        syndEnclosures.add((SyndEnclosure)syndEnclosure);
        return syndEnclosures;
    }

    public static List<SyndLink> getDLLinks(String portalURL, String url) {
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        FileEntry fileEntry = JournalRSSUtil.getFileEntry(url);
        if (fileEntry == null) {
            return syndLinks;
        }
        SyndLinkImpl syndLink = new SyndLinkImpl();
        syndLink.setHref(String.valueOf(portalURL) + url);
        syndLink.setLength(fileEntry.getSize());
        syndLink.setRel("enclosure");
        syndLink.setType(fileEntry.getMimeType());
        syndLinks.add((SyndLink)syndLink);
        return syndLinks;
    }

    public static FileEntry getFileEntry(String url) {
        FileEntry fileEntry;
        block17: {
            fileEntry = null;
            String queryString = HttpUtil.getQueryString((String)url);
            Map parameters = HttpUtil.parameterMapFromString((String)queryString);
            if (url.startsWith("/documents/")) {
                String[] pathArray = StringUtil.split((String)url, (char)'/');
                String uuid = null;
                long groupId = GetterUtil.getLong((String)pathArray[2]);
                long folderId = 0L;
                String title = null;
                if (pathArray.length == 4) {
                    uuid = pathArray[3];
                } else if (pathArray.length == 5) {
                    folderId = GetterUtil.getLong((String)pathArray[3]);
                    title = HttpUtil.decodeURL((String)pathArray[4], (boolean)true);
                } else if (pathArray.length > 5) {
                    uuid = pathArray[5];
                }
                try {
                    if (Validator.isNotNull((String)uuid)) {
                        fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                        break block17;
                    }
                    fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, title);
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e2, (Throwable)e2);
                    }
                    break block17;
                }
            }
            if (parameters.containsKey("folderId") && parameters.containsKey("name")) {
                try {
                    long fileEntryId = GetterUtil.getLong((String)((String[])parameters.get("fileEntryId"))[0]);
                    fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
                }
                catch (Exception e3) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e3, (Throwable)e3);
                    }
                    break block17;
                }
            }
            if (parameters.containsKey("uuid") && parameters.containsKey("groupId")) {
                try {
                    String uuid = ((String[])parameters.get("uuid"))[0];
                    long groupId = GetterUtil.getLong((String)((String[])parameters.get("groupId"))[0]);
                    fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                }
                catch (Exception e4) {
                    if (!_log.isWarnEnabled()) break block17;
                    _log.warn((Object)e4, (Throwable)e4);
                }
            }
        }
        return fileEntry;
    }

    public static List<SyndEnclosure> getIGEnclosures(String portalURL, String url) {
        ArrayList<SyndEnclosure> syndEnclosures = new ArrayList<SyndEnclosure>();
        Object[] imageProperties = JournalRSSUtil.getImageProperties(url);
        if (imageProperties == null) {
            return syndEnclosures;
        }
        SyndEnclosureImpl syndEnclosure = new SyndEnclosureImpl();
        syndEnclosure.setLength(((Long)imageProperties[1]).longValue());
        syndEnclosure.setType(MimeTypesUtil.getExtensionContentType((String)imageProperties[0].toString()));
        syndEnclosure.setUrl(String.valueOf(portalURL) + url);
        syndEnclosures.add((SyndEnclosure)syndEnclosure);
        return syndEnclosures;
    }

    public static List<SyndLink> getIGLinks(String portalURL, String url) {
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        Object[] imageProperties = JournalRSSUtil.getImageProperties(url);
        if (imageProperties == null) {
            return syndLinks;
        }
        SyndLinkImpl syndLink = new SyndLinkImpl();
        syndLink.setHref(String.valueOf(portalURL) + url);
        syndLink.setLength(((Long)imageProperties[1]).longValue());
        syndLink.setRel("enclosure");
        syndLink.setType(MimeTypesUtil.getExtensionContentType((String)imageProperties[0].toString()));
        syndLinks.add((SyndLink)syndLink);
        return syndLinks;
    }

    public static Image getImage(String url) {
        Image image;
        block8: {
            image = null;
            String queryString = HttpUtil.getQueryString((String)url);
            Map parameters = HttpUtil.parameterMapFromString((String)queryString);
            if (parameters.containsKey("image_id") || parameters.containsKey("img_id") || parameters.containsKey("i_id")) {
                try {
                    long imageId = 0L;
                    if (parameters.containsKey("image_id")) {
                        imageId = GetterUtil.getLong((String)((String[])parameters.get("image_id"))[0]);
                    } else if (parameters.containsKey("img_id")) {
                        imageId = GetterUtil.getLong((String)((String[])parameters.get("img_id"))[0]);
                    } else if (parameters.containsKey("i_id")) {
                        imageId = GetterUtil.getLong((String)((String[])parameters.get("i_id"))[0]);
                    }
                    image = ImageLocalServiceUtil.getImage((long)imageId);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)e2, (Throwable)e2);
                }
            }
        }
        return image;
    }

    protected static Object[] getImageProperties(String url) {
        String type = null;
        long size = 0L;
        Image image = JournalRSSUtil.getImage(url);
        if (image != null) {
            type = image.getType();
            size = image.getSize();
        } else {
            FileEntry fileEntry = JournalRSSUtil.getFileEntry(url);
            Set imageMimeTypes = ImageProcessorUtil.getImageMimeTypes();
            if (fileEntry != null && imageMimeTypes.contains(fileEntry.getMimeType())) {
                type = fileEntry.getExtension();
                size = fileEntry.getSize();
            }
        }
        if (Validator.isNotNull((String)type)) {
            return new Object[]{type, size};
        }
        return null;
    }
}

