/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.StructureFieldException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexerUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.persistence.JournalArticleActionableDynamicQuery;
import com.liferay.portlet.journal.util.JournalConverterUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class JournalArticleIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName()};
    public static final String PORTLET_ID = "15";
    private static Log _log = LogFactoryUtil.getLog(JournalArticleIndexer.class);

    public JournalArticleIndexer() {
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return JournalArticlePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        String ddmTemplateKey;
        String ddmStructureKey;
        String articleType;
        Long classNameId = (Long)searchContext.getAttribute("classNameId");
        if (classNameId != null && classNameId != 0L) {
            contextQuery.addRequiredTerm("classNameId", classNameId.toString());
        }
        this.addStatus(contextQuery, searchContext);
        this.addSearchClassTypeIds(contextQuery, searchContext);
        String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"/");
            DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)GetterUtil.getLong((String)ddmStructureFieldNameParts[1]));
            String fieldName = StringUtil.replaceLast((String)ddmStructureFieldNameParts[2], (String)"_".concat(LocaleUtil.toLanguageId((Locale)searchContext.getLocale())), (String)"");
            try {
                ddmStructureFieldValue = DDMUtil.getIndexedFieldValue((Serializable)ddmStructureFieldValue, (String)structure.getFieldType(fieldName));
            }
            catch (StructureFieldException structureFieldException) {}
            contextQuery.addRequiredTerm(ddmStructureFieldName, "\"" + ddmStructureFieldValue + "\"");
        }
        if (Validator.isNotNull((String)(articleType = (String)((Object)searchContext.getAttribute("articleType"))))) {
            contextQuery.addRequiredTerm("type", articleType);
        }
        if (Validator.isNotNull((String)(ddmStructureKey = (String)((Object)searchContext.getAttribute("ddmStructureKey"))))) {
            contextQuery.addRequiredTerm("ddmStructureKey", ddmStructureKey);
        }
        if (Validator.isNotNull((String)(ddmTemplateKey = (String)((Object)searchContext.getAttribute("ddmTemplateKey"))))) {
            contextQuery.addRequiredTerm("ddmTemplateKey", ddmTemplateKey);
        }
        boolean head = GetterUtil.getBoolean((Object)searchContext.getAttribute("head"), (boolean)Boolean.TRUE);
        boolean relatedClassName = GetterUtil.getBoolean((Object)searchContext.getAttribute("relatedClassName"));
        if (head && !relatedClassName) {
            contextQuery.addRequiredTerm("head", Boolean.TRUE);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "classPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
        this.addSearchTerm(searchQuery, searchContext, "type", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addSearchTerm(searchQuery, searchContext, "articleId", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void addDDMStructureAttributes(Document document, JournalArticle article) throws Exception {
        if (Validator.isNull((String)article.getStructureId())) {
            return;
        }
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)article.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)article.getStructureId(), (boolean)true);
        if (ddmStructure == null) {
            return;
        }
        document.addKeyword("classTypeId", ddmStructure.getStructureId());
        Fields fields = null;
        try {
            fields = JournalConverterUtil.getDDMFields((DDMStructure)ddmStructure, (String)article.getContent());
        }
        catch (Exception exception) {
            return;
        }
        if (fields != null) {
            DDMIndexerUtil.addAttributes((Document)document, (DDMStructure)ddmStructure, (Fields)fields);
        }
    }

    protected void addSearchLocalizedTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        if (Validator.isNull((String)field)) {
            return;
        }
        String value = String.valueOf(searchContext.getAttribute(field));
        if (Validator.isNull((String)value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isNull((String)value)) {
            return;
        }
        field = DocumentImpl.getLocalizedName((Locale)searchContext.getLocale(), (String)field);
        if (searchContext.isAndSearch()) {
            searchQuery.addRequiredTerm(field, value, like);
        } else {
            searchQuery.addTerm(field, value, like);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        this.deleteDocument(article.getCompanyId(), article.getId());
        this.reindexArticleVersions(article);
    }

    protected Document doGetDocument(Object obj) throws Exception {
        String[] languageIds;
        JournalArticle article = (JournalArticle)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)article);
        document.addUID(PORTLET_ID, article.getId());
        String articleDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)article.getContent());
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        String[] stringArray = languageIds = this.getLanguageIds(defaultLanguageId, article.getContent());
        int n = languageIds.length;
        int n2 = 0;
        while (n2 < n) {
            String languageId = stringArray[n2];
            String content = this.extractContent(article, languageId);
            String description = article.getDescription(languageId);
            String title = article.getTitle(languageId);
            if (languageId.equals(articleDefaultLanguageId)) {
                document.addText("content", content);
                document.addText("description", description);
                document.addText("title", title);
                document.addText("defaultLanguageId", languageId);
            }
            document.addText("content".concat("_").concat(languageId), content);
            document.addText("description".concat("_").concat(languageId), description);
            document.addText("title".concat("_").concat(languageId), title);
            ++n2;
        }
        document.addKeyword("folderId", article.getFolderId());
        document.addKeyword("layoutUuid", article.getLayoutUuid());
        document.addKeyword("treePath", StringUtil.split((String)article.getTreePath(), (char)'/'));
        document.addKeyword("type", article.getType());
        document.addKeyword("version", article.getVersion());
        String articleId = article.getArticleId();
        if (article.isInTrash()) {
            articleId = TrashUtil.getOriginalTitle((String)articleId);
        }
        document.addKeyword("articleId", articleId);
        document.addKeyword("ddmStructureKey", article.getStructureId());
        document.addKeyword("ddmTemplateKey", article.getTemplateId());
        document.addDate("displayDate", article.getDisplayDate());
        document.addKeyword("head", false);
        this.addDDMStructureAttributes(document, article);
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("display-date")) {
            return "displayDate";
        }
        if (orderByCol.equals("id")) {
            return "entryClassPK";
        }
        if (orderByCol.equals("modified-date")) {
            return "modified";
        }
        if (orderByCol.equals("title")) {
            return "title";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        Locale snippetLocale = this.getSnippetLocale(document, locale);
        if (snippetLocale == null) {
            snippetLocale = LocaleUtil.fromLanguageId((String)document.get("defaultLanguageId"));
        }
        String prefix = "snippet_";
        String title = document.get(snippetLocale, String.valueOf(prefix) + "title", "title");
        String content = "";
        String ddmStructureKey = document.get("ddmStructureKey");
        content = Validator.isNotNull((String)ddmStructureKey) ? this.getDDMContentSummary(document, snippetLocale) : this.getBasicContentSummary(document, snippetLocale);
        String groupId = document.get("groupId");
        String articleId = document.get("articleId");
        String version = document.get("version");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("groupId", groupId);
        portletURL.setParameter("articleId", articleId);
        portletURL.setParameter("version", version);
        return new Summary(snippetLocale, title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        if (!article.isIndexable() || PortalUtil.getClassNameId(DDMStructure.class) == article.getClassNameId()) {
            Document document = this.getDocument(article);
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)article.getCompanyId(), (String)document.get("uid"));
            return;
        }
        this.reindexArticleVersions(article);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)classPK);
        this.doReindex(article);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexArticles(companyId);
    }

    protected void doReindexDDMStructures(List<Long> ddmStructureIds) throws Exception {
        String[] ddmStructureKeys = new String[ddmStructureIds.size()];
        int i2 = 0;
        while (i2 < ddmStructureIds.size()) {
            long structureId = ddmStructureIds.get(i2);
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)structureId);
            ddmStructureKeys[i2] = ddmStructure.getStructureKey();
            ++i2;
        }
        List articles = JournalArticleLocalServiceUtil.getStructureArticles((String[])ddmStructureKeys);
        for (JournalArticle article : articles) {
            this.doReindex(article);
        }
    }

    protected String extractBasicContent(JournalArticle article, String languageId) {
        String content = article.getContentByLocale(languageId);
        content = StringUtil.replace((String)content, (String)"<![CDATA[", (String)"");
        content = StringUtil.replace((String)content, (String)"]]>", (String)"");
        content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
        content = StringUtil.replace((String)content, (String)"&lt;", (String)"<");
        content = StringUtil.replace((String)content, (String)"&gt;", (String)">");
        content = HtmlUtil.extractText((String)content);
        return content;
    }

    protected String extractContent(JournalArticle article, String languageId) throws Exception {
        if (Validator.isNotNull((String)article.getStructureId())) {
            return this.extractDDMContent(article, languageId);
        }
        return this.extractBasicContent(article, languageId);
    }

    protected String extractDDMContent(JournalArticle article, String languageId) throws Exception {
        if (Validator.isNull((String)article.getStructureId())) {
            return "";
        }
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)article.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)article.getStructureId(), (boolean)true);
        if (ddmStructure == null) {
            return "";
        }
        Fields fields = null;
        try {
            fields = JournalConverterUtil.getDDMFields((DDMStructure)ddmStructure, (String)article.getContent());
        }
        catch (Exception exception) {
            return "";
        }
        if (fields == null) {
            return "";
        }
        return DDMIndexerUtil.extractAttributes((DDMStructure)ddmStructure, (Fields)fields, (Locale)LocaleUtil.fromLanguageId((String)languageId));
    }

    protected Collection<Document> getArticleVersions(JournalArticle article) throws PortalException, SystemException {
        Document document;
        ArrayList<Document> documents = new ArrayList<Document>();
        JournalArticle latestIndexableArticle = JournalArticleLocalServiceUtil.fetchLatestIndexableArticle((long)article.getResourcePrimKey());
        List articles = JournalArticleLocalServiceUtil.getArticlesByResourcePrimKey((long)article.getResourcePrimKey());
        for (JournalArticle curArticle : articles) {
            if (!curArticle.isIndexable() || latestIndexableArticle != null && curArticle.getId() == latestIndexableArticle.getId()) continue;
            Document document2 = this.getDocument(curArticle);
            document2.addKeyword("head", false);
            documents.add(document2);
        }
        if (latestIndexableArticle != null) {
            document = this.getDocument(latestIndexableArticle);
            document.addKeyword("head", true);
            documents.add(document);
        } else if (article.getStatus() == 8) {
            document = this.getDocument(article);
            document.addKeyword("head", true);
            documents.add(document);
        }
        return documents;
    }

    protected String getBasicContentSummary(Document document, Locale snippetLocale) {
        String prefix = "snippet_";
        String content = document.get(snippetLocale, String.valueOf(prefix) + "description", String.valueOf(prefix) + "content");
        if (Validator.isBlank((String)content)) {
            content = document.get(snippetLocale, "description", "content");
        }
        if (content.length() > 200) {
            content = StringUtil.shorten((String)content, (int)200);
        }
        return content;
    }

    protected String getDDMContentSummary(Document document, Locale snippetLocale) {
        String content;
        block4: {
            content = "";
            try {
                long groupId = GetterUtil.getLong((String)document.get("groupId"));
                String articleId = document.get("articleId");
                double version = GetterUtil.getDouble((String)document.get("version"));
                JournalArticle article = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)articleId, (double)version);
                if (article == null) {
                    return content;
                }
                JournalArticleDisplay articleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)article, null, (String)"view", (String)LocaleUtil.toLanguageId((Locale)snippetLocale), (int)1, null, null);
                content = HtmlUtil.escape((String)articleDisplay.getDescription());
                if (Validator.isNull((String)(content = HtmlUtil.replaceNewLine((String)content)))) {
                    content = HtmlUtil.stripHtml((String)articleDisplay.getContent());
                }
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)e2, (Throwable)e2);
            }
        }
        return content;
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexArticles(long companyId) throws PortalException, SystemException {
        JournalArticleActionableDynamicQuery actionableDynamicQuery = new JournalArticleActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property indexableProperty = PropertyFactoryUtil.forName((String)"indexable");
                dynamicQuery.add(indexableProperty.eq((Object)true));
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                JournalArticle article = (JournalArticle)object;
                this.addDocuments(JournalArticleIndexer.this.getArticleVersions(article));
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }

    protected void reindexArticleVersions(JournalArticle article) throws PortalException, SystemException {
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)article.getCompanyId(), this.getArticleVersions(article));
    }
}

