/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.social;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;

public class JournalArticleActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{JournalArticle.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)activity.getClassPK());
        if (Validator.isNotNull((String)article.getLayoutUuid())) {
            String groupFriendlyURL = PortalUtil.getGroupFriendlyURL((Group)serviceContext.getScopeGroup(), (boolean)false, (ThemeDisplay)serviceContext.getThemeDisplay());
            return groupFriendlyURL.concat("/-/").concat(article.getUrlTitle());
        }
        return null;
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-article-add-web-content";
            }
            return "activity-journal-article-add-web-content-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-article-update-web-content";
            }
            return "activity-journal-article-update-web-content-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-article-move-to-trash";
            }
            return "activity-journal-article-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-article-restore-from-trash";
            }
            return "activity-journal-article-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        int activityType = activity.getType();
        if (activityType == 1 && !JournalPermission.contains(permissionChecker, activity.getGroupId(), "ADD_ARTICLE")) {
            return false;
        }
        if (activityType == 2 && !JournalArticlePermission.contains(permissionChecker, activity.getClassPK(), "UPDATE")) {
            return false;
        }
        return JournalArticlePermission.contains(permissionChecker, activity.getClassPK(), actionId);
    }
}

