/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.ArticleContentException;
import com.liferay.portlet.journal.ArticleDisplayDateException;
import com.liferay.portlet.journal.ArticleExpirationDateException;
import com.liferay.portlet.journal.ArticleIdException;
import com.liferay.portlet.journal.ArticleReviewDateException;
import com.liferay.portlet.journal.ArticleSmallImageNameException;
import com.liferay.portlet.journal.ArticleSmallImageSizeException;
import com.liferay.portlet.journal.ArticleTitleException;
import com.liferay.portlet.journal.ArticleTypeException;
import com.liferay.portlet.journal.ArticleVersionException;
import com.liferay.portlet.journal.DuplicateArticleIdException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.StructureXsdException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleConstants;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.model.impl.JournalArticleDisplayImpl;
import com.liferay.portlet.journal.service.base.JournalArticleLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.journal.util.comparator.ArticleIDComparator;
import com.liferay.portlet.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class JournalArticleLocalServiceImpl
extends JournalArticleLocalServiceBaseImpl {
    private static final long _JOURNAL_ARTICLE_CHECK_INTERVAL = (long)PropsValues.JOURNAL_ARTICLE_CHECK_INTERVAL * 60000L;
    private static Log _log = LogFactoryUtil.getLog(JournalArticleLocalServiceImpl.class);
    private Date _previousCheckDate;

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle addArticle(long userId, long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String type, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        articleId = StringUtil.toUpperCase((String)articleId.trim());
        Date displayDate = null;
        Date expirationDate = null;
        Date reviewDate = null;
        if (classNameId == 0L) {
            displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), ArticleDisplayDateException.class);
            if (!neverExpire) {
                expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), ArticleExpirationDateException.class);
            }
            if (!neverReview) {
                reviewDate = PortalUtil.getDate((int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (TimeZone)user.getTimeZone(), ArticleReviewDateException.class);
            }
        }
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {}
        Date now = new Date();
        this.validate(user.getCompanyId(), groupId, classNameId, articleId, autoArticleId, version, titleMap, content, type, ddmStructureKey, ddmTemplateKey, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        if (autoArticleId) {
            articleId = String.valueOf(this.counterLocalService.increment());
        }
        long id = this.counterLocalService.increment();
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(serviceContext.getUuid(), groupId, articleId);
        JournalArticle article = this.journalArticlePersistence.create(id);
        Locale locale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = ParamUtil.getString((ServiceContext)serviceContext, (String)"defaultLanguageId");
        if (Validator.isNull((String)defaultLanguageId)) {
            defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)content);
        }
        if (Validator.isNotNull((String)defaultLanguageId)) {
            locale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        String title = titleMap.get(locale);
        content = this.format(user, groupId, articleId, version, false, content, ddmStructureKey, images);
        article.setResourcePrimKey(resourcePrimKey);
        article.setGroupId(groupId);
        article.setCompanyId(user.getCompanyId());
        article.setUserId(user.getUserId());
        article.setUserName(user.getFullName());
        article.setCreateDate(serviceContext.getCreateDate(now));
        article.setModifiedDate(serviceContext.getModifiedDate(now));
        article.setFolderId(folderId);
        article.setClassNameId(classNameId);
        article.setClassPK(classPK);
        article.setTreePath(article.buildTreePath());
        article.setArticleId(articleId);
        article.setVersion(version);
        article.setTitleMap(titleMap, locale);
        article.setUrlTitle(this.getUniqueUrlTitle(id, articleId, title, null, serviceContext));
        article.setDescriptionMap(descriptionMap, locale);
        article.setContent(content);
        article.setType(type);
        article.setStructureId(ddmStructureKey);
        article.setTemplateId(ddmTemplateKey);
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        article.setSmallImageId(this.counterLocalService.increment());
        article.setSmallImageURL(smallImageURL);
        if (expirationDate == null || expirationDate.after(now)) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        article.setStatusByUserId(userId);
        article.setStatusDate(serviceContext.getModifiedDate(now));
        article.setExpandoBridgeAttributes(serviceContext);
        this.journalArticlePersistence.update((BaseModel)article);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addArticleResources(article, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addArticleResources(article, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (PortalUtil.getClassNameId(DDMStructure.class) == classNameId) {
            this.updateDDMStructureXSD(classPK, content, serviceContext);
        }
        if (PropsValues.JOURNAL_ARTICLE_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, article.getUserName(), groupId, JournalArticle.class.getName(), resourcePrimKey, 1);
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        this.sendEmail(article, articleURL, preferences, "requested", serviceContext);
        if (classNameId == 0L) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)JournalArticle.class.getName(), (long)article.getId(), (Object)article, (ServiceContext)serviceContext);
        } else {
            this.updateStatus(userId, article, 0, null, new HashMap<String, Serializable>(), serviceContext);
        }
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    public JournalArticle addArticle(long userId, long groupId, long folderId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, ServiceContext serviceContext) throws PortalException, SystemException {
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        int displayDateMonth = calendar.get(2);
        int displayDateDay = calendar.get(5);
        int displayDateYear = calendar.get(1);
        int displayDateHour = calendar.get(11);
        int displayDateMinute = calendar.get(12);
        return this.journalArticleLocalService.addArticle(userId, groupId, folderId, 0L, 0L, "", true, 1.0, titleMap, descriptionMap, content, "general", ddmStructureKey, ddmTemplateKey, null, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext);
    }

    public void addArticleResources(JournalArticle article, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(JournalArticle article, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void addArticleResources(long groupId, String articleId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(long groupId, String articleId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, groupPermissions, guestPermissions);
    }

    public JournalArticle checkArticleResourcePrimKey(long groupId, String articleId, double version) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.getResourcePrimKey() > 0L) {
            return article;
        }
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId);
        article.setResourcePrimKey(resourcePrimKey);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    public void checkArticles() throws PortalException, SystemException {
        Date now = new Date();
        this.checkArticlesByExpirationDate(now);
        this.checkArticlesByReviewDate(now);
        this.checkArticlesByDisplayDate(now);
        this._previousCheckDate = now;
    }

    public void checkNewLine(long groupId, String articleId, double version) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        String content = GetterUtil.getString((String)article.getContent());
        if (content.contains("\\n")) {
            content = StringUtil.replace((String)content, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            article.setContent(content);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    public void checkStructure(long groupId, String articleId, double version) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (Validator.isNull((String)article.getStructureId())) {
            return;
        }
        this.checkStructure(article);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle copyArticle(long userId, long groupId, String oldArticleId, String newArticleId, boolean autoArticleId, double version) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        oldArticleId = StringUtil.toUpperCase((String)oldArticleId.trim());
        newArticleId = StringUtil.toUpperCase((String)newArticleId.trim());
        Date now = new Date();
        JournalArticle oldArticle = this.journalArticlePersistence.findByG_A_V(groupId, oldArticleId, version);
        if (autoArticleId) {
            newArticleId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validate(newArticleId);
            if (this.journalArticlePersistence.countByG_A(groupId, newArticleId) > 0) {
                throw new DuplicateArticleIdException();
            }
        }
        long id = this.counterLocalService.increment();
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, newArticleId);
        JournalArticle newArticle = this.journalArticlePersistence.create(id);
        newArticle.setResourcePrimKey(resourcePrimKey);
        newArticle.setGroupId(groupId);
        newArticle.setCompanyId(user.getCompanyId());
        newArticle.setUserId(user.getUserId());
        newArticle.setUserName(user.getFullName());
        newArticle.setCreateDate(now);
        newArticle.setModifiedDate(now);
        newArticle.setFolderId(oldArticle.getFolderId());
        newArticle.setTreePath(oldArticle.getTreePath());
        newArticle.setArticleId(newArticleId);
        newArticle.setVersion(1.0);
        newArticle.setTitle(oldArticle.getTitle());
        newArticle.setUrlTitle(this.getUniqueUrlTitle(id, groupId, newArticleId, oldArticle.getTitleCurrentValue()));
        newArticle.setDescription(oldArticle.getDescription());
        try {
            this.copyArticleImages(oldArticle, newArticle);
        }
        catch (Exception exception) {
            newArticle.setContent(oldArticle.getContent());
        }
        newArticle.setType(oldArticle.getType());
        newArticle.setStructureId(oldArticle.getStructureId());
        newArticle.setTemplateId(oldArticle.getTemplateId());
        newArticle.setLayoutUuid(oldArticle.getLayoutUuid());
        newArticle.setDisplayDate(oldArticle.getDisplayDate());
        newArticle.setExpirationDate(oldArticle.getExpirationDate());
        newArticle.setReviewDate(oldArticle.getReviewDate());
        newArticle.setIndexable(oldArticle.isIndexable());
        newArticle.setSmallImage(oldArticle.isSmallImage());
        newArticle.setSmallImageId(this.counterLocalService.increment());
        newArticle.setSmallImageURL(oldArticle.getSmallImageURL());
        if (oldArticle.isPending() || this.workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(user.getCompanyId(), groupId, JournalArticle.class.getName())) {
            newArticle.setStatus(2);
        } else {
            newArticle.setStatus(oldArticle.getStatus());
        }
        newArticle.setExpandoBridgeAttributes((BaseModel)oldArticle);
        this.journalArticlePersistence.update((BaseModel)newArticle);
        this.addArticleResources(newArticle, true, true);
        if (oldArticle.getSmallImage()) {
            Image image = this.imageLocalService.getImage(oldArticle.getSmallImageId());
            byte[] smallImageBytes = image.getTextObj();
            this.imageLocalService.updateImage(newArticle.getSmallImageId(), smallImageBytes);
        }
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        String[] assetTagNames = this.assetTagLocalService.getTagNames(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        this.updateAsset(userId, newArticle, assetCategoryIds, assetTagNames, null);
        return newArticle;
    }

    @SystemEvent(action=1, send=false)
    public JournalArticle deleteArticle(JournalArticle article) throws PortalException, SystemException {
        return this.journalArticleLocalService.deleteArticle(article, "", null);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, send=false)
    public JournalArticle deleteArticle(JournalArticle article, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        int articlesCount;
        PortletPreferences preferences;
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.fetchArticleResource(article.getGroupId(), article.getArticleId());
        if (article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion(), 0)) {
            this.updatePreviousApprovedArticle(article);
        }
        if (serviceContext != null && Validator.isNotNull((String)articleURL) && (preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext)) != null && !article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            this.sendEmail(article, articleURL, preferences, "denied", serviceContext);
        }
        this.journalArticleImageLocalService.deleteImages(article.getGroupId(), article.getArticleId(), article.getVersion());
        this.expandoRowLocalService.deleteRows(article.getId());
        if (!article.isDraft()) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        if ((articlesCount = this.journalArticlePersistence.countByG_A(article.getGroupId(), article.getArticleId())) == 1) {
            this.subscriptionLocalService.deleteSubscriptions(article.getCompanyId(), JournalArticle.class.getName(), article.getResourcePrimKey());
            this.ratingsStatsLocalService.deleteStats(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.mbMessageLocalService.deleteDiscussionMessages(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.journalContentSearchLocalService.deleteArticleContentSearches(article.getGroupId(), article.getArticleId());
            this.imageLocalService.deleteImage(article.getSmallImageId());
            this.trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.resourceLocalService.deleteResource(article.getCompanyId(), JournalArticle.class.getName(), 4, article.getResourcePrimKey());
            if (articleResource != null) {
                this.journalArticleResourceLocalService.deleteJournalArticleResource(articleResource);
            }
        }
        this.journalArticlePersistence.remove((BaseModel)article);
        if (articleResource != null) {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("version", article.getVersion());
            this.systemEventLocalService.addSystemEvent(0L, article.getGroupId(), article.getModelClassName(), article.getPrimaryKey(), articleResource.getUuid(), null, 1, extraDataJSONObject.toString());
        }
        return article;
    }

    public JournalArticle deleteArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.deleteArticle(article, articleURL, serviceContext);
    }

    public void deleteArticle(long groupId, String articleId, ServiceContext serviceContext) throws PortalException, SystemException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.fetchArticleResource(groupId, articleId);
        try {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                this.journalArticleLocalService.deleteArticle(article, null, serviceContext);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        if (articleResource != null) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticles(long groupId) throws PortalException, SystemException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            JournalArticleResource articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByGroupId(groupId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
                    articleResources.add(articleResource);
                }
                this.journalArticleLocalService.deleteArticle(article, null, null);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticles(long groupId, long folderId) throws PortalException, SystemException {
        this.deleteArticles(groupId, folderId, true);
    }

    public void deleteArticles(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException, SystemException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            JournalArticleResource articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByG_F(groupId, folderId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
                    articleResources.add(articleResource);
                }
                if (includeTrashedEntries || !article.isInTrash()) {
                    this.journalArticleLocalService.deleteArticle(article, null, null);
                    continue;
                }
                articleResources.remove(articleResource);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteLayoutArticleReferences(long groupId, String layoutUuid) throws SystemException {
        List articles = this.journalArticlePersistence.findByG_L(groupId, layoutUuid);
        for (JournalArticle article : articles) {
            article.setLayoutUuid("");
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle expireArticle(long userId, long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateStatus(userId, groupId, articleId, version, 3, articleURL, new HashMap<String, Serializable>(), serviceContext);
    }

    public void expireArticle(long userId, long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        if (PropsValues.JOURNAL_ARTICLE_EXPIRE_ALL_VERSIONS) {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
            }
        } else {
            JournalArticle article = this.getLatestArticle(groupId, articleId, 0);
            this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
        }
    }

    public JournalArticle fetchArticle(long groupId, String articleId, double version) throws SystemException {
        return this.journalArticlePersistence.fetchByG_A_V(groupId, articleId, version);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int status, boolean preferApproved) throws SystemException {
        JournalArticle article = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, 0, (OrderByComparator)orderByComparator);
            }
            if (article == null) {
                article = this.journalArticlePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)orderByComparator);
            }
        } else {
            article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, status, (OrderByComparator)orderByComparator);
        }
        return article;
    }

    public JournalArticle fetchLatestArticle(long groupId, String articleId, int status) throws SystemException {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            return this.journalArticlePersistence.fetchByG_A_First(groupId, articleId, (OrderByComparator)orderByComparator);
        }
        return this.journalArticlePersistence.fetchByG_A_ST_First(groupId, articleId, status, (OrderByComparator)orderByComparator);
    }

    public JournalArticle fetchLatestIndexableArticle(long resourcePrimKey) throws SystemException {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        int[] nArray = new int[2];
        nArray[1] = 8;
        int[] statuses = nArray;
        List articles = this.journalArticlePersistence.findByR_I_S(resourcePrimKey, true, statuses, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticle(long id) throws PortalException, SystemException {
        return this.journalArticlePersistence.findByPrimaryKey(id);
    }

    public JournalArticle getArticle(long groupId, String articleId) throws PortalException, SystemException {
        try {
            return this.getLatestArticle(groupId, articleId, 0);
        }
        catch (NoSuchArticleException noSuchArticleException) {
            return this.getLatestArticle(groupId, articleId, -1);
        }
    }

    public JournalArticle getArticle(long groupId, String articleId, double version) throws PortalException, SystemException {
        return this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
    }

    public JournalArticle getArticle(long groupId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, classNameId, classPK);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No approved JournalArticle exists with the key {groupId=" + groupId + ", className=" + className + ", classPK=" + classPK + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticleByUrlTitle(long groupId, String urlTitle) throws PortalException, SystemException {
        try {
            return this.getLatestArticleByUrlTitle(groupId, urlTitle, 0);
        }
        catch (NoSuchArticleException noSuchArticleException) {
            return this.getLatestArticleByUrlTitle(groupId, urlTitle, 1);
        }
    }

    public String getArticleContent(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, 1, null, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String ddmTemplateKey, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleContent(groupId, articleId, version, viewMode, null, languageId, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, String viewMode, String ddmTemplateKey, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, themeDisplay);
        return articleDisplay.getContent();
    }

    public String getArticleContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleContent(groupId, articleId, viewMode, null, languageId, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String content = null;
        if (page < 1) {
            page = 1;
        }
        int numberOfPages = 1;
        boolean paginate = false;
        boolean pageFlow = false;
        boolean cacheable = true;
        if (Validator.isNull((String)xmlRequest)) {
            xmlRequest = "<request />";
        }
        Map<String, String> tokens = JournalUtil.getTokens(article.getGroupId(), themeDisplay, xmlRequest);
        if (themeDisplay == null && xmlRequest.equals("<request />")) {
            tokens.put("company_id", String.valueOf(article.getCompanyId()));
            Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
            tokens.put("article_group_id", String.valueOf(article.getGroupId()));
            tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
            tokens.put("group_id", String.valueOf(article.getGroupId()));
        }
        tokens.put("article_resource_pk", String.valueOf(article.getResourcePrimKey()));
        String defaultDDMTemplateKey = article.getTemplateId();
        if (article.isTemplateDriven()) {
            if (Validator.isNull((String)ddmTemplateKey)) {
                ddmTemplateKey = defaultDDMTemplateKey;
            }
            tokens.put("structure_id", article.getStructureId());
            tokens.put("template_id", ddmTemplateKey);
        }
        String xml = article.getContent();
        try {
            Document document = null;
            Element rootElement = null;
            if (article.isTemplateDriven()) {
                document = SAXReaderUtil.read((String)xml);
                rootElement = document.getRootElement();
                Document requestDocument = SAXReaderUtil.read((String)xmlRequest);
                List pages = rootElement.elements("page");
                if (!pages.isEmpty()) {
                    pageFlow = true;
                    String targetPage = requestDocument.valueOf("/request/parameters/parameter[name='targetPage']/value");
                    Element pageElement = null;
                    if (Validator.isNotNull((String)targetPage)) {
                        targetPage = HtmlUtil.escapeXPathAttribute((String)targetPage);
                        XPath xPathSelector = SAXReaderUtil.createXPath((String)("/root/page[@id = " + targetPage + "]"));
                        pageElement = (Element)xPathSelector.selectSingleNode((Object)document);
                    }
                    if (pageElement != null) {
                        document = SAXReaderUtil.createDocument(pageElement);
                        rootElement = document.getRootElement();
                        numberOfPages = pages.size();
                    } else {
                        if (page > pages.size()) {
                            page = 1;
                        }
                        pageElement = (Element)pages.get(page - 1);
                        document = SAXReaderUtil.createDocument((Element)pageElement);
                        rootElement = document.getRootElement();
                        numberOfPages = pages.size();
                        paginate = true;
                    }
                }
                rootElement.add(requestDocument.getRootElement().createCopy());
                JournalUtil.addAllReservedEls(rootElement, tokens, article, languageId, themeDisplay);
                xml = DDMXMLUtil.formatXML((Document)document);
            }
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
        try {
            String[] pieces;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Transforming " + article.getArticleId() + " " + article.getVersion() + " " + languageId));
            }
            String script = null;
            String langType = null;
            if (article.isTemplateDriven()) {
                DDMTemplate ddmTemplate;
                block24: {
                    ddmTemplate = null;
                    try {
                        ddmTemplate = this.ddmTemplatePersistence.findByG_C_T(PortalUtil.getSiteGroupId((long)article.getGroupId()), PortalUtil.getClassNameId(DDMStructure.class), ddmTemplateKey);
                    }
                    catch (NoSuchTemplateException nste1) {
                        try {
                            Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
                            ddmTemplate = this.ddmTemplatePersistence.findByG_C_T(companyGroup.getGroupId(), PortalUtil.getClassNameId(DDMStructure.class), ddmTemplateKey);
                            tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
                        }
                        catch (NoSuchTemplateException noSuchTemplateException) {
                            if (!defaultDDMTemplateKey.equals(ddmTemplateKey)) {
                                ddmTemplate = this.ddmTemplatePersistence.findByG_C_T(PortalUtil.getSiteGroupId((long)article.getGroupId()), PortalUtil.getClassNameId(DDMStructure.class), defaultDDMTemplateKey);
                                break block24;
                            }
                            throw nste1;
                        }
                    }
                }
                script = ddmTemplate.getScript();
                langType = ddmTemplate.getLanguage();
                cacheable = ddmTemplate.isCacheable();
            }
            content = JournalUtil.transform(themeDisplay, tokens, viewMode, languageId, xml, script, langType);
            if (!pageFlow && (pieces = StringUtil.split((String)content, (String)PropsValues.JOURNAL_ARTICLE_TOKEN_PAGE_BREAK)).length > 1) {
                if (page > pieces.length) {
                    page = 1;
                }
                content = pieces[page - 1];
                numberOfPages = pieces.length;
                paginate = true;
            }
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        return new JournalArticleDisplayImpl(article.getCompanyId(), article.getId(), article.getResourcePrimKey(), article.getGroupId(), article.getUserId(), article.getArticleId(), article.getVersion(), article.getTitle(languageId), article.getUrlTitle(), article.getDescription(languageId), article.getAvailableLanguageIds(), content, article.getType(), article.getStructureId(), ddmTemplateKey, article.isSmallImage(), article.getSmallImageId(), article.getSmallImageURL(), numberOfPages, page, paginate, cacheable);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Date expirationDate;
        Date now = new Date();
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.isExpired() && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(now)) {
            return null;
        }
        Date displayDate = article.getDisplayDate();
        if (displayDate.after(now)) {
            return null;
        }
        return this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, xmlRequest, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, 1, null, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleDisplay(groupId, articleId, null, viewMode, languageId, page, xmlRequest, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, page, xmlRequest, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleDisplay(groupId, articleId, null, viewMode, languageId, themeDisplay);
    }

    public List<JournalArticle> getArticles() throws SystemException {
        return this.journalArticlePersistence.findAll();
    }

    public List<JournalArticle> getArticles(long groupId) throws SystemException {
        return this.journalArticlePersistence.findByGroupId(groupId);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end) throws SystemException {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId) throws SystemException {
        return this.journalArticlePersistence.findByG_F(groupId, folderId);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end) throws SystemException {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId) throws SystemException {
        return this.journalArticlePersistence.findByG_A(groupId, articleId);
    }

    public List<JournalArticle> getArticlesByResourcePrimKey(long resourcePrimKey) throws SystemException {
        return this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey);
    }

    public List<JournalArticle> getArticlesBySmallImageId(long smallImageId) throws SystemException {
        return this.journalArticlePersistence.findBySmallImageId(smallImageId);
    }

    public int getArticlesCount(long groupId) throws SystemException {
        return this.journalArticlePersistence.countByGroupId(groupId);
    }

    public int getArticlesCount(long groupId, long folderId) throws SystemException {
        return this.journalArticlePersistence.countByG_F(groupId, folderId);
    }

    public List<JournalArticle> getCompanyArticles(long companyId, double version, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.journalArticlePersistence.findByC_V(companyId, version, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_V_ST(companyId, version, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public List<JournalArticle> getCompanyArticles(long companyId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.journalArticlePersistence.findByCompanyId(companyId, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_ST(companyId, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public int getCompanyArticlesCount(long companyId, double version, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.journalArticlePersistence.countByC_V(companyId, version);
        }
        return this.journalArticlePersistence.countByC_V_ST(companyId, version, status);
    }

    public int getCompanyArticlesCount(long companyId, int status) throws SystemException {
        if (status == -1) {
            return this.journalArticlePersistence.countByCompanyId(companyId);
        }
        return this.journalArticlePersistence.countByC_ST(companyId, status);
    }

    public JournalArticle getDisplayArticle(long groupId, String articleId) throws PortalException, SystemException {
        List articles = this.journalArticlePersistence.findByG_A_ST(groupId, articleId, 0);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No approved JournalArticle exists with the key {groupId=" + groupId + ", " + "articleId=" + articleId + "}");
        }
        Date now = new Date();
        int i2 = 0;
        while (i2 < articles.size()) {
            JournalArticle article = (JournalArticle)articles.get(i2);
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if ((displayDate == null || displayDate.before(now)) && (expirationDate == null || expirationDate.after(now))) {
                return article;
            }
            ++i2;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getDisplayArticleByUrlTitle(long groupId, String urlTitle) throws PortalException, SystemException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = this.journalArticlePersistence.findByG_UT_ST(groupId, urlTitle, 0, -1, -1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", urlTitle=" + urlTitle + "}");
        }
        Date now = new Date();
        for (JournalArticle article : articles) {
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if (displayDate == null || !displayDate.before(now) || expirationDate != null && !expirationDate.after(now)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey) throws PortalException, SystemException {
        return this.getLatestArticle(resourcePrimKey, -1);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status) throws PortalException, SystemException {
        return this.getLatestArticle(resourcePrimKey, status, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status, boolean preferApproved) throws PortalException, SystemException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, 0, 0, 1, (OrderByComparator)orderByComparator);
            }
            if (articles == null || articles.size() == 0) {
                articles = this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey, 0, 1, (OrderByComparator)orderByComparator);
            }
        } else {
            articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, status, 0, 1, (OrderByComparator)orderByComparator);
        }
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {resourcePrimKey=" + resourcePrimKey + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId) throws PortalException, SystemException {
        return this.getLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId, int status) throws PortalException, SystemException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = status == -1 ? this.journalArticlePersistence.findByG_A(groupId, articleId, 0, 1, (OrderByComparator)orderByComparator) : this.journalArticlePersistence.findByG_A_ST(groupId, articleId, status, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", articleId=" + articleId + ", status=" + status + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long groupId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, classNameId, classPK, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", className=" + className + ", classPK =" + classPK + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticleByUrlTitle(long groupId, String urlTitle, int status) throws PortalException, SystemException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = status == -1 ? this.journalArticlePersistence.findByG_UT(groupId, urlTitle, 0, 1, (OrderByComparator)orderByComparator) : this.journalArticlePersistence.findByG_UT_ST(groupId, urlTitle, status, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", urlTitle=" + urlTitle + ", status=" + status + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public double getLatestVersion(long groupId, String articleId) throws PortalException, SystemException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        return article.getVersion();
    }

    public double getLatestVersion(long groupId, String articleId, int status) throws PortalException, SystemException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, status);
        return article.getVersion();
    }

    public int getNotInTrashArticlesCount(long groupId, long folderId) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey) throws SystemException {
        return this.journalArticlePersistence.findByG_S(groupId, ddmStructureKey);
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticlePersistence.findByG_S(groupId, ddmStructureKey, start, end, obc);
    }

    public List<JournalArticle> getStructureArticles(String[] ddmStructureKeys) throws SystemException {
        return this.journalArticlePersistence.findByStructureId(ddmStructureKeys);
    }

    public int getStructureArticlesCount(long groupId, String ddmStructureKey) throws SystemException {
        return this.journalArticlePersistence.countByG_S(groupId, ddmStructureKey);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey) throws SystemException {
        return this.journalArticlePersistence.findByG_T(groupId, ddmTemplateKey);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticlePersistence.findByG_T(groupId, ddmTemplateKey, start, end, obc);
    }

    public int getTemplateArticlesCount(long groupId, String ddmTemplateKey) throws SystemException {
        return this.journalArticlePersistence.countByG_T(groupId, ddmTemplateKey);
    }

    public String getUniqueUrlTitle(long groupId, String articleId, String urlTitle) throws PortalException, SystemException {
        int i2 = 1;
        while (true) {
            JournalArticle article = null;
            try {
                article = this.getArticleByUrlTitle(groupId, urlTitle);
            }
            catch (NoSuchArticleException noSuchArticleException) {}
            if (article == null || articleId.equals(article.getArticleId())) break;
            String suffix = "-" + i2;
            String prefix = urlTitle;
            if (urlTitle.length() > suffix.length()) {
                prefix = urlTitle.substring(0, urlTitle.length() - suffix.length());
            }
            urlTitle = String.valueOf(prefix) + suffix;
            ++i2;
        }
        return urlTitle;
    }

    public boolean hasArticle(long groupId, String articleId) throws SystemException {
        try {
            this.getArticle(groupId, articleId);
            return true;
        }
        catch (PortalException portalException) {
            return false;
        }
    }

    public boolean isLatestVersion(long groupId, String articleId, double version) throws PortalException, SystemException {
        return this.getLatestVersion(groupId, articleId) == version;
    }

    public boolean isLatestVersion(long groupId, String articleId, double version, int status) throws PortalException, SystemException {
        return this.getLatestVersion(groupId, articleId, status) == version;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticle(long groupId, String articleId, long newFolderId) throws PortalException, SystemException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            article.setFolderId(newFolderId);
            article.setTreePath(article.buildTreePath());
            this.journalArticlePersistence.update((BaseModel)article);
        }
        return this.getArticle(groupId, articleId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleFromTrash(long userId, long groupId, JournalArticle article, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        TrashEntry trashEntry = article.getTrashEntry();
        if (trashEntry.isTrashEntry(JournalArticle.class, article.getResourcePrimKey())) {
            this.restoreArticleFromTrash(userId, article);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(trashEntry.getEntryId(), JournalArticle.class.getName(), article.getResourcePrimKey());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, article, status, null, new HashMap<String, Serializable>(), serviceContext);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
        }
        return this.moveArticle(groupId, article.getArticleId(), newFolderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleToTrash(long userId, JournalArticle article) throws PortalException, SystemException {
        int oldStatus = article.getStatus();
        if (oldStatus == 1) {
            article.setStatus(2);
            this.journalArticlePersistence.update((BaseModel)article);
        }
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        articleVersions = ListUtil.sort((List)articleVersions, (Comparator)new ArticleVersionComparator());
        List<Object> articleVersionStatusOVPs = new ArrayList();
        if (articleVersions != null && !articleVersions.isEmpty()) {
            articleVersionStatusOVPs = this.getArticleVersionStatuses(articleVersions);
        }
        article = this.updateStatus(userId, article.getId(), 8, new HashMap<String, Serializable>(), new ServiceContext());
        for (JournalArticle articleVersion : articleVersions) {
            articleVersion.setStatus(8);
            this.journalArticlePersistence.update((BaseModel)articleVersion);
        }
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", article.getArticleId());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), articleResource.getUuid(), null, oldStatus, articleVersionStatusOVPs, typeSettingsProperties);
        String trashArticleId = TrashUtil.getTrashTitle((long)trashEntry.getEntryId());
        if (!articleVersions.isEmpty()) {
            for (JournalArticle articleVersion : articleVersions) {
                articleVersion.setArticleId(trashArticleId);
                this.journalArticlePersistence.update((BaseModel)articleVersion);
            }
        }
        articleResource.setArticleId(trashArticleId);
        this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        article.setArticleId(trashArticleId);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", article.getTitle());
        this.socialActivityLocalService.addActivity(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), 10007, extraDataJSONObject.toString(), 0L);
        if (!articleVersions.isEmpty()) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            for (JournalArticle articleVersion : articleVersions) {
                indexer.reindex((Object)articleVersion);
            }
        }
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        return article;
    }

    public JournalArticle moveArticleToTrash(long userId, long groupId, String articleId) throws PortalException, SystemException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (!articles.isEmpty()) {
            return this.journalArticleLocalService.moveArticleToTrash(userId, (JournalArticle)articles.get(0));
        }
        return null;
    }

    public void rebuildTree(long companyId) throws PortalException, SystemException {
        List articles = this.journalArticlePersistence.findByC_NotST(companyId, 8);
        for (JournalArticle article : articles) {
            article.setTreePath(article.buildTreePath());
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle removeArticleLocale(long groupId, String articleId, double version, String languageId) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        String title = article.getTitle();
        title = LocalizationUtil.removeLocalization((String)title, (String)"static-content", (String)languageId, (boolean)true);
        article.setTitle(title);
        String description = article.getDescription();
        description = LocalizationUtil.removeLocalization((String)description, (String)"static-content", (String)languageId, (boolean)true);
        article.setDescription(description);
        String content = article.getContent();
        content = article.isTemplateDriven() ? JournalUtil.removeArticleLocale(content, languageId) : LocalizationUtil.removeLocalization((String)content, (String)"static-content", (String)languageId, (boolean)true);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle restoreArticleFromTrash(long userId, JournalArticle article) throws PortalException, SystemException {
        String trashArticleId = TrashUtil.getOriginalTitle((String)article.getArticleId());
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        if (!articleVersions.isEmpty()) {
            for (JournalArticle articleVersion : articleVersions) {
                articleVersion.setArticleId(trashArticleId);
                this.journalArticlePersistence.update((BaseModel)articleVersion);
            }
        }
        article.setArticleId(trashArticleId);
        this.journalArticlePersistence.update((BaseModel)article);
        JournalArticleResource articleResource = this.journalArticleResourcePersistence.fetchByPrimaryKey(article.getResourcePrimKey());
        articleResource.setArticleId(trashArticleId);
        this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(article.getGroupId());
        this.updateStatus(userId, article, trashEntry.getStatus(), null, new HashMap<String, Serializable>(), serviceContext);
        List trashVersions = this.trashVersionLocalService.getVersions(trashEntry.getEntryId());
        for (TrashVersion trashVersion : trashVersions) {
            JournalArticle trashArticleVersion = this.journalArticlePersistence.findByPrimaryKey(trashVersion.getClassPK());
            trashArticleVersion.setStatus(trashVersion.getStatus());
            this.journalArticlePersistence.update((BaseModel)trashArticleVersion);
        }
        this.trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", article.getTitle());
        this.socialActivityLocalService.addActivity(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), 10008, extraDataJSONObject.toString(), 0L);
        if (!articleVersions.isEmpty()) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            for (JournalArticle articleVersion : articleVersions) {
                indexer.reindex((Object)articleVersion);
            }
        }
        return article;
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String type, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticleFinder.findByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, type, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate, start, end, obc);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String type, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_T_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, type, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String type, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_T_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, type, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws SystemException {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        String status = String.valueOf(-1);
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, groupId, folderIds, classNameId, articleId, title, description, content, null, status, ddmStructureKey, ddmTemplateKey, params, andOperator, start, end, sort);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, String type, String status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws SystemException {
        try {
            String keywords;
            SearchContext searchContext = new SearchContext();
            searchContext.setAndSearch(andSearch);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("classNameId", classNameId);
            attributes.put("content", content);
            attributes.put("description", description);
            attributes.put("status", status);
            attributes.put("title", title);
            attributes.put("type", type);
            attributes.put("articleId", articleId);
            attributes.put("ddmStructureKey", ddmStructureKey);
            attributes.put("ddmTemplateKey", ddmTemplateKey);
            attributes.put("params", params);
            searchContext.setAttributes(attributes);
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setFolderIds(folderIds);
            searchContext.setGroupIds(new long[]{groupId});
            searchContext.setIncludeDiscussions(GetterUtil.getBoolean((Object)params.get("includeDiscussions")));
            if (params != null && Validator.isNotNull((String)(keywords = (String)params.remove("keywords")))) {
                searchContext.setKeywords(keywords);
            }
            QueryConfig queryConfig = new QueryConfig();
            queryConfig.setHighlightEnabled(false);
            queryConfig.setScoreEnabled(false);
            searchContext.setQueryConfig(queryConfig);
            if (sort != null) {
                searchContext.setSorts(new Sort[]{sort});
            }
            searchContext.setStart(start);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException, SystemException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)JournalArticle.class.getName());
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("userId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("modified", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return indexer.search(searchContext);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String type, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate) throws SystemException {
        return this.journalArticleFinder.countByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, type, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String type, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) throws SystemException {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_T_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, type, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String type, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) throws SystemException {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_T_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, type, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public void subscribe(long userId, long groupId) throws PortalException, SystemException {
        this.subscriptionLocalService.addSubscription(userId, groupId, JournalArticle.class.getName(), groupId);
    }

    public void unsubscribe(long userId, long groupId) throws PortalException, SystemException {
        this.subscriptionLocalService.deleteSubscription(userId, JournalArticle.class.getName(), groupId);
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String layoutUuid, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, titleMap, descriptionMap, content, article.getType(), article.getStructureId(), article.getTemplateId(), layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.getIndexable(), article.isSmallImage(), article.getSmallImageURL(), null, null, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String type, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle latestArticle;
        User user = this.userPersistence.findByPrimaryKey(userId);
        articleId = StringUtil.toUpperCase((String)articleId.trim());
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {}
        JournalArticle article = latestArticle = this.getLatestArticle(groupId, articleId, -1);
        boolean imported = ExportImportThreadLocal.isImportInProcess();
        double latestVersion = latestArticle.getVersion();
        boolean addNewVersion = false;
        if (imported) {
            if (latestVersion > version) {
                JournalArticle existingArticle = this.journalArticlePersistence.fetchByG_A_V(groupId, articleId, version);
                if (existingArticle != null) {
                    article = existingArticle;
                } else {
                    addNewVersion = true;
                }
            } else if (latestVersion < version) {
                addNewVersion = true;
            }
        } else {
            if (version > 0.0 && version != latestVersion) {
                throw new ArticleVersionException();
            }
            serviceContext.validateModifiedDate((AuditedModel)latestArticle, ArticleVersionException.class);
            if (latestArticle.isApproved() || latestArticle.isExpired() || latestArticle.isScheduled()) {
                addNewVersion = true;
                version = MathUtil.format((double)(latestVersion + 0.1), (int)1, (int)1);
            }
        }
        Date displayDate = null;
        Date expirationDate = null;
        Date reviewDate = null;
        if (article.getClassNameId() == 0L) {
            displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), ArticleDisplayDateException.class);
            if (!neverExpire) {
                expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), ArticleExpirationDateException.class);
            }
            if (!neverReview) {
                reviewDate = PortalUtil.getDate((int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (TimeZone)user.getTimeZone(), ArticleReviewDateException.class);
            }
        }
        Date now = new Date();
        boolean expired = false;
        if (expirationDate != null && expirationDate.before(now)) {
            expired = true;
        }
        this.validate(user.getCompanyId(), groupId, latestArticle.getClassNameId(), titleMap, content, type, ddmStructureKey, ddmTemplateKey, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        if (addNewVersion) {
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(latestArticle.getResourcePrimKey());
            article.setGroupId(latestArticle.getGroupId());
            article.setCompanyId(latestArticle.getCompanyId());
            article.setUserId(user.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(serviceContext.getModifiedDate(now));
            article.setClassNameId(latestArticle.getClassNameId());
            article.setClassPK(latestArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(version);
            article.setSmallImageId(latestArticle.getSmallImageId());
        }
        Locale locale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = ParamUtil.getString((ServiceContext)serviceContext, (String)"defaultLanguageId");
        if (Validator.isNull((String)defaultLanguageId)) {
            defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)content);
        }
        if (Validator.isNotNull((String)defaultLanguageId)) {
            locale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        String title = titleMap.get(locale);
        content = this.format(user, groupId, articleId, article.getVersion(), addNewVersion, content, ddmStructureKey, images);
        article.setModifiedDate(serviceContext.getModifiedDate(now));
        article.setFolderId(folderId);
        article.setTreePath(article.buildTreePath());
        article.setTitleMap(titleMap, locale);
        article.setUrlTitle(this.getUniqueUrlTitle(article.getId(), article.getArticleId(), title, latestArticle.getUrlTitle(), serviceContext));
        article.setDescriptionMap(descriptionMap, locale);
        article.setContent(content);
        article.setType(type);
        article.setStructureId(ddmStructureKey);
        article.setTemplateId(ddmTemplateKey);
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
        } else {
            article.setSmallImageId(0L);
        }
        article.setSmallImageURL(smallImageURL);
        if (latestArticle.isPending()) {
            article.setStatus(latestArticle.getStatus());
        } else if (!expired) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        article.setExpandoBridgeAttributes(serviceContext);
        this.journalArticlePersistence.update((BaseModel)article);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (PortalUtil.getClassNameId(DDMStructure.class) == article.getClassNameId()) {
            this.updateDDMStructureXSD(article.getClassPK(), content, serviceContext);
        }
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (expired && imported) {
            this.updateStatus(userId, article, article.getStatus(), articleURL, new HashMap<String, Serializable>(), serviceContext);
        }
        if (serviceContext.getWorkflowAction() == 1) {
            this.sendEmail(article, articleURL, preferences, "requested", serviceContext);
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)JournalArticle.class.getName(), (long)article.getId(), (Object)article, (ServiceContext)serviceContext);
        }
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, String content, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, article.getTitleMap(), article.getDescriptionMap(), content, article.getLayoutUuid(), serviceContext);
    }

    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images) throws PortalException, SystemException {
        return this.journalArticleLocalService.updateArticleTranslation(groupId, articleId, version, locale, title, description, content, images, null);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images, ServiceContext serviceContext) throws PortalException, SystemException {
        this.validateContent(content);
        JournalArticle oldArticle = this.getLatestArticle(groupId, articleId, -1);
        double oldVersion = oldArticle.getVersion();
        if (version > 0.0 && version != oldVersion) {
            throw new ArticleVersionException();
        }
        boolean incrementVersion = false;
        if (oldArticle.isApproved() || oldArticle.isExpired()) {
            incrementVersion = true;
        }
        if (serviceContext != null) {
            serviceContext.validateModifiedDate((AuditedModel)oldArticle, ArticleVersionException.class);
        }
        JournalArticle article = null;
        User user = this.userPersistence.findByPrimaryKey(oldArticle.getUserId());
        if (incrementVersion) {
            double newVersion = MathUtil.format((double)(oldVersion + 0.1), (int)1, (int)1);
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(oldArticle.getResourcePrimKey());
            article.setGroupId(oldArticle.getGroupId());
            article.setCompanyId(oldArticle.getCompanyId());
            article.setUserId(oldArticle.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(new Date());
            article.setModifiedDate(new Date());
            article.setClassNameId(oldArticle.getClassNameId());
            article.setClassPK(oldArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(newVersion);
            article.setTitleMap(oldArticle.getTitleMap());
            article.setUrlTitle(this.getUniqueUrlTitle(id, articleId, title, oldArticle.getUrlTitle(), serviceContext));
            article.setDescriptionMap(oldArticle.getDescriptionMap());
            article.setType(oldArticle.getType());
            article.setStructureId(oldArticle.getStructureId());
            article.setTemplateId(oldArticle.getTemplateId());
            article.setLayoutUuid(oldArticle.getLayoutUuid());
            article.setDisplayDate(oldArticle.getDisplayDate());
            article.setExpirationDate(oldArticle.getExpirationDate());
            article.setReviewDate(oldArticle.getReviewDate());
            article.setIndexable(oldArticle.getIndexable());
            article.setSmallImage(oldArticle.getSmallImage());
            article.setSmallImageId(oldArticle.getSmallImageId());
            if (article.getSmallImageId() == 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
            article.setSmallImageURL(oldArticle.getSmallImageURL());
            article.setStatus(2);
            article.setStatusDate(new Date());
        } else {
            article = oldArticle;
        }
        Map titleMap = article.getTitleMap();
        titleMap.put(locale, title);
        article.setTitleMap(titleMap);
        Map descriptionMap = article.getDescriptionMap();
        descriptionMap.put(locale, description);
        article.setDescriptionMap(descriptionMap);
        content = this.format(user, groupId, articleId, article.getVersion(), !oldArticle.isDraft(), content, oldArticle.getStructureId(), images);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    public void updateAsset(long userId, JournalArticle article, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        int approvedArticlesCount;
        boolean visible = article.isApproved();
        if (article.getClassNameId() != 0L) {
            visible = false;
        }
        boolean addDraftAssetEntry = false;
        if (!article.isApproved() && article.getVersion() != 1.0 && (approvedArticlesCount = this.journalArticlePersistence.countByG_A_ST(article.getGroupId(), article.getArticleId(), JournalArticleConstants.ASSET_ENTRY_CREATION_STATUSES)) > 0) {
            addDraftAssetEntry = true;
        }
        AssetEntry assetEntry = null;
        if (addDraftAssetEntry) {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getPrimaryKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, false, null, null, null, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, null, false);
        } else {
            JournalArticleResource journalArticleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), journalArticleResource.getResourcePrimKey(), journalArticleResource.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, visible, null, null, null, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, null, false);
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateContent(long groupId, String articleId, double version, String content) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateStatus(long userId, JournalArticle article, int status, String articleURL, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException, SystemException {
        Date expirationDate;
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        if (status == 0 && article.getClassNameId() == 0L && article.getDisplayDate() != null && now.before(article.getDisplayDate())) {
            status = 7;
        }
        int oldStatus = article.getStatus();
        article.setModifiedDate(serviceContext.getModifiedDate(now));
        boolean neverExpire = false;
        if (status == 0 && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(now)) {
            neverExpire = true;
            article.setExpirationDate(null);
        }
        if (status == 3) {
            article.setExpirationDate(now);
        }
        article.setStatus(status);
        article.setStatusByUserId(user.getUserId());
        article.setStatusByUserName(user.getFullName());
        article.setStatusDate(serviceContext.getModifiedDate(now));
        this.journalArticlePersistence.update((BaseModel)article);
        if (this.hasModifiedLatestApprovedVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            if (status == 0) {
                AssetEntry draftAssetEntry;
                this.updateUrlTitles(article.getGroupId(), article.getArticleId(), article.getUrlTitle());
                if (oldStatus != 0 && article.getVersion() != 1.0 && (draftAssetEntry = this.assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getPrimaryKey())) != null) {
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0);
                    long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
                    AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getResourcePrimKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, false, null, null, null, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, null, false);
                    this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                    SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
                    try {
                        this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getPrimaryKey());
                    }
                    finally {
                        SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
                    }
                }
                if (article.getClassNameId() == 0L) {
                    Date[] dateInterval = this.getDateInterval(article.getGroupId(), article.getArticleId(), article.getDisplayDate(), article.getExpirationDate());
                    Date displayDate = dateInterval[0];
                    Date expirationDate2 = dateInterval[1];
                    if (neverExpire) {
                        expirationDate2 = null;
                    }
                    this.assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), displayDate, expirationDate2, true);
                }
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("title", article.getTitle());
                if (serviceContext.isCommandUpdate()) {
                    this.socialActivityLocalService.addActivity(user.getUserId(), article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), 2, extraDataJSONObject.toString(), 0L);
                } else {
                    this.socialActivityLocalService.addUniqueActivity(user.getUserId(), article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), 1, extraDataJSONObject.toString(), 0L);
                }
            } else if (oldStatus == 0) {
                this.updatePreviousApprovedArticle(article);
            }
        }
        if (article.getClassNameId() == 0L && oldStatus != 8 && status != 8) {
            if (oldStatus == 1 && (status == 0 || status == 4)) {
                String msg = "granted";
                if (status == 4) {
                    msg = "denied";
                }
                try {
                    PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
                    this.sendEmail(article, articleURL, preferences, msg, serviceContext);
                }
                catch (Exception e2) {
                    _log.error((Object)("Unable to send email to notify the change of status  to " + msg + " for article " + article.getId() + ": " + e2.getMessage()));
                }
            }
            this.notifySubscribers(article, serviceContext);
        }
        return article;
    }

    public JournalArticle updateStatus(long userId, long classPK, int status, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = this.getArticle(classPK);
        return this.journalArticleLocalService.updateStatus(userId, article, status, null, workflowContext, serviceContext);
    }

    public JournalArticle updateStatus(long userId, long groupId, String articleId, double version, int status, String articleURL, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateStatus(userId, article, status, articleURL, workflowContext, serviceContext);
    }

    public void updateTemplateId(long groupId, long classNameId, String oldDDMTemplateKey, String newDDMTemplateKey) throws SystemException {
        List articles = this.journalArticlePersistence.findByG_C_T(groupId, classNameId, oldDDMTemplateKey);
        for (JournalArticle article : articles) {
            article.setTemplateId(newDDMTemplateKey);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    protected void checkArticlesByDisplayDate(Date displayDate) throws PortalException, SystemException {
        List articles = this.journalArticlePersistence.findByLtD_S(displayDate, 7);
        for (JournalArticle article : articles) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            indexer.reindex((Object)article);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            String layoutFullURL = PortalUtil.getLayoutFullURL((long)article.getGroupId(), (String)"15");
            serviceContext.setLayoutFullURL(layoutFullURL);
            serviceContext.setScopeGroupId(article.getGroupId());
            this.updateStatus(article.getUserId(), article, 0, null, new HashMap<String, Serializable>(), serviceContext);
        }
    }

    protected void checkArticlesByExpirationDate(Date expirationDate) throws PortalException, SystemException {
        List articles = this.journalArticleFinder.findByExpirationDate(0L, new Date(expirationDate.getTime() + _JOURNAL_ARTICLE_CHECK_INTERVAL), new QueryDefinition(0));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + articles.size() + " articles"));
        }
        HashSet<Long> companyIds = new HashSet<Long>();
        for (JournalArticle article : articles) {
            if (PropsValues.JOURNAL_ARTICLE_EXPIRE_ALL_VERSIONS) {
                List currentArticles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId(), -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
                for (JournalArticle currentArticle : currentArticles) {
                    currentArticle.setExpirationDate(article.getExpirationDate());
                    currentArticle.setStatus(3);
                    this.journalArticlePersistence.update((BaseModel)currentArticle);
                }
            } else {
                article.setStatus(3);
                this.journalArticlePersistence.update((BaseModel)article);
            }
            this.updatePreviousApprovedArticle(article);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            indexer.reindex((Object)article);
            JournalContentUtil.clearCache((long)article.getGroupId(), (String)article.getArticleId(), (String)article.getTemplateId());
            companyIds.add(article.getCompanyId());
        }
        Iterator iterator = companyIds.iterator();
        while (iterator.hasNext()) {
            long companyId = (Long)iterator.next();
            CacheUtil.clearCache(companyId);
        }
        if (this._previousCheckDate == null) {
            this._previousCheckDate = new Date(expirationDate.getTime() - _JOURNAL_ARTICLE_CHECK_INTERVAL);
        }
    }

    protected void checkArticlesByReviewDate(Date reviewDate) throws PortalException, SystemException {
        List articles = this.journalArticleFinder.findByReviewDate(0L, reviewDate, this._previousCheckDate);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending review notifications for " + articles.size() + " articles"));
        }
        for (JournalArticle article : articles) {
            String articleURL = "";
            long ownerId = article.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "15";
            PortletPreferences preferences = this.portletPreferencesLocalService.getPreferences(article.getCompanyId(), ownerId, ownerType, plid, portletId);
            this.sendEmail(article, articleURL, preferences, "review", new ServiceContext());
        }
    }

    protected void checkStructure(Document contentDoc, Element root) throws PortalException {
        for (Element el : root.elements()) {
            this.checkStructureField(el, contentDoc);
            this.checkStructure(contentDoc, el);
        }
    }

    protected void checkStructure(JournalArticle article) throws PortalException, SystemException {
        block5: {
            Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
            DDMStructure structure = null;
            try {
                structure = this.ddmStructurePersistence.findByG_C_S(PortalUtil.getSiteGroupId((long)article.getGroupId()), PortalUtil.getClassNameId(JournalArticle.class), article.getStructureId());
            }
            catch (NoSuchStructureException noSuchStructureException) {
                structure = this.ddmStructurePersistence.findByG_C_S(companyGroup.getGroupId(), PortalUtil.getClassNameId(JournalArticle.class), article.getStructureId());
            }
            String content = GetterUtil.getString((String)article.getContent());
            try {
                Document contentDocument = SAXReaderUtil.read((String)content);
                Document xsdDocument = SAXReaderUtil.read((String)structure.getXsd());
                this.checkStructure(contentDocument, xsdDocument.getRootElement());
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
            catch (StructureXsdException sxsde) {
                long groupId = article.getGroupId();
                String articleId = article.getArticleId();
                double version = article.getVersion();
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)("Article {groupId=" + groupId + ", articleId=" + articleId + ", version=" + version + "} has content that does not match its " + "structure: " + sxsde.getMessage()));
            }
        }
    }

    protected void checkStructureField(Element el, Document contentDoc) throws PortalException {
        StringBuilder elPath = new StringBuilder();
        elPath.append(el.attributeValue("name"));
        for (Element elParent = el.getParent(); elParent != null && !elParent.getName().equals("root"); elParent = elParent.getParent()) {
            elPath.insert(0, String.valueOf(elParent.attributeValue("name")) + ",");
        }
        String[] elPathNames = StringUtil.split((String)elPath.toString());
        Element contentEl = contentDoc.getRootElement();
        String[] stringArray = elPathNames;
        int n = elPathNames.length;
        int n2 = 0;
        while (n2 < n) {
            String _elPathName = stringArray[n2];
            boolean foundEl = false;
            for (Element tempEl : contentEl.elements()) {
                if (!_elPathName.equals(tempEl.attributeValue("name", ""))) continue;
                contentEl = tempEl;
                foundEl = true;
                break;
            }
            if (!foundEl) {
                String elType = contentEl.attributeValue("type", "");
                if (elType.equals("list") || elType.equals("multi-list")) break;
                throw new StructureXsdException(elPath.toString());
            }
            ++n2;
        }
    }

    protected void copyArticleImages(JournalArticle oldArticle, JournalArticle newArticle) throws Exception {
        Document contentDoc = SAXReaderUtil.read((String)oldArticle.getContent());
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPathSelector.selectNodes((Object)contentDoc);
        for (Node imageNode : imageNodes) {
            Element imageEl = (Element)imageNode;
            String instanceId = imageEl.attributeValue("instance-id");
            String name = imageEl.attributeValue("name");
            List dynamicContentEls = imageEl.elements("dynamic-content");
            for (Element dynamicContentEl : dynamicContentEls) {
                long imageId = GetterUtil.getLong((String)dynamicContentEl.attributeValue("id"));
                String languageId = dynamicContentEl.attributeValue("language-id");
                Image oldImage = null;
                try {
                    oldImage = this.imageLocalService.getImage(imageId);
                }
                catch (NoSuchImageException noSuchImageException) {
                    continue;
                }
                imageId = this.journalArticleImageLocalService.getArticleImageId(newArticle.getGroupId(), newArticle.getArticleId(), newArticle.getVersion(), instanceId, name, languageId);
                this.imageLocalService.updateImage(imageId, oldImage.getTextObj());
                String elContent = "/image/journal/article?img_id=" + imageId + "&t=" + WebServerServletTokenUtil.getToken((long)imageId);
                dynamicContentEl.setText(elContent);
                dynamicContentEl.addAttribute("id", String.valueOf(imageId));
            }
        }
        newArticle.setContent(contentDoc.formattedString());
    }

    protected void format(User user, long groupId, String articleId, double version, boolean incrementVersion, Element root, Map<String, byte[]> images) throws PortalException, SystemException {
        for (Element element : root.elements()) {
            String elInstanceId = element.attributeValue("instance-id", "");
            String elType = element.attributeValue("type", "");
            if (elType.equals("image")) {
                String elName = element.attributeValue("name", "");
                String elIndex = element.attributeValue("index", "");
                String name = String.valueOf(elName) + "_" + elIndex;
                this.formatImage(groupId, articleId, version, incrementVersion, element, elInstanceId, name, images);
            } else if (elType.equals("text_area") || elType.equals("text") || elType.equals("text_box")) {
                List dynamicContentElements = element.elements("dynamic-content");
                for (Element dynamicContentElement : dynamicContentElements) {
                    String dynamicContent = dynamicContentElement.getText();
                    if (!Validator.isNotNull((String)dynamicContent)) continue;
                    String contentType = "text/plain";
                    if (elType.equals("text_area")) {
                        contentType = "text/html";
                    }
                    dynamicContent = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)user.getUserId(), (String)JournalArticle.class.getName(), (long)0L, (String)contentType, (String)dynamicContent);
                    dynamicContentElement.clearContent();
                    dynamicContentElement.addCDATA(dynamicContent);
                }
            }
            this.format(user, groupId, articleId, version, incrementVersion, element, images);
        }
    }

    protected String format(User user, long groupId, String articleId, double version, boolean incrementVersion, String content, String ddmStructureKey, Map<String, byte[]> images) throws PortalException, SystemException {
        Document document = null;
        try {
            document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            if (Validator.isNotNull((String)ddmStructureKey)) {
                this.format(user, groupId, articleId, version, incrementVersion, rootElement, images);
            } else {
                List staticContentElements = rootElement.elements("static-content");
                for (Element staticContentElement : staticContentElements) {
                    String staticContent = staticContentElement.getText();
                    staticContent = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)user.getUserId(), (String)JournalArticle.class.getName(), (long)0L, (String)"text/html", (String)staticContent);
                    staticContentElement.clearContent();
                    staticContentElement.addCDATA(staticContent);
                }
            }
            content = DDMXMLUtil.formatXML((Document)document);
        }
        catch (DocumentException de) {
            _log.error((Object)de, (Throwable)de);
        }
        content = HtmlUtil.replaceMsWordCharacters((String)content);
        return content;
    }

    protected void formatImage(long groupId, String articleId, double version, boolean incrementVersion, Element el, String elInstanceId, String elName, Map<String, byte[]> images) throws PortalException, SystemException {
        List imageContents = el.elements("dynamic-content");
        for (Element dynamicContent : imageContents) {
            long defaultImageId;
            Image defaultImage;
            String elLanguage = dynamicContent.attributeValue("language-id", "");
            if (!elLanguage.equals("")) {
                elLanguage = "_" + elLanguage;
            }
            long imageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, elLanguage);
            if (dynamicContent.getText().equals("delete") || Validator.isNull((String)dynamicContent.getText())) {
                dynamicContent.setText("");
                this.imageLocalService.deleteImage(imageId);
                String defaultElLanguage = "";
                if (Validator.isNull((String)elLanguage)) {
                    defaultElLanguage = "_" + LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
                }
                long defaultImageId2 = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, defaultElLanguage);
                this.imageLocalService.deleteImage(defaultImageId2);
                continue;
            }
            String elContent = "/image/journal/article?img_id=" + imageId + "&t=" + WebServerServletTokenUtil.getToken((long)imageId);
            byte[] bytes = images.get(String.valueOf(elInstanceId) + "_" + elName + elLanguage);
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(imageId));
                this.imageLocalService.updateImage(imageId, bytes);
                continue;
            }
            if (version > 1.0 && incrementVersion) {
                double oldVersion = MathUtil.format((double)(version - 0.1), (int)1, (int)1);
                long oldImageId = 0L;
                if (oldVersion >= 1.0 && incrementVersion) {
                    oldImageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, oldVersion, elInstanceId, elName, elLanguage);
                }
                Image oldImage = null;
                if (oldImageId > 0L) {
                    oldImage = this.imageLocalService.getImage(oldImageId);
                }
                if (oldImage != null) {
                    dynamicContent.setText(elContent);
                    dynamicContent.addAttribute("id", String.valueOf(imageId));
                    bytes = oldImage.getTextObj();
                    this.imageLocalService.updateImage(imageId, bytes);
                    continue;
                }
                if (!dynamicContent.getText().equals("update")) continue;
                dynamicContent.setText("");
                continue;
            }
            Image image = this.imageLocalService.getImage(imageId);
            if (image != null) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(imageId));
                continue;
            }
            if (dynamicContent.getText().equals("update")) {
                dynamicContent.setText("");
                continue;
            }
            long contentImageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)dynamicContent.getText(), (String)"img_id"));
            if (contentImageId <= 0L) {
                contentImageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)dynamicContent.getText(), (String)"img_id", (boolean)false));
            }
            if (contentImageId > 0L && (image = this.imageLocalService.getImage(contentImageId)) != null) {
                dynamicContent.addAttribute("id", String.valueOf(contentImageId));
                continue;
            }
            String defaultElLanguage = "";
            if (Validator.isNull((String)elLanguage)) {
                defaultElLanguage = "_" + LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            }
            if ((defaultImage = this.imageLocalService.getImage(defaultImageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, defaultElLanguage))) != null) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(defaultImageId));
                bytes = defaultImage.getTextObj();
                this.imageLocalService.updateImage(defaultImageId, bytes);
                continue;
            }
            if (!Validator.isNotNull((String)elLanguage)) continue;
            dynamicContent.setText("");
        }
    }

    protected List<ObjectValuePair<Long, Integer>> getArticleVersionStatuses(List<JournalArticle> articles) {
        ArrayList<ObjectValuePair<Long, Integer>> dlArticleVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(articles.size());
        for (JournalArticle article : articles) {
            int status = article.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair dlFileVersionStatusOVP = new ObjectValuePair((Object)article.getId(), (Object)status);
            dlArticleVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)dlFileVersionStatusOVP);
        }
        return dlArticleVersionStatusOVPs;
    }

    protected long getClassTypeId(JournalArticle article) {
        long classTypeId = 0L;
        try {
            long classNameId = PortalUtil.getClassNameId(JournalArticle.class);
            DDMStructure ddmStructure = this.ddmStructurePersistence.fetchByG_C_S(article.getGroupId(), classNameId, article.getStructureId());
            if (ddmStructure == null) {
                Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
                ddmStructure = this.ddmStructurePersistence.fetchByG_C_S(companyGroup.getGroupId(), classNameId, article.getStructureId());
            }
            if (ddmStructure != null) {
                classTypeId = ddmStructure.getStructureId();
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return classTypeId;
    }

    protected Date[] getDateInterval(long groupId, String articleId, Date earliestDisplayDate, Date latestExpirationDate) throws SystemException {
        Date[] dateInterval = new Date[2];
        List articles = this.journalArticlePersistence.findByG_A_ST(groupId, articleId, 0);
        boolean expiringArticle = true;
        if (latestExpirationDate == null) {
            expiringArticle = false;
        }
        for (JournalArticle article : articles) {
            if (earliestDisplayDate == null || article.getDisplayDate() != null && earliestDisplayDate.after(article.getDisplayDate())) {
                earliestDisplayDate = article.getDisplayDate();
            }
            if (expiringArticle && (latestExpirationDate == null || article.getExpirationDate() != null && latestExpirationDate.before(article.getExpirationDate()))) {
                latestExpirationDate = article.getExpirationDate();
            }
            if (!expiringArticle || article.getExpirationDate() != null || latestExpirationDate == null) continue;
            expiringArticle = false;
        }
        dateInterval[0] = earliestDisplayDate;
        dateInterval[1] = latestExpirationDate;
        return dateInterval;
    }

    protected String getUniqueUrlTitle(long id, long groupId, String articleId, String title) throws PortalException, SystemException {
        String urlTitle = JournalUtil.getUrlTitle(id, title);
        return this.getUniqueUrlTitle(groupId, articleId, urlTitle);
    }

    protected String getUniqueUrlTitle(long id, String articleId, String title, String oldUrlTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        String serviceContextUrlTitle = ParamUtil.getString((ServiceContext)serviceContext, (String)"urlTitle");
        String urlTitle = null;
        if (Validator.isNotNull((String)serviceContextUrlTitle)) {
            urlTitle = JournalUtil.getUrlTitle(id, serviceContextUrlTitle);
        } else {
            if (Validator.isNotNull((String)oldUrlTitle)) {
                return oldUrlTitle;
            }
            urlTitle = this.getUniqueUrlTitle(id, serviceContext.getScopeGroupId(), articleId, title);
        }
        JournalArticle urlTitleArticle = null;
        try {
            urlTitleArticle = this.getArticleByUrlTitle(serviceContext.getScopeGroupId(), urlTitle);
        }
        catch (NoSuchArticleException noSuchArticleException) {}
        if (urlTitleArticle != null && !Validator.equals((Object)urlTitleArticle.getArticleId(), (Object)articleId)) {
            urlTitle = this.getUniqueUrlTitle(id, serviceContext.getScopeGroupId(), articleId, urlTitle);
        }
        return urlTitle;
    }

    protected boolean hasModifiedLatestApprovedVersion(long groupId, String articleId, double version) throws PortalException, SystemException {
        try {
            double latestApprovedVersion = this.getLatestVersion(groupId, articleId, 0);
            return version >= latestApprovedVersion;
        }
        catch (NoSuchArticleException noSuchArticleException) {
            return true;
        }
    }

    protected void notifySubscribers(JournalArticle article, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!article.isApproved()) {
            return;
        }
        String articleURL = PortalUtil.getControlPanelFullURL((long)serviceContext.getScopeGroupId(), (String)"15", null);
        if (Validator.isNull((String)articleURL)) {
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = article.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "15";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(article.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(article.getVersion() == 1.0 && JournalUtil.getEmailArticleAddedEnabled(preferences) || article.getVersion() != 1.0 && JournalUtil.getEmailArticleUpdatedEnabled(preferences))) {
            return;
        }
        String fromName = JournalUtil.getEmailFromName(preferences, article.getCompanyId());
        String fromAddress = JournalUtil.getEmailFromAddress(preferences, article.getCompanyId());
        String subject = null;
        String body = null;
        if (article.getVersion() == 1.0) {
            subject = JournalUtil.getEmailArticleAddedSubject(preferences);
            body = JournalUtil.getEmailArticleAddedBody(preferences);
        } else {
            subject = JournalUtil.getEmailArticleUpdatedSubject(preferences);
            body = JournalUtil.getEmailArticleUpdatedBody(preferences);
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(article.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", article.getTitle(serviceContext.getLanguageId()), "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_VERSION$]", article.getVersion()});
        subscriptionSender.setContextUserPrefix("ARTICLE");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        subscriptionSender.setPortletId("15");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(article.getUserId());
        subscriptionSender.addPersistedSubscribers(JournalArticle.class.getName(), article.getResourcePrimKey());
        JournalFolder folder = article.getFolder();
        ArrayList<Long> folderIds = new ArrayList<Long>();
        if (folder != null) {
            folderIds.add(folder.getFolderId());
            folderIds.addAll(folder.getAncestorFolderIds());
        }
        Iterator iterator = folderIds.iterator();
        while (iterator.hasNext()) {
            long curFolderId = (Long)iterator.next();
            subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), curFolderId);
        }
        subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), article.getGroupId());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected void sendEmail(JournalArticle article, String articleURL, PortletPreferences preferences, String emailType, ServiceContext serviceContext) throws PortalException, SystemException {
        if (preferences == null) {
            return;
        }
        if (!(emailType.equals("denied") && JournalUtil.getEmailArticleApprovalDeniedEnabled(preferences) || emailType.equals("granted") && JournalUtil.getEmailArticleApprovalGrantedEnabled(preferences) || emailType.equals("requested") && JournalUtil.getEmailArticleApprovalRequestedEnabled(preferences) || emailType.equals("review") && JournalUtil.getEmailArticleReviewEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(article.getCompanyId());
        User user = this.userPersistence.findByPrimaryKey(article.getUserId());
        articleURL = String.valueOf(articleURL) + "&groupId=" + article.getGroupId() + "&articleId=" + article.getArticleId() + "&version=" + article.getVersion();
        String fromName = JournalUtil.getEmailFromName(preferences, article.getCompanyId());
        String fromAddress = JournalUtil.getEmailFromAddress(preferences, article.getCompanyId());
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        if (emailType.equals("requested") || emailType.equals("review")) {
            String tempToName = fromName;
            String tempToAddress = fromAddress;
            fromName = toName;
            fromAddress = toAddress;
            toName = tempToName;
            toAddress = tempToAddress;
        }
        String subject = null;
        String body = null;
        if (emailType.equals("denied")) {
            subject = JournalUtil.getEmailArticleApprovalDeniedSubject(preferences);
            body = JournalUtil.getEmailArticleApprovalDeniedBody(preferences);
        } else if (emailType.equals("granted")) {
            subject = JournalUtil.getEmailArticleApprovalGrantedSubject(preferences);
            body = JournalUtil.getEmailArticleApprovalGrantedBody(preferences);
        } else if (emailType.equals("requested")) {
            subject = JournalUtil.getEmailArticleApprovalRequestedSubject(preferences);
            body = JournalUtil.getEmailArticleApprovalRequestedBody(preferences);
        } else if (emailType.equals("review")) {
            subject = JournalUtil.getEmailArticleReviewSubject(preferences);
            body = JournalUtil.getEmailArticleReviewBody(preferences);
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(company.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", article.getTitle(serviceContext.getLanguageId()), "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_USER_NAME$]", article.getUserName(), "[$ARTICLE_VERSION$]", article.getVersion()});
        subscriptionSender.setContextUserPrefix("ARTICLE");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        subscriptionSender.setPortletId("15");
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(article.getUserId());
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void updateDDMStructureXSD(long ddmStructureId, String content, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            Document document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            List elements = rootElement.elements();
            for (Element element : elements) {
                String fieldName = element.attributeValue("name", "");
                List dynamicContentElements = element.elements("dynamic-content");
                for (Element dynamicContentElement : dynamicContentElements) {
                    String value = dynamicContentElement.getText();
                    this.ddmStructureLocalService.updateXSDFieldMetadata(ddmStructureId, fieldName, "predefinedValue", value, serviceContext);
                }
            }
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
    }

    protected void updatePreviousApprovedArticle(JournalArticle article) throws PortalException, SystemException {
        List approvedArticles = this.journalArticlePersistence.findByG_A_ST(article.getGroupId(), article.getArticleId(), 0, 0, 2);
        if (approvedArticles.isEmpty() || approvedArticles.size() == 1 && article.getStatus() == 0) {
            this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        } else {
            JournalArticle previousApprovedArticle = (JournalArticle)approvedArticles.get(0);
            if (article.getStatus() == 0) {
                previousApprovedArticle = (JournalArticle)approvedArticles.get(1);
            }
            Date[] dateInterval = this.getDateInterval(previousApprovedArticle.getGroupId(), previousApprovedArticle.getArticleId(), previousApprovedArticle.getDisplayDate(), previousApprovedArticle.getExpirationDate());
            Date displayDate = dateInterval[0];
            Date expirationDate = dateInterval[1];
            AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), displayDate, expirationDate, true);
            assetEntry.setModifiedDate(previousApprovedArticle.getModifiedDate());
            assetEntry.setTitle(previousApprovedArticle.getTitle());
            this.assetEntryPersistence.update((BaseModel)assetEntry);
        }
    }

    protected void updateUrlTitles(long groupId, String articleId, String urlTitle) throws SystemException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            if (article.getUrlTitle().equals(urlTitle)) continue;
            article.setUrlTitle(urlTitle);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, Map<Locale, String> titleMap, String content, String type, String ddmStructureKey, String ddmTemplateKey, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        long smallImageMaxSize;
        Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)content));
        Object[] availableLocales = LanguageUtil.getAvailableLocales((long)groupId);
        if (!ArrayUtil.contains((Object[])availableLocales, (Object)articleDefaultLocale)) {
            LocaleException le = new LocaleException(3, "The locale " + articleDefaultLocale + " is not available in site with groupId" + groupId);
            Locale[] sourceAvailableLocales = new Locale[]{articleDefaultLocale};
            le.setSourceAvailableLocales(sourceAvailableLocales);
            le.setTargetAvailableLocales((Locale[])availableLocales);
            throw le;
        }
        if (classNameId == 0L && (titleMap.isEmpty() || Validator.isNull((String)titleMap.get(articleDefaultLocale)))) {
            throw new ArticleTitleException();
        }
        if (Validator.isNull((String)type)) {
            throw new ArticleTypeException();
        }
        this.validateContent(content);
        if (Validator.isNotNull((String)ddmStructureKey)) {
            Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
            DDMStructure ddmStructure = null;
            try {
                ddmStructure = this.ddmStructurePersistence.findByG_C_S(PortalUtil.getSiteGroupId((long)groupId), PortalUtil.getClassNameId(JournalArticle.class), ddmStructureKey);
            }
            catch (NoSuchStructureException noSuchStructureException) {
                ddmStructure = this.ddmStructurePersistence.findByG_C_S(companyGroup.getGroupId(), PortalUtil.getClassNameId(JournalArticle.class), ddmStructureKey);
            }
            DDMTemplate ddmTemplate = null;
            if (Validator.isNotNull((String)ddmTemplateKey)) {
                try {
                    ddmTemplate = this.ddmTemplatePersistence.findByG_C_T(PortalUtil.getSiteGroupId((long)groupId), PortalUtil.getClassNameId(DDMStructure.class), ddmTemplateKey);
                }
                catch (NoSuchTemplateException noSuchTemplateException) {
                    ddmTemplate = this.ddmTemplatePersistence.findByG_C_T(companyGroup.getGroupId(), PortalUtil.getClassNameId(DDMStructure.class), ddmTemplateKey);
                }
                if (ddmTemplate.getClassPK() != ddmStructure.getStructureId()) {
                    throw new NoSuchTemplateException();
                }
            } else if (classNameId == 0L) {
                throw new NoSuchTemplateException();
            }
        }
        if (expirationDate != null && expirationDate.before(new Date()) && !ExportImportThreadLocal.isImportInProcess()) {
            throw new ArticleExpirationDateException();
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray("journal.image.extensions", ",");
        if (!smallImage || Validator.isNotNull((String)smallImageURL) || smallImageFile == null || smallImageBytes == null) {
            return;
        }
        String smallImageName = smallImageFile.getName();
        if (smallImageName != null) {
            boolean validSmallImageExtension = false;
            String[] stringArray = imageExtensions;
            int n = imageExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String _imageExtension = stringArray[n2];
                if ("*".equals(_imageExtension) || StringUtil.endsWith((String)smallImageName, (String)_imageExtension)) {
                    validSmallImageExtension = true;
                    break;
                }
                ++n2;
            }
            if (!validSmallImageExtension) {
                throw new ArticleSmallImageNameException(smallImageName);
            }
        }
        if ((smallImageMaxSize = PrefsPropsUtil.getLong("journal.image.small.max.size")) > 0L && (smallImageBytes == null || (long)smallImageBytes.length > smallImageMaxSize)) {
            throw new ArticleSmallImageSizeException();
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, String content, String type, String ddmStructureKey, String ddmTemplateKey, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        JournalArticle article;
        if (!autoArticleId) {
            this.validate(articleId);
        }
        if ((article = this.journalArticlePersistence.fetchByG_A_V(groupId, articleId, version)) != null) {
            throw new DuplicateArticleIdException();
        }
        this.validate(companyId, groupId, classNameId, titleMap, content, type, ddmStructureKey, ddmTemplateKey, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes);
    }

    protected void validate(String articleId) throws PortalException {
        if (Validator.isNull((String)articleId) || articleId.indexOf(44) != -1 || articleId.indexOf(32) != -1) {
            throw new ArticleIdException();
        }
    }

    protected void validateContent(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new ArticleContentException("Content is null");
        }
        try {
            SAXReaderUtil.read((String)content);
        }
        catch (DocumentException de) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid content:\n" + content));
            }
            throw new ArticleContentException("Unable to read content with an XML parser", (Throwable)de);
        }
    }
}

