/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureExportActionableDynamicQuery;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMTemplateExportActionableDynamicQuery;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleExportActionableDynamicQuery;
import com.liferay.portlet.journal.service.persistence.JournalFeedExportActionableDynamicQuery;
import com.liferay.portlet.journal.service.persistence.JournalFolderExportActionableDynamicQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletPreferences;

public class JournalPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "journal";

    public JournalPortletDataHandler() {
        this.setDataLocalized(true);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(DDMStructure.class, JournalArticle.class), new StagedModelType(DDMTemplate.class, DDMStructure.class), new StagedModelType(JournalArticle.class), new StagedModelType(JournalFeed.class), new StagedModelType(JournalFolder.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "web-content", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "referenced-content"), new PortletDataHandlerBoolean(NAMESPACE, "version-history", PropsValues.JOURNAL_PUBLISH_VERSION_HISTORY_BY_DEFAULT)}, JournalArticle.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "structures", true, false, null, DDMStructure.class.getName(), JournalArticle.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "feeds", true, false, null, JournalFeed.class.getName())});
        this.setPublishToLiveByDefault(PropsValues.JOURNAL_PUBLISH_TO_LIVE_BY_DEFAULT);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(JournalPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        JournalArticleLocalServiceUtil.deleteArticles((long)portletDataContext.getScopeGroupId());
        JournalFolderLocalServiceUtil.deleteFolders((long)portletDataContext.getGroupId());
        DDMTemplateLocalServiceUtil.deleteTemplates((long)portletDataContext.getScopeGroupId());
        DDMStructureLocalServiceUtil.deleteStructures((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.portlet.journal");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "feeds")) {
            JournalFeedExportActionableDynamicQuery feedActionableDynamicQuery = new JournalFeedExportActionableDynamicQuery(portletDataContext);
            feedActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "structures")) {
            ArrayList<DDMTemplate> ddmTemplates = new ArrayList<DDMTemplate>();
            ActionableDynamicQuery ddmStructureActionableDynamicQuery = this.getDDMStructureActionableDynamicQuery(portletDataContext, ddmTemplates, true);
            ddmStructureActionableDynamicQuery.performActions();
            for (DDMTemplate ddmTemplate : ddmTemplates) {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
            }
            ActionableDynamicQuery ddmTemplateActionableDynamicQuery = this.getDDMTemplateActionableDynamicQuery(portletDataContext);
            ddmTemplateActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "web-content")) {
            JournalFolderExportActionableDynamicQuery folderActionableDynamicQuery = new JournalFolderExportActionableDynamicQuery(portletDataContext);
            folderActionableDynamicQuery.performActions();
            ActionableDynamicQuery articleActionableDynamicQuery = this.getArticleActionableDynamicQuery(portletDataContext);
            articleActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.portlet.journal");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "feeds")) {
            Element feedsElement = portletDataContext.getImportDataGroupElement(JournalFeed.class);
            List feedElements = feedsElement.elements();
            for (Element feedElement : feedElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)feedElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "structures")) {
            Element ddmStructuresElement = portletDataContext.getImportDataGroupElement(DDMStructure.class);
            List ddmStructureElements = ddmStructuresElement.elements();
            for (Element ddmStructureElement : ddmStructureElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmStructureElement);
            }
            Element ddmTemplatesElement = portletDataContext.getImportDataGroupElement(DDMTemplate.class);
            List ddmTemplateElements = ddmTemplatesElement.elements();
            Iterator iterator = ddmTemplateElements.iterator();
            while (iterator.hasNext()) {
                Element ddmTemplateElement = (Element)iterator.next();
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmTemplateElement);
            }
        }
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "web-content")) {
            return portletPreferences;
        }
        Element foldersElement = portletDataContext.getImportDataGroupElement(JournalFolder.class);
        List folderElements = foldersElement.elements();
        for (Element folderElement : folderElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
        }
        Element articlesElement = portletDataContext.getImportDataGroupElement(JournalArticle.class);
        List articleElements = articlesElement.elements();
        for (Element articleElement : articleElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)articleElement);
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ActionableDynamicQuery articleActionableDynamicQuery = this.getArticleActionableDynamicQuery(portletDataContext);
        articleActionableDynamicQuery.performCount();
        ArrayList<DDMTemplate> ddmTemplates = new ArrayList<DDMTemplate>();
        ActionableDynamicQuery ddmStructureActionableDynamicQuery = this.getDDMStructureActionableDynamicQuery(portletDataContext, ddmTemplates, false);
        ddmStructureActionableDynamicQuery.performActions();
        ddmStructureActionableDynamicQuery.performCount();
        ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
        ActionableDynamicQuery ddmTemplateActionableDynamicQuery = this.getDDMTemplateActionableDynamicQuery(portletDataContext);
        manifestSummary.addModelAdditionCount(new StagedModelType(DDMTemplate.class, DDMStructure.class), ddmTemplateActionableDynamicQuery.performCount() + (long)ddmTemplates.size());
        JournalFeedExportActionableDynamicQuery feedActionableDynamicQuery = new JournalFeedExportActionableDynamicQuery(portletDataContext);
        feedActionableDynamicQuery.performCount();
        JournalFolderExportActionableDynamicQuery folderActionableDynamicQuery = new JournalFolderExportActionableDynamicQuery(portletDataContext);
        folderActionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getArticleActionableDynamicQuery(final PortletDataContext portletDataContext) throws SystemException {
        return new JournalArticleExportActionableDynamicQuery(portletDataContext){

            protected void performAction(Object object) throws PortalException {
                JournalArticle article = (JournalArticle)object;
                boolean latestVersion = false;
                try {
                    latestVersion = JournalArticleLocalServiceUtil.isLatestVersion((long)article.getGroupId(), (String)article.getArticleId(), (double)article.getVersion(), (int)0);
                }
                catch (Exception exception) {}
                if (portletDataContext.getBooleanParameter(JournalPortletDataHandler.NAMESPACE, "version-history") || latestVersion) {
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)article);
                }
            }
        };
    }

    protected ActionableDynamicQuery getDDMStructureActionableDynamicQuery(final PortletDataContext portletDataContext, final List<DDMTemplate> ddmTemplates, final boolean export) throws SystemException {
        return new DDMStructureExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                long classNameId = PortalUtil.getClassNameId(JournalArticle.class);
                dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
            }

            protected StagedModelType getStagedModelType() {
                return new StagedModelType(DDMStructure.class.getName(), JournalArticle.class.getName());
            }

            protected void performAction(Object object) throws PortalException {
                DDMStructure ddmStructure = (DDMStructure)object;
                if (export) {
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
                }
                try {
                    ddmTemplates.addAll(ddmStructure.getTemplates());
                }
                catch (SystemException systemException) {}
            }
        };
    }

    protected ActionableDynamicQuery getDDMTemplateActionableDynamicQuery(PortletDataContext portletDataContext) throws SystemException {
        return new DDMTemplateExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
                dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
                Property classPKProperty = PropertyFactoryUtil.forName((String)"classPK");
                dynamicQuery.add(classPKProperty.eq((Object)-1L));
            }

            protected StagedModelType getStagedModelType() {
                return new StagedModelType(DDMTemplate.class.getName(), DDMStructure.class.getName());
            }
        };
    }
}

