/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.journal.DuplicateArticleIdException;
import com.liferay.portlet.journal.DuplicateFolderNameException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchFolderException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            WindowState windowState;
            if (cmd.equals("delete") || cmd.equals("delete_versions")) {
                this.deleteEntries(actionRequest, false);
            } else if (cmd.equals("expire")) {
                this.expireEntries(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveEntries(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntries(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreEntryFromTrash(actionRequest);
            }
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (cmd.equals("delete_versions") && !ActionUtil.hasArticle(actionRequest)) {
                String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
                if (Validator.isNotNull((String)referringPortletResource)) {
                    this.setForward((PortletRequest)actionRequest, "portlet.journal.asset.add_asset_redirect");
                    return;
                }
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)portletConfig.getPortletName(), (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
                redirect = portletURL.toString();
            }
            if (!(windowState = actionRequest.getWindowState()).equals((Object)LiferayWindowState.POP_UP)) {
                this.sendRedirect(actionRequest, actionResponse);
            } else if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchArticleException || e2 instanceof NoSuchFolderException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e2 instanceof DuplicateArticleIdException || e2 instanceof DuplicateFolderNameException || e2 instanceof NoSuchFolderException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof AssetCategoryException || e2 instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getArticles((PortletRequest)renderRequest);
            ActionUtil.getFolders((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchArticleException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.journal.error");
            }
            throw e2;
        }
        String forward = "portlet.journal.edit_entry";
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    protected void deleteEntries(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String deleteEntryClassName = null;
        String deleteEntryTitle = null;
        long[] deleteFolderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int i2 = 0;
        while (i2 < deleteFolderIds.length) {
            long deleteFolderId = deleteFolderIds[i2];
            if (moveToTrash) {
                JournalFolder folder = JournalFolderServiceUtil.moveFolderToTrash((long)deleteFolderId);
                if (i2 == 0) {
                    deleteEntryClassName = JournalFolder.class.getName();
                    deleteEntryTitle = TrashUtil.getOriginalTitle((String)folder.getName());
                }
            } else {
                JournalFolderServiceUtil.deleteFolder((long)deleteFolderId);
            }
            ++i2;
        }
        String[] deleteArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"));
        long[] restoreArticleIds = new long[deleteArticleIds.length];
        int i3 = 0;
        while (i3 < deleteArticleIds.length) {
            String deleteArticleId = deleteArticleIds[i3];
            if (moveToTrash) {
                JournalArticle article = JournalArticleServiceUtil.moveArticleToTrash((long)themeDisplay.getScopeGroupId(), (String)deleteArticleId);
                if (i3 == 0) {
                    deleteEntryClassName = JournalArticle.class.getName();
                    deleteEntryTitle = article.getTitle(themeDisplay.getLocale());
                }
                restoreArticleIds[i3] = article.getResourcePrimKey();
            } else {
                ActionUtil.deleteArticle(actionRequest, deleteArticleId);
            }
            ++i3;
        }
        if (moveToTrash && (deleteArticleIds.length > 0 || deleteFolderIds.length > 0)) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            if (Validator.isNotNull((String)deleteEntryClassName)) {
                data.put("deleteEntryClassName", new String[]{deleteEntryClassName});
            }
            if (Validator.isNotNull((String)deleteEntryTitle)) {
                data.put("deleteEntryTitle", new String[]{deleteEntryTitle});
            }
            data.put("restoreArticleIds", ArrayUtil.toStringArray((long[])restoreArticleIds));
            data.put("restoreFolderIds", ArrayUtil.toStringArray((long[])deleteFolderIds));
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".deleteSuccessData"), data);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void expireEntries(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] expireFolderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        Object[] objectArray = expireFolderIds;
        int n = expireFolderIds.length;
        int n2 = 0;
        while (n2 < n) {
            long expireFolderId = objectArray[n2];
            ActionUtil.expireFolder(themeDisplay.getScopeGroupId(), expireFolderId, serviceContext);
            ++n2;
        }
        String[] expireArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"));
        objectArray = expireArticleIds;
        n = expireArticleIds.length;
        n2 = 0;
        while (n2 < n) {
            long expireArticleId = objectArray[n2];
            ActionUtil.expireArticle(actionRequest, (String)expireArticleId);
            ++n2;
        }
    }

    protected void moveEntries(ActionRequest actionRequest) throws Exception {
        String[] articleIds;
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        long[] folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        long[] lArray = folderIds;
        int n = folderIds.length;
        int n2 = 0;
        while (n2 < n) {
            long folderId = lArray[n2];
            JournalFolderServiceUtil.moveFolder((long)folderId, (long)newFolderId, (ServiceContext)serviceContext);
            ++n2;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String[] stringArray = articleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"));
        int n3 = articleIds.length;
        n = 0;
        while (n < n3) {
            String articleId = stringArray[n];
            JournalArticleServiceUtil.moveArticle((long)themeDisplay.getScopeGroupId(), (String)articleId, (long)newFolderId);
            ++n;
        }
    }

    protected void restoreEntryFromTrash(ActionRequest actionRequest) throws PortalException, SystemException {
        long[] restoreArticleIds;
        long[] restoreFolderIds;
        long[] lArray = restoreFolderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreFolderIds"), (long)0L);
        int n = restoreFolderIds.length;
        int n2 = 0;
        while (n2 < n) {
            long restoreFolderId = lArray[n2];
            JournalFolderServiceUtil.restoreFolderFromTrash((long)restoreFolderId);
            ++n2;
        }
        long[] lArray2 = restoreArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreArticleIds"), (long)0L);
        int n3 = restoreArticleIds.length;
        n = 0;
        while (n < n3) {
            long restoreEntryId = lArray2[n];
            JournalArticleServiceUtil.restoreArticleFromTrash((long)restoreEntryId);
            ++n;
        }
    }
}

