/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.journal.ArticleContentException;
import com.liferay.portlet.journal.ArticleContentSizeException;
import com.liferay.portlet.journal.ArticleDisplayDateException;
import com.liferay.portlet.journal.ArticleExpirationDateException;
import com.liferay.portlet.journal.ArticleIdException;
import com.liferay.portlet.journal.ArticleSmallImageNameException;
import com.liferay.portlet.journal.ArticleSmallImageSizeException;
import com.liferay.portlet.journal.ArticleTitleException;
import com.liferay.portlet.journal.ArticleTypeException;
import com.liferay.portlet.journal.ArticleVersionException;
import com.liferay.portlet.journal.DuplicateArticleIdException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.asset.JournalArticleAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.util.JournalConverterUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditArticleAction
extends PortletAction {
    public static final String VERSION_SEPARATOR = "_version_";

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        JournalArticle article = null;
        String oldUrlTitle = "";
        try {
            String oldRedirectParam;
            String oldRedirect;
            if (Validator.isNull((String)cmd)) {
                UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                if (uploadException != null) {
                    if (uploadException.isExceededSizeLimit()) {
                        throw new ArticleContentSizeException();
                    }
                    throw new PortalException(uploadException.getCause());
                }
                return;
            }
            if (cmd.equals("add") || cmd.equals("preview") || cmd.equals("translate") || cmd.equals("update")) {
                Object[] contentAndImages = this.updateArticle(actionRequest);
                article = (JournalArticle)contentAndImages[0];
                oldUrlTitle = (String)contentAndImages[1];
            } else if (cmd.equals("delete")) {
                this.deleteArticles(actionRequest, false);
            } else if (cmd.equals("delete_translation")) {
                this.removeArticlesLocale(actionRequest);
            } else if (cmd.equals("expire")) {
                this.expireArticles(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveArticles(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteArticles(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreArticles(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeArticles(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeArticles(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
            String portletId = HttpUtil.getParameter((String)redirect, (String)"p_p_id", (boolean)false);
            String namespace = PortalUtil.getPortletNamespace((String)portletId);
            if (Validator.isNotNull((String)oldUrlTitle) && Validator.isNotNull((String)(oldRedirect = HttpUtil.getParameter((String)redirect, (String)(oldRedirectParam = String.valueOf(namespace) + "redirect"), (boolean)false)))) {
                String newRedirect = HttpUtil.decodeURL((String)oldRedirect);
                newRedirect = StringUtil.replace((String)newRedirect, (String)oldUrlTitle, (String)article.getUrlTitle());
                newRedirect = StringUtil.replace((String)newRedirect, (String)oldRedirectParam, (String)"redirect");
                redirect = StringUtil.replace((String)redirect, (String)oldRedirect, (String)newRedirect);
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (cmd.equals("delete") && !ActionUtil.hasArticle(actionRequest)) {
                String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
                if (Validator.isNotNull((String)referringPortletResource)) {
                    this.setForward((PortletRequest)actionRequest, "portlet.journal.asset.add_asset_redirect");
                    return;
                }
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)portletConfig.getPortletName(), (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
                redirect = portletURL.toString();
            }
            if (cmd.equals("delete_translation") || cmd.equals("translate")) {
                this.setForward((PortletRequest)actionRequest, "portlet.journal.update_translation_redirect");
            } else if (article != null && workflowAction == 2) {
                redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, article, redirect);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                WindowState windowState = actionRequest.getWindowState();
                Layout layout = themeDisplay.getLayout();
                if (!windowState.equals((Object)LiferayWindowState.POP_UP) && layout.isTypeControlPanel()) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else if (Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)redirect)))) {
                    if (cmd.equals("add") && article != null) {
                        redirect = HttpUtil.addParameter((String)redirect, (String)(String.valueOf(namespace) + "className"), (String)JournalArticle.class.getName());
                        redirect = HttpUtil.addParameter((String)redirect, (String)(String.valueOf(namespace) + "classPK"), (long)JournalArticleAssetRenderer.getClassPK(article));
                    }
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchArticleException || e2 instanceof NoSuchStructureException || e2 instanceof NoSuchTemplateException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e2 instanceof ArticleContentException || e2 instanceof ArticleContentSizeException || e2 instanceof ArticleDisplayDateException || e2 instanceof ArticleExpirationDateException || e2 instanceof ArticleIdException || e2 instanceof ArticleSmallImageNameException || e2 instanceof ArticleSmallImageSizeException || e2 instanceof ArticleTitleException || e2 instanceof ArticleTypeException || e2 instanceof ArticleVersionException || e2 instanceof DuplicateArticleIdException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof AssetCategoryException || e2 instanceof AssetTagException || e2 instanceof LocaleException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getArticle((PortletRequest)renderRequest);
        }
        catch (NoSuchArticleException noSuchArticleException) {
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.journal.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_article"));
    }

    protected void deleteArticles(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String deleteEntryTitle = null;
        String[] deleteArticleIds = null;
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        deleteArticleIds = Validator.isNotNull((String)articleId) ? new String[]{articleId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"));
        long[] restoreArticleIds = new long[deleteArticleIds.length];
        int i2 = 0;
        while (i2 < deleteArticleIds.length) {
            String deleteArticleId = deleteArticleIds[i2];
            if (moveToTrash) {
                JournalArticle article = JournalArticleServiceUtil.moveArticleToTrash((long)themeDisplay.getScopeGroupId(), (String)deleteArticleId);
                if (i2 == 0) {
                    deleteEntryTitle = article.getTitle(themeDisplay.getLocale());
                }
                restoreArticleIds[i2] = article.getResourcePrimKey();
            } else {
                ActionUtil.deleteArticle(actionRequest, deleteArticleId);
            }
            ++i2;
        }
        if (moveToTrash && deleteArticleIds.length > 0) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            data.put("deleteEntryClassName", new String[]{JournalArticle.class.getName()});
            if (Validator.isNotNull((String)deleteEntryTitle)) {
                data.put("deleteEntryTitle", new String[]{deleteEntryTitle});
            }
            data.put("restoreArticleIds", ArrayUtil.toStringArray((long[])restoreArticleIds));
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".deleteSuccessData"), data);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void expireArticles(ActionRequest actionRequest) throws Exception {
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        if (Validator.isNotNull((String)articleId)) {
            ActionUtil.expireArticle(actionRequest, articleId);
        } else {
            String[] expireArticleIds;
            String[] stringArray = expireArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"expireArticleIds"));
            int n = expireArticleIds.length;
            int n2 = 0;
            while (n2 < n) {
                String expireArticleId = stringArray[n2];
                ActionUtil.expireArticle(actionRequest, expireArticleId);
                ++n2;
            }
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, JournalArticle article, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("cmd", cmd, false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("referringPortletResource", referringPortletResource, false);
        portletURL.setParameter("resourcePrimKey", String.valueOf(article.getResourcePrimKey()), false);
        portletURL.setParameter("groupId", String.valueOf(article.getGroupId()), false);
        portletURL.setParameter("articleId", article.getArticleId(), false);
        portletURL.setParameter("version", String.valueOf(article.getVersion()), false);
        portletURL.setParameter("languageId", languageId, false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected void moveArticles(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        if (Validator.isNotNull((String)articleId)) {
            JournalArticleServiceUtil.moveArticle((long)themeDisplay.getScopeGroupId(), (String)articleId, (long)newFolderId);
        } else {
            String[] articleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"));
            int i2 = 0;
            while (i2 < articleIds.length) {
                JournalArticleServiceUtil.moveArticle((long)themeDisplay.getScopeGroupId(), (String)articleIds[i2], (long)newFolderId);
                ++i2;
            }
        }
    }

    protected void removeArticlesLocale(ActionRequest actionRequest) throws Exception {
        String[] removeArticleLocaleIds;
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] stringArray = removeArticleLocaleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"));
        int n = removeArticleLocaleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String removeArticleLocaleId = stringArray[n2];
            int pos = removeArticleLocaleId.lastIndexOf(VERSION_SEPARATOR);
            String articleId = removeArticleLocaleId.substring(0, pos);
            double version = GetterUtil.getDouble((String)removeArticleLocaleId.substring(pos + VERSION_SEPARATOR.length()));
            String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
            JournalArticleServiceUtil.removeArticleLocale((long)groupId, (String)articleId, (double)version, (String)languageId);
            ++n2;
        }
    }

    protected void restoreArticles(ActionRequest actionRequest) throws Exception {
        String[] restoreEntryIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String[] stringArray = restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreEntryIds"));
        int n = restoreEntryIds.length;
        int n2 = 0;
        while (n2 < n) {
            String restoreEntryId = stringArray[n2];
            JournalArticleServiceUtil.restoreArticleFromTrash((long)themeDisplay.getScopeGroupId(), (String)restoreEntryId);
            ++n2;
        }
    }

    protected void subscribeArticles(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JournalArticleServiceUtil.subscribe((long)themeDisplay.getScopeGroupId());
    }

    protected void unsubscribeArticles(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JournalArticleServiceUtil.unsubscribe((long)themeDisplay.getScopeGroupId());
    }

    protected Object[] updateArticle(ActionRequest actionRequest) throws Exception {
        Boolean fileItemThresholdSizeExceeded;
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        long classNameId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classPK");
        String articleId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"articleId");
        boolean autoArticleId = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"autoArticleId");
        double version = ParamUtil.getDouble((HttpServletRequest)uploadPortletRequest, (String)"version");
        boolean localized = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"localized");
        String defaultLanguageId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"defaultLanguageId");
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        String toLanguageId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"toLanguageId");
        Locale toLocale = null;
        String title = "";
        String description = "";
        if (Validator.isNull((String)toLanguageId)) {
            title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("title_" + defaultLanguageId));
            description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("description_" + defaultLanguageId));
        } else {
            toLocale = LocaleUtil.fromLanguageId((String)toLanguageId);
            title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("title_" + toLanguageId));
            description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("description_" + toLanguageId));
        }
        String content = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"articleContent");
        HashMap images = new HashMap();
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (UploadPortletRequest)uploadPortletRequest);
        String structureId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"structureId");
        DDMStructure ddmStructure = null;
        if (Validator.isNotNull((String)structureId)) {
            try {
                ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)PortalUtil.getSiteGroupId((long)groupId), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)structureId);
            }
            catch (NoSuchStructureException noSuchStructureException) {
                ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)themeDisplay.getCompanyGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)structureId);
            }
            String languageId = toLanguageId;
            if (Validator.isNull((String)languageId)) {
                languageId = defaultLanguageId;
            }
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            Object[] contentAndImages = ActionUtil.getContentAndImages(ddmStructure, locale, serviceContext);
            content = (String)contentAndImages[0];
            images = (HashMap)contentAndImages[1];
        }
        if ((fileItemThresholdSizeExceeded = (Boolean)uploadPortletRequest.getAttribute("FILE_ITEM_THRESHOLD_SIZE_EXCEEDED")) != null && fileItemThresholdSizeExceeded.booleanValue()) {
            throw new ArticleContentSizeException();
        }
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        String templateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"templateId");
        String layoutUuid = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutUuid");
        Layout targetLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId, (boolean)false);
        if (targetLayout == null) {
            targetLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId, (boolean)true);
        }
        if (targetLayout == null) {
            layoutUuid = null;
        }
        int displayDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        int expirationDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateMonth");
        int expirationDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateDay");
        int expirationDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateYear");
        int expirationDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateHour");
        int expirationDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateMinute");
        int expirationDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateAmPm");
        boolean neverExpire = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"neverExpire");
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        int reviewDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateMonth");
        int reviewDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateDay");
        int reviewDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateYear");
        int reviewDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateHour");
        int reviewDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateMinute");
        int reviewDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateAmPm");
        boolean neverReview = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"neverReview");
        if (reviewDateAmPm == 1) {
            reviewDateHour += 12;
        }
        boolean indexable = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"indexable");
        boolean smallImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"smallImage");
        String smallImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"smallImageURL");
        File smallFile = uploadPortletRequest.getFile("smallFile");
        String articleURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"articleURL");
        serviceContext.setAttribute("defaultLanguageId", (Serializable)((Object)defaultLanguageId));
        JournalArticle article = null;
        String oldUrlTitle = "";
        if (cmd.equals("add")) {
            HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
            titleMap.put(defaultLocale, title);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(defaultLocale, description);
            if (Validator.isNull((String)structureId)) {
                content = LocalizationUtil.updateLocalization((String)"", (String)"static-content", (String)content, (String)defaultLanguageId, (String)defaultLanguageId, (boolean)true, (boolean)localized);
            }
            article = JournalArticleServiceUtil.addArticle((long)groupId, (long)folderId, (long)classNameId, (long)classPK, (String)articleId, (boolean)autoArticleId, titleMap, descriptionMap, (String)content, (String)type, (String)structureId, (String)templateId, (String)layoutUuid, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)indexable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (Map)images, (String)articleURL, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (int)-1);
        } else {
            JournalArticle curArticle = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
            if (Validator.isNull((String)structureId)) {
                if (!curArticle.isTemplateDriven()) {
                    String curContent = "";
                    curContent = curArticle.getContent();
                    content = cmd.equals("translate") ? LocalizationUtil.updateLocalization((String)curContent, (String)"static-content", (String)content, (String)toLanguageId, (String)defaultLanguageId, (boolean)true, (boolean)true) : LocalizationUtil.updateLocalization((String)curContent, (String)"static-content", (String)content, (String)defaultLanguageId, (String)defaultLanguageId, (boolean)true, (boolean)localized);
                }
            } else if (curArticle.isTemplateDriven()) {
                Fields newFields = DDMUtil.getFields((long)ddmStructure.getStructureId(), (ServiceContext)serviceContext);
                Fields existingFields = JournalConverterUtil.getDDMFields((DDMStructure)ddmStructure, (String)curArticle.getContent());
                Fields mergedFields = DDMUtil.mergeFields((Fields)newFields, (Fields)existingFields);
                content = JournalConverterUtil.getContent((DDMStructure)ddmStructure, (Fields)mergedFields);
            }
            article = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
            Map titleMap = article.getTitleMap();
            Map descriptionMap = article.getDescriptionMap();
            String tempOldUrlTitle = article.getUrlTitle();
            if (cmd.equals("preview") || cmd.equals("update")) {
                titleMap.put(defaultLocale, title);
                descriptionMap.put(defaultLocale, description);
                article = JournalArticleServiceUtil.updateArticle((long)groupId, (long)folderId, (String)articleId, (double)version, (Map)titleMap, (Map)descriptionMap, (String)content, (String)type, (String)structureId, (String)templateId, (String)layoutUuid, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)indexable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (Map)images, (String)articleURL, (ServiceContext)serviceContext);
            } else if (cmd.equals("translate")) {
                article = JournalArticleServiceUtil.updateArticleTranslation((long)groupId, (String)articleId, (double)version, (Locale)toLocale, (String)title, (String)description, (String)content, (Map)images, (ServiceContext)serviceContext);
            }
            if (!tempOldUrlTitle.equals(article.getUrlTitle())) {
                oldUrlTitle = tempOldUrlTitle;
            }
        }
        JournalUtil.addRecentArticle((PortletRequest)actionRequest, article);
        PortletPreferences portletPreferences = this.getStrictPortletSetup((PortletRequest)actionRequest);
        if (portletPreferences != null) {
            portletPreferences.setValue("groupId", String.valueOf(article.getGroupId()));
            portletPreferences.setValue("articleId", article.getArticleId());
            portletPreferences.store();
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            this.updateContentSearch(actionRequest, portletResource, article.getArticleId());
        }
        return new Object[]{article, oldUrlTitle};
    }

    protected void updateContentSearch(ActionRequest actionRequest, String portletResource, String articleId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        JournalContentSearchLocalServiceUtil.updateContentSearch((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletResource, (String)articleId, (boolean)true);
    }
}

