/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.flags.messaging;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.flags.messaging.FlagsRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class FlagsRequestMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(FlagsRequestMessageListener.class);

    protected void doReceive(Message message) throws Exception {
        FlagsRequest flagsRequest = (FlagsRequest)message.getPayload();
        ServiceContext serviceContext = flagsRequest.getServiceContext();
        long companyId = serviceContext.getCompanyId();
        Company company = CompanyLocalServiceUtil.getCompany((long)serviceContext.getCompanyId());
        Layout layout = LayoutLocalServiceUtil.getLayout((long)serviceContext.getPlid());
        Group group = layout.getGroup();
        String groupName = group.getDescriptiveName();
        String reporterUserName = null;
        String reporterEmailAddress = null;
        User reporterUser = UserLocalServiceUtil.getUserById((long)serviceContext.getUserId());
        Locale locale = LocaleUtil.getDefault();
        if (reporterUser.isDefaultUser()) {
            reporterUserName = LanguageUtil.get((Locale)locale, (String)"anonymous");
        } else {
            reporterUserName = reporterUser.getFullName();
            reporterEmailAddress = reporterUser.getEmailAddress();
        }
        String reportedUserName = "";
        String reportedEmailAddress = "";
        String reportedURL = "";
        User reportedUser = UserLocalServiceUtil.getUserById((long)flagsRequest.getReportedUserId());
        if (reportedUser.isDefaultUser()) {
            reportedUserName = group.getDescriptiveName();
        } else {
            reportedUserName = reportedUser.getFullName();
            reportedEmailAddress = reportedUser.getEmailAddress();
            reportedURL = reportedUser.getDisplayURL(serviceContext.getPortalURL(), serviceContext.getPathMain());
        }
        String contentType = ResourceActionsUtil.getModelResource((Locale)locale, (String)flagsRequest.getClassName());
        String reason = LanguageUtil.get((Locale)locale, (String)flagsRequest.getReason());
        String fromName = PrefsPropsUtil.getStringFromNames(companyId, "flags.email.from.name", "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getStringFromNames(companyId, "flags.email.from.address", "admin.email.from.address");
        String subject = PrefsPropsUtil.getContent(companyId, "flags.email.subject");
        String body = PrefsPropsUtil.getContent(companyId, "flags.email.body");
        List<User> recipients = this.getRecipients(companyId, serviceContext.getScopeGroupId());
        for (User recipient : recipients) {
            try {
                this.notify(company, groupName, reporterEmailAddress, reporterUserName, reportedEmailAddress, reportedUserName, reportedURL, flagsRequest.getClassPK(), flagsRequest.getContentTitle(), contentType, flagsRequest.getContentURL(), reason, fromName, fromAddress, recipient.getFullName(), recipient.getEmailAddress(), subject, body, serviceContext);
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)ioe);
            }
        }
    }

    protected List<User> getRecipients(long companyId, long groupId) throws PortalException, SystemException {
        UniqueList recipients = new UniqueList();
        ArrayList<String> roleNames = new ArrayList<String>();
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isSite()) {
            roleNames.add("Site Administrator");
            roleNames.add("Site Owner");
        }
        if (group.isCompany()) {
            roleNames.add("Administrator");
        } else if (group.isOrganization()) {
            roleNames.add("Organization Administrator");
            roleNames.add("Organization Owner");
        }
        for (String roleName : roleNames) {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
            List userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroupAndRole((long)groupId, (long)role.getRoleId());
            for (UserGroupRole userGroupRole : userGroupRoles) {
                recipients.add(userGroupRole.getUser());
            }
        }
        if (recipients.isEmpty()) {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Administrator");
            recipients.addAll(UserLocalServiceUtil.getRoleUsers((long)role.getRoleId()));
        }
        return recipients;
    }

    protected void notify(Company company, String groupName, String reporterEmailAddress, String reporterUserName, String reportedEmailAddress, String reportedUserName, String reportedUserURL, long contentId, String contentTitle, String contentType, String contentURL, String reason, String fromName, String fromAddress, String toName, String toAddress, String subject, String body, ServiceContext serviceContext) throws Exception {
        Date now = new Date();
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(company.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$CONTENT_ID$]", contentId, "[$CONTENT_TYPE$]", contentType, "[$DATE$]", now.toString(), "[$REASON$]", reason, "[$REPORTED_USER_ADDRESS$]", reportedEmailAddress, "[$REPORTED_USER_NAME$]", reportedUserName, "[$REPORTED_USER_URL$]", reportedUserURL, "[$REPORTER_USER_ADDRESS$]", reporterEmailAddress, "[$REPORTER_USER_NAME$]", reporterUserName, "[$SITE_NAME$]", groupName});
        subscriptionSender.setContextAttribute("[$CONTENT_TITLE$]", (Object)contentTitle, false);
        subscriptionSender.setContextAttribute("[$CONTENT_URL$]", (Object)contentURL, false);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("flags_request", new Object[]{contentId});
        subscriptionSender.setPortletId("142");
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }
}

