/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoColumnServiceUtil;
import com.liferay.portlet.expando.service.ExpandoTableLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpandoBridgeImpl
implements ExpandoBridge {
    private String _className;
    private long _classPK;
    private long _companyId;
    private boolean _indexEnabled;

    public ExpandoBridgeImpl(long companyId, String className) {
        this(companyId, className, 0L);
    }

    public ExpandoBridgeImpl(long companyId, String className, long classPK) {
        this._companyId = companyId;
        if (this._companyId == 0L) {
            this._companyId = CompanyThreadLocal.getCompanyId();
        }
        this._className = className;
        this._classPK = classPK;
        if (IndexerRegistryUtil.getIndexer((String)className) == null) {
            this.setIndexEnabled(true);
        }
    }

    public void addAttribute(String name) throws PortalException {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.addAttribute(name, 15, null, secure);
    }

    public void addAttribute(String name, boolean secure) throws PortalException {
        this.addAttribute(name, 15, null, secure);
    }

    public void addAttribute(String name, int type) throws PortalException {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.addAttribute(name, type, null, secure);
    }

    public void addAttribute(String name, int type, boolean secure) throws PortalException {
        this.addAttribute(name, type, null, secure);
    }

    public void addAttribute(String name, int type, Serializable defaultValue) throws PortalException {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.addAttribute(name, type, defaultValue, secure);
    }

    public void addAttribute(String name, int type, Serializable defaultValue, boolean secure) throws PortalException {
        try {
            ExpandoTable table = this.getTable();
            if (secure) {
                ExpandoColumnServiceUtil.addColumn((long)table.getTableId(), (String)name, (int)type, (Object)defaultValue);
            } else {
                ExpandoColumnLocalServiceUtil.addColumn((long)table.getTableId(), (String)name, (int)type, (Object)defaultValue);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof PortalException) {
                throw (PortalException)((Object)e2);
            }
            throw new RuntimeException(e2);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpandoBridgeImpl)) {
            return false;
        }
        ExpandoBridgeImpl expandoBridgeImpl = (ExpandoBridgeImpl)obj;
        try {
            ExpandoTable table1 = this.getTable();
            long tableId1 = table1.getTableId();
            ExpandoTable table2 = expandoBridgeImpl.getTable();
            long tableId2 = table2.getTableId();
            if (tableId1 != tableId2) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        for (ExpandoColumn column : this.getAttributeColumns()) {
            Serializable attribute1 = this.getAttribute(column.getName());
            Serializable attribute2 = expandoBridgeImpl.getAttribute(column.getName());
            if (this.equals(column.getType(), attribute1, attribute2)) continue;
            return false;
        }
        return true;
    }

    public Serializable getAttribute(String name) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_READ_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isExportInProcess()) {
            secure = false;
        }
        return this.getAttribute(name, secure);
    }

    public Serializable getAttribute(String name, boolean secure) {
        Serializable data = null;
        try {
            data = secure ? ExpandoValueServiceUtil.getData((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (String)name, (long)this._classPK) : ExpandoValueLocalServiceUtil.getData((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (String)name, (long)this._classPK);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return data;
    }

    public Serializable getAttributeDefault(String name) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            return column.getDefaultValue();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public Enumeration<String> getAttributeNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ExpandoColumn column : this.getAttributeColumns()) {
            columnNames.add(column.getName());
        }
        return Collections.enumeration(columnNames);
    }

    public UnicodeProperties getAttributeProperties(String name) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            return column.getTypeSettingsProperties();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public Map<String, Serializable> getAttributes() {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_READ_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isExportInProcess()) {
            secure = false;
        }
        return this.getAttributes(secure);
    }

    public Map<String, Serializable> getAttributes(boolean secure) {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        for (ExpandoColumn column : this.getAttributeColumns()) {
            attributes.put(column.getName(), this.getAttribute(column.getName(), secure));
        }
        return attributes;
    }

    public Map<String, Serializable> getAttributes(Collection<String> names) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_READ_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isExportInProcess()) {
            secure = false;
        }
        return this.getAttributes(names, secure);
    }

    public Map<String, Serializable> getAttributes(Collection<String> names, boolean secure) {
        Map attributeValues = null;
        try {
            attributeValues = secure ? ExpandoValueServiceUtil.getData((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", names, (long)this._classPK) : ExpandoValueLocalServiceUtil.getData((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", names, (long)this._classPK);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return attributeValues;
    }

    public int getAttributeType(String name) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            return column.getType();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public boolean hasAttribute(String name) {
        ExpandoColumn column = null;
        try {
            column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return column != null;
    }

    public boolean isIndexEnabled() {
        return this._indexEnabled && this._classPK > 0L;
    }

    public void reindex() {
        if (!this.isIndexEnabled()) {
            return;
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)this._className);
        if (indexer != null) {
            try {
                indexer.reindex(this._className, this._classPK);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public void setAttribute(String name, Serializable value) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.setAttribute(name, value, secure);
    }

    public void setAttribute(String name, Serializable value, boolean secure) {
        if (this._classPK <= 0L) {
            throw new UnsupportedOperationException("Class primary key is less than 0");
        }
        try {
            if (secure) {
                ExpandoValueServiceUtil.addValue((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (String)name, (long)this._classPK, (Object)value);
            } else {
                ExpandoValueLocalServiceUtil.addValue((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (String)name, (long)this._classPK, (Object)value);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public void setAttributeDefault(String name, Serializable defaultValue) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            ExpandoColumnServiceUtil.updateColumn((long)column.getColumnId(), (String)column.getName(), (int)column.getType(), (Object)defaultValue);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public void setAttributeProperties(String name, UnicodeProperties properties) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.setAttributeProperties(name, properties, secure);
    }

    public void setAttributeProperties(String name, UnicodeProperties properties, boolean secure) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            if (secure) {
                ExpandoColumnServiceUtil.updateTypeSettings((long)column.getColumnId(), (String)properties.toString());
            } else {
                ExpandoColumnLocalServiceUtil.updateTypeSettings((long)column.getColumnId(), (String)properties.toString());
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.setAttributes(attributes, secure);
    }

    public void setAttributes(Map<String, Serializable> attributes, boolean secure) {
        if (this._classPK <= 0L) {
            throw new UnsupportedOperationException("Class primary key is less than 0");
        }
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        try {
            if (secure) {
                ExpandoValueServiceUtil.addValues((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (long)this._classPK, attributes);
            } else {
                ExpandoValueLocalServiceUtil.addValues((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (long)this._classPK, attributes);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public void setAttributes(ServiceContext serviceContext) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ExportImportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.setAttributes(serviceContext, secure);
    }

    public void setAttributes(ServiceContext serviceContext, boolean secure) {
        if (serviceContext == null) {
            return;
        }
        this.setAttributes(serviceContext.getExpandoBridgeAttributes(), secure);
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setIndexEnabled(boolean indexEnabled) {
        this._indexEnabled = indexEnabled;
    }

    protected boolean equals(int type, Serializable serializable1, Serializable serializable2) {
        if (type == 2) {
            Object[] array1 = (Boolean[])serializable1;
            Object[] array2 = (Boolean[])serializable2;
            return Arrays.equals(array1, array2);
        }
        if (type == 4) {
            Object[] array1 = (Date[])serializable1;
            Object[] array2 = (Date[])serializable2;
            return Arrays.equals(array1, array2);
        }
        if (type == 6) {
            double[] array1 = (double[])serializable1;
            double[] array2 = (double[])serializable2;
            return Arrays.equals(array1, array2);
        }
        if (type == 8) {
            float[] array1 = (float[])serializable1;
            float[] array2 = (float[])serializable2;
            return Arrays.equals(array1, array2);
        }
        if (type == 10) {
            int[] array1 = (int[])serializable1;
            int[] array2 = (int[])serializable2;
            return Arrays.equals(array1, array2);
        }
        if (type == 12) {
            long[] array1 = (long[])serializable1;
            long[] array2 = (long[])serializable2;
            return Arrays.equals(array1, array2);
        }
        if (type == 18) {
            Object[] array1 = (Number[])serializable1;
            Object[] array2 = (Number[])serializable2;
            return Arrays.equals(array1, array2);
        }
        if (type == 14) {
            short[] array1 = (short[])serializable1;
            short[] array2 = (short[])serializable2;
            return Arrays.equals(array1, array2);
        }
        if (type == 16) {
            Object[] array1 = (String[])serializable1;
            Object[] array2 = (String[])serializable2;
            return Arrays.equals(array1, array2);
        }
        return serializable1.equals(serializable2);
    }

    protected List<ExpandoColumn> getAttributeColumns() {
        ArrayList<ExpandoColumn> columns = new ArrayList();
        try {
            columns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((long)this._companyId, (String)this._className);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return columns;
    }

    protected ExpandoTable getTable() throws PortalException, SystemException {
        ExpandoTable table = ExpandoTableLocalServiceUtil.fetchDefaultTable((long)this._companyId, (String)this._className);
        if (table == null) {
            table = ExpandoTableLocalServiceUtil.addDefaultTable((long)this._companyId, (String)this._className);
        }
        return table;
    }
}

