/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.upload.UploadRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.FieldConstants;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDM;
import com.liferay.portlet.dynamicdatamapping.util.DDMDisplay;
import com.liferay.portlet.dynamicdatamapping.util.DDMDisplayRegistryUtil;
import com.liferay.portlet.dynamicdatamapping.util.comparator.StructureIdComparator;
import com.liferay.portlet.dynamicdatamapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.portlet.dynamicdatamapping.util.comparator.TemplateIdComparator;
import com.liferay.portlet.dynamicdatamapping.util.comparator.TemplateModifiedDateComparator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class DDMImpl
implements DDM {
    public static final String FIELDS_DISPLAY_NAME = "_fieldsDisplay";
    public static final String INSTANCE_SEPARATOR = "_INSTANCE_";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_DDM_DATE = "ddm-date";
    public static final String TYPE_DDM_DOCUMENTLIBRARY = "ddm-documentlibrary";
    public static final String TYPE_DDM_LINK_TO_PAGE = "ddm-link-to-page";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_SELECT = "select";

    public DDMDisplay getDDMDisplay(ServiceContext serviceContext) {
        String refererPortletName = (String)((Object)serviceContext.getAttribute("refererPortletName"));
        if (refererPortletName == null) {
            refererPortletName = serviceContext.getPortletId();
        }
        return DDMDisplayRegistryUtil.getDDMDisplay((String)refererPortletName);
    }

    public Serializable getDisplayFieldValue(ThemeDisplay themeDisplay, Serializable fieldValue, String type) throws Exception {
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            DateFormat dateFormat = DateFormatFactoryUtil.getDate((Locale)themeDisplay.getLocale());
            fieldValue = dateFormat.format(valueDate);
        } else if (type.equals(TYPE_CHECKBOX)) {
            Boolean valueBoolean = (Boolean)fieldValue;
            fieldValue = valueBoolean.booleanValue() ? LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"yes") : LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"no");
        } else if (type.equals(TYPE_DDM_DOCUMENTLIBRARY)) {
            if (Validator.isNull((Object)fieldValue)) {
                return "";
            }
            String valueString = String.valueOf(fieldValue);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
            fieldValue = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)true);
        } else if (type.equals(TYPE_DDM_LINK_TO_PAGE)) {
            if (Validator.isNull((Object)fieldValue)) {
                return "";
            }
            String valueString = String.valueOf(fieldValue);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            long groupId = jsonObject.getLong("groupId");
            boolean privateLayout = jsonObject.getBoolean("privateLayout");
            long layoutId = jsonObject.getLong("layoutId");
            Layout layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
            fieldValue = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        } else if (type.equals(TYPE_RADIO) || type.equals(TYPE_SELECT)) {
            String valueString = String.valueOf(fieldValue);
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
            String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
            fieldValue = stringArray[0];
        }
        return fieldValue;
    }

    public Fields getFields(long ddmStructureId, long ddmTemplateId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.getFields(ddmStructureId, ddmTemplateId, "", serviceContext);
    }

    public Fields getFields(long ddmStructureId, long ddmTemplateId, String fieldNamespace, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.getDDMStructure(ddmStructureId, ddmTemplateId);
        Set fieldNames = ddmStructure.getFieldNames();
        Fields fields = new Fields();
        for (String fieldName : fieldNames) {
            List<Serializable> fieldValues = this.getFieldValues(ddmStructure, fieldName, fieldNamespace, serviceContext);
            if (fieldValues == null || fieldValues.isEmpty()) continue;
            Field field = this.createField(ddmStructure, fieldName, fieldValues, serviceContext);
            fields.put(field);
        }
        return fields;
    }

    public Fields getFields(long ddmStructureId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.getFields(ddmStructureId, 0L, serviceContext);
    }

    public Fields getFields(long ddmStructureId, String fieldNamespace, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.getFields(ddmStructureId, 0L, fieldNamespace, serviceContext);
    }

    public String[] getFieldsDisplayValues(Field fieldsDisplayField) throws Exception {
        String[] values;
        DDMStructure ddmStructure = fieldsDisplayField.getDDMStructure();
        ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
        String[] stringArray = values = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())));
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            String fieldName = StringUtil.extractFirst((String)value, (String)INSTANCE_SEPARATOR);
            if (ddmStructure.hasField(fieldName)) {
                fieldsDisplayValues.add(fieldName);
            }
            ++n2;
        }
        return fieldsDisplayValues.toArray(new String[fieldsDisplayValues.size()]);
    }

    public Serializable getIndexedFieldValue(Serializable fieldValue, String type) throws Exception {
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
            fieldValue = dateFormat.format(valueDate);
        } else if (type.equals(TYPE_RADIO) || type.equals(TYPE_SELECT)) {
            String valueString = (String)fieldValue;
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
            String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
            fieldValue = stringArray[0];
        }
        return fieldValue;
    }

    public OrderByComparator getStructureOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        StructureIdComparator orderByComparator = null;
        if (orderByCol.equals("id")) {
            orderByComparator = new StructureIdComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new StructureModifiedDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public OrderByComparator getTemplateOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        TemplateIdComparator orderByComparator = null;
        if (orderByCol.equals("id")) {
            orderByComparator = new TemplateIdComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new TemplateModifiedDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public Fields mergeFields(Fields newFields, Fields existingFields) {
        Iterator itr = newFields.iterator(true);
        while (itr.hasNext()) {
            Field newField = (Field)itr.next();
            Field existingField = existingFields.get(newField.getName());
            if (existingField == null) {
                existingFields.put(newField);
                continue;
            }
            for (Locale locale : newField.getAvailableLocales()) {
                existingField.setValues(locale, newField.getValues(locale));
            }
            existingField.setDefaultLocale(newField.getDefaultLocale());
        }
        return existingFields;
    }

    protected Field createField(DDMStructure ddmStructure, String fieldName, List<Serializable> fieldValues, ServiceContext serviceContext) throws PortalException, SystemException {
        Field field = new Field();
        field.setDDMStructureId(ddmStructure.getStructureId());
        String languageId = GetterUtil.getString((Object)serviceContext.getAttribute("languageId"), (String)serviceContext.getLanguageId());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        String defaultLanguageId = GetterUtil.getString((Object)serviceContext.getAttribute("defaultLanguageId"));
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        if (ddmStructure.isFieldPrivate(fieldName)) {
            locale = LocaleUtil.getSiteDefault();
            defaultLocale = LocaleUtil.getSiteDefault();
        }
        field.setDefaultLocale(defaultLocale);
        field.setName(fieldName);
        field.setValues(locale, fieldValues);
        return field;
    }

    protected DDMStructure getDDMStructure(long ddmStructureId, long ddmTemplateId) throws PortalException, SystemException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        try {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)ddmTemplateId);
            ddmStructure = (DDMStructure)ddmStructure.clone();
            ddmStructure.setXsd(ddmTemplate.getScript());
        }
        catch (NoSuchTemplateException noSuchTemplateException) {}
        return ddmStructure;
    }

    protected List<String> getFieldNames(String fieldNamespace, String fieldName, ServiceContext serviceContext) {
        String[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)serviceContext.getAttribute(String.valueOf(fieldNamespace) + FIELDS_DISPLAY_NAME))));
        List privateFieldNames = ListUtil.fromArray((Object[])PropsValues.DYNAMIC_DATA_MAPPING_STRUCTURE_PRIVATE_FIELD_NAMES);
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (fieldsDisplayValues.length == 0 || privateFieldNames.contains(fieldName)) {
            fieldNames.add(String.valueOf(fieldNamespace) + fieldName);
        } else {
            String[] stringArray = fieldsDisplayValues;
            int n = fieldsDisplayValues.length;
            int n2 = 0;
            while (n2 < n) {
                String namespacedFieldName = stringArray[n2];
                String fieldNameValue = StringUtil.extractFirst((String)namespacedFieldName, (String)INSTANCE_SEPARATOR);
                if (fieldNameValue.equals(fieldName)) {
                    fieldNames.add(String.valueOf(fieldNamespace) + namespacedFieldName);
                }
                ++n2;
            }
        }
        return fieldNames;
    }

    protected List<Serializable> getFieldValues(DDMStructure ddmStructure, String fieldName, String fieldNamespace, ServiceContext serviceContext) throws PortalException, SystemException {
        String fieldDataType = ddmStructure.getFieldDataType(fieldName);
        String fieldType = ddmStructure.getFieldType(fieldName);
        List<String> fieldNames = this.getFieldNames(fieldNamespace, fieldName, serviceContext);
        ArrayList<Serializable> fieldValues = new ArrayList<Serializable>(fieldNames.size());
        for (String fieldNameValue : fieldNames) {
            Object fieldValue = serviceContext.getAttribute(fieldNameValue);
            if (fieldDataType.equals("date")) {
                int fieldValueYear;
                int fieldValueDay;
                int fieldValueMonth = GetterUtil.getInteger((Object)serviceContext.getAttribute(String.valueOf(fieldNameValue) + "Month"));
                Date fieldValueDate = PortalUtil.getDate((int)fieldValueMonth, (int)(fieldValueDay = GetterUtil.getInteger((Object)serviceContext.getAttribute(String.valueOf(fieldNameValue) + "Day"))), (int)(fieldValueYear = GetterUtil.getInteger((Object)serviceContext.getAttribute(String.valueOf(fieldNameValue) + "Year"))));
                if (fieldValueDate != null) {
                    fieldValue = String.valueOf(fieldValueDate.getTime());
                }
            } else if (fieldDataType.equals("image") && Validator.isNull((Object)fieldValue)) {
                HttpServletRequest request = serviceContext.getRequest();
                if (!(request instanceof UploadRequest)) {
                    return null;
                }
                UploadRequest uploadRequest = (UploadRequest)request;
                File file = uploadRequest.getFile(fieldNameValue);
                try {
                    byte[] bytes = FileUtil.getBytes((File)file);
                    fieldValue = ArrayUtil.isNotEmpty((byte[])bytes) ? UnicodeFormatter.bytesToHex((byte[])bytes) : "update";
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            if (fieldValue == null) {
                return null;
            }
            if (TYPE_RADIO.equals(fieldType) || TYPE_SELECT.equals(fieldType)) {
                if (fieldValue instanceof String) {
                    fieldValue = new String[]{String.valueOf(fieldValue)};
                }
                fieldValue = JSONFactoryUtil.serialize((Object)fieldValue);
            }
            Serializable fieldValueSerializable = FieldConstants.getSerializable((String)fieldDataType, (String)GetterUtil.getString((Object)fieldValue));
            fieldValues.add(fieldValueSerializable);
        }
        return fieldValues;
    }
}

