/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.TemplateDuplicateTemplateKeyException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import java.io.File;
import java.util.Map;

public class DDMTemplateStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMTemplate> {
    public static final String[] CLASS_NAMES = new String[]{DDMTemplate.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(DDMTemplateStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplateByUuidAndGroupId((String)uuid, (long)groupId);
        if (ddmTemplate != null) {
            DDMTemplateLocalServiceUtil.deleteTemplate((DDMTemplate)ddmTemplate);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMTemplate template) {
        return template.getNameCurrentValue();
    }

    protected DDMTemplate addTemplate(long userId, long groupId, DDMTemplate template, long classPK, File smallFile, ServiceContext serviceContext) throws Exception {
        DDMTemplate newTemplate = null;
        try {
            return DDMTemplateLocalServiceUtil.addTemplate((long)userId, (long)groupId, (long)template.getClassNameId(), (long)classPK, (String)template.getTemplateKey(), (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
        }
        catch (TemplateDuplicateTemplateKeyException templateDuplicateTemplateKeyException) {
            newTemplate = DDMTemplateLocalServiceUtil.addTemplate((long)userId, (long)groupId, (long)template.getClassNameId(), (long)classPK, null, (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("A template with the key ");
                sb.append(template.getTemplateKey());
                sb.append(" already exists. The new generated key is ");
                sb.append(newTemplate.getTemplateKey());
                _log.warn((Object)sb.toString());
            }
            return newTemplate;
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMTemplate template) throws Exception {
        Element templateElement = portletDataContext.getExportDataElement((ClassedModel)template);
        DDMStructure structure = DDMStructureLocalServiceUtil.fetchStructure((long)template.getClassPK());
        if (structure != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)template, (StagedModel)structure, (String)"strong");
        }
        if (template.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.fetchImage((long)template.getSmallImageId());
            if (Validator.isNotNull((String)template.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)template, (Element)templateElement, (String)template.getSmallImageURL().concat(" "), (boolean)true);
                template.setSmallImageURL(smallImageURL);
            } else if (smallImage != null) {
                String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)template, (String)(String.valueOf(smallImage.getImageId()) + "." + template.getSmallImageType()));
                templateElement.addAttribute("small-image-path", smallImagePath);
                template.setSmallImageType(smallImage.getType());
                portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
            }
        }
        if (portletDataContext.getBooleanParameter("dynamic_data_mapping", "referenced-content")) {
            String content = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)template, (Element)templateElement, (String)template.getScript(), (boolean)true);
            template.setScript(content);
        }
        portletDataContext.addClassedModel(templateElement, ExportImportPathUtil.getModelPath((StagedModel)template), (ClassedModel)template);
    }

    protected void doImportCompanyStagedModel(PortletDataContext portletDataContext, DDMTemplate template) throws Exception {
        DDMTemplate existingTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplateByUuidAndGroupId((String)template.getUuid(), (long)portletDataContext.getCompanyGroupId());
        Map templateIds = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class);
        templateIds.put(template.getTemplateId(), existingTemplate.getTemplateId());
        Map templateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
        templateKeys.put(template.getTemplateKey(), existingTemplate.getTemplateKey());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMTemplate template) throws Exception {
        long userId = portletDataContext.getUserId(template.getUserUuid());
        long classPK = template.getClassPK();
        Element structureElement = portletDataContext.getReferenceDataElement((StagedModel)template, DDMStructure.class, classPK);
        if (structureElement != null) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)structureElement);
            Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
            classPK = MapUtil.getLong((Map)structureIds, (long)classPK, (long)classPK);
        }
        File smallFile = null;
        try {
            if (template.isSmallImage()) {
                byte[] bytes;
                Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)template);
                String smallImagePath = element.attributeValue("small-image-path");
                if (Validator.isNotNull((String)template.getSmallImageURL())) {
                    String smallImageURL = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (Element)element, (String)template.getSmallImageURL(), (boolean)true);
                    template.setSmallImageURL(smallImageURL);
                } else if (Validator.isNotNull((String)smallImagePath) && (bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath)) != null) {
                    smallFile = FileUtil.createTempFile((String)template.getSmallImageType());
                    FileUtil.write((File)smallFile, (byte[])bytes);
                }
            }
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)template);
            DDMTemplate importedTemplate = null;
            if (portletDataContext.isDataStrategyMirror()) {
                DDMTemplate existingTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplateByUuidAndGroupId((String)template.getUuid(), (long)portletDataContext.getScopeGroupId());
                if (existingTemplate == null) {
                    serviceContext.setUuid(template.getUuid());
                    importedTemplate = this.addTemplate(userId, portletDataContext.getScopeGroupId(), template, classPK, smallFile, serviceContext);
                } else {
                    importedTemplate = DDMTemplateLocalServiceUtil.updateTemplate((long)existingTemplate.getTemplateId(), (long)template.getClassPK(), (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
                }
            } else {
                importedTemplate = this.addTemplate(userId, portletDataContext.getScopeGroupId(), template, classPK, smallFile, serviceContext);
            }
            portletDataContext.importClassedModel((ClassedModel)template, (ClassedModel)importedTemplate);
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            ddmTemplateKeys.put(template.getTemplateKey(), importedTemplate.getTemplateKey());
        }
        finally {
            if (smallFile != null) {
                smallFile.delete();
            }
        }
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        DDMTemplate template = DDMTemplateLocalServiceUtil.fetchDDMTemplateByUuidAndGroupId((String)uuid, (long)groupId);
        return template != null;
    }
}

