/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.util.Locale;
import java.util.Map;

public class DDMStructureStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMStructure> {
    public static final String[] CLASS_NAMES = new String[]{DDMStructure.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchDDMStructureByUuidAndGroupId((String)uuid, (long)groupId);
        if (ddmStructure != null) {
            DDMStructureLocalServiceUtil.deleteStructure((DDMStructure)ddmStructure);
        }
    }

    public void doImportCompanyStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        DDMStructure existingStructure = DDMStructureLocalServiceUtil.fetchDDMStructureByUuidAndGroupId((String)structure.getUuid(), (long)portletDataContext.getCompanyGroupId());
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        structureIds.put(structure.getStructureId(), existingStructure.getStructureId());
        Map structureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        structureKeys.put(structure.getStructureKey(), existingStructure.getStructureKey());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMStructure structure) {
        return structure.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        long defaultUserId;
        Element structureElement = portletDataContext.getExportDataElement((ClassedModel)structure);
        if (structure.getParentStructureId() != 0L) {
            DDMStructure parentStructure = DDMStructureLocalServiceUtil.getStructure((long)structure.getParentStructureId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)structure, (StagedModel)parentStructure, (String)"parent");
        }
        if ((defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)structure.getCompanyId())) == structure.getUserId()) {
            structureElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(structureElement, ExportImportPathUtil.getModelPath((StagedModel)structure), (ClassedModel)structure);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        this.prepareLanguagesForImport(structure);
        long userId = portletDataContext.getUserId(structure.getUserUuid());
        if (structure.getParentStructureId() != 0L) {
            Element structureElement = portletDataContext.getReferenceDataElement((StagedModel)structure, DDMStructure.class, structure.getParentStructureId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)structureElement);
        }
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long parentStructureId = MapUtil.getLong((Map)structureIds, (long)structure.getParentStructureId(), (long)structure.getParentStructureId());
        Map structureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)structure);
        DDMStructure importedStructure = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)structure);
            boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
            DDMStructure existingStructure = null;
            existingStructure = !preloaded ? DDMStructureLocalServiceUtil.fetchDDMStructureByUuidAndGroupId((String)structure.getUuid(), (long)portletDataContext.getScopeGroupId()) : DDMStructureLocalServiceUtil.fetchStructure((long)portletDataContext.getScopeGroupId(), (long)structure.getClassNameId(), (String)structure.getStructureKey());
            if (existingStructure == null) {
                serviceContext.setUuid(structure.getUuid());
                importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentStructureId, (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
            } else {
                importedStructure = DDMStructureLocalServiceUtil.updateStructure((long)existingStructure.getStructureId(), (long)parentStructureId, (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (ServiceContext)serviceContext);
            }
        } else {
            importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentStructureId, (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)structure, (ClassedModel)importedStructure);
        structureKeys.put(structure.getStructureKey(), importedStructure.getStructureKey());
    }

    protected void prepareLanguagesForImport(DDMStructure structure) throws PortalException {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)structure.getDefaultLanguageId());
        Locale[] availableLocales = LocaleUtil.fromLanguageIds((String[])structure.getAvailableLanguageIds());
        Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale((String)DDMStructure.class.getName(), (long)structure.getPrimaryKey(), (Locale)defaultLocale, (Locale[])availableLocales);
        structure.prepareLocalizedFieldsForImport(defaultImportLocale);
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        DDMStructure structure = DDMStructureLocalServiceUtil.fetchDDMStructureByUuidAndGroupId((String)uuid, (long)groupId);
        return structure != null;
    }
}

