/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.action;

import com.liferay.portal.LocaleException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.RequiredStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateElementException;
import com.liferay.portlet.dynamicdatamapping.StructureNameException;
import com.liferay.portlet.dynamicdatamapping.StructureXsdException;
import com.liferay.portlet.dynamicdatamapping.action.ActionUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditStructureAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        DDMStructure structure = null;
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                structure = this.updateStructure(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteStructures(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                boolean saveAndContinue;
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                if (structure != null && (saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue"))) {
                    redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, structure, redirect);
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchStructureException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_mapping.error");
            }
            if (e2 instanceof LocaleException || e2 instanceof RequiredStructureException || e2 instanceof StructureDuplicateElementException || e2 instanceof StructureNameException || e2 instanceof StructureXsdException) {
                String redirect;
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
                if (e2 instanceof RequiredStructureException && Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)renderRequest, (String)"cmd");
            if (!cmd.equals("add")) {
                ActionUtil.getStructure((PortletRequest)renderRequest);
            }
        }
        catch (NoSuchStructureException noSuchStructureException) {
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.dynamic_data_mapping.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.dynamic_data_mapping.edit_structure"));
    }

    protected void deleteStructures(ActionRequest actionRequest) throws Exception {
        long[] deleteStructureIds = null;
        long structureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        deleteStructureIds = structureId > 0L ? new long[]{structureId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteStructureIds"), (long)0L);
        long[] lArray = deleteStructureIds;
        int n = deleteStructureIds.length;
        int n2 = 0;
        while (n2 < n) {
            long deleteStructureId = lArray[n2];
            DDMStructureServiceUtil.deleteStructure((long)deleteStructureId);
            ++n2;
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, DDMStructure structure, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String availableFields = ParamUtil.getString((PortletRequest)actionRequest, (String)"availableFields");
        String eventName = ParamUtil.getString((PortletRequest)actionRequest, (String)"eventName");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("struts_action", "/dynamic_data_mapping/edit_structure");
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("groupId", String.valueOf(structure.getGroupId()), false);
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        portletURL.setParameter("classNameId", String.valueOf(classNameId), false);
        portletURL.setParameter("classPK", String.valueOf(structure.getStructureId()), false);
        portletURL.setParameter("availableFields", availableFields, false);
        portletURL.setParameter("eventName", eventName, false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected DDMStructure updateStructure(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long scopeClassNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scopeClassNameId");
        long parentStructureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentStructureId", (long)0L);
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String xsd = ParamUtil.getString((PortletRequest)actionRequest, (String)"xsd");
        String storageType = ParamUtil.getString((PortletRequest)actionRequest, (String)"storageType");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMStructure.class.getName(), (PortletRequest)actionRequest);
        DDMStructure structure = null;
        if (cmd.equals("add")) {
            structure = DDMStructureServiceUtil.addStructure((long)groupId, (long)parentStructureId, (long)scopeClassNameId, null, (Map)nameMap, (Map)descriptionMap, (String)xsd, (String)storageType, (int)0, (ServiceContext)serviceContext);
        } else if (cmd.equals("update")) {
            structure = DDMStructureServiceUtil.updateStructure((long)classPK, (long)parentStructureId, (Map)nameMap, (Map)descriptionMap, (String)xsd, (ServiceContext)serviceContext);
        }
        return structure;
    }
}

