/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.portlet.PortletURL;

public class DDLIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{DDLRecord.class.getName()};
    public static final String PORTLET_ID = "167";
    private static Log _log = LogFactoryUtil.getLog(DDLIndexer.class);

    public DDLIndexer() {
        this.setFilterSearch(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long recordSetId;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
        if ((recordSetId = GetterUtil.getLong((Object)searchContext.getAttribute("recordSetId"))) > 0L) {
            contextQuery.addRequiredTerm("recordSetId", recordSetId);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        TreeSet<DDMStructure> ddmStructuresSet = new TreeSet<DDMStructure>();
        long recordSetId = GetterUtil.getLong((Object)searchContext.getAttribute("recordSetId"));
        if (recordSetId > 0L) {
            DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getRecordSet((long)recordSetId);
            ddmStructuresSet.add(recordSet.getDDMStructure());
        } else {
            long[] groupIds = searchContext.getGroupIds();
            if (ArrayUtil.isNotEmpty((long[])groupIds)) {
                List ddmStructures = DDMStructureLocalServiceUtil.getStructures((long[])groupIds);
                ddmStructuresSet.addAll(ddmStructures);
            }
        }
        BooleanQuery ddmStructureQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        for (DDMStructure ddmStructure : ddmStructuresSet) {
            this.addSearchDDMStruture(searchQuery, searchContext, ddmStructure);
        }
        if (ddmStructureQuery.hasClauses()) {
            searchQuery.add((Query)ddmStructureQuery, BooleanClauseOccur.MUST);
        }
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
    }

    protected void doDelete(Object obj) throws Exception {
        DDLRecord record = (DDLRecord)obj;
        this.deleteDocument(record.getCompanyId(), record.getRecordId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        DDLRecord record = (DDLRecord)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)record);
        DDLRecordVersion recordVersion = record.getRecordVersion();
        document.addKeyword("status", recordVersion.getStatus());
        document.addKeyword("version", recordVersion.getVersion());
        document.addKeyword("recordSetId", recordVersion.getRecordSetId());
        DDLRecordSet recordSet = recordVersion.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
        DDMIndexerUtil.addAttributes((Document)document, (DDMStructure)ddmStructure, (Fields)fields);
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        long recordSetId = GetterUtil.getLong((String)document.get("recordSetId"));
        String title = this.getTitle(recordSetId, locale);
        String recordId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/dynamic_data_lists/view_record");
        portletURL.setParameter("recordId", recordId);
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        summary.setTitle(title);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        DDLRecord record = (DDLRecord)obj;
        DDLRecordVersion recordVersion = record.getRecordVersion();
        if (!recordVersion.isApproved()) {
            return;
        }
        Document document = this.getDocument(record);
        if (document != null) {
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)record.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DDLRecord record = DDLRecordLocalServiceUtil.getRecord((long)classPK);
        this.doReindex(record);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexRecords(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected String getTitle(long recordSetId, Locale locale) {
        try {
            DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getRecordSet((long)recordSetId);
            DDMStructure ddmStructure = recordSet.getDDMStructure();
            String ddmStructureName = ddmStructure.getName(locale);
            String recordSetName = recordSet.getName(locale);
            return LanguageUtil.format((Locale)locale, (String)"new-x-for-list-x", (Object[])new Object[]{ddmStructureName, recordSetName});
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return "";
        }
    }

    protected void reindexRecords(long companyId) throws Exception {
        Long[] minAndMaxRecordIds = DDLRecordLocalServiceUtil.getMinAndMaxCompanyRecordIds((long)companyId, (int)0, (int)0);
        if (minAndMaxRecordIds[0] == null || minAndMaxRecordIds[1] == null) {
            return;
        }
        long minRecordId = minAndMaxRecordIds[0];
        long maxRecordId = minAndMaxRecordIds[1];
        long startRecordId = minRecordId;
        long endRecordId = startRecordId + 10000L;
        while (startRecordId <= maxRecordId) {
            this.reindexRecords(companyId, startRecordId, endRecordId);
            startRecordId = endRecordId;
            endRecordId += 10000L;
        }
    }

    protected void reindexRecords(long companyId, long startRecordId, long endRecordId) throws Exception {
        List records = DDLRecordLocalServiceUtil.getMinAndMaxCompanyRecords((long)companyId, (int)0, (int)0, (long)startRecordId, (long)endRecordId);
        ArrayList<Document> documents = new ArrayList<Document>(records.size());
        for (DDLRecord record : records) {
            Document document = this.getDocument(record);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

