/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.templateparser.Transformer;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.NoSuchRecordException;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.DDL;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class DDLImpl
implements DDL {
    private static Log _log = LogFactoryUtil.getLog(DDLImpl.class);
    private Transformer _transformer = new Transformer("dynamic.data.lists.error.template", false);

    public JSONObject getRecordJSONObject(DDLRecord record) throws Exception {
        return this.getRecordJSONObject(record, false);
    }

    public JSONObject getRecordJSONObject(DDLRecord record, boolean latestRecordVersion) throws Exception {
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (String fieldName : ddmStructure.getFieldNames()) {
            jsonObject.put(fieldName, "");
        }
        jsonObject.put("displayIndex", record.getDisplayIndex());
        jsonObject.put("recordId", record.getRecordId());
        DDLRecordVersion recordVersion = record.getRecordVersion();
        if (latestRecordVersion) {
            recordVersion = record.getLatestRecordVersion();
        }
        Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
        for (Field field : fields) {
            String fieldName = field.getName();
            String fieldType = field.getType();
            Serializable fieldValue = field.getValue();
            if (fieldValue instanceof Date) {
                jsonObject.put(fieldName, ((Date)fieldValue).getTime());
                continue;
            }
            if (fieldType.equals("ddm-documentlibrary") && Validator.isNotNull((Object)fieldValue)) {
                JSONObject fieldValueJSONObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(fieldValue));
                String uuid = fieldValueJSONObject.getString("uuid");
                long groupId = fieldValueJSONObject.getLong("groupId");
                fieldValueJSONObject.put("title", this.getFileEntryTitle(uuid, groupId));
                jsonObject.put(fieldName, fieldValueJSONObject.toString());
                continue;
            }
            if ((fieldType.equals("radio") || fieldType.equals("select")) && Validator.isNotNull((Object)fieldValue)) {
                fieldValue = JSONFactoryUtil.createJSONArray((String)String.valueOf(fieldValue));
                jsonObject.put(fieldName, (JSONArray)fieldValue);
                continue;
            }
            jsonObject.put(fieldName, String.valueOf(fieldValue));
        }
        return jsonObject;
    }

    public List<DDLRecord> getRecords(Hits hits) throws Exception {
        ArrayList<DDLRecord> records = new ArrayList<DDLRecord>();
        List documents = hits.toList();
        for (Document document : documents) {
            long recordId = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                DDLRecord record = DDLRecordLocalServiceUtil.getRecord((long)recordId);
                records.add(record);
            }
            catch (NoSuchRecordException noSuchRecordException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("DDL record index is stale and contains record " + recordId));
                }
                Indexer indexer = IndexerRegistryUtil.getIndexer(DDLRecord.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
            }
        }
        return records;
    }

    public JSONArray getRecordSetJSONArray(DDLRecordSet recordSet) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Map fieldsMap = ddmStructure.getFieldsMap();
        for (Map fields : fieldsMap.values()) {
            String name = (String)fields.get("name");
            if (ddmStructure.isFieldPrivate(name)) continue;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            String dataType = (String)fields.get("dataType");
            jsonObject.put("dataType", dataType);
            boolean editable = GetterUtil.getBoolean((String)((String)fields.get("editable")), (boolean)true);
            jsonObject.put("editable", editable);
            String label = (String)fields.get("label");
            jsonObject.put("label", label);
            jsonObject.put("name", name);
            boolean required = GetterUtil.getBoolean((String)((String)fields.get("required")));
            jsonObject.put("required", required);
            boolean sortable = GetterUtil.getBoolean((String)((String)fields.get("sortable")), (boolean)true);
            jsonObject.put("sortable", sortable);
            String type = (String)fields.get("type");
            jsonObject.put("type", type);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getRecordsJSONArray(DDLRecordSet recordSet) throws Exception {
        return this.getRecordsJSONArray(recordSet.getRecords(), false);
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDLRecord record : records) {
            JSONObject jsonObject = this.getRecordJSONObject(record);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records, boolean latestRecordVersion) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDLRecord record : records) {
            JSONObject jsonObject = this.getRecordJSONObject(record, latestRecordVersion);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public String getTemplateContent(long ddmTemplateId, DDLRecordSet recordSet, ThemeDisplay themeDisplay, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        contextObjects.put("reserved_ddm_structure_id", recordSet.getDDMStructureId());
        contextObjects.put("reserved_ddm_template_id", ddmTemplateId);
        contextObjects.put("reserved_record_set_description", recordSet.getDescription(themeDisplay.getLocale()));
        contextObjects.put("reserved_record_set_id", recordSet.getRecordSetId());
        contextObjects.put("reserved_record_set_name", recordSet.getName(themeDisplay.getLocale()));
        contextObjects.put("template_id", ddmTemplateId);
        String viewMode = ParamUtil.getString((PortletRequest)renderRequest, (String)"viewMode");
        if (Validator.isNull((String)viewMode)) {
            viewMode = "view";
        }
        contextObjects.put("viewMode", viewMode);
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)ddmTemplateId);
        return this._transformer.transform(themeDisplay, contextObjects, ddmTemplate.getScript(), ddmTemplate.getLanguage());
    }

    public boolean isEditable(HttpServletRequest request, String portletId, long groupId) throws Exception {
        boolean defaultValue = ParamUtil.getBoolean((HttpServletRequest)request, (String)"editable", (boolean)true);
        return this.isEditable(portletId, groupId, defaultValue);
    }

    public boolean isEditable(PortletPreferences preferences, String portletId, long groupId) throws Exception {
        boolean defaultValue = GetterUtil.getBoolean((String)preferences.getValue("editable", null), (boolean)true);
        return this.isEditable(portletId, groupId, defaultValue);
    }

    public DDLRecord updateRecord(long recordId, long recordSetId, boolean mergeFields, boolean checkPermission, ServiceContext serviceContext) throws Exception {
        DDLRecord record = DDLRecordLocalServiceUtil.fetchRecord((long)recordId);
        PortletPreferences preferences = PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)serviceContext.getPortletPreferencesIds());
        if (!this.isEditable(preferences, serviceContext.getPortletId(), serviceContext.getScopeGroupId())) {
            return record;
        }
        boolean majorVersion = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"majorVersion");
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getDDLRecordSet((long)recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = DDMUtil.getFields((long)ddmStructure.getStructureId(), (ServiceContext)serviceContext);
        record = record != null ? (checkPermission ? DDLRecordServiceUtil.updateRecord((long)recordId, (boolean)majorVersion, (int)0, (Fields)fields, (boolean)mergeFields, (ServiceContext)serviceContext) : DDLRecordLocalServiceUtil.updateRecord((long)serviceContext.getUserId(), (long)recordId, (boolean)majorVersion, (int)0, (Fields)fields, (boolean)mergeFields, (ServiceContext)serviceContext)) : (checkPermission ? DDLRecordServiceUtil.addRecord((long)serviceContext.getScopeGroupId(), (long)recordSetId, (int)0, (Fields)fields, (ServiceContext)serviceContext) : DDLRecordLocalServiceUtil.addRecord((long)serviceContext.getUserId(), (long)serviceContext.getScopeGroupId(), (long)recordSetId, (int)0, (Fields)fields, (ServiceContext)serviceContext));
        return record;
    }

    public DDLRecord updateRecord(long recordId, long recordSetId, boolean mergeFields, ServiceContext serviceContext) throws Exception {
        return this.updateRecord(recordId, recordSetId, mergeFields, true, serviceContext);
    }

    protected String getFileEntryTitle(String uuid, long groupId) {
        try {
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
            return fileEntry.getTitle();
        }
        catch (Exception exception) {
            return LanguageUtil.format((Locale)LocaleUtil.getSiteDefault(), (String)"is-temporarily-unavailable", (Object)"content");
        }
    }

    protected boolean isEditable(String portletId, long groupId, boolean defaultValue) throws Exception {
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        if (rootPortletId.equals("167")) {
            return true;
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group == null || group.isInStagingPortlet(portletId)) {
            return false;
        }
        return defaultValue;
    }
}

