/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DL;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import com.liferay.portlet.documentlibrary.util.PDFProcessorUtil;
import com.liferay.portlet.documentlibrary.util.VideoProcessorUtil;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelCreateDateComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelNameComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelReadCountComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelSizeComparator;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.util.ContentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DLImpl
implements DL {
    private static final String _DEFAULT_FILE_ICON = "page";
    private static final String _DEFAULT_GENERIC_NAME = "default";
    private static final long _DIVISOR = 256L;
    private static final String _STRUCTURE_KEY_PREFIX = "AUTO_";
    private static Log _log;
    private static Set<String> _allMediaGalleryMimeTypes;
    private static String _allMediaGalleryMimeTypesString;
    private static Set<String> _fileIcons;
    private static Map<String, String> _genericNames;

    static {
        String[] genericNames;
        _log = LogFactoryUtil.getLog(DLImpl.class);
        _allMediaGalleryMimeTypes = new TreeSet<String>();
        _fileIcons = new HashSet<String>();
        _genericNames = new HashMap<String, String>();
        _allMediaGalleryMimeTypes.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.audio.mime.types")));
        _allMediaGalleryMimeTypes.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.video.mime.types")));
        _allMediaGalleryMimeTypes.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.image.mime.types")));
        _allMediaGalleryMimeTypesString = StringUtil.merge(_allMediaGalleryMimeTypes);
        String[] fileIcons = null;
        try {
            fileIcons = PropsUtil.getArray((String)"dl.file.icons");
        }
        catch (Exception e2) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e2, (Throwable)e2);
            }
            fileIcons = new String[]{""};
        }
        int i2 = 0;
        while (i2 < fileIcons.length) {
            if (!"*".equals(fileIcons[i2])) {
                String extension = fileIcons[i2];
                if (extension.length() > 0) {
                    extension = extension.substring(1);
                }
                _fileIcons.add(extension);
            }
            ++i2;
        }
        String[] stringArray = genericNames = PropsUtil.getArray((String)"dl.file.generic.names");
        int n = genericNames.length;
        int n2 = 0;
        while (n2 < n) {
            String genericName = stringArray[n2];
            DLImpl._populateGenericNamesMap(genericName);
            ++n2;
        }
    }

    public void addPortletBreadcrumbEntries(DLFileShortcut dlFileShortcut, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder = dlFileShortcut.getFolder();
        if (folder.getFolderId() != 0L) {
            this.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        DLFileShortcut unescapedDLFileShortcut = dlFileShortcut.toUnescapedModel();
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(dlFileShortcut.getToFileEntryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedDLFileShortcut.getToTitle(), (String)portletURL.toString());
    }

    public void addPortletBreadcrumbEntries(FileEntry fileEntry, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder = fileEntry.getFolder();
        if (folder.getFolderId() != 0L) {
            this.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        PortletURL portletURL = renderResponse.createRenderURL();
        FileEntry unescapedFileEntry = (FileEntry)fileEntry.toUnescapedModel();
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntry.getFileEntryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFileEntry.getTitle(), (String)portletURL.toString());
    }

    public void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, LiferayPortletResponse liferayPortletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("direction-right", Boolean.TRUE.toString());
        data.put("folder-id", this.getDefaultFolderId(request));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString(), data);
        this.addPortletBreadcrumbEntries(folder, request, portletURL);
    }

    public void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, PortletURL portletURL) throws Exception {
        long defaultFolderId = this.getDefaultFolderId(request);
        List ancestorFolders = Collections.emptyList();
        if (folder != null && folder.getFolderId() != defaultFolderId) {
            ancestorFolders = folder.getAncestors();
            int indexOfRootFolder = -1;
            int i2 = 0;
            while (i2 < ancestorFolders.size()) {
                Folder ancestorFolder = (Folder)ancestorFolders.get(i2);
                if (defaultFolderId == ancestorFolder.getFolderId()) {
                    indexOfRootFolder = i2;
                }
                ++i2;
            }
            if (indexOfRootFolder > -1) {
                ancestorFolders = ancestorFolders.subList(0, indexOfRootFolder);
            }
        }
        Collections.reverse(ancestorFolders);
        for (Folder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", ancestorFolder.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString(), data);
        }
        long folderId = 0L;
        if (folder != null) {
            folderId = folder.getFolderId();
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        if (folderId != 0L && folderId != defaultFolderId) {
            Folder unescapedFolder = (Folder)folder.toUnescapedModel();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", folderId);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFolder.getName(), (String)portletURL.toString(), data);
        }
    }

    public void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (strutsAction.equals("/document_library/select_file_entry") || strutsAction.equals("/document_library/select_folder") || strutsAction.equals("/document_library_display/select_folder") || strutsAction.equals("/dynamic_data_mapping/select_document_library") || strutsAction.equals("/image_gallery_display/select_folder")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            portletURL.setParameter("struts_action", strutsAction);
            portletURL.setParameter("groupId", String.valueOf(groupId));
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/document_library/view");
        }
        this.addPortletBreadcrumbEntries(folder, request, portletURL);
    }

    public void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder;
        if (folderId != 0L && (folder = DLAppLocalServiceUtil.getFolder((long)folderId)).getFolderId() != 0L) {
            this.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
    }

    public int compareVersions(String version1, String version2) {
        int[] splitVersion1 = StringUtil.split((String)version1, (String)".", (int)0);
        int[] splitVersion2 = StringUtil.split((String)version2, (String)".", (int)0);
        if (splitVersion1.length != 2 && splitVersion2.length != 2) {
            return 0;
        }
        if (splitVersion1.length != 2) {
            return -1;
        }
        if (splitVersion2.length != 2) {
            return 1;
        }
        if (splitVersion1[0] > splitVersion2[0]) {
            return 1;
        }
        if (splitVersion1[0] < splitVersion2[0]) {
            return -1;
        }
        if (splitVersion1[1] > splitVersion2[1]) {
            return 1;
        }
        if (splitVersion1[1] < splitVersion2[1]) {
            return -1;
        }
        return 0;
    }

    public String getAbsolutePath(PortletRequest portletRequest, long folderId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L) {
            return themeDisplay.translate("home");
        }
        Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
        List folders = folder.getAncestors();
        Collections.reverse(folders);
        StringBundler sb = new StringBundler(folders.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (Folder curFolder : folders) {
            sb.append("&raquo;");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append("&raquo;");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    public Set<String> getAllMediaGalleryMimeTypes() {
        return _allMediaGalleryMimeTypes;
    }

    public String getDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDDMStructureKey(dlFileEntryType.getUuid());
    }

    public String getDDMStructureKey(String fileEntryTypeUuid) {
        return _STRUCTURE_KEY_PREFIX + StringUtil.toUpperCase((String)fileEntryTypeUuid);
    }

    public String getDeprecatedDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDeprecatedDDMStructureKey(dlFileEntryType.getFileEntryTypeId());
    }

    public String getDeprecatedDDMStructureKey(long fileEntryTypeId) {
        return _STRUCTURE_KEY_PREFIX + fileEntryTypeId;
    }

    public String getDividedPath(long id) {
        StringBundler sb = new StringBundler(16);
        long dividend = id;
        while (dividend / 256L != 0L) {
            sb.append("/");
            sb.append(dividend % 256L);
            dividend /= 256L;
        }
        sb.append("/");
        sb.append(id);
        return sb.toString();
    }

    public String getDLFileEntryControlPanelLink(PortletRequest portletRequest, long fileEntryId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"20", (long)PortalUtil.getControlPanelPlid((long)themeDisplay.getCompanyId()), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntryId));
        return portletURL.toString();
    }

    public String getDLFolderControlPanelLink(PortletRequest portletRequest, long folderId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"20", (long)PortalUtil.getControlPanelPlid((long)themeDisplay.getCompanyId()), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/document_library/view");
        portletURL.setParameter("folderId", String.valueOf(folderId));
        return portletURL.toString();
    }

    public Map<Locale, String> getEmailFileEntryAddedBodyMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailFileEntryAddedBody");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getSiteDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get((String)"dl.email.file.entry.added.body")));
        return map;
    }

    public boolean getEmailFileEntryAddedEnabled(PortletPreferences preferences) {
        String emailFileEntryAddedEnabled = preferences.getValue("emailFileEntryAddedEnabled", "");
        if (Validator.isNotNull((String)emailFileEntryAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailFileEntryAddedEnabled);
        }
        return PropsValues.DL_EMAIL_FILE_ENTRY_ADDED_ENABLED;
    }

    public Map<Locale, String> getEmailFileEntryAddedSubjectMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailFileEntryAddedSubject");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getSiteDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get((String)"dl.email.file.entry.added.subject")));
        return map;
    }

    public Map<Locale, String> getEmailFileEntryUpdatedBodyMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailFileEntryUpdatedBody");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getSiteDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get((String)"dl.email.file.entry.updated.body")));
        return map;
    }

    public boolean getEmailFileEntryUpdatedEnabled(PortletPreferences preferences) {
        String emailFileEntryUpdatedEnabled = preferences.getValue("emailFileEntryUpdatedEnabled", "");
        if (Validator.isNotNull((String)emailFileEntryUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailFileEntryUpdatedEnabled);
        }
        return PropsValues.DL_EMAIL_FILE_ENTRY_UPDATED_ENABLED;
    }

    public Map<Locale, String> getEmailFileEntryUpdatedSubjectMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailFileEntryUpdatedSubject");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getSiteDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get((String)"dl.email.file.entry.updated.subject")));
        return map;
    }

    public String getEmailFromAddress(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)preferences, (long)companyId, (String)PropsValues.DL_EMAIL_FROM_ADDRESS);
    }

    public String getEmailFromName(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromName((PortletPreferences)preferences, (long)companyId, (String)PropsValues.DL_EMAIL_FROM_NAME);
    }

    public List<Object> getEntries(Hits hits) {
        ArrayList<Object> entries = new ArrayList<Object>();
        Document[] documentArray = hits.getDocs();
        int n = documentArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Document document = documentArray[n2];
                String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
                long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
                try {
                    FileEntry obj = null;
                    if (entryClassName.equals(DLFileEntry.class.getName())) {
                        obj = DLAppLocalServiceUtil.getFileEntry((long)entryClassPK);
                    } else if (entryClassName.equals(MBMessage.class.getName())) {
                        long classPK = GetterUtil.getLong((String)document.get("classPK"));
                        DLAppLocalServiceUtil.getFileEntry((long)classPK);
                        obj = MBMessageLocalServiceUtil.getMessage((long)entryClassPK);
                    }
                    entries.add(obj);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)("Documents and Media search index is stale and contains entry {className=" + entryClassName + ", classPK=" + entryClassPK + "}"));
                }
            }
            ++n2;
        }
        return entries;
    }

    public String getFileEntryImage(FileEntry fileEntry, ThemeDisplay themeDisplay) {
        StringBundler sb = new StringBundler(5);
        sb.append("<img style=\"border-width: 0; text-align: left;\" src=\"");
        sb.append(themeDisplay.getPathThemeImages());
        sb.append("/file_system/small/");
        sb.append(fileEntry.getIcon());
        sb.append(".png\">");
        return sb.toString();
    }

    public Set<Long> getFileEntryTypeSubscriptionClassPKs(long userId) throws SystemException {
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)userId, (String)DLFileEntryType.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    public String getFileIcon(String extension) {
        if (!_fileIcons.contains(extension)) {
            extension = _DEFAULT_FILE_ICON;
        }
        return extension;
    }

    public String getGenericName(String extension) {
        String genericName = _genericNames.get(extension);
        if (genericName == null) {
            genericName = _DEFAULT_GENERIC_NAME;
        }
        return genericName;
    }

    public String getImagePreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay) throws Exception {
        String previewQueryString = null;
        if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            if (ImageProcessorUtil.hasImages((FileVersion)fileVersion)) {
                previewQueryString = "&imagePreview=1";
            } else if (PDFProcessorUtil.hasImages((FileVersion)fileVersion)) {
                previewQueryString = "&previewFileIndex=1";
            } else if (VideoProcessorUtil.hasVideo((FileVersion)fileVersion)) {
                previewQueryString = "&videoThumbnail=1";
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, previewQueryString);
    }

    public String getImagePreviewURL(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        return this.getImagePreviewURL(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    public String[] getMediaGalleryMimeTypes(PortletPreferences portletPreferences, PortletRequest portletRequest) {
        String mimeTypes = PrefsParamUtil.getString((PortletPreferences)portletPreferences, (PortletRequest)portletRequest, (String)"mimeTypes", (String)_allMediaGalleryMimeTypesString);
        Object[] mimeTypesArray = StringUtil.split((String)mimeTypes);
        Arrays.sort(mimeTypesArray);
        return mimeTypesArray;
    }

    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendToken) {
        return this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String portletId;
        PortletDisplay portletDisplay;
        StringBundler sb = new StringBundler(17);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        String title = fileEntry.getTitle();
        if (fileEntry.isInTrash()) {
            title = TrashUtil.getOriginalTitle((String)fileEntry.getTitle());
        }
        sb.append(HttpUtil.encodeURL((String)HtmlUtil.unescape((String)title)));
        sb.append("/");
        sb.append(fileEntry.getUuid());
        if (appendVersion) {
            sb.append("?version=");
            sb.append(fileVersion.getVersion());
        }
        if (ImageProcessorUtil.isImageSupported((FileVersion)fileVersion)) {
            if (appendVersion) {
                sb.append("&t=");
            } else {
                sb.append("?t=");
            }
            Date modifiedDate = fileVersion.getModifiedDate();
            sb.append(modifiedDate.getTime());
        }
        sb.append(queryString);
        if (themeDisplay != null && (portletDisplay = themeDisplay.getPortletDisplay()) != null && (portletId = portletDisplay.getId()).equals("182")) {
            sb.append("&status=");
            sb.append(8);
        }
        String previewURL = sb.toString();
        if (themeDisplay != null && themeDisplay.isAddSessionIdToURL()) {
            return PortalUtil.getURLWithSessionId((String)previewURL, (String)themeDisplay.getSessionId());
        }
        return previewURL;
    }

    public OrderByComparator getRepositoryModelOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = true;
        if (orderByType.equals("desc")) {
            orderByAsc = false;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("creationDate") ? new RepositoryModelCreateDateComparator(orderByAsc) : (orderByCol.equals("downloads") ? new RepositoryModelReadCountComparator(orderByAsc) : (orderByCol.equals("modifiedDate") ? new RepositoryModelModifiedDateComparator(orderByAsc) : (orderByCol.equals("size") ? new RepositoryModelSizeComparator(orderByAsc) : new RepositoryModelNameComparator(orderByAsc))));
        return orderByComparator;
    }

    public String getTempFileId(long id, String version) {
        return this.getTempFileId(id, version, null);
    }

    public String getTempFileId(long id, String version, String languageId) {
        if (Validator.isNull((String)languageId)) {
            return String.valueOf(id).concat(".").concat(version);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(id);
        sb.append(".");
        sb.append(version);
        sb.append(".");
        sb.append(languageId);
        return sb.toString();
    }

    public String getThumbnailSrc(FileEntry fileEntry, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        return this.getThumbnailSrc(fileEntry, fileEntry.getFileVersion(), dlFileShortcut, themeDisplay);
    }

    public String getThumbnailSrc(FileEntry fileEntry, FileVersion fileVersion, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        String thumbnailQueryString = null;
        if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            if (ImageProcessorUtil.hasImages((FileVersion)fileVersion)) {
                thumbnailQueryString = "&imageThumbnail=1";
            } else if (PDFProcessorUtil.hasImages((FileVersion)fileVersion)) {
                thumbnailQueryString = "&documentThumbnail=1";
            } else if (VideoProcessorUtil.hasVideo((FileVersion)fileVersion)) {
                thumbnailQueryString = "&videoThumbnail=1";
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, thumbnailQueryString);
    }

    public String getThumbnailStyle() throws Exception {
        return this.getThumbnailStyle(true, 0);
    }

    public String getThumbnailStyle(boolean max, int margin) throws Exception {
        StringBundler sb = new StringBundler(5);
        if (max) {
            sb.append("max-height: ");
        } else {
            sb.append("height: ");
        }
        sb.append(PrefsPropsUtil.getLong((String)"dl.file.entry.thumbnail.max.height") + (long)(2 * margin));
        if (max) {
            sb.append("px; max-width: ");
        } else {
            sb.append("px; width: ");
        }
        sb.append(PrefsPropsUtil.getLong((String)"dl.file.entry.thumbnail.max.width") + (long)(2 * margin));
        sb.append("px;");
        return sb.toString();
    }

    public String getTitleWithExtension(FileEntry fileEntry) {
        String title = fileEntry.getTitle();
        String extension = fileEntry.getExtension();
        return this.getTitleWithExtension(title, extension);
    }

    public String getTitleWithExtension(String title, String extension) {
        String periodAndExtension;
        if (Validator.isNotNull((String)extension) && !title.endsWith(periodAndExtension = ".".concat(extension))) {
            title = String.valueOf(title) + periodAndExtension;
        }
        return title;
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry) throws PortalException, SystemException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, false);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired) throws PortalException, SystemException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, manualCheckInRequired, false);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired, boolean openDocumentUrl) throws PortalException, SystemException {
        StringBundler webDavURL = new StringBundler(8);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = PortalUtil.getPortalURL((String)themeDisplay.getServerName(), (int)themeDisplay.getServerPort(), (boolean)secure);
        webDavURL.append(portalURL);
        webDavURL.append(themeDisplay.getPathContext());
        webDavURL.append("/webdav");
        if (manualCheckInRequired) {
            webDavURL.append("/manualCheckInRequired");
        }
        String fileEntryTitle = null;
        if (fileEntry != null) {
            String extension = fileEntry.getExtension();
            fileEntryTitle = HtmlUtil.unescape((String)fileEntry.getTitle());
            if (openDocumentUrl && this.isOfficeExtension(extension) && !fileEntryTitle.endsWith("." + extension)) {
                webDavURL.append("/officeExtension");
                fileEntryTitle = String.valueOf(fileEntryTitle) + "." + extension;
            }
        }
        Group group = themeDisplay.getScopeGroup();
        webDavURL.append(group.getFriendlyURL());
        webDavURL.append("/document_library");
        StringBuilder sb = new StringBuilder();
        if (folder != null && folder.getFolderId() != 0L) {
            Folder curFolder = folder;
            while (true) {
                sb.insert(0, HttpUtil.encodeURL((String)curFolder.getName(), (boolean)true));
                sb.insert(0, "/");
                if (curFolder.getParentFolderId() == 0L) break;
                curFolder = DLAppLocalServiceUtil.getFolder((long)curFolder.getParentFolderId());
            }
        }
        if (fileEntry != null) {
            sb.append("/");
            sb.append(HttpUtil.encodeURL((String)fileEntryTitle, (boolean)true));
        }
        webDavURL.append(sb.toString());
        return webDavURL.toString();
    }

    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, long folderId, long fileEntryTypeId) throws Exception {
        while (folderId != 0L) {
            DLFolder dlFolder = DLFolderLocalServiceUtil.fetchDLFolder((long)folderId);
            if (dlFolder == null) {
                return false;
            }
            if (dlFolder.isOverrideFileEntryTypes()) break;
            folderId = dlFolder.getParentFolderId();
        }
        return WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)companyId, (long)groupId, (String)DLFolderConstants.getClassName(), (long)folderId, (long)fileEntryTypeId) || WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)companyId, (long)groupId, (String)DLFolderConstants.getClassName(), (long)folderId, (long)-1L);
    }

    public boolean isAutoGeneratedDLFileEntryTypeDDMStructureKey(String ddmStructureKey) {
        return ddmStructureKey.startsWith(_STRUCTURE_KEY_PREFIX);
    }

    public boolean isOfficeExtension(String extension) {
        return StringUtil.equalsIgnoreCase((String)extension, (String)"doc") || StringUtil.equalsIgnoreCase((String)extension, (String)"docx") || StringUtil.equalsIgnoreCase((String)extension, (String)"dot") || StringUtil.equalsIgnoreCase((String)extension, (String)"ppt") || StringUtil.equalsIgnoreCase((String)extension, (String)"pptx") || StringUtil.equalsIgnoreCase((String)extension, (String)"xls") || StringUtil.equalsIgnoreCase((String)extension, (String)"xlsx");
    }

    public boolean isSubscribedToFileEntryType(long companyId, long groupId, long userId, long fileEntryTypeId) throws SystemException {
        if (fileEntryTypeId == 0L) {
            fileEntryTypeId = groupId;
        }
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)DLFileEntryType.class.getName(), (long)fileEntryTypeId);
    }

    public boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId) throws PortalException, SystemException {
        return this.isSubscribedToFolder(companyId, groupId, userId, folderId, true);
    }

    public boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId, boolean recursive) throws PortalException, SystemException {
        List<Long> ancestorFolderIds = new ArrayList<Long>();
        if (folderId != 0L) {
            Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
            if (recursive) {
                ancestorFolderIds = folder.getAncestorFolderIds();
                ancestorFolderIds.add(groupId);
            }
            ancestorFolderIds.add(0, folderId);
        } else {
            ancestorFolderIds.add(groupId);
        }
        long[] folderIdsArray = ArrayUtil.toLongArray(ancestorFolderIds);
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)Folder.class.getName(), (long[])folderIdsArray);
    }

    protected long getDefaultFolderId(HttpServletRequest request) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletPreferences((HttpServletRequest)request, (String)PortalUtil.getPortletId((HttpServletRequest)request));
        return GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", String.valueOf(0L)));
    }

    protected String getImageSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append(themeDisplay.getPathThemeImages());
        sb.append("/file_system/large/");
        sb.append(this.getGenericName(fileEntry.getExtension()));
        sb.append(".png");
        String thumbnailSrc = sb.toString();
        if (Validator.isNotNull((String)queryString)) {
            thumbnailSrc = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
        }
        return thumbnailSrc;
    }

    private static void _populateGenericNamesMap(String genericName) {
        String[] extensions;
        String[] stringArray = extensions = PropsUtil.getArray((String)"dl.file.generic.extensions", (Filter)new Filter(genericName));
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            _genericNames.put(extension, genericName);
            ++n2;
        }
    }
}

