/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderActionableDynamicQuery;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;

public class DLFolderIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{DLFolder.class.getName()};
    public static final String PORTLET_ID = "20";
    private static Log _log = LogFactoryUtil.getLog(DLFolderIndexer.class);

    public DLFolderIndexer() {
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)entryClassPK);
        return DLFolderPermission.contains(permissionChecker, dlFolder, "VIEW");
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        this.addStatus(contextQuery, searchContext);
        contextQuery.addRequiredTerm("hidden", false);
    }

    protected void doDelete(Object obj) throws Exception {
        DLFolder dlFolder = (DLFolder)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, dlFolder.getFolderId());
        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)dlFolder.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        DLFolder trashedFolder;
        DLFolder dlFolder = (DLFolder)obj;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing folder " + dlFolder));
        }
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)dlFolder);
        document.addText("description", dlFolder.getDescription());
        document.addKeyword("folderId", dlFolder.getParentFolderId());
        document.addKeyword("hidden", dlFolder.isHidden() || dlFolder.isInHiddenFolder());
        document.addText("title", dlFolder.getName());
        document.addKeyword("treePath", dlFolder.getTreePath());
        document.addKeyword("treePath", StringUtil.split((String)dlFolder.getTreePath(), (char)'/'));
        if (!dlFolder.isInTrash() && dlFolder.isInTrashContainer() && (trashedFolder = dlFolder.getTrashContainer()) != null) {
            this.addTrashFields(document, DLFolder.class.getName(), trashedFolder.getFolderId(), null, null, "document");
            document.addKeyword("rootEntryClassName", DLFolder.class.getName());
            document.addKeyword("rootEntryClassPK", trashedFolder.getFolderId());
            document.addKeyword("status", 8);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + dlFolder + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        liferayPortletURL.setLifecycle("ACTION_PHASE");
        try {
            liferayPortletURL.setWindowState(LiferayWindowState.EXCLUSIVE);
        }
        catch (WindowStateException windowStateException) {}
        String folderId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/document_library/view");
        portletURL.setParameter("folderId", folderId);
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        DLFolder dlFolder = (DLFolder)obj;
        if (!dlFolder.isApproved() && !dlFolder.isInTrash()) {
            return;
        }
        Document document = this.getDocument(dlFolder);
        if (document != null) {
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)dlFolder.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)classPK);
        this.doReindex(dlFolder);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexFolders(long companyId) throws PortalException, SystemException {
        DLFolderActionableDynamicQuery actionableDynamicQuery = new DLFolderActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"mountPoint");
                dynamicQuery.add(property.eq((Object)false));
            }

            protected void performAction(Object object) throws PortalException {
                DLFolder dlFolder = (DLFolder)object;
                Document document = DLFolderIndexer.this.getDocument(dlFolder);
                if (document != null) {
                    this.addDocument(document);
                }
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

