/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.AudioProcessor;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.LiferayAudioConverter;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.liferay.util.log4j.Log4JUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import org.apache.commons.lang.time.StopWatch;

public class AudioProcessorImpl
extends DLPreviewableProcessor
implements AudioProcessor {
    private static final String[] _PREVIEW_TYPES = PropsValues.DL_FILE_ENTRY_PREVIEW_AUDIO_CONTAINERS;
    private static Log _log = LogFactoryUtil.getLog(AudioProcessorImpl.class);
    private Set<String> _audioMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_AUDIO_MIME_TYPES);
    private List<Long> _fileVersionIds = new Vector<Long>();

    public void afterPropertiesSet() {
        boolean valid = true;
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            valid = false;
        } else {
            String[] stringArray = _PREVIEW_TYPES;
            int n = _PREVIEW_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String previewType = stringArray[n2];
                if (!previewType.equals("mp3") && !previewType.equals("ogg")) {
                    valid = false;
                    break;
                }
                ++n2;
            }
        }
        if (!valid && _log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Liferay is incorrectly configured to generate video ");
            sb.append("previews using video containers other than MP3 or ");
            sb.append("OGG. Please change the property ");
            sb.append("dl.file.entry.preview.audio.containers");
            sb.append(" in portal-ext.properties.");
            _log.warn((Object)sb.toString());
        }
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
    }

    public void generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateAudio(sourceFileVersion, destinationFileVersion);
    }

    public Set<String> getAudioMimeTypes() {
        return this._audioMimeTypes;
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, type);
    }

    public boolean hasAudio(FileVersion fileVersion) {
        boolean hasAudio = false;
        try {
            hasAudio = this._hasAudio(fileVersion);
            if (!hasAudio && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return hasAudio;
    }

    public boolean isAudioSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isAudioSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        try {
            if (XugglerUtil.isEnabled()) {
                return this._audioMimeTypes.contains(mimeType);
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void deletePreviews(long companyId, long groupId, long fileEntryId, long fileVersionId) {
        String pathSegment = AudioProcessorImpl.getPathSegment((long)groupId, (long)fileEntryId, (long)fileVersionId, (boolean)true);
        String[] stringArray = _PREVIEW_TYPES;
        int n = _PREVIEW_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String previewType = stringArray[n2];
            String path = String.valueOf(pathSegment) + "." + previewType;
            try {
                DLStoreUtil.deleteDirectory((long)companyId, (long)0L, (String)path);
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasPreviews(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
                return;
            }
            String[] stringArray = _PREVIEW_TYPES;
            int n = _PREVIEW_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String previewType = stringArray[n2];
                if (previewType.equals("mp3") || previewType.equals("ogg")) {
                    this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "audio", previewType);
                }
                ++n2;
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return null;
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            return;
        }
        String[] stringArray = _PREVIEW_TYPES;
        int n = _PREVIEW_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String previewType = stringArray[n2];
            if (previewType.equals("mp3") || previewType.equals("ogg")) {
                this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "audio", previewType);
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void _generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block19: {
            block18: {
                block17: {
                    tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
                    previewTempFiles = new File[AudioProcessorImpl._PREVIEW_TYPES.length];
                    i = 0;
                    while (i < AudioProcessorImpl._PREVIEW_TYPES.length) {
                        previewTempFiles[i] = this.getPreviewTempFile(tempFileId, AudioProcessorImpl._PREVIEW_TYPES[i]);
                        ++i;
                    }
                    audioTempFile = null;
                    inputStream = null;
                    if (sourceFileVersion == null) break block17;
                    this.copy(sourceFileVersion, destinationFileVersion);
                    while (true) {
                        StreamUtil.cleanUp(inputStream);
                        this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                        i = 0;
                        while (i < previewTempFiles.length) {
                            FileUtil.delete((File)previewTempFiles[i]);
                            ++i;
                        }
                        FileUtil.delete((File)audioTempFile);
                        return;
                    }
                }
                try {
                    try {
                        if (!XugglerUtil.isEnabled() || this._hasAudio(destinationFileVersion)) ** continue;
                        audioTempFile = FileUtil.createTempFile((String)destinationFileVersion.getExtension());
                        if (this.hasPreviews(destinationFileVersion)) break block18;
                        file = null;
                        if (destinationFileVersion instanceof LiferayFileVersion) {
                            try {
                                liferayFileVersion = (LiferayFileVersion)destinationFileVersion;
                                file = liferayFileVersion.getFile(false);
                            }
                            catch (UnsupportedOperationException v0) {}
                        }
                        if (file == null) {
                            inputStream = destinationFileVersion.getContentStream(false);
                            FileUtil.write((File)audioTempFile, (InputStream)inputStream);
                            file = audioTempFile;
                        }
                        try {
                            this._generateAudioXuggler(destinationFileVersion, file, previewTempFiles);
                        }
                        catch (Exception e) {
                            AudioProcessorImpl._log.error((Object)e, (Throwable)e);
                        }
                        break block18;
                    }
                    catch (NoSuchFileEntryException v1) {
                        StreamUtil.cleanUp(inputStream);
                        this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                        i = 0;
                        ** while (i < previewTempFiles.length)
                    }
                }
                catch (Throwable var9_15) {
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                    i = 0;
                    ** while (i < previewTempFiles.length)
                }
lbl-1000:
                // 1 sources

                {
                    FileUtil.delete((File)previewTempFiles[i]);
                    ++i;
                    continue;
                }
lbl59:
                // 1 sources

                FileUtil.delete((File)audioTempFile);
                break block19;
lbl-1000:
                // 1 sources

                {
                    FileUtil.delete((File)previewTempFiles[i]);
                    ++i;
                    continue;
                }
lbl72:
                // 1 sources

                FileUtil.delete((File)audioTempFile);
                throw var9_15;
            }
            StreamUtil.cleanUp(inputStream);
            this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            i = 0;
            while (i < previewTempFiles.length) {
                FileUtil.delete((File)previewTempFiles[i]);
                ++i;
            }
            FileUtil.delete((File)audioTempFile);
        }
    }

    private void _generateAudioXuggler(FileVersion fileVersion, File srcFile, File destFile, String containerType) throws Exception {
        if (this.hasPreview(fileVersion, containerType)) {
            return;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        try {
            if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
                LiferayAudioProcessCallable processCallable = new LiferayAudioProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), srcFile.getCanonicalPath(), destFile.getCanonicalPath(), containerType, PropsUtil.getProperties("dl.file.entry.preview.audio.", false));
                Future future = ProcessExecutor.execute((String)ClassPathUtil.getPortalClassPath(), (ProcessCallable)processCallable);
                String processIdentity = String.valueOf(fileVersion.getFileVersionId());
                this.futures.put(processIdentity, future);
                future.get();
            } else {
                LiferayAudioConverter liferayConverter = new LiferayAudioConverter(srcFile.getCanonicalPath(), destFile.getCanonicalPath(), containerType, PropsUtil.getProperties("dl.file.entry.preview.audio.", false));
                ((LiferayConverter)liferayConverter).convert();
            }
        }
        catch (CancellationException cancellationException) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Cancellation received for " + fileVersion.getFileVersionId() + " " + fileVersion.getTitle()));
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), destFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Xuggler generated a " + containerType + " preview audio for " + fileVersion.getFileVersionId() + " in " + stopWatch.getTime() + "ms"));
        }
    }

    private void _generateAudioXuggler(FileVersion fileVersion, File srcFile, File[] destFiles) {
        try {
            int i2 = 0;
            while (i2 < destFiles.length) {
                this._generateAudioXuggler(fileVersion, srcFile, destFiles[i2], _PREVIEW_TYPES[i2]);
                ++i2;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    private boolean _hasAudio(FileVersion fileVersion) throws Exception {
        if (!this.isSupported(fileVersion)) {
            return false;
        }
        return this.hasPreviews(fileVersion);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId()) || !this.isSupported(destinationFileVersion)) {
            return;
        }
        this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
        this.sendGenerationMessage("liferay/document_library_audio_processor", sourceFileVersion, destinationFileVersion);
    }

    private static class LiferayAudioProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private String _audioContainer;
        private Properties _audioProperties;
        private Map<String, String> _customLogSettings;
        private String _inputURL;
        private String _liferayHome;
        private String _outputURL;
        private String _serverId;

        public LiferayAudioProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, String inputURL, String outputURL, String audioContainer, Properties audioProperties) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputURL = inputURL;
            this._outputURL = outputURL;
            this._audioContainer = audioContainer;
            this._audioProperties = audioProperties;
        }

        public String call() throws ProcessException {
            Properties systemProperties = System.getProperties();
            SystemEnv.setProperties((Properties)systemProperties);
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayAudioConverter liferayConverter = new LiferayAudioConverter(this._inputURL, this._outputURL, this._audioContainer, this._audioProperties);
                ((LiferayConverter)liferayConverter).convert();
            }
            catch (Exception e2) {
                throw new ProcessException((Throwable)e2);
            }
            return "";
        }
    }
}

