/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.trash;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.service.RepositoryServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import java.util.ArrayList;
import java.util.List;

public abstract class DLBaseTrashHandler
extends BaseTrashHandler {
    public ContainerModel getContainerModel(long containerModelId) throws PortalException, SystemException {
        if (containerModelId == 0L) {
            return null;
        }
        return this.getDLFolder(containerModelId);
    }

    public String getContainerModelClassName() {
        return DLFolder.class.getName();
    }

    public String getContainerModelName() {
        return "folder";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException, SystemException {
        Repository repository = this.getRepository(classPK);
        List folders = repository.getFolders(parentContainerModelId, false, start, end, null);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>(folders.size());
        for (Folder folder : folders) {
            containerModels.add((ContainerModel)folder.getModel());
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException, SystemException {
        Repository repository = this.getRepository(classPK);
        return repository.getFoldersCount(parentContainerModelId, false);
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException, SystemException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getParentContainerModel(classPK);
        if (containerModel == null) {
            return containerModels;
        }
        containerModels.add(containerModel);
        while (containerModel.getParentContainerModelId() > 0L) {
            if ((containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) == null) break;
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRootContainerModelName() {
        return "home";
    }

    public String getTrashContainedModelName() {
        return "documents";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException, SystemException {
        Repository repository = this.getRepository(classPK);
        return repository.getFileEntriesAndFileShortcutsCount(classPK, -1);
    }

    public List<TrashRenderer> getTrashContainedModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        Repository repository = this.getRepository(classPK);
        List fileEntriesAndFileShortcuts = repository.getFileEntriesAndFileShortcuts(classPK, -1, start, end);
        for (Object fileEntryOrFileShortcut : fileEntriesAndFileShortcuts) {
            String curClassName = "";
            long curClassPK = 0L;
            if (fileEntryOrFileShortcut instanceof DLFileShortcut) {
                DLFileShortcut dlFileShortcut = (DLFileShortcut)fileEntryOrFileShortcut;
                curClassName = DLFileShortcut.class.getName();
                curClassPK = dlFileShortcut.getPrimaryKey();
            } else {
                if (!(fileEntryOrFileShortcut instanceof FileEntry)) continue;
                FileEntry fileEntry = (FileEntry)fileEntryOrFileShortcut;
                curClassName = DLFileEntry.class.getName();
                curClassPK = fileEntry.getPrimaryKey();
            }
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)curClassName);
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(curClassPK);
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public String getTrashContainerModelName() {
        return "folders";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException, SystemException {
        Repository repository = this.getRepository(classPK);
        return repository.getFoldersCount(classPK, false);
    }

    public List<TrashRenderer> getTrashContainerModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        Repository repository = this.getRepository(classPK);
        List folders = repository.getFolders(classPK, false, start, end, null);
        for (Folder folder : folders) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFolder.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(folder.getPrimaryKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public boolean isMovable() {
        return true;
    }

    protected DLFolder fetchDLFolder(long classPK) throws PortalException, SystemException {
        Repository repository = RepositoryServiceUtil.getRepositoryImpl((long)classPK, (long)0L, (long)0L);
        if (!(repository instanceof LiferayRepository)) {
            return null;
        }
        Folder folder = repository.getFolder(classPK);
        return (DLFolder)folder.getModel();
    }

    protected DLFolder getDLFolder(long classPK) throws PortalException, SystemException {
        Repository repository = RepositoryServiceUtil.getRepositoryImpl((long)classPK, (long)0L, (long)0L);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        Folder folder = repository.getFolder(classPK);
        return (DLFolder)folder.getModel();
    }

    protected abstract Repository getRepository(long var1) throws PortalException, SystemException;
}

