/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portlet.documentlibrary.store.Store;
import java.io.File;
import java.io.InputStream;

public class SafeFileNameStoreWrapper
implements Store {
    private Store _store;

    public SafeFileNameStoreWrapper(Store store) {
        this._store = store;
    }

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        if (!safeDirName.equals(dirName)) {
            try {
                this._store.move(dirName, safeDirName);
            }
            catch (Exception exception) {}
        }
        this._store.addDirectory(companyId, repositoryId, safeDirName);
    }

    public void addFile(long companyId, long repositoryId, String fileName, byte[] bytes) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this._store.addFile(companyId, repositoryId, safeFileName, bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this._store.addFile(companyId, repositoryId, safeFileName, file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this._store.addFile(companyId, repositoryId, safeFileName, is);
    }

    public void checkRoot(long companyId) throws SystemException {
        this._store.checkRoot(companyId);
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this._store.copyFileVersion(companyId, repositoryId, safeFileName, fromVersionLabel, toVersionLabel);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        if (!safeDirName.equals(dirName)) {
            try {
                this._store.deleteDirectory(companyId, repositoryId, dirName);
                return;
            }
            catch (Exception exception) {}
        }
        this._store.deleteDirectory(companyId, repositoryId, safeDirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName)) {
            this._store.deleteFile(companyId, repositoryId, fileName);
            return;
        }
        this._store.deleteFile(companyId, repositoryId, safeFileName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            this._store.deleteFile(companyId, repositoryId, fileName, versionLabel);
            return;
        }
        this._store.deleteFile(companyId, repositoryId, safeFileName, versionLabel);
    }

    public File getFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName)) {
            return this._store.getFile(companyId, repositoryId, fileName);
        }
        return this._store.getFile(companyId, repositoryId, safeFileName);
    }

    public File getFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            return this._store.getFile(companyId, repositoryId, fileName, versionLabel);
        }
        return this._store.getFile(companyId, repositoryId, safeFileName, versionLabel);
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName)) {
            return this._store.getFileAsBytes(companyId, repositoryId, fileName);
        }
        return this._store.getFileAsBytes(companyId, repositoryId, safeFileName);
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            return this._store.getFileAsBytes(companyId, repositoryId, fileName, versionLabel);
        }
        return this._store.getFileAsBytes(companyId, repositoryId, safeFileName, versionLabel);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName)) {
            return this._store.getFileAsStream(companyId, repositoryId, fileName);
        }
        return this._store.getFileAsStream(companyId, repositoryId, safeFileName);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            return this._store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
        }
        return this._store.getFileAsStream(companyId, repositoryId, safeFileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId) throws SystemException {
        String[] fileNames = this._store.getFileNames(companyId, repositoryId);
        String[] decodedFileNames = new String[fileNames.length];
        int i2 = 0;
        while (i2 < fileNames.length) {
            decodedFileNames[i2] = FileUtil.decodeSafeFileName((String)fileNames[i2]);
            ++i2;
        }
        return decodedFileNames;
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        if (!safeDirName.equals(dirName)) {
            try {
                this._store.move(dirName, safeDirName);
            }
            catch (Exception exception) {}
        }
        String[] fileNames = this._store.getFileNames(companyId, repositoryId, safeDirName);
        String[] decodedFileNames = new String[fileNames.length];
        int i2 = 0;
        while (i2 < fileNames.length) {
            decodedFileNames[i2] = FileUtil.decodeSafeFileName((String)fileNames[i2]);
            ++i2;
        }
        return decodedFileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName)) {
            return this._store.getFileSize(companyId, repositoryId, fileName);
        }
        return this._store.getFileSize(companyId, repositoryId, safeFileName);
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        return this._store.hasDirectory(companyId, repositoryId, safeDirName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName)) {
            return true;
        }
        return this._store.hasFile(companyId, repositoryId, safeFileName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            return true;
        }
        return this._store.hasFile(companyId, repositoryId, safeFileName, versionLabel);
    }

    public void move(String srcDir, String destDir) throws SystemException {
        this._store.move(srcDir, destDir);
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this._store.updateFile(companyId, repositoryId, newRepositoryId, safeFileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        String safeNewFileName = FileUtil.encodeSafeFileName((String)newFileName);
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName, "1.0")) {
            safeFileName = fileName;
        }
        this._store.updateFile(companyId, repositoryId, safeFileName, safeNewFileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, byte[] bytes) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this._store.updateFile(companyId, repositoryId, safeFileName, versionLabel, bytes);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, File file) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this._store.updateFile(companyId, repositoryId, safeFileName, versionLabel, file);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this._store.updateFile(companyId, repositoryId, safeFileName, versionLabel, is);
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, repositoryId, fileName, safeFileName);
        this._store.updateFileVersion(companyId, repositoryId, safeFileName, fromVersionLabel, toVersionLabel);
    }

    protected void renameUnsafeFile(long companyId, long repositoryId, String fileName, String safeFileName) throws PortalException, SystemException {
        if (!safeFileName.equals(fileName) && this._store.hasFile(companyId, repositoryId, fileName, "1.0")) {
            this._store.updateFile(companyId, repositoryId, fileName, safeFileName);
        }
    }
}

