/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;

public class DLFolderPermission {
    public static void check(PermissionChecker permissionChecker, DLFolder dlFolder, String actionId) throws PortalException, SystemException {
        if (!DLFolderPermission.contains(permissionChecker, dlFolder, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, Folder folder, String actionId) throws PortalException, SystemException {
        if (!folder.containsPermission(permissionChecker, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (!DLFolderPermission.contains(permissionChecker, groupId, folderId, actionId)) {
            throw new PrincipalException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contains(PermissionChecker permissionChecker, DLFolder dlFolder, String actionId) throws PortalException, SystemException {
        Boolean hasPermission;
        if (actionId.equals("ADD_FOLDER")) {
            actionId = "ADD_SUBFOLDER";
        }
        if ((hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)dlFolder.getGroupId(), (String)DLFolder.class.getName(), (long)dlFolder.getFolderId(), (String)"20", (String)actionId)) != null) {
            return hasPermission;
        }
        if (!actionId.equals("VIEW")) return DLFolderPermission._hasPermission(permissionChecker, dlFolder, actionId);
        if (!PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) return DLFolderPermission._hasPermission(permissionChecker, dlFolder, actionId);
        try {
            long dlFolderId = dlFolder.getFolderId();
            while (true) {
                if (dlFolderId == 0L) {
                    return true;
                }
                dlFolder = DLFolderLocalServiceUtil.getFolder((long)dlFolderId);
                if (!DLFolderPermission._hasPermission(permissionChecker, dlFolder, actionId)) {
                    return false;
                }
                dlFolderId = dlFolder.getParentFolderId();
            }
        }
        catch (NoSuchFolderException nsfe) {
            if (dlFolder.isInTrash()) return true;
            throw nsfe;
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, Folder folder, String actionId) throws PortalException, SystemException {
        return folder.containsPermission(permissionChecker, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (folderId == 0L) {
            if (actionId.equals("ACCESS") || actionId.equals("ADD_SUBFOLDER") || actionId.equals("DELETE")) {
                return false;
            }
            return DLPermission.contains(permissionChecker, groupId, actionId);
        }
        Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
        return folder.containsPermission(permissionChecker, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, DLFolder dlFolder, String actionId) {
        return permissionChecker.hasOwnerPermission(dlFolder.getCompanyId(), DLFolder.class.getName(), dlFolder.getFolderId(), dlFolder.getUserId(), actionId) || permissionChecker.hasPermission(dlFolder.getGroupId(), DLFolder.class.getName(), dlFolder.getFolderId(), actionId);
    }
}

