/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class DLFileShortcutLocalServiceImpl
extends DLFileShortcutLocalServiceBaseImpl {
    public DLFileShortcut addFileShortcut(long userId, long groupId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        folderId = this.getFolderId(user.getCompanyId(), folderId);
        Date now = new Date();
        this.validate(user, toFileEntryId);
        long fileShortcutId = this.counterLocalService.increment();
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.create(fileShortcutId);
        fileShortcut.setUuid(serviceContext.getUuid());
        fileShortcut.setGroupId(groupId);
        fileShortcut.setCompanyId(user.getCompanyId());
        fileShortcut.setUserId(user.getUserId());
        fileShortcut.setUserName(user.getFullName());
        fileShortcut.setCreateDate(serviceContext.getCreateDate(now));
        fileShortcut.setModifiedDate(serviceContext.getModifiedDate(now));
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFileEntryId(toFileEntryId);
        fileShortcut.setTreePath(fileShortcut.buildTreePath());
        fileShortcut.setActive(true);
        fileShortcut.setStatus(0);
        fileShortcut.setStatusByUserId(userId);
        fileShortcut.setStatusByUserName(user.getFullName());
        fileShortcut.setStatusDate(now);
        this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFileShortcutResources(fileShortcut, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFileShortcutResources(fileShortcut, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        if (folderId != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            dlFolder.setLastPostDate(fileShortcut.getModifiedDate());
            this.dlFolderPersistence.update((BaseModel)dlFolder);
        }
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(toFileEntryId);
        this.copyAssetTags(fileEntry, serviceContext);
        this.updateAsset(userId, fileShortcut, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return fileShortcut;
    }

    public void addFileShortcutResources(DLFileShortcut fileShortcut, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addFileShortcutResources(DLFileShortcut fileShortcut, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), groupPermissions, guestPermissions);
    }

    public void addFileShortcutResources(long fileShortcutId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, addGroupPermissions, addGuestPermissions);
    }

    public void addFileShortcutResources(long fileShortcutId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, groupPermissions, guestPermissions);
    }

    public void deleteFileShortcut(DLFileShortcut fileShortcut) throws PortalException, SystemException {
        this.dlFileShortcutPersistence.remove((BaseModel)fileShortcut);
        this.resourceLocalService.deleteResource(fileShortcut.getCompanyId(), DLFileShortcut.class.getName(), 4, fileShortcut.getFileShortcutId());
        this.assetEntryLocalService.deleteEntry(DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId());
        this.trashEntryLocalService.deleteEntry(DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId());
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.dlFileShortcutLocalService.getDLFileShortcut(fileShortcutId);
        this.deleteFileShortcut(fileShortcut);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException, SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(toFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.deleteFileShortcut(fileShortcut);
        }
    }

    public void deleteFileShortcuts(long groupId, long folderId) throws PortalException, SystemException {
        this.deleteFileShortcuts(groupId, folderId, true);
    }

    public void deleteFileShortcuts(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException, SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByG_F(groupId, folderId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            if (!includeTrashedEntries && fileShortcut.isInTrash()) continue;
            this.deleteFileShortcut(fileShortcut);
        }
    }

    public void disableFileShortcuts(long toFileEntryId) throws SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(toFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            fileShortcut.setActive(false);
            this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        }
    }

    public void enableFileShortcuts(long toFileEntryId) throws SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(toFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            fileShortcut.setActive(true);
            this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        }
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        return this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
    }

    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, boolean active, int status, int start, int end) throws SystemException {
        return this.dlFileShortcutPersistence.findByG_F_A_S(groupId, folderId, active, status, start, end);
    }

    public int getFileShortcutsCount(long groupId, long folderId, boolean active, int status) throws SystemException {
        return this.dlFileShortcutPersistence.countByG_F_A_S(groupId, folderId, active, status);
    }

    public void rebuildTree(long companyId) throws PortalException, SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByC_NotS(companyId, 8);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            if (fileShortcut.isInTrashContainer()) continue;
            fileShortcut.setTreePath(fileShortcut.buildTreePath());
            this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        }
    }

    public void updateAsset(long userId, DLFileShortcut fileShortcut, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileShortcut.getToFileEntryId());
        this.assetEntryLocalService.updateEntry(userId, fileShortcut.getGroupId(), fileShortcut.getCreateDate(), fileShortcut.getModifiedDate(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), fileShortcut.getUuid(), 0L, assetCategoryIds, assetTagNames, false, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
    }

    public DLFileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.validate(user, toFileEntryId);
        fileShortcut.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFileEntryId(toFileEntryId);
        fileShortcut.setTreePath(fileShortcut.buildTreePath());
        this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        if (folderId != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            dlFolder.setLastPostDate(fileShortcut.getModifiedDate());
            this.dlFolderPersistence.update((BaseModel)dlFolder);
        }
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(toFileEntryId);
        this.copyAssetTags(fileEntry, serviceContext);
        this.updateAsset(userId, fileShortcut, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return fileShortcut;
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(oldToFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            fileShortcut.setToFileEntryId(newToFileEntryId);
            this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        }
    }

    public void updateStatus(long userId, long fileShortcutId, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        fileShortcut.setStatus(status);
        fileShortcut.setStatusByUserId(user.getUserId());
        fileShortcut.setStatusByUserName(user.getFullName());
        fileShortcut.setStatusDate(serviceContext.getModifiedDate(new Date()));
        this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
    }

    protected void copyAssetTags(FileEntry fileEntry, ServiceContext serviceContext) throws PortalException, SystemException {
        String[] assetTagNames = this.assetTagLocalService.getTagNames(FileEntry.class.getName(), fileEntry.getFileEntryId());
        this.assetTagLocalService.checkTags(serviceContext.getUserId(), serviceContext.getScopeGroupId(), assetTagNames);
        serviceContext.setAssetTagNames(assetTagNames);
    }

    protected long getFolderId(long companyId, long folderId) throws SystemException {
        DLFolder dlFolder;
        if (folderId != 0L && ((dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != dlFolder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    protected void validate(User user, long toFileEntryId) throws PortalException, SystemException {
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(toFileEntryId);
        if (user.getCompanyId() != fileEntry.getCompanyId()) {
            throw new NoSuchFileEntryException();
        }
    }
}

