/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TempFileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.base.DLAppServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFileShortcutPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelModifiedDateComparator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class DLAppServiceImpl
extends DLAppServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLAppServiceImpl.class);

    public FileEntry addFileEntry(long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.addFileEntry(repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry addFileEntry(long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.addFileEntry(repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, null, 0L, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        Repository repository = this.getRepository(repositoryId);
        FileEntry fileEntry = repository.addFileEntry(folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        this.dlAppHelperLocalService.addFileEntry(this.getUserId(), fileEntry, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry addFileEntry(long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        if (is == null) {
            is = new UnsyncByteArrayInputStream(new byte[0]);
            size = 0L;
        }
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            String extension = DLAppUtil.getExtension(title, sourceFileName);
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)is);
                    FileEntry fileEntry = this.addFileEntry(repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioe) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioe);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        Repository repository = this.getRepository(repositoryId);
        FileEntry fileEntry = repository.addFileEntry(folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        this.dlAppHelperLocalService.addFileEntry(this.getUserId(), fileEntry, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public DLFileShortcut addFileShortcut(long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.dlFileShortcutService.addFileShortcut(repositoryId, folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.addFolder(parentFolderId, name, description, serviceContext);
    }

    public FileEntry addTempFileEntry(long groupId, long folderId, String fileName, String tempFolderName, File file, String mimeType) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_DOCUMENT");
        return TempFileUtil.addTempFile((long)groupId, (long)this.getUserId(), (String)fileName, (String)tempFolderName, (File)file, (String)mimeType);
    }

    public FileEntry addTempFileEntry(long groupId, long folderId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_DOCUMENT");
        return TempFileUtil.addTempFile((long)groupId, (long)this.getUserId(), (String)fileName, (String)tempFolderName, (InputStream)inputStream, (String)mimeType);
    }

    public void cancelCheckOut(long fileEntryId) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        DLProcessorRegistryUtil.cleanUp((FileVersion)fileEntry.getLatestFileVersion());
        FileVersion draftFileVersion = repository.cancelCheckOut(fileEntryId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setWorkflowAction(1);
        this.dlAppHelperLocalService.cancelCheckOut(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), draftFileVersion, serviceContext);
    }

    public void checkInFileEntry(long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry oldFileEntry = repository.getFileEntry(fileEntryId);
        FileVersion oldFileVersion = oldFileEntry.getFileVersion();
        repository.checkInFileEntry(fileEntryId, majorVersion, changeLog, serviceContext);
        FileEntry fileEntry = this.getFileEntry(fileEntryId);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, oldFileVersion, fileVersion, fileVersion.getFileVersionId());
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        this.checkInFileEntry(fileEntryId, lockUuid, new ServiceContext());
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry oldFileEntry = repository.getFileEntry(fileEntryId);
        FileVersion oldFileVersion = oldFileEntry.getFileVersion();
        repository.checkInFileEntry(fileEntryId, lockUuid, serviceContext);
        FileEntry fileEntry = this.getFileEntry(fileEntryId);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, oldFileVersion, fileVersion, fileVersion.getFileVersionId());
    }

    public void checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry oldFileEntry = repository.getFileEntry(fileEntryId);
        FileVersion oldFileVersion = oldFileEntry.getFileVersion();
        FileEntry fileEntry = repository.checkOutFileEntry(fileEntryId, serviceContext);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, oldFileVersion, fileVersion, fileEntryId);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry oldFileEntry = repository.getFileEntry(fileEntryId);
        FileVersion oldFileVersion = oldFileEntry.getFileVersion();
        FileEntry fileEntry = repository.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, oldFileVersion, fileVersion, fileEntryId);
        return fileEntry;
    }

    public Folder copyFolder(long repositoryId, long sourceFolderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        Folder srcFolder = repository.getFolder(sourceFolderId);
        Folder destFolder = repository.addFolder(parentFolderId, name, description, serviceContext);
        this.copyFolder(repository, srcFolder, destFolder, serviceContext);
        return destFolder;
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        repository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileEntryByTitle(long repositoryId, long folderId, String title) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        FileEntry fileEntry = repository.getFileEntry(folderId, title);
        this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        repository.deleteFileEntry(folderId, title);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        this.dlFileShortcutService.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        repository.deleteFileVersion(fileEntryId, version);
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        Repository repository = this.getFolderRepository(folderId);
        repository.deleteFolder(folderId);
    }

    public void deleteFolder(long repositoryId, long parentFolderId, String name) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        repository.deleteFolder(parentFolderId, name);
    }

    public void deleteTempFileEntry(long groupId, long folderId, String fileName, String tempFolderName) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_DOCUMENT");
        TempFileUtil.deleteTempFile((long)groupId, (long)this.getUserId(), (String)fileName, (String)tempFolderName);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId) throws PortalException, SystemException {
        return this.getFileEntries(repositoryId, folderId, -1, -1);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, int start, int end) throws PortalException, SystemException {
        return this.getFileEntries(repositoryId, folderId, start, end, null);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntries(folderId, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, long fileEntryTypeId) throws PortalException, SystemException {
        return this.getFileEntries(repositoryId, folderId, fileEntryTypeId, -1, -1);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, long fileEntryTypeId, int start, int end) throws PortalException, SystemException {
        return this.getFileEntries(repositoryId, folderId, fileEntryTypeId, start, end, null);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, long fileEntryTypeId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntries(folderId, fileEntryTypeId, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, String[] mimeTypes) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntries(folderId, mimeTypes, -1, -1, null);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, int start, int end) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    public int getFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes);
    }

    public int getFileEntriesCount(long repositoryId, long folderId) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long repositoryId, long folderId, long fileEntryTypeId) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesCount(folderId, fileEntryTypeId);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        return repository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException, SystemException {
        try {
            Repository repository = this.getRepository(groupId);
            return repository.getFileEntry(folderId, title);
        }
        catch (NoSuchFileEntryException nsfee) {
            if (folderId != 0L) {
                Repository repository = this.getFolderRepository(folderId);
                return repository.getFileEntry(folderId, title);
            }
            throw nsfee;
        }
    }

    public FileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException, SystemException {
        try {
            Repository repository = this.getRepository(groupId);
            return repository.getFileEntryByUuid(uuid);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
        }
        catch (RepositoryException re) {
            throw new NoSuchFileEntryException((Throwable)re);
        }
        List repositories = this.repositoryPersistence.findByGroupId(groupId);
        int i2 = 0;
        while (i2 < repositories.size()) {
            try {
                long repositoryId = ((com.liferay.portal.model.Repository)repositories.get(i2)).getRepositoryId();
                Repository repository = this.getRepository(repositoryId);
                return repository.getFileEntryByUuid(uuid);
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                ++i2;
            }
        }
        StringBundler msg = new StringBundler(6);
        msg.append("No DLFileEntry exists with the key {");
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchFileEntryException(msg.toString());
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        return this.dlFileShortcutService.getFileShortcut(fileShortcutId);
    }

    public Folder getFolder(long folderId) throws PortalException, SystemException {
        Repository repository = this.getFolderRepository(folderId);
        return repository.getFolder(folderId);
    }

    public Folder getFolder(long repositoryId, long parentFolderId, String name) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFolder(parentFolderId, name);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId) throws PortalException, SystemException {
        return this.getFolders(repositoryId, parentFolderId, -1, -1);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders) throws PortalException, SystemException {
        return this.getFolders(repositoryId, parentFolderId, includeMountFolders, -1, -1);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end) throws PortalException, SystemException {
        return this.getFolders(repositoryId, parentFolderId, includeMountFolders, start, end, null);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFolders(parentFolderId, includeMountFolders, start, end, obc);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFolders(parentFolderId, status, includeMountFolders, start, end, obc);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int start, int end) throws PortalException, SystemException {
        return this.getFolders(repositoryId, parentFolderId, start, end, null);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFolders(parentFolderId, true, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, boolean includeMountFolders, int start, int end) throws PortalException, SystemException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, status, includeMountFolders, start, end, null);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, status, null, includeMountFolders, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, start, end, obc);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, boolean includeMountFolders) throws PortalException, SystemException {
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, null, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId) throws PortalException, SystemException {
        return this.getFoldersCount(repositoryId, parentFolderId, true);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId, boolean includeMountFolders) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersCount(parentFolderId, includeMountFolders);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId, int status, boolean includeMountFolders) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersCount(parentFolderId, status, includeMountFolders);
    }

    public int getFoldersFileEntriesCount(long repositoryId, List<Long> folderIds, int status) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersFileEntriesCount(folderIds, status);
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, int start, int end) throws PortalException, SystemException {
        return this.getGroupFileEntries(groupId, userId, 0L, start, end, (OrderByComparator)new RepositoryModelModifiedDateComparator());
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.getGroupFileEntries(groupId, userId, 0L, start, end, obc);
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end) throws PortalException, SystemException {
        return this.getGroupFileEntries(groupId, userId, rootFolderId, start, end, (OrderByComparator)new RepositoryModelModifiedDateComparator());
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntries(userId, rootFolderId, start, end, obc);
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntries(userId, rootFolderId, mimeTypes, status, start, end, obc);
    }

    public int getGroupFileEntriesCount(long groupId, long userId) throws PortalException, SystemException {
        return this.getGroupFileEntriesCount(groupId, userId, 0L);
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId) throws PortalException, SystemException {
        Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntriesCount(userId, rootFolderId);
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException, SystemException {
        Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntriesCount(userId, rootFolderId, mimeTypes, status);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId) throws PortalException, SystemException {
        return this.getMountFolders(repositoryId, parentFolderId, -1, -1);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId, int start, int end) throws PortalException, SystemException {
        return this.getMountFolders(repositoryId, parentFolderId, start, end, null);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getMountFolders(parentFolderId, start, end, obc);
    }

    public int getMountFoldersCount(long repositoryId, long parentFolderId) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getMountFoldersCount(parentFolderId);
    }

    public void getSubfolderIds(long repositoryId, List<Long> folderIds, long folderId) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        repository.getSubfolderIds(folderIds, folderId);
    }

    public List<Long> getSubfolderIds(long repositoryId, long folderId) throws PortalException, SystemException {
        return this.getSubfolderIds(repositoryId, folderId, true);
    }

    public List<Long> getSubfolderIds(long repositoryId, long folderId, boolean recurse) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.getSubfolderIds(folderId, recurse);
    }

    public String[] getTempFileEntryNames(long groupId, long folderId, String tempFolderName) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_DOCUMENT");
        return TempFileUtil.getTempFileEntryNames((long)groupId, (long)this.getUserId(), (String)tempFolderName);
    }

    public Lock lockFileEntry(long fileEntryId) throws PortalException, SystemException {
        this.checkOutFileEntry(fileEntryId, new ServiceContext());
        FileEntry fileEntry = this.getFileEntry(fileEntryId);
        return fileEntry.getLock();
    }

    public Lock lockFileEntry(long fileEntryId, String owner, long expirationTime) throws PortalException, SystemException {
        FileEntry fileEntry = this.checkOutFileEntry(fileEntryId, owner, expirationTime, new ServiceContext());
        return fileEntry.getLock();
    }

    public Lock lockFolder(long repositoryId, long folderId) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.lockFolder(folderId);
    }

    public Lock lockFolder(long repositoryId, long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.lockFolder(folderId, owner, inheritable, expirationTime);
    }

    public FileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        Folder toFolder;
        Repository fromRepository = this.getFileEntryRepository(fileEntryId);
        Repository toRepository = this.getFolderRepository(newFolderId, serviceContext.getScopeGroupId());
        if (newFolderId != 0L && (toFolder = toRepository.getFolder(newFolderId)).isMountPoint()) {
            toRepository = this.getRepository(toFolder.getRepositoryId());
        }
        if (fromRepository.getRepositoryId() == toRepository.getRepositoryId()) {
            FileEntry fileEntry = fromRepository.moveFileEntry(fileEntryId, newFolderId, serviceContext);
            return fileEntry;
        }
        return this.moveFileEntries(fileEntryId, newFolderId, fromRepository, toRepository, serviceContext);
    }

    public FileEntry moveFileEntryFromTrash(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntry, "UPDATE");
        return this.dlAppHelperLocalService.moveFileEntryFromTrash(this.getUserId(), fileEntry, newFolderId, serviceContext);
    }

    public FileEntry moveFileEntryToTrash(long fileEntryId) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntry, "DELETE");
        return this.dlAppHelperLocalService.moveFileEntryToTrash(this.getUserId(), fileEntry);
    }

    public DLFileShortcut moveFileShortcutFromTrash(long fileShortcutId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.getFileShortcut(fileShortcutId);
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcut, "UPDATE");
        return this.dlAppHelperLocalService.moveFileShortcutFromTrash(this.getUserId(), fileShortcut, newFolderId, serviceContext);
    }

    public DLFileShortcut moveFileShortcutToTrash(long fileShortcutId) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.getFileShortcut(fileShortcutId);
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcut, "DELETE");
        return this.dlAppHelperLocalService.moveFileShortcutToTrash(this.getUserId(), fileShortcut);
    }

    public Folder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        Folder toFolder;
        Repository fromRepository = this.getFolderRepository(folderId);
        Repository toRepository = this.getFolderRepository(parentFolderId, serviceContext.getScopeGroupId());
        if (parentFolderId != 0L && (toFolder = toRepository.getFolder(parentFolderId)).isMountPoint()) {
            toRepository = this.getRepository(toFolder.getRepositoryId());
        }
        if (fromRepository.getRepositoryId() == toRepository.getRepositoryId()) {
            Folder folder = fromRepository.moveFolder(folderId, parentFolderId, serviceContext);
            return folder;
        }
        return this.moveFolders(folderId, parentFolderId, fromRepository, toRepository, serviceContext);
    }

    public Folder moveFolderFromTrash(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getFolderRepository(folderId);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        Folder folder = repository.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        return this.dlAppHelperLocalService.moveFolderFromTrash(this.getUserId(), folder, parentFolderId, serviceContext);
    }

    public Folder moveFolderToTrash(long folderId) throws PortalException, SystemException {
        Repository repository = this.getFolderRepository(folderId);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        Folder folder = repository.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        return this.dlAppHelperLocalService.moveFolderToTrash(this.getUserId(), folder);
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException, SystemException {
        Lock lock = this.lockLocalService.getLockByUuidAndCompanyId(lockUuid, companyId);
        long fileEntryId = GetterUtil.getLong((String)lock.getKey());
        Repository repository = this.getFileEntryRepository(fileEntryId);
        return repository.refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException, SystemException {
        Lock lock = this.lockLocalService.getLockByUuidAndCompanyId(lockUuid, companyId);
        long folderId = GetterUtil.getLong((String)lock.getKey());
        Repository repository = this.getFolderRepository(folderId);
        return repository.refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    public void restoreFileEntryFromTrash(long fileEntryId) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntry, "DELETE");
        this.dlAppHelperLocalService.restoreFileEntryFromTrash(this.getUserId(), fileEntry);
    }

    public void restoreFileShortcutFromTrash(long fileShortcutId) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.getFileShortcut(fileShortcutId);
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcut, "DELETE");
        this.dlAppHelperLocalService.restoreFileShortcutFromTrash(this.getUserId(), fileShortcut);
    }

    public void restoreFolderFromTrash(long folderId) throws PortalException, SystemException {
        Repository repository = this.getFolderRepository(folderId);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        Folder folder = repository.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        this.dlAppHelperLocalService.restoreFolderFromTrash(this.getUserId(), folder);
    }

    public void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        repository.revertFileEntry(fileEntryId, version, serviceContext);
        FileEntry fileEntry = this.getFileEntry(fileEntryId);
        this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, fileEntry.getFileVersion(version), fileEntry.getFileVersion(), serviceContext);
    }

    public Hits search(long repositoryId, long creatorUserId, int status, int start, int end) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.search(creatorUserId, status, start, end);
    }

    public Hits search(long repositoryId, long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.search(creatorUserId, folderId, mimeTypes, status, start, end);
    }

    public Hits search(long repositoryId, SearchContext searchContext) throws SearchException {
        try {
            Repository repository = this.getRepository(repositoryId);
            return repository.search(searchContext);
        }
        catch (Exception e2) {
            throw new SearchException((Throwable)e2);
        }
    }

    public Hits search(long repositoryId, SearchContext searchContext, Query query) throws SearchException {
        try {
            Repository repository = this.getRepository(repositoryId);
            return repository.search(searchContext, query);
        }
        catch (Exception e2) {
            throw new SearchException((Throwable)e2);
        }
    }

    public void subscribeFileEntryType(long groupId, long fileEntryTypeId) throws PortalException, SystemException {
        DLPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.dlAppLocalService.subscribeFileEntryType(this.getUserId(), groupId, fileEntryTypeId);
    }

    public void subscribeFolder(long groupId, long folderId) throws PortalException, SystemException {
        DLPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.dlAppLocalService.subscribeFolder(this.getUserId(), groupId, folderId);
    }

    public void unlockFileEntry(long fileEntryId) throws PortalException, SystemException {
        this.checkInFileEntry(fileEntryId, false, "", new ServiceContext());
    }

    public void unlockFileEntry(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        this.checkInFileEntry(fileEntryId, lockUuid);
    }

    public void unlockFolder(long repositoryId, long folderId, String lockUuid) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        repository.unlockFolder(folderId, lockUuid);
    }

    public void unlockFolder(long repositoryId, long parentFolderId, String name, String lockUuid) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        repository.unlockFolder(parentFolderId, name, lockUuid);
    }

    public void unsubscribeFileEntryType(long groupId, long fileEntryTypeId) throws PortalException, SystemException {
        DLPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.dlAppLocalService.unsubscribeFileEntryType(this.getUserId(), groupId, fileEntryTypeId);
    }

    public void unsubscribeFolder(long groupId, long folderId) throws PortalException, SystemException {
        DLPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.dlAppLocalService.unsubscribeFolder(this.getUserId(), groupId, folderId);
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, null, 0L, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        DLProcessorRegistryUtil.cleanUp((FileVersion)fileEntry.getLatestFileVersion());
        this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            String extension = DLAppUtil.getExtension(title, sourceFileName);
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)is);
                    FileEntry fileEntry = this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioe) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioe);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry oldFileEntry = repository.getFileEntry(fileEntryId);
        FileVersion oldFileVersion = oldFileEntry.getFileVersion();
        FileEntry fileEntry = repository.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
        if (is != null) {
            DLProcessorRegistryUtil.cleanUp((FileVersion)fileEntry.getLatestFileVersion());
            oldFileVersion = null;
        }
        this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, oldFileVersion, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntryAndCheckIn(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntryAndCheckIn(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, null, 0L, serviceContext);
        }
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        DLProcessorRegistryUtil.cleanUp((FileVersion)fileEntry.getLatestFileVersion());
        repository.checkInFileEntry(fileEntryId, majorVersion, changeLog, serviceContext);
        this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntryAndCheckIn(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getFileEntryRepository(fileEntryId);
        FileEntry oldFileEntry = repository.getFileEntry(fileEntryId);
        FileVersion oldFileVersion = oldFileEntry.getFileVersion();
        FileEntry fileEntry = repository.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
        if (is != null) {
            DLProcessorRegistryUtil.cleanUp((FileVersion)fileEntry.getLatestFileVersion());
            oldFileVersion = null;
        }
        repository.checkInFileEntry(fileEntryId, majorVersion, changeLog, serviceContext);
        this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, oldFileVersion, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public DLFileShortcut updateFileShortcut(long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.dlFileShortcutService.updateFileShortcut(fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = null;
        repository = folderId == 0L ? this.getRepository(serviceContext.getScopeGroupId()) : this.getFolderRepository(folderId);
        return repository.updateFolder(folderId, name, description, serviceContext);
    }

    public boolean verifyFileEntryCheckOut(long repositoryId, long fileEntryId, String lockUuid) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyFileEntryLock(long repositoryId, long fileEntryId, String lockUuid) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.verifyFileEntryLock(fileEntryId, lockUuid);
    }

    public boolean verifyInheritableLock(long repositoryId, long folderId, String lockUuid) throws PortalException, SystemException {
        Repository repository = this.getRepository(repositoryId);
        return repository.verifyInheritableLock(folderId, lockUuid);
    }

    protected FileEntry copyFileEntry(Repository toRepository, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        List fileVersions = fileEntry.getFileVersions(-1);
        FileVersion latestFileVersion = (FileVersion)fileVersions.get(fileVersions.size() - 1);
        FileEntry destinationFileEntry = toRepository.addFileEntry(newFolderId, fileEntry.getTitle(), latestFileVersion.getMimeType(), latestFileVersion.getTitle(), latestFileVersion.getDescription(), "", latestFileVersion.getContentStream(false), latestFileVersion.getSize(), serviceContext);
        FileVersion oldDestinationFileVersion = destinationFileEntry.getFileVersion();
        this.dlAppHelperLocalService.addFileEntry(this.getUserId(), destinationFileEntry, oldDestinationFileVersion, serviceContext);
        int i2 = fileVersions.size() - 2;
        while (i2 >= 0) {
            FileVersion fileVersion = (FileVersion)fileVersions.get(i2);
            FileVersion previousFileVersion = (FileVersion)fileVersions.get(i2 + 1);
            try {
                destinationFileEntry = toRepository.updateFileEntry(destinationFileEntry.getFileEntryId(), fileVersion.getTitle(), fileVersion.getMimeType(), fileVersion.getTitle(), fileVersion.getDescription(), "", DLAppUtil.isMajorVersion(previousFileVersion, fileVersion), fileVersion.getContentStream(false), fileVersion.getSize(), serviceContext);
                FileVersion destinationFileVersion = destinationFileEntry.getFileVersion();
                this.dlAppHelperLocalService.updateFileEntry(this.getUserId(), destinationFileEntry, oldDestinationFileVersion, destinationFileVersion, serviceContext);
                oldDestinationFileVersion = destinationFileVersion;
            }
            catch (PortalException pe) {
                toRepository.deleteFileEntry(destinationFileEntry.getFileEntryId());
                throw pe;
            }
            --i2;
        }
        return destinationFileEntry;
    }

    protected void copyFolder(Repository repository, Folder srcFolder, Folder destFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        LinkedList<Folder[]> folders = new LinkedList<Folder[]>();
        final ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        Folder curSrcFolder = srcFolder;
        Folder curDestFolder = destFolder;
        while (true) {
            List srcFileEntries = repository.getFileEntries(curSrcFolder.getFolderId(), -1, -1, null);
            for (FileEntry srcFileEntry : srcFileEntries) {
                try {
                    FileEntry fileEntry = repository.copyFileEntry(curDestFolder.getGroupId(), srcFileEntry.getFileEntryId(), curDestFolder.getFolderId(), serviceContext);
                    this.dlAppHelperLocalService.addFileEntry(this.getUserId(), fileEntry, fileEntry.getFileVersion(), serviceContext);
                    fileEntries.add(fileEntry);
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                }
            }
            List srcSubfolders = repository.getFolders(curSrcFolder.getFolderId(), false, -1, -1, null);
            for (Folder srcSubfolder : srcSubfolders) {
                Folder destSubfolder = repository.addFolder(curDestFolder.getFolderId(), srcSubfolder.getName(), srcSubfolder.getDescription(), serviceContext);
                folders.offer(new Folder[]{srcSubfolder, destSubfolder});
            }
            Folder[] next = (Folder[])folders.poll();
            if (next == null) break;
            curSrcFolder = next[0];
            curDestFolder = next[1];
        }
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (FileEntry fileEntry : fileEntries) {
                    DLProcessorRegistryUtil.trigger((FileEntry)fileEntry, null);
                }
                return null;
            }
        });
    }

    protected void deleteFileEntry(long oldFileEntryId, long newFileEntryId, Repository fromRepository, Repository toRepository) throws PortalException, SystemException {
        try {
            FileEntry fileEntry = fromRepository.getFileEntry(oldFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
            fromRepository.deleteFileEntry(oldFileEntryId);
        }
        catch (PortalException pe) {
            FileEntry fileEntry = toRepository.getFileEntry(newFileEntryId);
            toRepository.deleteFileEntry(newFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
            throw pe;
        }
    }

    protected Repository getFileEntryRepository(long fileEntryId) throws PortalException, SystemException {
        try {
            return this.repositoryService.getRepositoryImpl(0L, fileEntryId, 0L);
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileEntry exists with the key {fileEntryId=");
            sb.append(fileEntryId);
            sb.append("}");
            throw new NoSuchFileEntryException(sb.toString(), (Throwable)irie);
        }
    }

    protected Repository getFileVersionRepository(long fileVersionId) throws PortalException, SystemException {
        try {
            return this.repositoryService.getRepositoryImpl(0L, 0L, fileVersionId);
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileVersion exists with the key {fileVersionId=");
            sb.append(fileVersionId);
            sb.append("}");
            throw new NoSuchFileVersionException(sb.toString(), (Throwable)irie);
        }
    }

    protected Repository getFolderRepository(long folderId) throws PortalException, SystemException {
        try {
            return this.repositoryService.getRepositoryImpl(folderId, 0L, 0L);
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No Folder exists with the key {folderId=");
            sb.append(folderId);
            sb.append("}");
            throw new NoSuchFolderException(sb.toString(), (Throwable)irie);
        }
    }

    protected Repository getFolderRepository(long folderId, long groupId) throws PortalException, SystemException {
        Repository repository = null;
        repository = folderId == 0L ? this.getRepository(groupId) : this.getFolderRepository(folderId);
        return repository;
    }

    protected Repository getRepository(long repositoryId) throws PortalException, SystemException {
        try {
            return this.repositoryService.getRepositoryImpl(repositoryId);
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No Group exists with the key {repositoryId=");
            sb.append(repositoryId);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString(), (Throwable)irie);
        }
    }

    protected FileEntry moveFileEntries(long fileEntryId, long newFolderId, Repository fromRepository, Repository toRepository, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry sourceFileEntry = fromRepository.getFileEntry(fileEntryId);
        FileEntry destinationFileEntry = this.copyFileEntry(toRepository, sourceFileEntry, newFolderId, serviceContext);
        this.deleteFileEntry(fileEntryId, destinationFileEntry.getFileEntryId(), fromRepository, toRepository);
        return destinationFileEntry;
    }

    protected Folder moveFolders(long folderId, long parentFolderId, Repository fromRepository, Repository toRepository, ServiceContext serviceContext) throws PortalException, SystemException {
        Folder folder = fromRepository.getFolder(folderId);
        Folder newFolder = toRepository.addFolder(parentFolderId, folder.getName(), folder.getDescription(), serviceContext);
        List<Object> foldersAndFileEntriesAndFileShortcuts = this.getFoldersAndFileEntriesAndFileShortcuts(fromRepository.getRepositoryId(), folderId, -1, true, -1, -1);
        try {
            for (Object folderAndFileEntryAndFileShortcut : foldersAndFileEntriesAndFileShortcuts) {
                if (folderAndFileEntryAndFileShortcut instanceof FileEntry) {
                    FileEntry fileEntry = (FileEntry)folderAndFileEntryAndFileShortcut;
                    this.copyFileEntry(toRepository, fileEntry, newFolder.getFolderId(), serviceContext);
                    continue;
                }
                if (folderAndFileEntryAndFileShortcut instanceof Folder) {
                    Folder currentFolder = (Folder)folderAndFileEntryAndFileShortcut;
                    this.moveFolders(currentFolder.getFolderId(), newFolder.getFolderId(), fromRepository, toRepository, serviceContext);
                    continue;
                }
                if (!(folderAndFileEntryAndFileShortcut instanceof DLFileShortcut) || !newFolder.isSupportsShortcuts()) continue;
                DLFileShortcut dlFileShorcut = (DLFileShortcut)folderAndFileEntryAndFileShortcut;
                this.dlFileShortcutService.addFileShortcut(dlFileShorcut.getGroupId(), newFolder.getFolderId(), dlFileShorcut.getToFileEntryId(), serviceContext);
            }
        }
        catch (PortalException pe) {
            toRepository.deleteFolder(newFolder.getFolderId());
            throw pe;
        }
        try {
            fromRepository.deleteFolder(folderId);
        }
        catch (PortalException pe) {
            toRepository.deleteFolder(newFolder.getFolderId());
            throw pe;
        }
        return newFolder;
    }
}

