/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.User;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.model.DLSyncEvent;
import com.liferay.portlet.documentlibrary.service.base.DLAppHelperLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLAppHelperThreadLocal;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.portlet.PortletPreferences;

public class DLAppHelperLocalServiceImpl
extends DLAppHelperLocalServiceBaseImpl {
    public void addFileEntry(long userId, FileEntry fileEntry, FileVersion fileVersion, ServiceContext serviceContext) throws PortalException, SystemException {
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.updateAsset(userId, fileEntry, fileVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
            if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
                this.mbMessageLocalService.addDiscussionMessage(fileEntry.getUserId(), fileEntry.getUserName(), fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 1);
            }
        }
        boolean previousEnabled = WorkflowThreadLocal.isEnabled();
        if (!DLAppHelperThreadLocal.isEnabled()) {
            WorkflowThreadLocal.setEnabled((boolean)false);
        }
        try {
            if (fileVersion instanceof LiferayFileVersion) {
                DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
                HashMap<String, String> workflowContext = new HashMap<String, String>();
                workflowContext.put("event", "add");
                WorkflowHandlerRegistryUtil.startWorkflowInstance((long)dlFileVersion.getCompanyId(), (long)dlFileVersion.getGroupId(), (long)userId, (String)DLFileEntryConstants.getClassName(), (long)dlFileVersion.getFileVersionId(), (Object)dlFileVersion, (ServiceContext)serviceContext, workflowContext);
            }
        }
        finally {
            if (!DLAppHelperThreadLocal.isEnabled()) {
                WorkflowThreadLocal.setEnabled((boolean)previousEnabled);
            }
        }
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.registerDLProcessorCallback(fileEntry, null);
        }
    }

    public void addFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.registerDLSyncEventCallback("add", folder);
    }

    public void cancelCheckOut(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, FileVersion draftFileVersion, ServiceContext serviceContext) throws PortalException, SystemException {
        this.updateFileEntry(userId, fileEntry, sourceFileVersion, destinationFileVersion, serviceContext);
        if (draftFileVersion == null) {
            return;
        }
        AssetEntry draftAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), draftFileVersion.getPrimaryKey());
        if (draftAssetEntry != null) {
            this.assetEntryLocalService.deleteEntry(draftAssetEntry);
        }
    }

    public void checkAssetEntry(long userId, FileEntry fileEntry, FileVersion fileVersion) throws PortalException, SystemException {
        AssetEntry fileVersionAssetEntry;
        AssetEntry fileEntryAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        long[] assetCategoryIds = new long[]{};
        String[] assetTagNames = new String[]{};
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (fileEntryAssetEntry == null) {
            fileEntryAssetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, false, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
        }
        if ((fileVersionAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId())) == null && !fileVersion.isApproved() && !fileVersion.getVersion().equals("1.0")) {
            assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            fileVersionAssetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, false, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
            List assetLinks = this.assetLinkLocalService.getDirectLinks(fileEntryAssetEntry.getEntryId());
            long[] assetLinkIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
            this.assetLinkLocalService.updateLinks(userId, fileVersionAssetEntry.getEntryId(), assetLinkIds, 0);
        }
    }

    public void deleteFileEntry(FileEntry fileEntry) throws PortalException, SystemException {
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.subscriptionLocalService.deleteSubscriptions(fileEntry.getCompanyId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            DLProcessorRegistryUtil.cleanUp((FileEntry)fileEntry);
            this.dlFileRankLocalService.deleteFileRanksByFileEntryId(fileEntry.getFileEntryId());
            this.dlFileShortcutLocalService.deleteFileShortcuts(fileEntry.getFileEntryId());
            this.registerDLSyncEventCallback("delete", fileEntry);
            this.assetEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            this.mbMessageLocalService.deleteDiscussionMessages(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            this.ratingsStatsLocalService.deleteStats(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        }
        if (fileEntry.getModel() instanceof DLFileEntry) {
            this.trashEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        }
    }

    public void deleteFolder(Folder folder) throws PortalException, SystemException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.registerDLSyncEventCallback("delete", folder);
        this.assetEntryLocalService.deleteEntry(DLFolderConstants.getClassName(), folder.getFolderId());
        if (folder.getModel() instanceof DLFolder) {
            this.trashEntryLocalService.deleteEntry(DLFolderConstants.getClassName(), folder.getFolderId());
        }
    }

    public void getFileAsStream(long userId, FileEntry fileEntry, boolean incrementCounter) throws SystemException {
        if (!incrementCounter) {
            return;
        }
        if (userId > 0L) {
            this.dlFileRankLocalService.updateFileRank(fileEntry.getGroupId(), fileEntry.getCompanyId(), userId, fileEntry.getFileEntryId(), new ServiceContext());
        }
        this.assetEntryLocalService.incrementViewCounter(userId, DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 1);
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.assetEntryLocalService.incrementViewCounter(userId, DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), 1);
        }
    }

    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, boolean active, int status) throws SystemException {
        return this.dlFileShortcutPersistence.findByG_F_A_S(groupId, folderId, active, status);
    }

    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, int status) throws SystemException {
        return this.getFileShortcuts(groupId, folderId, true, status);
    }

    public int getFileShortcutsCount(long groupId, long folderId, boolean active, int status) throws SystemException {
        return this.dlFileShortcutPersistence.countByG_F_A_S(groupId, folderId, active, status);
    }

    public int getFileShortcutsCount(long groupId, long folderId, int status) throws SystemException {
        return this.getFileShortcutsCount(groupId, folderId, true, status);
    }

    public List<FileEntry> getNoAssetFileEntries() {
        return null;
    }

    public void moveFileEntry(FileEntry fileEntry) throws PortalException, SystemException {
        this.registerDLSyncEventCallback("move", fileEntry);
    }

    public FileEntry moveFileEntryFromTrash(long userId, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean hasLock = this.dlFileEntryLocalService.hasFileEntryLock(userId, fileEntry.getFileEntryId());
        if (!hasLock) {
            this.dlFileEntryLocalService.lockFileEntry(userId, fileEntry.getFileEntryId());
        }
        try {
            FileEntry fileEntry2 = this.doMoveFileEntryFromTrash(userId, fileEntry, newFolderId, serviceContext);
            return fileEntry2;
        }
        finally {
            if (!hasLock) {
                this.dlFileEntryLocalService.unlockFileEntry(fileEntry.getFileEntryId());
            }
        }
    }

    public FileEntry moveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException, SystemException {
        boolean hasLock = this.dlFileEntryLocalService.hasFileEntryLock(userId, fileEntry.getFileEntryId());
        if (!hasLock) {
            this.dlFileEntryLocalService.lockFileEntry(userId, fileEntry.getFileEntryId());
        }
        try {
            FileEntry fileEntry2 = this.doMoveFileEntryToTrash(userId, fileEntry);
            return fileEntry2;
        }
        finally {
            if (!hasLock) {
                this.dlFileEntryLocalService.unlockFileEntry(fileEntry.getFileEntryId());
            }
        }
    }

    public DLFileShortcut moveFileShortcutFromTrash(long userId, DLFileShortcut dlFileShortcut, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        if (dlFileShortcut.isInTrash()) {
            this.restoreFileShortcutFromTrash(userId, dlFileShortcut);
        }
        return this.dlAppService.updateFileShortcut(dlFileShortcut.getFileShortcutId(), newFolderId, dlFileShortcut.getToFileEntryId(), serviceContext);
    }

    public DLFileShortcut moveFileShortcutToTrash(long userId, DLFileShortcut dlFileShortcut) throws PortalException, SystemException {
        int oldStatus = dlFileShortcut.getStatus();
        this.dlFileShortcutLocalService.updateStatus(userId, dlFileShortcut.getFileShortcutId(), 8, new ServiceContext());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", TrashUtil.getOriginalTitle((String)dlFileShortcut.getToTitle()));
        this.socialActivityLocalService.addActivity(userId, dlFileShortcut.getGroupId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), 10007, extraDataJSONObject.toString(), 0L);
        this.trashEntryLocalService.addTrashEntry(userId, dlFileShortcut.getGroupId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), dlFileShortcut.getUuid(), null, oldStatus, null, null);
        return dlFileShortcut;
    }

    public void moveFolder(Folder folder) throws SystemException {
        this.registerDLSyncEventCallback("move", folder);
    }

    public Folder moveFolderFromTrash(long userId, Folder folder, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean hasLock = this.dlFolderLocalService.hasFolderLock(userId, folder.getFolderId());
        Lock lock = null;
        if (!hasLock) {
            lock = this.dlFolderLocalService.lockFolder(userId, folder.getFolderId());
        }
        try {
            Folder folder2 = this.doMoveFolderFromTrash(userId, folder, parentFolderId, serviceContext);
            return folder2;
        }
        finally {
            if (!hasLock) {
                this.dlFolderLocalService.unlockFolder(folder.getFolderId(), lock.getUuid());
            }
        }
    }

    public Folder moveFolderToTrash(long userId, Folder folder) throws PortalException, SystemException {
        boolean hasLock = this.dlFolderLocalService.hasFolderLock(userId, folder.getFolderId());
        Lock lock = null;
        if (!hasLock) {
            lock = this.dlFolderLocalService.lockFolder(userId, folder.getFolderId());
        }
        try {
            Folder folder2 = this.doMoveFolderToTrash(userId, folder);
            return folder2;
        }
        finally {
            if (!hasLock) {
                this.dlFolderLocalService.unlockFolder(folder.getFolderId(), lock.getUuid());
            }
        }
    }

    public void registerDLSyncEventCallback(String event, FileEntry fileEntry) throws PortalException, SystemException {
        FileVersion fileVersion;
        if (this.isStagingGroup(fileEntry.getGroupId())) {
            return;
        }
        if (!(event.equals("delete") || event.equals("trash") || (fileVersion = fileEntry.getFileVersion()).isApproved())) {
            return;
        }
        this.registerDLSyncEventCallback(event, "file", fileEntry.getFileEntryId());
    }

    public void registerDLSyncEventCallback(String event, Folder folder) throws SystemException {
        if (this.isStagingGroup(folder.getGroupId())) {
            return;
        }
        this.registerDLSyncEventCallback(event, "folder", folder.getFolderId());
    }

    public void restoreFileEntryFromTrash(long userId, FileEntry fileEntry) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        dlFileEntry.setTitle(TrashUtil.getOriginalTitle((String)dlFileEntry.getTitle()));
        this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileEntry.getLatestFileVersion(true));
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
        HashMap<String, Serializable> workflowContext = new HashMap<String, Serializable>();
        List trashVersions = this.trashVersionLocalService.getVersions(trashEntry.getEntryId());
        workflowContext.put("trashVersions", (Serializable)((Object)trashVersions));
        this.dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), trashEntry.getStatus(), workflowContext, new ServiceContext());
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.dlFileShortcutLocalService.enableFileShortcuts(fileEntry.getFileEntryId());
        this.dlFileRankLocalService.enableFileRanks(fileEntry.getFileEntryId());
        this.registerDLSyncEventCallback("restore", fileEntry);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", fileEntry.getTitle());
        this.socialActivityLocalService.addActivity(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 10008, extraDataJSONObject.toString(), 0L);
    }

    public void restoreFileShortcutFromTrash(long userId, DLFileShortcut dlFileShortcut) throws PortalException, SystemException {
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId());
        this.dlFileShortcutLocalService.updateStatus(userId, dlFileShortcut.getFileShortcutId(), trashEntry.getStatus(), new ServiceContext());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", dlFileShortcut.getToTitle());
        this.socialActivityLocalService.addActivity(userId, dlFileShortcut.getGroupId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), 10008, extraDataJSONObject.toString(), 0L);
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
    }

    public void restoreFolderFromTrash(long userId, Folder folder) throws PortalException, SystemException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        dlFolder.setName(TrashUtil.getOriginalTitle((String)dlFolder.getName()));
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        this.dlFolderLocalService.updateStatus(userId, folder.getFolderId(), 0, new HashMap(), new ServiceContext());
        this.dlFileRankLocalService.enableFileRanksByFolderId(folder.getFolderId());
        this.registerDLSyncEventCallback("restore", folder);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", folder.getName());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), DLFolderConstants.getClassName(), folder.getFolderId(), 10008, extraDataJSONObject.toString(), 0L);
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long assetClassPk) throws PortalException, SystemException {
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), assetClassPk);
        String[] assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), assetClassPk);
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), assetClassPk);
        List assetLinks = this.assetLinkLocalService.getDirectLinks(assetEntry.getEntryId());
        long[] assetLinkIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
        return this.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkIds);
    }

    public AssetEntry updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        AssetEntry assetEntry = null;
        boolean visible = false;
        boolean addDraftAssetEntry = false;
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileVersion dlFileVersion = (DLFileVersion)fileVersion.getModel();
            if (dlFileVersion.isApproved()) {
                visible = true;
            } else {
                String version = dlFileVersion.getVersion();
                if (!version.equals("1.0")) {
                    addDraftAssetEntry = true;
                }
            }
        } else {
            visible = true;
        }
        long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
        if (addDraftAssetEntry) {
            if (assetCategoryIds == null) {
                assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            }
            if (assetTagNames == null) {
                assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
            }
            if (assetLinkEntryIds == null) {
                AssetEntry previousAssetEntry = this.assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
                List assetLinks = this.assetLinkLocalService.getDirectLinks(previousAssetEntry.getEntryId(), 0);
                assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
            }
            assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, false, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
        } else {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, visible, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
            List dlFileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(fileEntry.getFileEntryId());
            for (DLFileShortcut dlFileShortcut : dlFileShortcuts) {
                this.assetEntryLocalService.updateEntry(userId, dlFileShortcut.getGroupId(), dlFileShortcut.getCreateDate(), dlFileShortcut.getModifiedDate(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), dlFileShortcut.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, null, null, null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
            }
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
        return assetEntry;
    }

    public AssetEntry updateAsset(long userId, Folder folder, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        AssetEntry assetEntry = null;
        boolean visible = false;
        if (folder instanceof LiferayFolder) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            if (dlFolder.isApproved() && !dlFolder.isHidden() && !dlFolder.isInHiddenFolder()) {
                visible = true;
            }
        } else {
            visible = true;
        }
        assetEntry = this.assetEntryLocalService.updateEntry(userId, folder.getGroupId(), folder.getCreateDate(), folder.getModifiedDate(), DLFolderConstants.getClassName(), folder.getFolderId(), folder.getUuid(), 0L, assetCategoryIds, assetTagNames, visible, null, null, null, null, folder.getName(), folder.getDescription(), null, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
        return assetEntry;
    }

    public void updateDependentStatus(User user, List<Object> dlFileEntriesAndDLFolders, int status) throws PortalException, SystemException {
        for (Object object : dlFileEntriesAndDLFolders) {
            DLFolder dlFolder;
            Indexer indexer;
            if (object instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), -1);
                dlFileVersions = ListUtil.copy((List)dlFileVersions);
                Collections.sort(dlFileVersions, new FileVersionVersionComparator());
                DLFileVersion latestDlFileVersion = (DLFileVersion)dlFileVersions.get(0);
                if (status == 0 && latestDlFileVersion.getStatus() == 8) continue;
                if (status == 0) {
                    this.dlFileShortcutLocalService.enableFileShortcuts(dlFileEntry.getFileEntryId());
                } else {
                    this.dlFileShortcutLocalService.disableFileShortcuts(dlFileEntry.getFileEntryId());
                }
                if (status == 0) {
                    if (latestDlFileVersion.isApproved()) {
                        this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId(), true);
                    }
                } else {
                    this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId(), false);
                }
                indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
                indexer.reindex((Object)dlFileEntry);
                if (status == 0) continue;
                for (DLFileVersion dlFileVersion : dlFileVersions) {
                    if (!dlFileVersion.isPending()) continue;
                    dlFileVersion.setStatus(2);
                    this.dlFileVersionPersistence.update((BaseModel)dlFileVersion);
                    this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), dlFileVersion.getGroupId(), DLFileEntryConstants.getClassName(), dlFileVersion.getFileVersionId());
                }
                continue;
            }
            if (!(object instanceof DLFolder) || (dlFolder = (DLFolder)object).isInTrash()) continue;
            QueryDefinition queryDefinition = new QueryDefinition(-1);
            List foldersAndFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcuts(dlFolder.getGroupId(), dlFolder.getFolderId(), null, false, queryDefinition);
            this.updateDependentStatus(user, foldersAndFileEntriesAndFileShortcuts, status);
            if (status == 8) {
                this.assetEntryLocalService.updateVisible(DLFolderConstants.getClassName(), dlFolder.getFolderId(), false);
            } else {
                this.assetEntryLocalService.updateVisible(DLFolderConstants.getClassName(), dlFolder.getFolderId(), true);
            }
            indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFolder.class);
            indexer.reindex((Object)dlFolder);
        }
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, long assetClassPk) throws PortalException, SystemException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        boolean updateAsset = true;
        if (fileEntry instanceof LiferayFileEntry && fileEntry.getVersion().equals(destinationFileVersion.getVersion())) {
            updateAsset = false;
        }
        if (updateAsset) {
            this.updateAsset(userId, fileEntry, destinationFileVersion, assetClassPk);
        }
        this.registerDLProcessorCallback(fileEntry, sourceFileVersion);
        this.registerDLSyncEventCallback("update", fileEntry);
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        this.updateAsset(userId, fileEntry, destinationFileVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.registerDLProcessorCallback(fileEntry, sourceFileVersion);
        this.registerDLSyncEventCallback("update", fileEntry);
    }

    public void updateFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException, SystemException {
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.registerDLSyncEventCallback("update", folder);
    }

    public void updateStatus(long userId, FileEntry fileEntry, FileVersion latestFileVersion, int oldStatus, int newStatus, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        if (newStatus == 0) {
            String event;
            String latestFileVersionVersion = latestFileVersion.getVersion();
            if (latestFileVersionVersion.equals(fileEntry.getVersion())) {
                AssetEntry draftAssetEntry;
                if (!latestFileVersionVersion.equals("1.0") && (draftAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), latestFileVersion.getPrimaryKey())) != null) {
                    long fileEntryTypeId = this.getFileEntryTypeId(fileEntry);
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0);
                    long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
                    AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, fileEntry.getGroupId(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntry.getUuid(), fileEntryTypeId, assetCategoryIds, assetTagNames, true, null, null, null, draftAssetEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null, false);
                    this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                    this.assetEntryLocalService.deleteEntry(draftAssetEntry);
                }
                this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), true);
            }
            if (Validator.isNotNull((String)(event = (String)((Object)workflowContext.get("event"))))) {
                this.registerDLSyncEventCallback(event, fileEntry);
            }
            if (oldStatus != 8 && !fileEntry.isInTrashContainer()) {
                Date activityDate = latestFileVersion.getModifiedDate();
                int activityType = 2;
                if (event.equals("add")) {
                    activityDate = latestFileVersion.getCreateDate();
                    activityType = 1;
                }
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("title", fileEntry.getTitle());
                this.socialActivityLocalService.addUniqueActivity(latestFileVersion.getStatusByUserId(), fileEntry.getGroupId(), activityDate, DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), activityType, extraDataJSONObject.toString(), 0L);
                this.notifySubscribers(latestFileVersion, serviceContext);
            }
        } else {
            List approvedFileVersions;
            boolean visible = false;
            if (newStatus != 8 && !(approvedFileVersions = this.dlFileVersionPersistence.findByF_S(fileEntry.getFileEntryId(), 0)).isEmpty()) {
                visible = true;
            }
            this.assetEntryLocalService.updateVisible(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), visible);
        }
    }

    protected FileEntry doMoveFileEntryFromTrash(long userId, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), -1);
        dlFileVersions = ListUtil.sort((List)dlFileVersions, (Comparator)new FileVersionVersionComparator());
        if (fileEntry.isInTrash()) {
            this.restoreFileEntryFromTrash(userId, fileEntry);
            fileEntry = this.dlAppLocalService.moveFileEntry(userId, fileEntry.getFileEntryId(), newFolderId, serviceContext);
            if (DLAppHelperThreadLocal.isEnabled()) {
                this.dlFileRankLocalService.enableFileRanks(fileEntry.getFileEntryId());
            }
            return fileEntry;
        }
        LiferayFileVersion fileVersion = new LiferayFileVersion((DLFileVersion)dlFileVersions.get(0));
        this.dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), fileVersion.getStatus(), new HashMap(), serviceContext);
        if (DLAppHelperThreadLocal.isEnabled()) {
            this.dlFileRankLocalService.enableFileRanks(fileEntry.getFileEntryId());
            this.dlFileShortcutLocalService.enableFileShortcuts(fileEntry.getFileEntryId());
        }
        fileEntry = this.dlAppService.moveFileEntry(fileEntry.getFileEntryId(), newFolderId, serviceContext);
        this.registerDLSyncEventCallback("restore", fileEntry);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", fileEntry.getTitle());
        this.socialActivityLocalService.addActivity(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 10008, extraDataJSONObject.toString(), 0L);
        return fileEntry;
    }

    protected FileEntry doMoveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException, SystemException {
        List dlFileVersions = this.dlFileVersionLocalService.getFileVersions(fileEntry.getFileEntryId(), -1);
        dlFileVersions = ListUtil.sort((List)dlFileVersions, (Comparator)new FileVersionVersionComparator());
        LiferayFileVersion fileVersion = new LiferayFileVersion((DLFileVersion)dlFileVersions.get(0));
        HashMap<String, Serializable> workflowContext = new HashMap<String, Serializable>();
        workflowContext.put("dlFileVersions", (Serializable)((Object)dlFileVersions));
        int oldStatus = fileVersion.getStatus();
        this.dlFileEntryLocalService.updateStatus(userId, fileVersion.getFileVersionId(), 8, workflowContext, new ServiceContext());
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId());
        String trashTitle = TrashUtil.getTrashTitle((long)trashEntry.getEntryId());
        dlFileEntry.setTitle(trashTitle);
        this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return fileEntry;
        }
        this.dlFileShortcutLocalService.disableFileShortcuts(fileEntry.getFileEntryId());
        this.dlFileRankLocalService.disableFileRanks(fileEntry.getFileEntryId());
        this.registerDLSyncEventCallback("trash", fileEntry);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", TrashUtil.getOriginalTitle((String)fileEntry.getTitle()));
        this.socialActivityLocalService.addActivity(userId, fileEntry.getGroupId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), 10007, extraDataJSONObject.toString(), 0L);
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(fileVersion.getCompanyId(), fileVersion.getGroupId(), DLFileEntryConstants.getClassName(), fileVersion.getFileVersionId());
        }
        return fileEntry;
    }

    protected Folder doMoveFolderFromTrash(long userId, Folder folder, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        if (dlFolder.isInTrash()) {
            this.restoreFolderFromTrash(userId, folder);
        } else {
            this.dlFolderLocalService.updateStatus(userId, folder.getFolderId(), 0, new HashMap(), new ServiceContext());
            this.dlFileRankLocalService.enableFileRanksByFolderId(folder.getFolderId());
            this.registerDLSyncEventCallback("restore", folder);
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("title", folder.getName());
            this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), DLFolderConstants.class.getName(), folder.getFolderId(), 10008, extraDataJSONObject.toString(), 0L);
        }
        return this.dlAppLocalService.moveFolder(userId, folder.getFolderId(), parentFolderId, serviceContext);
    }

    protected Folder doMoveFolderToTrash(long userId, Folder folder) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderLocalService.updateStatus(userId, folder.getFolderId(), 8, new HashMap(), new ServiceContext());
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(DLFolderConstants.getClassName(), dlFolder.getFolderId());
        String trashTitle = TrashUtil.getTrashTitle((long)trashEntry.getEntryId());
        dlFolder.setName(trashTitle);
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        this.dlFileRankLocalService.disableFileRanksByFolderId(folder.getFolderId());
        this.registerDLSyncEventCallback("trash", folder);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", folder.getName());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), DLFolderConstants.getClassName(), folder.getFolderId(), 10007, extraDataJSONObject.toString(), 0L);
        return new LiferayFolder(dlFolder);
    }

    protected long getFileEntryTypeId(FileEntry fileEntry) {
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            return dlFileEntry.getFileEntryTypeId();
        }
        return 0L;
    }

    protected boolean isStagingGroup(long groupId) {
        try {
            Group group = this.groupLocalService.getGroup(groupId);
            return group.isStagingGroup();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void notifySubscribers(FileVersion fileVersion, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!fileVersion.isApproved()) {
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = fileVersion.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "20";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(fileVersion.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(serviceContext.isCommandAdd() && DLUtil.getEmailFileEntryAddedEnabled((PortletPreferences)preferences) || serviceContext.isCommandUpdate() && DLUtil.getEmailFileEntryUpdatedEnabled((PortletPreferences)preferences))) {
            return;
        }
        String fromName = DLUtil.getEmailFromName((PortletPreferences)preferences, (long)fileVersion.getCompanyId());
        String fromAddress = DLUtil.getEmailFromAddress((PortletPreferences)preferences, (long)fileVersion.getCompanyId());
        Map localizedSubjectMap = null;
        Map localizedBodyMap = null;
        if (serviceContext.isCommandUpdate()) {
            localizedSubjectMap = DLUtil.getEmailFileEntryUpdatedSubjectMap((PortletPreferences)preferences);
            localizedBodyMap = DLUtil.getEmailFileEntryUpdatedBodyMap((PortletPreferences)preferences);
        } else {
            localizedSubjectMap = DLUtil.getEmailFileEntryAddedSubjectMap((PortletPreferences)preferences);
            localizedBodyMap = DLUtil.getEmailFileEntryAddedBodyMap((PortletPreferences)preferences);
        }
        FileEntry fileEntry = fileVersion.getFileEntry();
        Folder folder = null;
        long folderId = fileEntry.getFolderId();
        if (folderId != 0L) {
            folder = this.dlAppLocalService.getFolder(folderId);
        }
        String folderName = LanguageUtil.get((Locale)serviceContext.getLocale(), (String)"home");
        if (folder != null) {
            folderName = folder.getName();
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypeLocalService.getDLFileEntryType(dlFileEntry.getFileEntryTypeId());
        subscriptionSender.setCompanyId(fileVersion.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$DOCUMENT_STATUS_BY_USER_NAME$]", fileVersion.getStatusByUserName(), "[$DOCUMENT_TITLE$]", fileVersion.getTitle(), "[$DOCUMENT_TYPE$]", dlFileEntryType.getName(serviceContext.getLocale()), "[$FOLDER_NAME$]", folderName});
        subscriptionSender.setContextUserPrefix("DOCUMENT");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("file_entry", new Object[]{fileVersion.getFileEntryId()});
        subscriptionSender.setPortletId("20");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(fileVersion.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUserId(fileVersion.getUserId());
        subscriptionSender.addPersistedSubscribers(Folder.class.getName(), fileVersion.getGroupId());
        ArrayList<Long> folderIds = new ArrayList<Long>();
        if (folder != null) {
            folderIds.add(folder.getFolderId());
            folderIds.addAll(folder.getAncestorFolderIds());
        }
        Iterator iterator = folderIds.iterator();
        while (iterator.hasNext()) {
            long curFolderId = (Long)iterator.next();
            subscriptionSender.addPersistedSubscribers(Folder.class.getName(), curFolderId);
        }
        if (dlFileEntryType.getFileEntryTypeId() == 0L) {
            subscriptionSender.addPersistedSubscribers(DLFileEntryType.class.getName(), fileVersion.getGroupId());
        } else {
            subscriptionSender.addPersistedSubscribers(DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId());
        }
        subscriptionSender.addPersistedSubscribers(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void registerDLProcessorCallback(final FileEntry fileEntry, final FileVersion fileVersion) {
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DLProcessorRegistryUtil.trigger((FileEntry)fileEntry, (FileVersion)fileVersion, (boolean)true);
                return null;
            }
        });
    }

    protected void registerDLSyncEventCallback(final String event, final String type, final long typePK) throws SystemException {
        DLSyncEvent dlSyncEvent = this.dlSyncEventLocalService.addDLSyncEvent(event, type, typePK);
        final long modifiedTime = dlSyncEvent.getModifiedTime();
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                HashMap<String, Object> values = new HashMap<String, Object>(4);
                values.put("event", event);
                values.put("modifiedTime", modifiedTime);
                values.put("type", type);
                values.put("typePK", typePK);
                message.setValues(values);
                MessageBusUtil.sendMessage((String)"liferay/document_library_sync_event_processor", (Message)message);
                return null;
            }
        });
    }
}

