/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import java.io.IOException;
import java.io.InputStream;

public class DLFileVersionImpl
extends DLFileVersionBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileVersionImpl.class);
    private transient ExpandoBridge _expandoBridge;
    private UnicodeProperties _extraSettingsProperties;

    public String buildTreePath() throws PortalException, SystemException {
        StringBundler sb = new StringBundler();
        this.buildTreePath(sb, this.getFolder());
        return sb.toString();
    }

    public InputStream getContentStream(boolean incrementCounter) throws PortalException, SystemException {
        return DLFileEntryLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (long)this.getFileEntryId(), (String)this.getVersion(), (boolean)incrementCounter);
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        if (this._expandoBridge == null) {
            this._expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)DLFileEntry.class.getName(), (long)this.getPrimaryKey());
        }
        return this._expandoBridge;
    }

    @Override
    public String getExtraSettings() {
        if (this._extraSettingsProperties == null) {
            return super.getExtraSettings();
        }
        return this._extraSettingsProperties.toString();
    }

    public UnicodeProperties getExtraSettingsProperties() {
        if (this._extraSettingsProperties == null) {
            this._extraSettingsProperties = new UnicodeProperties(true);
            try {
                this._extraSettingsProperties.load(super.getExtraSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._extraSettingsProperties;
    }

    public DLFileEntry getFileEntry() throws PortalException, SystemException {
        return DLFileEntryLocalServiceUtil.getFileEntry((long)this.getFileEntryId());
    }

    public DLFolder getFolder() throws PortalException, SystemException {
        if (this.getFolderId() <= 0L) {
            return new DLFolderImpl();
        }
        return DLFolderLocalServiceUtil.getFolder((long)this.getFolderId());
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public DLFolder getTrashContainer() throws PortalException, SystemException {
        DLFolder dlFolder = null;
        try {
            dlFolder = this.getFolder();
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return null;
        }
        if (dlFolder.isInTrash()) {
            return dlFolder;
        }
        return dlFolder.getTrashContainer();
    }

    public boolean isInTrashContainer() throws PortalException, SystemException {
        return this.getTrashContainer() != null;
    }

    @Override
    public void setExtraSettings(String extraSettings) {
        this._extraSettingsProperties = null;
        super.setExtraSettings(extraSettings);
    }

    public void setExtraSettingsProperties(UnicodeProperties extraSettingsProperties) {
        this._extraSettingsProperties = extraSettingsProperties;
        super.setExtraSettings(this._extraSettingsProperties.toString());
    }

    protected void buildTreePath(StringBundler sb, DLFolder dlFolder) throws PortalException, SystemException {
        if (dlFolder == null) {
            sb.append("/");
        } else {
            this.buildTreePath(sb, dlFolder.getParentFolder());
            sb.append(dlFolder.getFolderId());
            sb.append("/");
        }
    }
}

