/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Repository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFileShortcutBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;

public class DLFileShortcutImpl
extends DLFileShortcutBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileShortcutImpl.class);

    public String buildTreePath() throws PortalException, SystemException {
        StringBundler sb = new StringBundler();
        this.buildTreePath(sb, this.getDLFolder());
        return sb.toString();
    }

    public DLFolder getDLFolder() throws PortalException, SystemException {
        Folder folder = this.getFolder();
        return (DLFolder)folder.getModel();
    }

    public Folder getFolder() throws PortalException, SystemException {
        if (this.getFolderId() <= 0L) {
            return new LiferayFolder(new DLFolderImpl());
        }
        return DLAppLocalServiceUtil.getFolder((long)this.getFolderId());
    }

    public String getToTitle() {
        String toTitle = null;
        try {
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)this.getToFileEntryId());
            toTitle = fileEntry.getTitle();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return toTitle;
    }

    public DLFolder getTrashContainer() throws PortalException, SystemException {
        DLFolder dlFolder = null;
        try {
            dlFolder = this.getDLFolder();
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return null;
        }
        if (dlFolder.isInTrash()) {
            return dlFolder;
        }
        return dlFolder.getTrashContainer();
    }

    public boolean isInHiddenFolder() {
        try {
            long repositoryId = this.getRepositoryId();
            Repository repository = RepositoryLocalServiceUtil.getRepository((long)repositoryId);
            long dlFolderId = repository.getDlFolderId();
            DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)dlFolderId);
            return dlFolder.isHidden();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isInTrashContainer() {
        try {
            if (this.getTrashContainer() != null) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected void buildTreePath(StringBundler sb, DLFolder dlFolder) throws PortalException, SystemException {
        if (dlFolder == null) {
            sb.append("/");
        } else {
            this.buildTreePath(sb, dlFolder.getParentFolder());
            sb.append(dlFolder.getFolderId());
            sb.append("/");
        }
    }
}

