/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.lar.FolderUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FolderStagedModelDataHandler
extends BaseStagedModelDataHandler<Folder> {
    public static final String[] CLASS_NAMES = new String[]{DLFolder.class.getName(), Folder.class.getName(), LiferayFolder.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        DLFolder dlFolder = DLFolderLocalServiceUtil.fetchDLFolderByUuidAndGroupId((String)uuid, (long)groupId);
        if (dlFolder != null) {
            DLFolderLocalServiceUtil.deleteFolder((DLFolder)dlFolder);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Folder folder) {
        return folder.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder, Folder.class);
        String folderPath = ExportImportPathUtil.getModelPath((StagedModel)folder);
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, Folder.class, (StagedModel)folder.getParentFolder(), Folder.class, (String)"parent");
        }
        this.exportFolderFileEntryTypes(portletDataContext, folderElement, folder);
        portletDataContext.addClassedModel(folderElement, folderPath, (ClassedModel)folder, DLFolder.class);
    }

    protected void doImportCompanyStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        Folder existingFolder = FolderUtil.fetchByUUID_R(folder.getUuid(), portletDataContext.getCompanyGroupId());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        folderIds.put(folder.getFolderId(), existingFolder.getFolderId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        String path = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)Folder.class.getName(), (long)folder.getFolderId());
        Element folderElement = portletDataContext.getImportDataElement(Folder.class.getSimpleName(), "path", path);
        if (folder.getParentFolderId() != 0L) {
            String parentFolderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)Folder.class.getName(), (long)folder.getParentFolderId());
            Folder parentFolder = (Folder)portletDataContext.getZipEntryAsObject(parentFolderPath);
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)parentFolder);
        }
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)folder, DLFolder.class);
        serviceContext.setUserId(userId);
        Folder importedFolder = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Folder existingFolder = FolderUtil.fetchByUUID_R(folder.getUuid(), portletDataContext.getScopeGroupId());
            if (existingFolder == null) {
                String name = this.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                serviceContext.setUuid(folder.getUuid());
                importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                String name = this.getFolderName(folder.getUuid(), portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                importedFolder = DLAppLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            String name = this.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
            importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        this.importFolderFileEntryTypes(portletDataContext, folderElement, folder, serviceContext);
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder, DLFolder.class);
        folderIds.put(folder.getFolderId(), importedFolder.getFolderId());
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Folder existingFolder = FolderUtil.fetchByUUID_R(folder.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFolder == null || !(existingFolder.getModel() instanceof DLFolder)) {
            return;
        }
        DLFolder dlFolder = (DLFolder)existingFolder.getModel();
        if (!dlFolder.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFolder.class.getName());
        if (trashHandler.isRestorable(existingFolder.getFolderId())) {
            trashHandler.restoreTrashEntry(userId, existingFolder.getFolderId());
        }
    }

    protected void exportFolderFileEntryTypes(PortletDataContext portletDataContext, Element folderElement, Folder folder) throws Exception {
        List dlFileEntryTypes = DLFileEntryTypeLocalServiceUtil.getFolderFileEntryTypes((long[])new long[]{portletDataContext.getCompanyGroupId(), portletDataContext.getScopeGroupId()}, (long)folder.getFolderId(), (boolean)false);
        long defaultFileEntryTypeId = DLFileEntryTypeLocalServiceUtil.getDefaultFileEntryTypeId((long)folder.getFolderId());
        String defaultFileEntryTypeUuid = "";
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            if (dlFileEntryType.getFileEntryTypeId() == 0L) {
                folderElement.addAttribute("basic-document", "true");
                continue;
            }
            if (defaultFileEntryTypeId == dlFileEntryType.getFileEntryTypeId()) {
                defaultFileEntryTypeUuid = dlFileEntryType.getUuid();
            }
            if (!dlFileEntryType.isExportable()) continue;
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, Folder.class, (StagedModel)dlFileEntryType, DLFileEntryType.class, (String)"strong");
        }
        folderElement.addAttribute("defaultFileEntryTypeUuid", defaultFileEntryTypeUuid);
    }

    protected String getFolderName(String uuid, long groupId, long parentFolderId, String name, int count) throws Exception {
        Folder folder = FolderUtil.fetchByR_P_N(groupId, parentFolderId, name);
        if (folder == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(folder.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getFolderName(uuid, groupId, parentFolderId, name, ++count);
    }

    protected void importFolderFileEntryTypes(PortletDataContext portletDataContext, Element folderElement, Folder folder, ServiceContext serviceContext) throws Exception {
        ArrayList<Long> currentFolderFileEntryTypeIds = new ArrayList<Long>();
        String defaultFileEntryTypeUuid = GetterUtil.getString((String)folderElement.attributeValue("defaultFileEntryTypeUuid"));
        long defaultFileEntryTypeId = 0L;
        List referenceDataElements = portletDataContext.getReferenceDataElements(folderElement, DLFileEntryType.class);
        for (Element referenceDataElement : referenceDataElements) {
            String referencePath = referenceDataElement.attributeValue("path");
            DLFileEntryType referenceDLFileEntryType = (DLFileEntryType)portletDataContext.getZipEntryAsObject(referencePath);
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)referenceDLFileEntryType);
            Map fileEntryTypeIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntryType.class);
            long dlFileEntryTypeId = MapUtil.getLong((Map)fileEntryTypeIds, (long)referenceDLFileEntryType.getFileEntryTypeId(), (long)referenceDLFileEntryType.getFileEntryTypeId());
            DLFileEntryType existingDLFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)dlFileEntryTypeId);
            if (existingDLFileEntryType == null) continue;
            currentFolderFileEntryTypeIds.add(existingDLFileEntryType.getFileEntryTypeId());
            if (!defaultFileEntryTypeUuid.equals(referenceDLFileEntryType.getUuid())) continue;
            defaultFileEntryTypeId = existingDLFileEntryType.getFileEntryTypeId();
        }
        if (GetterUtil.getBoolean((String)folderElement.attributeValue("basic-document"))) {
            currentFolderFileEntryTypeIds.add(0L);
        }
        if (!currentFolderFileEntryTypeIds.isEmpty()) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            dlFolder.setDefaultFileEntryTypeId(defaultFileEntryTypeId);
            dlFolder.setOverrideFileEntryTypes(true);
            DLFolderLocalServiceUtil.updateDLFolder((DLFolder)dlFolder);
            DLFileEntryTypeLocalServiceUtil.updateFolderFileEntryTypes((DLFolder)dlFolder, currentFolderFileEntryTypeIds, (long)defaultFileEntryTypeId, (ServiceContext)serviceContext);
        }
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        DLFolder dlFolder = DLFolderLocalServiceUtil.fetchDLFolderByUuidAndGroupId((String)uuid, (long)groupId);
        return dlFolder != null;
    }
}

