/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.service.persistence.RepositoryExportActionableDynamicQuery;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryExportActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryTypeExportActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutExportActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderExportActionableDynamicQuery;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DLPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "document_library";

    public DLPortletDataHandler() {
        this.setDataLocalized(true);
        this.setDataPortletPreferences(new String[]{"rootFolderId"});
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(DLFileEntryType.class), new StagedModelType(DLFileRank.class), new StagedModelType(DLFileShortcut.class), new StagedModelType(FileEntry.class), new StagedModelType(Folder.class), new StagedModelType(Repository.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "repositories", false, false, null, Repository.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "folders", true, false, null, Folder.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "documents", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "previews-and-thumbnails")}, FileEntry.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "shortcuts", true, false, null, DLFileShortcut.class.getName())});
        this.setPublishToLiveByDefault(PropsValues.DL_PUBLISH_TO_LIVE_BY_DEFAULT);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(DLPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        DLAppLocalServiceUtil.deleteAll((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.portlet.documentlibrary");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            ActionableDynamicQuery folderActionableDynamicQuery = this.getFolderActionableDynamicQuery(portletDataContext);
            folderActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "documents")) {
            ActionableDynamicQuery fileEntryTypeActionableDynamicQuery = this.getDLFileEntryTypeActionableDynamicQuery(portletDataContext);
            fileEntryTypeActionableDynamicQuery.performActions();
            ActionableDynamicQuery fileEntryActionableDynamicQuery = this.getFileEntryActionableDynamicQuery(portletDataContext);
            fileEntryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "repositories")) {
            ActionableDynamicQuery repositoryActionableDynamicQuery = this.getRepositoryActionableDynamicQuery(portletDataContext);
            repositoryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "shortcuts")) {
            ActionableDynamicQuery fileShortcutActionableDynamicQuery = this.getDLFileShortcutActionableDynamicQuery(portletDataContext);
            fileShortcutActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.portlet.documentlibrary");
        Element fileEntryTypesElement = portletDataContext.getImportDataGroupElement(DLFileEntryType.class);
        List fileEntryTypeElements = fileEntryTypesElement.elements();
        for (Element fileEntryTypeElement : fileEntryTypeElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryTypeElement);
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            Element foldersElement = portletDataContext.getImportDataGroupElement(Folder.class);
            List folderElements = foldersElement.elements();
            for (Element folderElement : folderElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "documents")) {
            Element fileEntriesElement = portletDataContext.getImportDataGroupElement(FileEntry.class);
            List fileEntryElements = fileEntriesElement.elements();
            for (Element fileEntryElement : fileEntryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "repositories")) {
            Element repositoriesElement = portletDataContext.getImportDataGroupElement(Repository.class);
            List repositoryElements = repositoriesElement.elements();
            for (Element repositoryElement : repositoryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)repositoryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "shortcuts")) {
            Element fileShortcutsElement = portletDataContext.getImportDataGroupElement(DLFileShortcut.class);
            List fileShortcutElements = fileShortcutsElement.elements();
            for (Element fileShortcutElement : fileShortcutElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileShortcutElement);
            }
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ActionableDynamicQuery dlFileShortcutActionableDynamicQuery = this.getDLFileShortcutActionableDynamicQuery(portletDataContext);
        dlFileShortcutActionableDynamicQuery.performCount();
        ActionableDynamicQuery fileEntryActionableDynamicQuery = this.getFileEntryActionableDynamicQuery(portletDataContext);
        fileEntryActionableDynamicQuery.performCount();
        ActionableDynamicQuery folderActionableDynamicQuery = this.getFolderActionableDynamicQuery(portletDataContext);
        folderActionableDynamicQuery.performCount();
        ActionableDynamicQuery repositoryActionableDynamicQuery = this.getRepositoryActionableDynamicQuery(portletDataContext);
        repositoryActionableDynamicQuery.performCount();
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId != 0L) {
            Folder folder = DLAppLocalServiceUtil.getFolder((long)rootFolderId);
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)folder);
        }
        return portletPreferences;
    }

    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element foldersElement;
        List folderElements;
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId > 0L && !(folderElements = (foldersElement = portletDataContext.getImportDataGroupElement(Folder.class)).elements()).isEmpty()) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)((Element)folderElements.get(0)));
            Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
            rootFolderId = MapUtil.getLong((Map)folderIds, (long)rootFolderId, (long)rootFolderId);
            portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
        }
        return portletPreferences;
    }

    protected ActionableDynamicQuery getDLFileEntryTypeActionableDynamicQuery(final PortletDataContext portletDataContext) throws Exception {
        return new DLFileEntryTypeExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property property = PropertyFactoryUtil.forName((String)"groupId");
                dynamicQuery.add(property.in((Object[])new Long[]{portletDataContext.getScopeGroupId()}));
            }

            protected void performAction(Object object) throws PortalException {
                DLFileEntryType dlFileEntryType = (DLFileEntryType)object;
                if (dlFileEntryType.isExportable()) {
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)dlFileEntryType);
                }
            }
        };
    }

    protected ActionableDynamicQuery getDLFileShortcutActionableDynamicQuery(PortletDataContext portletDataContext) throws Exception {
        return new DLFileShortcutExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property property = PropertyFactoryUtil.forName((String)"active");
                dynamicQuery.add(property.eq((Object)Boolean.TRUE));
            }
        };
    }

    protected ActionableDynamicQuery getFileEntryActionableDynamicQuery(final PortletDataContext portletDataContext) throws Exception {
        return new DLFileEntryExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property property = PropertyFactoryUtil.forName((String)"repositoryId");
                dynamicQuery.add(property.eq((Object)portletDataContext.getScopeGroupId()));
            }

            protected StagedModelType getStagedModelType() {
                return new StagedModelType(FileEntry.class);
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                if (dlFileEntry.isInTrash() || dlFileEntry.isInTrashContainer()) {
                    return;
                }
                FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry.getFileEntryId());
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry);
            }

            public long performCount() throws PortalException, SystemException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                long modelAdditionCount = DLFileEntryLocalServiceUtil.getFileEntriesCount((long)portletDataContext.getScopeGroupId(), (DateRange)portletDataContext.getDateRange(), (long)portletDataContext.getScopeGroupId(), (QueryDefinition)new QueryDefinition(0));
                StagedModelType stagedModelType = this.getStagedModelType();
                manifestSummary.addModelAdditionCount(stagedModelType.toString(), modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType.toString(), modelDeletionCount);
                return modelAdditionCount;
            }
        };
    }

    protected ActionableDynamicQuery getFolderActionableDynamicQuery(final PortletDataContext portletDataContext) throws Exception {
        return new DLFolderExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property property = PropertyFactoryUtil.forName((String)"repositoryId");
                dynamicQuery.add(property.eq((Object)portletDataContext.getScopeGroupId()));
            }

            protected StagedModelType getStagedModelType() {
                return new StagedModelType(Folder.class);
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                DLFolder dlFolder = (DLFolder)object;
                if (dlFolder.isInTrash() || dlFolder.isInTrashContainer()) {
                    return;
                }
                Folder folder = DLAppLocalServiceUtil.getFolder((long)dlFolder.getFolderId());
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
            }
        };
    }

    protected ActionableDynamicQuery getRepositoryActionableDynamicQuery(PortletDataContext portletDataContext) throws Exception {
        return new RepositoryExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                long liferayRepositoryClassNameId = PortalUtil.getClassNameId(LiferayRepository.class);
                dynamicQuery.add(classNameIdProperty.ne((Object)liferayRepositoryClassNameId));
                Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
                Property portletIdProperty = PropertyFactoryUtil.forName((String)"portletId");
                disjunction.add(portletIdProperty.isNull());
                disjunction.add(portletIdProperty.eq((Object)""));
                dynamicQuery.add((Criterion)disjunction);
            }

            protected StagedModelType getStagedModelType() {
                return new StagedModelType(PortalUtil.getClassNameId((String)Repository.class.getName()), -1L);
            }
        };
    }
}

